/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAssemblyFunction;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigGatewayPeering;
import com.kumbasoft.core.beans.config.ConfigGatewayPeeringManager;
import com.kumbasoft.core.beans.config.ConfigIPMulticast;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.config.ConfigSSLServerProfile;
import com.kumbasoft.core.beans.types.APICGSProxyPolicy;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigAPIConnectGatewayService
extends ConfigConfigBase {
    private String userSummary;
    private String localAddress;
    private int localPort;
    private ObjectReference<ConfigSSLClientProfile> sSLClient;
    private ObjectReference<ConfigSSLServerProfile> sSLServer;
    private String aPIGatewayAddress;
    private int aPIGatewayPort;
    private ObjectReference<ConfigGatewayPeering> gatewayPeering;
    private ObjectReference<ConfigGatewayPeeringManager> gatewayPeeringManager;
    private String v5CompatibilityMode;
    private ArrayList<ObjectReference<ConfigAssemblyFunction>> userDefinedPolicies;
    private String v5CSlmMode;
    private ObjectReference<ConfigIPMulticast> iPMulticast;
    private String iPUnicast;
    private String jWTValidationMode;
    private String jWTURL;
    private APICGSProxyPolicy proxyPolicy;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=2, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="local-address", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0.0.0.0", displayOrder=0, displayValue="Local address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLocalAddress() {
        return this.localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=2, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="local-address", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0.0.0.0", displayValue="Local address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="local-port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="3000", displayOrder=0, displayValue="Local port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLocalPort() {
        return this.localPort;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="local-port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="3000", displayValue="Local port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(ObjectReference<ConfigSSLClientProfile> sSLClient) {
        this.sSLClient = sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-server", refType="SSLServerProfile", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference<ConfigSSLServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLServerProfile> getSSLServer() {
        return this.sSLServer;
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-server", refType="SSLServerProfile", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference<ConfigSSLServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLServer(ObjectReference<ConfigSSLServerProfile> sSLServer) {
        this.sSLServer = sSLServer;
    }

    @XMLInfo(elementType="element", elementName="APIGatewayAddress", elementOrder=6, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="api-gw-address", refType="", isEnumeration=false, javaName="aPIGatewayAddress", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0.0.0.0", displayOrder=0, displayValue="API gateway address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPIGatewayAddress() {
        return this.aPIGatewayAddress;
    }

    @XMLInfo(elementType="element", elementName="APIGatewayAddress", elementOrder=6, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="api-gw-address", refType="", isEnumeration=false, javaName="aPIGatewayAddress", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0.0.0.0", displayValue="API gateway address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPIGatewayAddress(String aPIGatewayAddress) {
        this.aPIGatewayAddress = aPIGatewayAddress;
    }

    @XMLInfo(elementType="element", elementName="APIGatewayPort", elementOrder=7, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="api-gw-port", refType="", isEnumeration=false, javaName="aPIGatewayPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="9443", displayOrder=0, displayValue="API gateway port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getAPIGatewayPort() {
        return this.aPIGatewayPort;
    }

    @XMLInfo(elementType="element", elementName="APIGatewayPort", elementOrder=7, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="api-gw-port", refType="", isEnumeration=false, javaName="aPIGatewayPort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="9443", displayValue="API gateway port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPIGatewayPort(int aPIGatewayPort) {
        this.aPIGatewayPort = aPIGatewayPort;
    }

    @XMLInfo(elementType="element", elementName="GatewayPeering", elementOrder=8, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="gateway-peering", refType="GatewayPeering", isEnumeration=false, javaName="gatewayPeering", javaType="ObjectReference<ConfigGatewayPeering>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Gateway peering", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigGatewayPeering> getGatewayPeering() {
        return this.gatewayPeering;
    }

    @XMLInfo(elementType="element", elementName="GatewayPeering", elementOrder=8, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="gateway-peering", refType="GatewayPeering", isEnumeration=false, javaName="gatewayPeering", javaType="ObjectReference<ConfigGatewayPeering>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Gateway peering", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGatewayPeering(ObjectReference<ConfigGatewayPeering> gatewayPeering) {
        this.gatewayPeering = gatewayPeering;
    }

    @XMLInfo(elementType="element", elementName="GatewayPeeringManager", elementOrder=9, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="gateway-peering-manager", refType="GatewayPeeringManager", isEnumeration=false, javaName="gatewayPeeringManager", javaType="ObjectReference<ConfigGatewayPeeringManager>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default", displayOrder=0, displayValue="Gateway-peering manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigGatewayPeeringManager> getGatewayPeeringManager() {
        return this.gatewayPeeringManager;
    }

    @XMLInfo(elementType="element", elementName="GatewayPeeringManager", elementOrder=9, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="gateway-peering-manager", refType="GatewayPeeringManager", isEnumeration=false, javaName="gatewayPeeringManager", javaType="ObjectReference<ConfigGatewayPeeringManager>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default", displayValue="Gateway-peering manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGatewayPeeringManager(ObjectReference<ConfigGatewayPeeringManager> gatewayPeeringManager) {
        this.gatewayPeeringManager = gatewayPeeringManager;
    }

    @XMLInfo(elementType="element", elementName="V5CompatibilityMode", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="v5-compatibility-mode", refType="", isEnumeration=true, javaName="v5CompatibilityMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="V5 compatibility mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getV5CompatibilityMode() {
        return this.v5CompatibilityMode;
    }

    @XMLInfo(elementType="element", elementName="V5CompatibilityMode", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="v5-compatibility-mode", refType="", isEnumeration=true, javaName="v5CompatibilityMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="V5 compatibility mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setV5CompatibilityMode(String v5CompatibilityMode) {
        if (v5CompatibilityMode == null || Comparison.isIn(v5CompatibilityMode, DPEnumerations.TOGGLE)) {
            this.v5CompatibilityMode = v5CompatibilityMode;
        }
    }

    public void addUserDefinedPolicies(ObjectReference<ConfigAssemblyFunction> element) {
        if (element == null) {
            return;
        }
        if (this.userDefinedPolicies == null) {
            this.userDefinedPolicies = new ArrayList();
        }
        this.userDefinedPolicies.add(element);
    }

    public boolean removeUserDefinedPolicies(ObjectReference<ConfigAssemblyFunction> element) {
        if (element == null || this.userDefinedPolicies == null) {
            return false;
        }
        return this.userDefinedPolicies.remove(element);
    }

    @XMLInfo(elementType="element", elementName="UserDefinedPolicies", elementOrder=11, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="user-defined-policies", refType="AssemblyFunction", isEnumeration=false, javaName="userDefinedPolicies", javaType="ObjectReference<ConfigAssemblyFunction>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="User-defined policies", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigAssemblyFunction>> getUserDefinedPolicies() {
        return this.userDefinedPolicies;
    }

    @XMLInfo(elementType="element", elementName="UserDefinedPolicies", elementOrder=11, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="user-defined-policies", refType="AssemblyFunction", isEnumeration=false, javaName="userDefinedPolicies", javaType="ObjectReference<ConfigAssemblyFunction>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="User-defined policies", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserDefinedPolicies(ArrayList<ObjectReference<ConfigAssemblyFunction>> userDefinedPolicies) {
        this.userDefinedPolicies = userDefinedPolicies;
    }

    @XMLInfo(elementType="element", elementName="V5CSlmMode", elementOrder=12, dataPowerType="dmV5CSlmMode", subType="", benign=false, isPassword=false, cliAlias="slm-mode", refType="", isEnumeration=true, javaName="v5CSlmMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="autounicast", displayOrder=0, displayValue="SLM peer mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getV5CSlmMode() {
        return this.v5CSlmMode;
    }

    @XMLInfo(elementType="element", elementName="V5CSlmMode", elementOrder=12, dataPowerType="dmV5CSlmMode", subType="", benign=false, isPassword=false, cliAlias="slm-mode", refType="", isEnumeration=true, javaName="v5CSlmMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="autounicast", displayValue="SLM peer mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setV5CSlmMode(String v5CSlmMode) {
        if (v5CSlmMode == null || Comparison.isIn(v5CSlmMode, DPEnumerations.V5CSLM_MODE)) {
            this.v5CSlmMode = v5CSlmMode;
        }
    }

    @XMLInfo(elementType="element", elementName="IPMulticast", elementOrder=13, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="ip-multicast", refType="IPMulticast", isEnumeration=false, javaName="iPMulticast", javaType="ObjectReference<ConfigIPMulticast>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="IP multicast", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigIPMulticast> getIPMulticast() {
        return this.iPMulticast;
    }

    @XMLInfo(elementType="element", elementName="IPMulticast", elementOrder=13, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="ip-multicast", refType="IPMulticast", isEnumeration=false, javaName="iPMulticast", javaType="ObjectReference<ConfigIPMulticast>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="IP multicast", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIPMulticast(ObjectReference<ConfigIPMulticast> iPMulticast) {
        this.iPMulticast = iPMulticast;
    }

    @XMLInfo(elementType="element", elementName="IPUnicast", elementOrder=14, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="ip-unicast", refType="", isEnumeration=false, javaName="iPUnicast", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="IP unicast", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getIPUnicast() {
        return this.iPUnicast;
    }

    @XMLInfo(elementType="element", elementName="IPUnicast", elementOrder=14, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="ip-unicast", refType="", isEnumeration=false, javaName="iPUnicast", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="IP unicast", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIPUnicast(String iPUnicast) {
        this.iPUnicast = iPUnicast;
    }

    @XMLInfo(elementType="element", elementName="JWTValidationMode", elementOrder=15, dataPowerType="dmJWTValidationMode", subType="", benign=false, isPassword=false, cliAlias="jwt-validate-mode", refType="", isEnumeration=true, javaName="jWTValidationMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="request", displayOrder=0, displayValue="JWT validation mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getJWTValidationMode() {
        return this.jWTValidationMode;
    }

    @XMLInfo(elementType="element", elementName="JWTValidationMode", elementOrder=15, dataPowerType="dmJWTValidationMode", subType="", benign=false, isPassword=false, cliAlias="jwt-validate-mode", refType="", isEnumeration=true, javaName="jWTValidationMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="request", displayValue="JWT validation mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setJWTValidationMode(String jWTValidationMode) {
        if (jWTValidationMode == null || Comparison.isIn(jWTValidationMode, DPEnumerations.JWTVALIDATION_MODE)) {
            this.jWTValidationMode = jWTValidationMode;
        }
    }

    @XMLInfo(elementType="element", elementName="JWTURL", elementOrder=16, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="jwt-url", refType="", isEnumeration=false, javaName="jWTURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="JWT URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getJWTURL() {
        return this.jWTURL;
    }

    @XMLInfo(elementType="element", elementName="JWTURL", elementOrder=16, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="jwt-url", refType="", isEnumeration=false, javaName="jWTURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="JWT URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setJWTURL(String jWTURL) {
        this.jWTURL = jWTURL;
    }

    @XMLInfo(elementType="element", elementName="ProxyPolicy", elementOrder=17, dataPowerType="dmAPICGSProxyPolicy", subType="", benign=false, isPassword=false, cliAlias="proxy", refType="", isEnumeration=false, javaName="proxyPolicy", javaType="APICGSProxyPolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="API Manager proxy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public APICGSProxyPolicy getProxyPolicy() {
        return this.proxyPolicy;
    }

    @XMLInfo(elementType="element", elementName="ProxyPolicy", elementOrder=17, dataPowerType="dmAPICGSProxyPolicy", subType="", benign=false, isPassword=false, cliAlias="proxy", refType="", isEnumeration=false, javaName="proxyPolicy", javaType="APICGSProxyPolicy", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="API Manager proxy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProxyPolicy(APICGSProxyPolicy proxyPolicy) {
        this.proxyPolicy = proxyPolicy;
    }

    @Override
    public int compareTo(ConfigAPIConnectGatewayService that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "localAddress", "localPort", "sSLClient", "sSLServer", "aPIGatewayAddress", "aPIGatewayPort", "gatewayPeering", "gatewayPeeringManager", "v5CompatibilityMode", "userDefinedPolicies", "v5CSlmMode", "iPMulticast", "iPUnicast", "jWTValidationMode", "jWTURL", "proxyPolicy");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.localAddress, this.localPort, this.sSLClient, this.sSLServer, this.aPIGatewayAddress, this.aPIGatewayPort, this.gatewayPeering, this.gatewayPeeringManager, this.v5CompatibilityMode, this.userDefinedPolicies, this.v5CSlmMode, this.iPMulticast, this.iPUnicast, this.jWTValidationMode, this.jWTURL, this.proxyPolicy);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "localAddress", "localPort", "sSLClient", "sSLServer", "aPIGatewayAddress", "aPIGatewayPort", "gatewayPeering", "gatewayPeeringManager", "v5CompatibilityMode", "userDefinedPolicies", "v5CSlmMode", "iPMulticast", "iPUnicast", "jWTValidationMode", "jWTURL", "proxyPolicy");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "localAddress", "localPort", "sSLClient", "sSLServer", "aPIGatewayAddress", "aPIGatewayPort", "gatewayPeering", "gatewayPeeringManager", "v5CompatibilityMode", "userDefinedPolicies", "v5CSlmMode", "iPMulticast", "iPUnicast", "jWTValidationMode", "jWTURL", "proxyPolicy"));
    }
}

