/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAssemblyAction;
import com.kumbasoft.core.beans.config.ConfigControlList;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.InvokeErrorType;
import java.util.Objects;

public class ConfigAssemblyActionInvoke
extends ConfigAssemblyAction {
    private String url;
    private String sSLClient;
    private long timeout;
    private String userName;
    private ObjectReference<ConfigPasswordAlias> password;
    private String method;
    private String allowWebSocketUpgrade;
    private String backendType;
    private String graphQLSendType;
    private String compression;
    private String cacheType;
    private long timeToLive;
    private String cacheUnsafeResponse;
    private String cacheKey;
    private String followRedirects;
    private String useHTTP10;
    private String hTTPVersion;
    private String hTTP2Required;
    private String doChunkedUpload;
    private String persistentConnection;
    private String stopOnError;
    private InvokeErrorType errorTypes;
    private String output;
    private String decodeRequestParams;
    private String encodePlusChar;
    private String keepPayload;
    private String injectUserAgentHeader;
    private String injectProxyHeaders;
    private ObjectReference<ConfigControlList> headerControlList;
    private ObjectReference<ConfigControlList> parameterControlList;

    @XMLInfo(elementType="element", elementName="Url", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="url", refType="", isEnumeration=false, javaName="url", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUrl() {
        return this.url;
    }

    @XMLInfo(elementType="element", elementName="Url", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="url", refType="", isEnumeration=false, javaName="url", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUrl(String url) {
        this.url = url;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=6, dataPowerType="dmString", subType="dmReference", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=6, dataPowerType="dmString", subType="dmReference", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(String sSLClient) {
        this.sSLClient = sSLClient;
    }

    @XMLInfo(elementType="element", elementName="Timeout", elementOrder=7, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="timeout", refType="", isEnumeration=false, javaName="timeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="60", displayOrder=0, displayValue="Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getTimeout() {
        return this.timeout;
    }

    @XMLInfo(elementType="element", elementName="Timeout", elementOrder=7, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="timeout", refType="", isEnumeration=false, javaName="timeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="60", displayValue="Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^ ]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserName() {
        return this.userName;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^ ]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserName(String userName) {
        if (userName != null && userName.matches("^[^ ]+$")) {
            this.userName = userName;
        }
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password", refType="PasswordAlias", isEnumeration=false, javaName="password", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getPassword() {
        return this.password;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password", refType="PasswordAlias", isEnumeration=false, javaName="password", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPassword(ObjectReference<ConfigPasswordAlias> password) {
        this.password = password;
    }

    @XMLInfo(elementType="element", elementName="Method", elementOrder=10, dataPowerType="dmInvokeHTTPMethodType", subType="", benign=false, isPassword=false, cliAlias="method", refType="", isEnumeration=true, javaName="method", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="Keep", displayOrder=0, displayValue="HTTP method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMethod() {
        return this.method;
    }

    @XMLInfo(elementType="element", elementName="Method", elementOrder=10, dataPowerType="dmInvokeHTTPMethodType", subType="", benign=false, isPassword=false, cliAlias="method", refType="", isEnumeration=true, javaName="method", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="Keep", displayValue="HTTP method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMethod(String method) {
        if (Comparison.isIn(method, DPEnumerations.INVOKE_HTTPMETHOD_TYPE)) {
            this.method = method;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowWebSocketUpgrade", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="websocket-upgrade", refType="", isEnumeration=true, javaName="allowWebSocketUpgrade", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Allow WebSocket upgrade (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="10.0.2.0", isObsolete=false, obsoletedIn="")
    public String getAllowWebSocketUpgrade() {
        return this.allowWebSocketUpgrade;
    }

    @XMLInfo(elementType="element", elementName="AllowWebSocketUpgrade", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="websocket-upgrade", refType="", isEnumeration=true, javaName="allowWebSocketUpgrade", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Allow WebSocket upgrade (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="10.0.2.0", isObsolete=false, obsoletedIn="")
    public void setAllowWebSocketUpgrade(String allowWebSocketUpgrade) {
        if (allowWebSocketUpgrade == null || Comparison.isIn(allowWebSocketUpgrade, DPEnumerations.TOGGLE)) {
            this.allowWebSocketUpgrade = allowWebSocketUpgrade;
        }
    }

    @XMLInfo(elementType="element", elementName="BackendType", elementOrder=12, dataPowerType="dmInvokeBackendType", subType="", benign=false, isPassword=false, cliAlias="backend-type", refType="", isEnumeration=true, javaName="backendType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="detect", displayOrder=0, displayValue="Backend type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getBackendType() {
        return this.backendType;
    }

    @XMLInfo(elementType="element", elementName="BackendType", elementOrder=12, dataPowerType="dmInvokeBackendType", subType="", benign=false, isPassword=false, cliAlias="backend-type", refType="", isEnumeration=true, javaName="backendType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="detect", displayValue="Backend type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBackendType(String backendType) {
        if (Comparison.isIn(backendType, DPEnumerations.INVOKE_BACKEND_TYPE)) {
            this.backendType = backendType;
        }
    }

    @XMLInfo(elementType="element", elementName="GraphQLSendType", elementOrder=13, dataPowerType="dmInvokeGraphQLSendType", subType="", benign=false, isPassword=false, cliAlias="graphql-send-type", refType="", isEnumeration=true, javaName="graphQLSendType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="GraphQL send type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getGraphQLSendType() {
        return this.graphQLSendType;
    }

    @XMLInfo(elementType="element", elementName="GraphQLSendType", elementOrder=13, dataPowerType="dmInvokeGraphQLSendType", subType="", benign=false, isPassword=false, cliAlias="graphql-send-type", refType="", isEnumeration=true, javaName="graphQLSendType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="GraphQL send type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGraphQLSendType(String graphQLSendType) {
        if (graphQLSendType == null || Comparison.isIn(graphQLSendType, DPEnumerations.INVOKE_GRAPH_QLSEND_TYPE)) {
            this.graphQLSendType = graphQLSendType;
        }
    }

    @XMLInfo(elementType="element", elementName="Compression", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="compression", refType="", isEnumeration=true, javaName="compression", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable compression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCompression() {
        return this.compression;
    }

    @XMLInfo(elementType="element", elementName="Compression", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="compression", refType="", isEnumeration=true, javaName="compression", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable compression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCompression(String compression) {
        if (compression == null || Comparison.isIn(compression, DPEnumerations.TOGGLE)) {
            this.compression = compression;
        }
    }

    @XMLInfo(elementType="element", elementName="CacheType", elementOrder=15, dataPowerType="dmInvokeCacheType", subType="", benign=false, isPassword=false, cliAlias="cache-type", refType="", isEnumeration=true, javaName="cacheType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="Protocol", displayOrder=0, displayValue="Cache type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCacheType() {
        return this.cacheType;
    }

    @XMLInfo(elementType="element", elementName="CacheType", elementOrder=15, dataPowerType="dmInvokeCacheType", subType="", benign=false, isPassword=false, cliAlias="cache-type", refType="", isEnumeration=true, javaName="cacheType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="Protocol", displayValue="Cache type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheType(String cacheType) {
        if (Comparison.isIn(cacheType, DPEnumerations.INVOKE_CACHE_TYPE)) {
            this.cacheType = cacheType;
        }
    }

    @XMLInfo(elementType="element", elementName="TimeToLive", elementOrder=16, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ttl", refType="", isEnumeration=false, javaName="timeToLive", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="900", displayOrder=0, displayValue="Time to live", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @XMLInfo(elementType="element", elementName="TimeToLive", elementOrder=16, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="ttl", refType="", isEnumeration=false, javaName="timeToLive", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="900", displayValue="Time to live", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    @XMLInfo(elementType="element", elementName="CacheUnsafeResponse", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="cache-unsafe-response", refType="", isEnumeration=true, javaName="cacheUnsafeResponse", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Cache response to POST and PUT requests", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCacheUnsafeResponse() {
        return this.cacheUnsafeResponse;
    }

    @XMLInfo(elementType="element", elementName="CacheUnsafeResponse", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="cache-unsafe-response", refType="", isEnumeration=true, javaName="cacheUnsafeResponse", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Cache response to POST and PUT requests", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheUnsafeResponse(String cacheUnsafeResponse) {
        if (cacheUnsafeResponse == null || Comparison.isIn(cacheUnsafeResponse, DPEnumerations.TOGGLE)) {
            this.cacheUnsafeResponse = cacheUnsafeResponse;
        }
    }

    @XMLInfo(elementType="element", elementName="CacheKey", elementOrder=18, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="cache-key", refType="", isEnumeration=false, javaName="cacheKey", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Cache key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCacheKey() {
        return this.cacheKey;
    }

    @XMLInfo(elementType="element", elementName="CacheKey", elementOrder=18, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="cache-key", refType="", isEnumeration=false, javaName="cacheKey", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Cache key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    @XMLInfo(elementType="element", elementName="FollowRedirects", elementOrder=19, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="follow-redirects", refType="", isEnumeration=true, javaName="followRedirects", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Follow redirects", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFollowRedirects() {
        return this.followRedirects;
    }

    @XMLInfo(elementType="element", elementName="FollowRedirects", elementOrder=19, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="follow-redirects", refType="", isEnumeration=true, javaName="followRedirects", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Follow redirects", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFollowRedirects(String followRedirects) {
        if (followRedirects == null || Comparison.isIn(followRedirects, DPEnumerations.TOGGLE)) {
            this.followRedirects = followRedirects;
        }
    }

    @XMLInfo(elementType="element", elementName="UseHTTP10", elementOrder=20, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-http-10", refType="", isEnumeration=true, javaName="useHTTP10", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Restrict to HTTP/1.0 (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="10.0.1.1", isObsolete=false, obsoletedIn="")
    public String getUseHTTP10() {
        return this.useHTTP10;
    }

    @XMLInfo(elementType="element", elementName="UseHTTP10", elementOrder=20, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="use-http-10", refType="", isEnumeration=true, javaName="useHTTP10", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Restrict to HTTP/1.0 (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="10.0.1.1", isObsolete=false, obsoletedIn="")
    public void setUseHTTP10(String useHTTP10) {
        if (useHTTP10 == null || Comparison.isIn(useHTTP10, DPEnumerations.TOGGLE)) {
            this.useHTTP10 = useHTTP10;
        }
    }

    @XMLInfo(elementType="element", elementName="HTTPVersion", elementOrder=21, dataPowerType="dmHTTPVersion2", subType="", benign=false, isPassword=false, cliAlias="http-version", refType="", isEnumeration=true, javaName="hTTPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="HTTP/1.1", displayOrder=0, displayValue="HTTP version to server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPVersion() {
        return this.hTTPVersion;
    }

    @XMLInfo(elementType="element", elementName="HTTPVersion", elementOrder=21, dataPowerType="dmHTTPVersion2", subType="", benign=false, isPassword=false, cliAlias="http-version", refType="", isEnumeration=true, javaName="hTTPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="HTTP/1.1", displayValue="HTTP version to server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPVersion(String hTTPVersion) {
        if (hTTPVersion == null || Comparison.isIn(hTTPVersion, DPEnumerations.HTTPVERSION2)) {
            this.hTTPVersion = hTTPVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="HTTP2Required", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="http2-required", refType="", isEnumeration=true, javaName="hTTP2Required", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="HTTP/2 required", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTP2Required() {
        return this.hTTP2Required;
    }

    @XMLInfo(elementType="element", elementName="HTTP2Required", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="http2-required", refType="", isEnumeration=true, javaName="hTTP2Required", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="HTTP/2 required", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTP2Required(String hTTP2Required) {
        if (hTTP2Required == null || Comparison.isIn(hTTP2Required, DPEnumerations.TOGGLE)) {
            this.hTTP2Required = hTTP2Required;
        }
    }

    @XMLInfo(elementType="element", elementName="DoChunkedUpload", elementOrder=23, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="chunked-uploads", refType="", isEnumeration=true, javaName="doChunkedUpload", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Allow chunked uploads", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDoChunkedUpload() {
        return this.doChunkedUpload;
    }

    @XMLInfo(elementType="element", elementName="DoChunkedUpload", elementOrder=23, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="chunked-uploads", refType="", isEnumeration=true, javaName="doChunkedUpload", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Allow chunked uploads", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDoChunkedUpload(String doChunkedUpload) {
        if (doChunkedUpload == null || Comparison.isIn(doChunkedUpload, DPEnumerations.TOGGLE)) {
            this.doChunkedUpload = doChunkedUpload;
        }
    }

    @XMLInfo(elementType="element", elementName="PersistentConnection", elementOrder=24, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="persistent-connection", refType="", isEnumeration=true, javaName="persistentConnection", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Persistent connection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPersistentConnection() {
        return this.persistentConnection;
    }

    @XMLInfo(elementType="element", elementName="PersistentConnection", elementOrder=24, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="persistent-connection", refType="", isEnumeration=true, javaName="persistentConnection", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Persistent connection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPersistentConnection(String persistentConnection) {
        if (persistentConnection == null || Comparison.isIn(persistentConnection, DPEnumerations.TOGGLE)) {
            this.persistentConnection = persistentConnection;
        }
    }

    @XMLInfo(elementType="element", elementName="StopOnError", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="stop-on-error", refType="", isEnumeration=true, javaName="stopOnError", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Stop on error", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStopOnError() {
        return this.stopOnError;
    }

    @XMLInfo(elementType="element", elementName="StopOnError", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="stop-on-error", refType="", isEnumeration=true, javaName="stopOnError", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Stop on error", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStopOnError(String stopOnError) {
        if (stopOnError == null || Comparison.isIn(stopOnError, DPEnumerations.TOGGLE)) {
            this.stopOnError = stopOnError;
        }
    }

    @XMLInfo(elementType="element", elementName="ErrorTypes", elementOrder=26, dataPowerType="dmInvokeErrorType", subType="", benign=false, isPassword=false, cliAlias="error-types", refType="", isEnumeration=false, javaName="errorTypes", javaType="InvokeErrorType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Error types", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public InvokeErrorType getErrorTypes() {
        return this.errorTypes;
    }

    @XMLInfo(elementType="element", elementName="ErrorTypes", elementOrder=26, dataPowerType="dmInvokeErrorType", subType="", benign=false, isPassword=false, cliAlias="error-types", refType="", isEnumeration=false, javaName="errorTypes", javaType="InvokeErrorType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Error types", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setErrorTypes(InvokeErrorType errorTypes) {
        this.errorTypes = errorTypes;
    }

    @XMLInfo(elementType="element", elementName="Output", elementOrder=27, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="output", refType="", isEnumeration=false, javaName="output", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="message", displayOrder=0, displayValue="Output", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOutput() {
        return this.output;
    }

    @XMLInfo(elementType="element", elementName="Output", elementOrder=27, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="output", refType="", isEnumeration=false, javaName="output", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="message", displayValue="Output", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOutput(String output) {
        this.output = output;
    }

    @XMLInfo(elementType="element", elementName="DecodeRequestParams", elementOrder=28, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="decode-request-params", refType="", isEnumeration=true, javaName="decodeRequestParams", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Decode request parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDecodeRequestParams() {
        return this.decodeRequestParams;
    }

    @XMLInfo(elementType="element", elementName="DecodeRequestParams", elementOrder=28, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="decode-request-params", refType="", isEnumeration=true, javaName="decodeRequestParams", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Decode request parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDecodeRequestParams(String decodeRequestParams) {
        if (decodeRequestParams == null || Comparison.isIn(decodeRequestParams, DPEnumerations.TOGGLE)) {
            this.decodeRequestParams = decodeRequestParams;
        }
    }

    @XMLInfo(elementType="element", elementName="EncodePlusChar", elementOrder=29, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="encode-plus-char", refType="", isEnumeration=true, javaName="encodePlusChar", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Encode + characters in query", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncodePlusChar() {
        return this.encodePlusChar;
    }

    @XMLInfo(elementType="element", elementName="EncodePlusChar", elementOrder=29, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="encode-plus-char", refType="", isEnumeration=true, javaName="encodePlusChar", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Encode + characters in query", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncodePlusChar(String encodePlusChar) {
        if (encodePlusChar == null || Comparison.isIn(encodePlusChar, DPEnumerations.TOGGLE)) {
            this.encodePlusChar = encodePlusChar;
        }
    }

    @XMLInfo(elementType="element", elementName="KeepPayload", elementOrder=30, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="keep-payload", refType="", isEnumeration=true, javaName="keepPayload", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Keep payload", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getKeepPayload() {
        return this.keepPayload;
    }

    @XMLInfo(elementType="element", elementName="KeepPayload", elementOrder=30, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="keep-payload", refType="", isEnumeration=true, javaName="keepPayload", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Keep payload", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setKeepPayload(String keepPayload) {
        if (keepPayload == null || Comparison.isIn(keepPayload, DPEnumerations.TOGGLE)) {
            this.keepPayload = keepPayload;
        }
    }

    @XMLInfo(elementType="element", elementName="InjectUserAgentHeader", elementOrder=31, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="inject-user-agent", refType="", isEnumeration=true, javaName="injectUserAgentHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Inject User-Agent header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getInjectUserAgentHeader() {
        return this.injectUserAgentHeader;
    }

    @XMLInfo(elementType="element", elementName="InjectUserAgentHeader", elementOrder=31, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="inject-user-agent", refType="", isEnumeration=true, javaName="injectUserAgentHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Inject User-Agent header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setInjectUserAgentHeader(String injectUserAgentHeader) {
        if (injectUserAgentHeader == null || Comparison.isIn(injectUserAgentHeader, DPEnumerations.TOGGLE)) {
            this.injectUserAgentHeader = injectUserAgentHeader;
        }
    }

    @XMLInfo(elementType="element", elementName="InjectProxyHeaders", elementOrder=32, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="inject-proxy-headers", refType="", isEnumeration=true, javaName="injectProxyHeaders", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Inject proxy headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getInjectProxyHeaders() {
        return this.injectProxyHeaders;
    }

    @XMLInfo(elementType="element", elementName="InjectProxyHeaders", elementOrder=32, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="inject-proxy-headers", refType="", isEnumeration=true, javaName="injectProxyHeaders", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Inject proxy headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setInjectProxyHeaders(String injectProxyHeaders) {
        if (injectProxyHeaders == null || Comparison.isIn(injectProxyHeaders, DPEnumerations.TOGGLE)) {
            this.injectProxyHeaders = injectProxyHeaders;
        }
    }

    @XMLInfo(elementType="element", elementName="HeaderControlList", elementOrder=33, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="header-control-list", refType="ControlList", isEnumeration=false, javaName="headerControlList", javaType="ObjectReference<ConfigControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default-accept-all", displayOrder=0, displayValue="Header control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigControlList> getHeaderControlList() {
        return this.headerControlList;
    }

    @XMLInfo(elementType="element", elementName="HeaderControlList", elementOrder=33, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="header-control-list", refType="ControlList", isEnumeration=false, javaName="headerControlList", javaType="ObjectReference<ConfigControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default-accept-all", displayValue="Header control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHeaderControlList(ObjectReference<ConfigControlList> headerControlList) {
        this.headerControlList = headerControlList;
    }

    @XMLInfo(elementType="element", elementName="ParameterControlList", elementOrder=34, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="parameter-control-list", refType="ControlList", isEnumeration=false, javaName="parameterControlList", javaType="ObjectReference<ConfigControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default-reject-all", displayOrder=0, displayValue="Parameter control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigControlList> getParameterControlList() {
        return this.parameterControlList;
    }

    @XMLInfo(elementType="element", elementName="ParameterControlList", elementOrder=34, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="parameter-control-list", refType="ControlList", isEnumeration=false, javaName="parameterControlList", javaType="ObjectReference<ConfigControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default-reject-all", displayValue="Parameter control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setParameterControlList(ObjectReference<ConfigControlList> parameterControlList) {
        this.parameterControlList = parameterControlList;
    }

    @Override
    public int compareTo(ConfigAssemblyActionInvoke that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "url", "sSLClient", "timeout", "userName", "password", "method", "allowWebSocketUpgrade", "backendType", "graphQLSendType", "compression", "cacheType", "timeToLive", "cacheUnsafeResponse", "cacheKey", "followRedirects", "useHTTP10", "hTTPVersion", "hTTP2Required", "doChunkedUpload", "persistentConnection", "stopOnError", "errorTypes", "output", "decodeRequestParams", "encodePlusChar", "keepPayload", "injectUserAgentHeader", "injectProxyHeaders", "headerControlList", "parameterControlList");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.url, this.sSLClient, this.timeout, this.userName, this.password, this.method, this.allowWebSocketUpgrade, this.backendType, this.graphQLSendType, this.compression, this.cacheType, this.timeToLive, this.cacheUnsafeResponse, this.cacheKey, this.followRedirects, this.useHTTP10, this.hTTPVersion, this.hTTP2Required, this.doChunkedUpload, this.persistentConnection, this.stopOnError, this.errorTypes, this.output, this.decodeRequestParams, this.encodePlusChar, this.keepPayload, this.injectUserAgentHeader, this.injectProxyHeaders, this.headerControlList, this.parameterControlList);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "url", "sSLClient", "timeout", "userName", "password", "method", "allowWebSocketUpgrade", "backendType", "graphQLSendType", "compression", "cacheType", "timeToLive", "cacheUnsafeResponse", "cacheKey", "followRedirects", "useHTTP10", "hTTPVersion", "hTTP2Required", "doChunkedUpload", "persistentConnection", "stopOnError", "errorTypes", "output", "decodeRequestParams", "encodePlusChar", "keepPayload", "injectUserAgentHeader", "injectProxyHeaders", "headerControlList", "parameterControlList");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("url", "sSLClient", "timeout", "userName", "password", "method", "allowWebSocketUpgrade", "backendType", "graphQLSendType", "compression", "cacheType", "timeToLive", "cacheUnsafeResponse", "cacheKey", "followRedirects", "useHTTP10", "hTTPVersion", "hTTP2Required", "doChunkedUpload", "persistentConnection", "stopOnError", "errorTypes", "output", "decodeRequestParams", "encodePlusChar", "keepPayload", "injectUserAgentHeader", "injectProxyHeaders", "headerControlList", "parameterControlList"));
    }
}

