/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.types.CloudGatewayTarget;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigCloudGatewayService
extends ConfigConfigBase {
    private String userSummary;
    private String priority;
    private long connTimeout;
    private String localAddress;
    private int localPort;
    private ObjectReference<ConfigSSLProxyProfile> sSLProxy;
    private long frontTimeout;
    private ArrayList<CloudGatewayTarget> backConnections;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=2, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="normal", displayOrder=0, displayValue="Service priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPriority() {
        return this.priority;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=2, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="normal", displayValue="Service priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPriority(String priority) {
        if (priority == null || Comparison.isIn(priority, DPEnumerations.SCHEDULER_PRIORITY)) {
            this.priority = priority;
        }
    }

    @XMLInfo(elementType="element", elementName="ConnTimeout", elementOrder=3, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="connection-timeout", refType="", isEnumeration=false, javaName="connTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Transaction timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getConnTimeout() {
        return this.connTimeout;
    }

    @XMLInfo(elementType="element", elementName="ConnTimeout", elementOrder=3, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="connection-timeout", refType="", isEnumeration=false, javaName="connTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Transaction timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConnTimeout(long connTimeout) {
        this.connTimeout = connTimeout;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=4, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="address", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0.0.0.0", displayOrder=0, displayValue="Local address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLocalAddress() {
        return this.localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=4, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="address", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0.0.0.0", displayValue="Local address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=5, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="local-port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Local port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLocalPort() {
        return this.localPort;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=5, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="local-port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Local port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getSSLProxy() {
        return this.sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLProxy(ObjectReference<ConfigSSLProxyProfile> sSLProxy) {
        this.sSLProxy = sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="FrontTimeout", elementOrder=7, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-timeout", refType="", isEnumeration=false, javaName="frontTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Cloud-based client timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getFrontTimeout() {
        return this.frontTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontTimeout", elementOrder=7, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-timeout", refType="", isEnumeration=false, javaName="frontTimeout", javaType="long", isRequired=true, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Cloud-based client timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontTimeout(long frontTimeout) {
        this.frontTimeout = frontTimeout;
    }

    public void addBackConnections(CloudGatewayTarget element) {
        if (element == null) {
            return;
        }
        if (this.backConnections == null) {
            this.backConnections = new ArrayList();
        }
        this.backConnections.add(element);
    }

    public boolean removeBackConnections(CloudGatewayTarget element) {
        if (element == null || this.backConnections == null) {
            return false;
        }
        return this.backConnections.remove(element);
    }

    @XMLInfo(elementType="element", elementName="BackConnections", elementOrder=8, dataPowerType="dmCloudGatewayTarget", subType="", benign=false, isPassword=false, cliAlias="back-connections", refType="", isEnumeration=false, javaName="backConnections", javaType="CloudGatewayTarget", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Allowed enterprise application connections", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<CloudGatewayTarget> getBackConnections() {
        return this.backConnections;
    }

    @XMLInfo(elementType="element", elementName="BackConnections", elementOrder=8, dataPowerType="dmCloudGatewayTarget", subType="", benign=false, isPassword=false, cliAlias="back-connections", refType="", isEnumeration=false, javaName="backConnections", javaType="CloudGatewayTarget", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Allowed enterprise application connections", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBackConnections(ArrayList<CloudGatewayTarget> backConnections) {
        this.backConnections = backConnections;
    }

    @Override
    public int compareTo(ConfigCloudGatewayService that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "priority", "connTimeout", "localAddress", "localPort", "sSLProxy", "frontTimeout", "backConnections");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.priority, this.connTimeout, this.localAddress, this.localPort, this.sSLProxy, this.frontTimeout, this.backConnections);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "priority", "connTimeout", "localAddress", "localPort", "sSLProxy", "frontTimeout", "backConnections");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "priority", "connTimeout", "localAddress", "localPort", "sSLProxy", "frontTimeout", "backConnections"));
    }
}

