/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigCompileSettings
extends ConfigConfigBase {
    private String userSummary;
    private String xSLTVersion;
    private String strict;
    private String profile;
    private String debug;
    private String stream;
    private String tryStream;
    private String minimumEscaping;
    private long stackSize;
    private String wSIValidation;
    private String wSDLValidateBody;
    private String wSDLValidateHeaders;
    private String wSDLValidateFaults;
    private String wSDLWrappedFaults;
    private String allowSoapEncArray;
    private String validateSoapEncArray;
    private String wildcardsIgnoreXsiType;
    private String wSDLStrictSOAPVersion;
    private String xACMLDebug;
    private String allowXOPInclude;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="XSLTVersion", elementOrder=2, dataPowerType="dmXSLTVersion", subType="", benign=false, isPassword=false, cliAlias="xslt-version", refType="", isEnumeration=true, javaName="xSLTVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="XSLT10", displayOrder=0, displayValue="XSLT version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getXSLTVersion() {
        return this.xSLTVersion;
    }

    @XMLInfo(elementType="element", elementName="XSLTVersion", elementOrder=2, dataPowerType="dmXSLTVersion", subType="", benign=false, isPassword=false, cliAlias="xslt-version", refType="", isEnumeration=true, javaName="xSLTVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="XSLT10", displayValue="XSLT version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXSLTVersion(String xSLTVersion) {
        if (xSLTVersion == null || Comparison.isIn(xSLTVersion, DPEnumerations.XSLTVERSION)) {
            this.xSLTVersion = xSLTVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="Strict", elementOrder=3, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="strict", refType="", isEnumeration=true, javaName="strict", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Strict", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStrict() {
        return this.strict;
    }

    @XMLInfo(elementType="element", elementName="Strict", elementOrder=3, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="strict", refType="", isEnumeration=true, javaName="strict", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Strict", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStrict(String strict) {
        if (strict == null || Comparison.isIn(strict, DPEnumerations.TOGGLE)) {
            this.strict = strict;
        }
    }

    @XMLInfo(elementType="element", elementName="Profile", elementOrder=4, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="profile", refType="", isEnumeration=true, javaName="profile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Profile rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getProfile() {
        return this.profile;
    }

    @XMLInfo(elementType="element", elementName="Profile", elementOrder=4, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="profile", refType="", isEnumeration=true, javaName="profile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Profile rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProfile(String profile) {
        if (profile == null || Comparison.isIn(profile, DPEnumerations.TOGGLE)) {
            this.profile = profile;
        }
    }

    @XMLInfo(elementType="element", elementName="Debug", elementOrder=5, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="debug", refType="", isEnumeration=true, javaName="debug", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Debug rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDebug() {
        return this.debug;
    }

    @XMLInfo(elementType="element", elementName="Debug", elementOrder=5, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="debug", refType="", isEnumeration=true, javaName="debug", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Debug rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDebug(String debug) {
        if (debug == null || Comparison.isIn(debug, DPEnumerations.TOGGLE)) {
            this.debug = debug;
        }
    }

    @XMLInfo(elementType="element", elementName="Stream", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="stream", refType="", isEnumeration=true, javaName="stream", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Streaming rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStream() {
        return this.stream;
    }

    @XMLInfo(elementType="element", elementName="Stream", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="stream", refType="", isEnumeration=true, javaName="stream", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Streaming rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStream(String stream) {
        if (stream == null || Comparison.isIn(stream, DPEnumerations.TOGGLE)) {
            this.stream = stream;
        }
    }

    @XMLInfo(elementType="element", elementName="TryStream", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="try-stream", refType="", isEnumeration=true, javaName="tryStream", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Attempt streaming rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTryStream() {
        return this.tryStream;
    }

    @XMLInfo(elementType="element", elementName="TryStream", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="try-stream", refType="", isEnumeration=true, javaName="tryStream", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Attempt streaming rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTryStream(String tryStream) {
        if (tryStream == null || Comparison.isIn(tryStream, DPEnumerations.TOGGLE)) {
            this.tryStream = tryStream;
        }
    }

    @XMLInfo(elementType="element", elementName="MinimumEscaping", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="minesc", refType="", isEnumeration=true, javaName="minimumEscaping", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Minimum output escaping rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMinimumEscaping() {
        return this.minimumEscaping;
    }

    @XMLInfo(elementType="element", elementName="MinimumEscaping", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="minesc", refType="", isEnumeration=true, javaName="minimumEscaping", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Minimum output escaping rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMinimumEscaping(String minimumEscaping) {
        if (minimumEscaping == null || Comparison.isIn(minimumEscaping, DPEnumerations.TOGGLE)) {
            this.minimumEscaping = minimumEscaping;
        }
    }

    @XMLInfo(elementType="element", elementName="StackSize", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="stack-size", refType="", isEnumeration=false, javaName="stackSize", javaType="long", isRequired=false, squelchNull=false, minimum=10240, maximum=0x6400000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1048576", displayOrder=0, displayValue="Maximum stack size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getStackSize() {
        return this.stackSize;
    }

    @XMLInfo(elementType="element", elementName="StackSize", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="stack-size", refType="", isEnumeration=false, javaName="stackSize", javaType="long", isRequired=false, squelchNull=false, minimum=10240, maximum=0x6400000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1048576", displayValue="Maximum stack size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStackSize(long stackSize) {
        this.stackSize = stackSize;
    }

    @XMLInfo(elementType="element", elementName="WSIValidation", elementOrder=10, dataPowerType="dmWSIValidationMode", subType="", benign=false, isPassword=false, cliAlias="wsi-validate", refType="", isEnumeration=true, javaName="wSIValidation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="warn", displayOrder=0, displayValue="WS-I Basic Profile validation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getWSIValidation() {
        return this.wSIValidation;
    }

    @XMLInfo(elementType="element", elementName="WSIValidation", elementOrder=10, dataPowerType="dmWSIValidationMode", subType="", benign=false, isPassword=false, cliAlias="wsi-validate", refType="", isEnumeration=true, javaName="wSIValidation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="warn", displayValue="WS-I Basic Profile validation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setWSIValidation(String wSIValidation) {
        if (wSIValidation == null || Comparison.isIn(wSIValidation, DPEnumerations.WSIVALIDATION_MODE)) {
            this.wSIValidation = wSIValidation;
        }
    }

    @XMLInfo(elementType="element", elementName="WSDLValidateBody", elementOrder=11, dataPowerType="dmWSDLValidationMode", subType="", benign=false, isPassword=false, cliAlias="wsdl-validate-body", refType="", isEnumeration=true, javaName="wSDLValidateBody", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="strict", displayOrder=0, displayValue="Validate message body", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getWSDLValidateBody() {
        return this.wSDLValidateBody;
    }

    @XMLInfo(elementType="element", elementName="WSDLValidateBody", elementOrder=11, dataPowerType="dmWSDLValidationMode", subType="", benign=false, isPassword=false, cliAlias="wsdl-validate-body", refType="", isEnumeration=true, javaName="wSDLValidateBody", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="strict", displayValue="Validate message body", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setWSDLValidateBody(String wSDLValidateBody) {
        if (wSDLValidateBody == null || Comparison.isIn(wSDLValidateBody, DPEnumerations.WSDLVALIDATION_MODE)) {
            this.wSDLValidateBody = wSDLValidateBody;
        }
    }

    @XMLInfo(elementType="element", elementName="WSDLValidateHeaders", elementOrder=12, dataPowerType="dmWSDLValidationMode", subType="", benign=false, isPassword=false, cliAlias="wsdl-validate-headers", refType="", isEnumeration=true, javaName="wSDLValidateHeaders", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="lax", displayOrder=0, displayValue="Validate message headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getWSDLValidateHeaders() {
        return this.wSDLValidateHeaders;
    }

    @XMLInfo(elementType="element", elementName="WSDLValidateHeaders", elementOrder=12, dataPowerType="dmWSDLValidationMode", subType="", benign=false, isPassword=false, cliAlias="wsdl-validate-headers", refType="", isEnumeration=true, javaName="wSDLValidateHeaders", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="lax", displayValue="Validate message headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setWSDLValidateHeaders(String wSDLValidateHeaders) {
        if (wSDLValidateHeaders == null || Comparison.isIn(wSDLValidateHeaders, DPEnumerations.WSDLVALIDATION_MODE)) {
            this.wSDLValidateHeaders = wSDLValidateHeaders;
        }
    }

    @XMLInfo(elementType="element", elementName="WSDLValidateFaults", elementOrder=13, dataPowerType="dmWSDLValidationMode", subType="", benign=false, isPassword=false, cliAlias="wsdl-validate-faults", refType="", isEnumeration=true, javaName="wSDLValidateFaults", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="strict", displayOrder=0, displayValue="Validate message fault details", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getWSDLValidateFaults() {
        return this.wSDLValidateFaults;
    }

    @XMLInfo(elementType="element", elementName="WSDLValidateFaults", elementOrder=13, dataPowerType="dmWSDLValidationMode", subType="", benign=false, isPassword=false, cliAlias="wsdl-validate-faults", refType="", isEnumeration=true, javaName="wSDLValidateFaults", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="strict", displayValue="Validate message fault details", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setWSDLValidateFaults(String wSDLValidateFaults) {
        if (wSDLValidateFaults == null || Comparison.isIn(wSDLValidateFaults, DPEnumerations.WSDLVALIDATION_MODE)) {
            this.wSDLValidateFaults = wSDLValidateFaults;
        }
    }

    @XMLInfo(elementType="element", elementName="WSDLWrappedFaults", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="wsdl-wrapped-faults", refType="", isEnumeration=true, javaName="wSDLWrappedFaults", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require wrappers on fault details specified by type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getWSDLWrappedFaults() {
        return this.wSDLWrappedFaults;
    }

    @XMLInfo(elementType="element", elementName="WSDLWrappedFaults", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="wsdl-wrapped-faults", refType="", isEnumeration=true, javaName="wSDLWrappedFaults", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require wrappers on fault details specified by type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setWSDLWrappedFaults(String wSDLWrappedFaults) {
        if (wSDLWrappedFaults == null || Comparison.isIn(wSDLWrappedFaults, DPEnumerations.TOGGLE)) {
            this.wSDLWrappedFaults = wSDLWrappedFaults;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowSoapEncArray", elementOrder=15, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-soap-enc-array", refType="", isEnumeration=true, javaName="allowSoapEncArray", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Specifically allow xsi:type='SOAP-ENC:Array' rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowSoapEncArray() {
        return this.allowSoapEncArray;
    }

    @XMLInfo(elementType="element", elementName="AllowSoapEncArray", elementOrder=15, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-soap-enc-array", refType="", isEnumeration=true, javaName="allowSoapEncArray", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Specifically allow xsi:type='SOAP-ENC:Array' rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowSoapEncArray(String allowSoapEncArray) {
        if (allowSoapEncArray == null || Comparison.isIn(allowSoapEncArray, DPEnumerations.TOGGLE)) {
            this.allowSoapEncArray = allowSoapEncArray;
        }
    }

    @XMLInfo(elementType="element", elementName="ValidateSoapEncArray", elementOrder=16, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="validate-soap-enc-array", refType="", isEnumeration=true, javaName="validateSoapEncArray", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Validate SOAP 1.1 encoding rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getValidateSoapEncArray() {
        return this.validateSoapEncArray;
    }

    @XMLInfo(elementType="element", elementName="ValidateSoapEncArray", elementOrder=16, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="validate-soap-enc-array", refType="", isEnumeration=true, javaName="validateSoapEncArray", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Validate SOAP 1.1 encoding rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setValidateSoapEncArray(String validateSoapEncArray) {
        if (validateSoapEncArray == null || Comparison.isIn(validateSoapEncArray, DPEnumerations.TOGGLE)) {
            this.validateSoapEncArray = validateSoapEncArray;
        }
    }

    @XMLInfo(elementType="element", elementName="WildcardsIgnoreXsiType", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="wildcards-ignore-xsi-type", refType="", isEnumeration=true, javaName="wildcardsIgnoreXsiType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Wildcards ignore xsi:type rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getWildcardsIgnoreXsiType() {
        return this.wildcardsIgnoreXsiType;
    }

    @XMLInfo(elementType="element", elementName="WildcardsIgnoreXsiType", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="wildcards-ignore-xsi-type", refType="", isEnumeration=true, javaName="wildcardsIgnoreXsiType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Wildcards ignore xsi:type rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setWildcardsIgnoreXsiType(String wildcardsIgnoreXsiType) {
        if (wildcardsIgnoreXsiType == null || Comparison.isIn(wildcardsIgnoreXsiType, DPEnumerations.TOGGLE)) {
            this.wildcardsIgnoreXsiType = wildcardsIgnoreXsiType;
        }
    }

    @XMLInfo(elementType="element", elementName="WSDLStrictSOAPVersion", elementOrder=18, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="wsdl-strict-soap-version", refType="", isEnumeration=true, javaName="wSDLStrictSOAPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Strict SOAP envelope version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getWSDLStrictSOAPVersion() {
        return this.wSDLStrictSOAPVersion;
    }

    @XMLInfo(elementType="element", elementName="WSDLStrictSOAPVersion", elementOrder=18, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="wsdl-strict-soap-version", refType="", isEnumeration=true, javaName="wSDLStrictSOAPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Strict SOAP envelope version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setWSDLStrictSOAPVersion(String wSDLStrictSOAPVersion) {
        if (wSDLStrictSOAPVersion == null || Comparison.isIn(wSDLStrictSOAPVersion, DPEnumerations.TOGGLE)) {
            this.wSDLStrictSOAPVersion = wSDLStrictSOAPVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="XACMLDebug", elementOrder=19, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="xacml-debug", refType="", isEnumeration=true, javaName="xACMLDebug", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Debug XACML policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getXACMLDebug() {
        return this.xACMLDebug;
    }

    @XMLInfo(elementType="element", elementName="XACMLDebug", elementOrder=19, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="xacml-debug", refType="", isEnumeration=true, javaName="xACMLDebug", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Debug XACML policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXACMLDebug(String xACMLDebug) {
        if (xACMLDebug == null || Comparison.isIn(xACMLDebug, DPEnumerations.TOGGLE)) {
            this.xACMLDebug = xACMLDebug;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowXOPInclude", elementOrder=20, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-xop-include", refType="", isEnumeration=true, javaName="allowXOPInclude", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Accept MTOM/XOP optimized messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowXOPInclude() {
        return this.allowXOPInclude;
    }

    @XMLInfo(elementType="element", elementName="AllowXOPInclude", elementOrder=20, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-xop-include", refType="", isEnumeration=true, javaName="allowXOPInclude", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Accept MTOM/XOP optimized messages", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowXOPInclude(String allowXOPInclude) {
        if (allowXOPInclude == null || Comparison.isIn(allowXOPInclude, DPEnumerations.TOGGLE)) {
            this.allowXOPInclude = allowXOPInclude;
        }
    }

    @Override
    public int compareTo(ConfigCompileSettings that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "xSLTVersion", "strict", "profile", "debug", "stream", "tryStream", "minimumEscaping", "stackSize", "wSIValidation", "wSDLValidateBody", "wSDLValidateHeaders", "wSDLValidateFaults", "wSDLWrappedFaults", "allowSoapEncArray", "validateSoapEncArray", "wildcardsIgnoreXsiType", "wSDLStrictSOAPVersion", "xACMLDebug", "allowXOPInclude");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.xSLTVersion, this.strict, this.profile, this.debug, this.stream, this.tryStream, this.minimumEscaping, this.stackSize, this.wSIValidation, this.wSDLValidateBody, this.wSDLValidateHeaders, this.wSDLValidateFaults, this.wSDLWrappedFaults, this.allowSoapEncArray, this.validateSoapEncArray, this.wildcardsIgnoreXsiType, this.wSDLStrictSOAPVersion, this.xACMLDebug, this.allowXOPInclude);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "xSLTVersion", "strict", "profile", "debug", "stream", "tryStream", "minimumEscaping", "stackSize", "wSIValidation", "wSDLValidateBody", "wSDLValidateHeaders", "wSDLValidateFaults", "wSDLWrappedFaults", "allowSoapEncArray", "validateSoapEncArray", "wildcardsIgnoreXsiType", "wSDLStrictSOAPVersion", "xACMLDebug", "allowXOPInclude");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "xSLTVersion", "strict", "profile", "debug", "stream", "tryStream", "minimumEscaping", "stackSize", "wSIValidation", "wSDLValidateBody", "wSDLValidateHeaders", "wSDLValidateFaults", "wSDLWrappedFaults", "allowSoapEncArray", "validateSoapEncArray", "wildcardsIgnoreXsiType", "wSDLStrictSOAPVersion", "xACMLDebug", "allowXOPInclude"));
    }
}

