/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAAAPolicy;
import com.kumbasoft.core.beans.config.ConfigAccessControlList;
import com.kumbasoft.core.beans.config.ConfigNFSStaticMount;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.config.ConfigSSLSNIServerProfile;
import com.kumbasoft.core.beans.config.ConfigSSLServerProfile;
import com.kumbasoft.core.beans.config.ConfigSourceProtocolHandler;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.FTPServerVirtualDirectory;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigFTPDemonSourceProtocolHandler
extends ConfigSourceProtocolHandler {
    private String userSummary;
    private String localAddress;
    private int localPort;
    private String filesystemType;
    private long persistentFilesystemTimeout;
    private ArrayList<FTPServerVirtualDirectory> virtualDirectories;
    private String defaultDirectory;
    private long maxFilenameLength;
    private ObjectReference<ConfigAccessControlList> aCL;
    private String requireTLS;
    private ObjectReference<ConfigSSLProxyProfile> sSLProxy;
    private ObjectReference<ConfigAAAPolicy> passwordAAAPolicy;
    private ObjectReference<ConfigAAAPolicy> certificateAAAPolicy;
    private String allowCCC;
    private String passive;
    private String usePasvPortRange;
    private int pasvMinPort;
    private int pasvMaxPort;
    private long pasvIdleTimeOut;
    private String disablePASVIPCheck;
    private String disablePORTIPCheck;
    private String useAlternatePASVAddr;
    private String alternatePASVAddr;
    private String allowLISTCmd;
    private String allowDELECmd;
    private String dataEncryption;
    private String allowCompression;
    private String allowSTOU;
    private String uniqueFilenamePrefix;
    private String allowREST;
    private long restartTimeout;
    private long idleTimeout;
    private String responseType;
    private String responseStorage;
    private long temporaryStorageSize;
    private ObjectReference<ConfigNFSStaticMount> responseNFSMount;
    private String responseSuffix;
    private String sSLServerConfigType;
    private ObjectReference<ConfigSSLServerProfile> sSLServer;
    private ObjectReference<ConfigSSLSNIServerProfile> sSLSNIServer;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=2, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="address", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0.0.0.0", displayOrder=0, displayValue="Local IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLocalAddress() {
        return this.localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=2, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="address", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0.0.0.0", displayValue="Local IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="21", displayOrder=0, displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLocalPort() {
        return this.localPort;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="21", displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @XMLInfo(elementType="element", elementName="FilesystemType", elementOrder=4, dataPowerType="dmFTPFilesystemType", subType="", benign=false, isPassword=false, cliAlias="filesystem", refType="", isEnumeration=true, javaName="filesystemType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="virtual-ephemeral", displayOrder=0, displayValue="File system type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFilesystemType() {
        return this.filesystemType;
    }

    @XMLInfo(elementType="element", elementName="FilesystemType", elementOrder=4, dataPowerType="dmFTPFilesystemType", subType="", benign=false, isPassword=false, cliAlias="filesystem", refType="", isEnumeration=true, javaName="filesystemType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="virtual-ephemeral", displayValue="File system type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFilesystemType(String filesystemType) {
        if (filesystemType == null || Comparison.isIn(filesystemType, DPEnumerations.FTPFILESYSTEM_TYPE)) {
            this.filesystemType = filesystemType;
        }
    }

    @XMLInfo(elementType="element", elementName="PersistentFilesystemTimeout", elementOrder=5, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="persistent-filesystem-timeout", refType="", isEnumeration=false, javaName="persistentFilesystemTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=43200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="600", displayOrder=0, displayValue="Persistent timeout", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getPersistentFilesystemTimeout() {
        return this.persistentFilesystemTimeout;
    }

    @XMLInfo(elementType="element", elementName="PersistentFilesystemTimeout", elementOrder=5, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="persistent-filesystem-timeout", refType="", isEnumeration=false, javaName="persistentFilesystemTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=43200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="600", displayValue="Persistent timeout", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPersistentFilesystemTimeout(long persistentFilesystemTimeout) {
        this.persistentFilesystemTimeout = persistentFilesystemTimeout;
    }

    public void addVirtualDirectories(FTPServerVirtualDirectory element) {
        if (element == null) {
            return;
        }
        if (this.virtualDirectories == null) {
            this.virtualDirectories = new ArrayList();
        }
        this.virtualDirectories.add(element);
    }

    public boolean removeVirtualDirectories(FTPServerVirtualDirectory element) {
        if (element == null || this.virtualDirectories == null) {
            return false;
        }
        return this.virtualDirectories.remove(element);
    }

    @XMLInfo(elementType="element", elementName="VirtualDirectories", elementOrder=6, dataPowerType="dmFTPServerVirtualDirectory", subType="", benign=false, isPassword=false, cliAlias="virtual-directory", refType="", isEnumeration=false, javaName="virtualDirectories", javaType="FTPServerVirtualDirectory", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Virtual directories", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<FTPServerVirtualDirectory> getVirtualDirectories() {
        return this.virtualDirectories;
    }

    @XMLInfo(elementType="element", elementName="VirtualDirectories", elementOrder=6, dataPowerType="dmFTPServerVirtualDirectory", subType="", benign=false, isPassword=false, cliAlias="virtual-directory", refType="", isEnumeration=false, javaName="virtualDirectories", javaType="FTPServerVirtualDirectory", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Virtual directories", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setVirtualDirectories(ArrayList<FTPServerVirtualDirectory> virtualDirectories) {
        this.virtualDirectories = virtualDirectories;
    }

    @XMLInfo(elementType="element", elementName="DefaultDirectory", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="default-directory", refType="", isEnumeration=false, javaName="defaultDirectory", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="/", displayOrder=0, displayValue="Default directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDefaultDirectory() {
        return this.defaultDirectory;
    }

    @XMLInfo(elementType="element", elementName="DefaultDirectory", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="default-directory", refType="", isEnumeration=false, javaName="defaultDirectory", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="/", displayValue="Default directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDefaultDirectory(String defaultDirectory) {
        this.defaultDirectory = defaultDirectory;
    }

    @XMLInfo(elementType="element", elementName="MaxFilenameLength", elementOrder=8, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-filename-len", refType="", isEnumeration=false, javaName="maxFilenameLength", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=4000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="256", displayOrder=0, displayValue="Max file name length", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxFilenameLength() {
        return this.maxFilenameLength;
    }

    @XMLInfo(elementType="element", elementName="MaxFilenameLength", elementOrder=8, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-filename-len", refType="", isEnumeration=false, javaName="maxFilenameLength", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=4000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="256", displayValue="Max file name length", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxFilenameLength(long maxFilenameLength) {
        this.maxFilenameLength = maxFilenameLength;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Access control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAccessControlList> getACL() {
        return this.aCL;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Access control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setACL(ObjectReference<ConfigAccessControlList> aCL) {
        this.aCL = aCL;
    }

    @XMLInfo(elementType="element", elementName="RequireTLS", elementOrder=10, dataPowerType="dmFTPServerTLS", subType="", benign=false, isPassword=false, cliAlias="require-tls", refType="", isEnumeration=true, javaName="requireTLS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require TLS", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRequireTLS() {
        return this.requireTLS;
    }

    @XMLInfo(elementType="element", elementName="RequireTLS", elementOrder=10, dataPowerType="dmFTPServerTLS", subType="", benign=false, isPassword=false, cliAlias="require-tls", refType="", isEnumeration=true, javaName="requireTLS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require TLS", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRequireTLS(String requireTLS) {
        if (requireTLS == null || Comparison.isIn(requireTLS, DPEnumerations.FTPSERVER_TLS)) {
            this.requireTLS = requireTLS;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=11, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getSSLProxy() {
        return this.sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=11, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLProxy(ObjectReference<ConfigSSLProxyProfile> sSLProxy) {
        this.sSLProxy = sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="PasswordAAAPolicy", elementOrder=12, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-aaa-policy", refType="AAAPolicy", isEnumeration=false, javaName="passwordAAAPolicy", javaType="ObjectReference<ConfigAAAPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Username-password AAA policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAAAPolicy> getPasswordAAAPolicy() {
        return this.passwordAAAPolicy;
    }

    @XMLInfo(elementType="element", elementName="PasswordAAAPolicy", elementOrder=12, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-aaa-policy", refType="AAAPolicy", isEnumeration=false, javaName="passwordAAAPolicy", javaType="ObjectReference<ConfigAAAPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Username-password AAA policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasswordAAAPolicy(ObjectReference<ConfigAAAPolicy> passwordAAAPolicy) {
        this.passwordAAAPolicy = passwordAAAPolicy;
    }

    @XMLInfo(elementType="element", elementName="CertificateAAAPolicy", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="certificate-aaa-policy", refType="AAAPolicy", isEnumeration=false, javaName="certificateAAAPolicy", javaType="ObjectReference<ConfigAAAPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password-required AAA policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAAAPolicy> getCertificateAAAPolicy() {
        return this.certificateAAAPolicy;
    }

    @XMLInfo(elementType="element", elementName="CertificateAAAPolicy", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="certificate-aaa-policy", refType="AAAPolicy", isEnumeration=false, javaName="certificateAAAPolicy", javaType="ObjectReference<ConfigAAAPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password-required AAA policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCertificateAAAPolicy(ObjectReference<ConfigAAAPolicy> certificateAAAPolicy) {
        this.certificateAAAPolicy = certificateAAAPolicy;
    }

    @XMLInfo(elementType="element", elementName="AllowCCC", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-ccc", refType="", isEnumeration=true, javaName="allowCCC", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Allow CCC command", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowCCC() {
        return this.allowCCC;
    }

    @XMLInfo(elementType="element", elementName="AllowCCC", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-ccc", refType="", isEnumeration=true, javaName="allowCCC", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Allow CCC command", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowCCC(String allowCCC) {
        if (allowCCC == null || Comparison.isIn(allowCCC, DPEnumerations.TOGGLE)) {
            this.allowCCC = allowCCC;
        }
    }

    @XMLInfo(elementType="element", elementName="Passive", elementOrder=15, dataPowerType="dmFTPPassive", subType="", benign=false, isPassword=false, cliAlias="passive", refType="", isEnumeration=true, javaName="passive", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="allow", displayOrder=0, displayValue="Passive (PASV) command", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPassive() {
        return this.passive;
    }

    @XMLInfo(elementType="element", elementName="Passive", elementOrder=15, dataPowerType="dmFTPPassive", subType="", benign=false, isPassword=false, cliAlias="passive", refType="", isEnumeration=true, javaName="passive", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="allow", displayValue="Passive (PASV) command", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPassive(String passive) {
        if (passive == null || Comparison.isIn(passive, DPEnumerations.FTPPASSIVE)) {
            this.passive = passive;
        }
    }

    @XMLInfo(elementType="element", elementName="UsePasvPortRange", elementOrder=16, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="passive-port-range", refType="", isEnumeration=true, javaName="usePasvPortRange", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Limit port range for passive connections", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUsePasvPortRange() {
        return this.usePasvPortRange;
    }

    @XMLInfo(elementType="element", elementName="UsePasvPortRange", elementOrder=16, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="passive-port-range", refType="", isEnumeration=true, javaName="usePasvPortRange", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Limit port range for passive connections", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUsePasvPortRange(String usePasvPortRange) {
        if (usePasvPortRange == null || Comparison.isIn(usePasvPortRange, DPEnumerations.TOGGLE)) {
            this.usePasvPortRange = usePasvPortRange;
        }
    }

    @XMLInfo(elementType="element", elementName="PasvMinPort", elementOrder=17, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="passive-port-min", refType="", isEnumeration=false, javaName="pasvMinPort", javaType="int", isRequired=false, squelchNull=false, minimum=1024, maximum=65534L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1024", displayOrder=0, displayValue="Min passive port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getPasvMinPort() {
        return this.pasvMinPort;
    }

    @XMLInfo(elementType="element", elementName="PasvMinPort", elementOrder=17, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="passive-port-min", refType="", isEnumeration=false, javaName="pasvMinPort", javaType="int", isRequired=false, squelchNull=false, minimum=1024, maximum=65534L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1024", displayValue="Min passive port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasvMinPort(int pasvMinPort) {
        this.pasvMinPort = pasvMinPort;
    }

    @XMLInfo(elementType="element", elementName="PasvMaxPort", elementOrder=18, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="passive-port-max", refType="", isEnumeration=false, javaName="pasvMaxPort", javaType="int", isRequired=false, squelchNull=false, minimum=1024, maximum=65534L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1050", displayOrder=0, displayValue="Max passive port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getPasvMaxPort() {
        return this.pasvMaxPort;
    }

    @XMLInfo(elementType="element", elementName="PasvMaxPort", elementOrder=18, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="passive-port-max", refType="", isEnumeration=false, javaName="pasvMaxPort", javaType="int", isRequired=false, squelchNull=false, minimum=1024, maximum=65534L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1050", displayValue="Max passive port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasvMaxPort(int pasvMaxPort) {
        this.pasvMaxPort = pasvMaxPort;
    }

    @XMLInfo(elementType="element", elementName="PasvIdleTimeOut", elementOrder=19, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="passive-idle-timeout", refType="", isEnumeration=false, javaName="pasvIdleTimeOut", javaType="long", isRequired=false, squelchNull=false, minimum=5, maximum=300L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="60", displayOrder=0, displayValue="Passive data connection idle timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getPasvIdleTimeOut() {
        return this.pasvIdleTimeOut;
    }

    @XMLInfo(elementType="element", elementName="PasvIdleTimeOut", elementOrder=19, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="passive-idle-timeout", refType="", isEnumeration=false, javaName="pasvIdleTimeOut", javaType="long", isRequired=false, squelchNull=false, minimum=5, maximum=300L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="60", displayValue="Passive data connection idle timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasvIdleTimeOut(long pasvIdleTimeOut) {
        this.pasvIdleTimeOut = pasvIdleTimeOut;
    }

    @XMLInfo(elementType="element", elementName="DisablePASVIPCheck", elementOrder=20, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="passive-promiscuous", refType="", isEnumeration=true, javaName="disablePASVIPCheck", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Disable passive data connection (PASV) IP security check", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDisablePASVIPCheck() {
        return this.disablePASVIPCheck;
    }

    @XMLInfo(elementType="element", elementName="DisablePASVIPCheck", elementOrder=20, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="passive-promiscuous", refType="", isEnumeration=true, javaName="disablePASVIPCheck", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Disable passive data connection (PASV) IP security check", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDisablePASVIPCheck(String disablePASVIPCheck) {
        if (disablePASVIPCheck == null || Comparison.isIn(disablePASVIPCheck, DPEnumerations.TOGGLE)) {
            this.disablePASVIPCheck = disablePASVIPCheck;
        }
    }

    @XMLInfo(elementType="element", elementName="DisablePORTIPCheck", elementOrder=21, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="port-promiscuous", refType="", isEnumeration=true, javaName="disablePORTIPCheck", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Disable active data connection (PORT) IP security check", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDisablePORTIPCheck() {
        return this.disablePORTIPCheck;
    }

    @XMLInfo(elementType="element", elementName="DisablePORTIPCheck", elementOrder=21, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="port-promiscuous", refType="", isEnumeration=true, javaName="disablePORTIPCheck", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Disable active data connection (PORT) IP security check", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDisablePORTIPCheck(String disablePORTIPCheck) {
        if (disablePORTIPCheck == null || Comparison.isIn(disablePORTIPCheck, DPEnumerations.TOGGLE)) {
            this.disablePORTIPCheck = disablePORTIPCheck;
        }
    }

    @XMLInfo(elementType="element", elementName="UseAlternatePASVAddr", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-passive-addr", refType="", isEnumeration=true, javaName="useAlternatePASVAddr", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Use alternate PASV IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUseAlternatePASVAddr() {
        return this.useAlternatePASVAddr;
    }

    @XMLInfo(elementType="element", elementName="UseAlternatePASVAddr", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-passive-addr", refType="", isEnumeration=true, javaName="useAlternatePASVAddr", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Use alternate PASV IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUseAlternatePASVAddr(String useAlternatePASVAddr) {
        if (useAlternatePASVAddr == null || Comparison.isIn(useAlternatePASVAddr, DPEnumerations.TOGGLE)) {
            this.useAlternatePASVAddr = useAlternatePASVAddr;
        }
    }

    @XMLInfo(elementType="element", elementName="AlternatePASVAddr", elementOrder=23, dataPowerType="dmIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="passive-addr", refType="", isEnumeration=false, javaName="alternatePASVAddr", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Alternate PASV IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAlternatePASVAddr() {
        return this.alternatePASVAddr;
    }

    @XMLInfo(elementType="element", elementName="AlternatePASVAddr", elementOrder=23, dataPowerType="dmIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="passive-addr", refType="", isEnumeration=false, javaName="alternatePASVAddr", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Alternate PASV IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAlternatePASVAddr(String alternatePASVAddr) {
        this.alternatePASVAddr = alternatePASVAddr;
    }

    @XMLInfo(elementType="element", elementName="AllowLISTCmd", elementOrder=24, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="list-cmd", refType="", isEnumeration=true, javaName="allowLISTCmd", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable LIST command support", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowLISTCmd() {
        return this.allowLISTCmd;
    }

    @XMLInfo(elementType="element", elementName="AllowLISTCmd", elementOrder=24, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="list-cmd", refType="", isEnumeration=true, javaName="allowLISTCmd", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable LIST command support", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowLISTCmd(String allowLISTCmd) {
        if (allowLISTCmd == null || Comparison.isIn(allowLISTCmd, DPEnumerations.TOGGLE)) {
            this.allowLISTCmd = allowLISTCmd;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowDELECmd", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="dele-cmd", refType="", isEnumeration=true, javaName="allowDELECmd", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable DELE command support", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowDELECmd() {
        return this.allowDELECmd;
    }

    @XMLInfo(elementType="element", elementName="AllowDELECmd", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="dele-cmd", refType="", isEnumeration=true, javaName="allowDELECmd", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable DELE command support", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowDELECmd(String allowDELECmd) {
        if (allowDELECmd == null || Comparison.isIn(allowDELECmd, DPEnumerations.TOGGLE)) {
            this.allowDELECmd = allowDELECmd;
        }
    }

    @XMLInfo(elementType="element", elementName="DataEncryption", elementOrder=26, dataPowerType="dmFTPDataEncryption", subType="", benign=false, isPassword=false, cliAlias="data-encryption", refType="", isEnumeration=true, javaName="dataEncryption", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="allow", displayOrder=0, displayValue="File transfer data encryption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDataEncryption() {
        return this.dataEncryption;
    }

    @XMLInfo(elementType="element", elementName="DataEncryption", elementOrder=26, dataPowerType="dmFTPDataEncryption", subType="", benign=false, isPassword=false, cliAlias="data-encryption", refType="", isEnumeration=true, javaName="dataEncryption", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="allow", displayValue="File transfer data encryption", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDataEncryption(String dataEncryption) {
        if (dataEncryption == null || Comparison.isIn(dataEncryption, DPEnumerations.FTPDATA_ENCRYPTION)) {
            this.dataEncryption = dataEncryption;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowCompression", elementOrder=27, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-compression", refType="", isEnumeration=true, javaName="allowCompression", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Allow compression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowCompression() {
        return this.allowCompression;
    }

    @XMLInfo(elementType="element", elementName="AllowCompression", elementOrder=27, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-compression", refType="", isEnumeration=true, javaName="allowCompression", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Allow compression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowCompression(String allowCompression) {
        if (allowCompression == null || Comparison.isIn(allowCompression, DPEnumerations.TOGGLE)) {
            this.allowCompression = allowCompression;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowSTOU", elementOrder=28, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-unique-filename", refType="", isEnumeration=true, javaName="allowSTOU", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Allow unique file name (STOU)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowSTOU() {
        return this.allowSTOU;
    }

    @XMLInfo(elementType="element", elementName="AllowSTOU", elementOrder=28, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-unique-filename", refType="", isEnumeration=true, javaName="allowSTOU", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Allow unique file name (STOU)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowSTOU(String allowSTOU) {
        if (allowSTOU == null || Comparison.isIn(allowSTOU, DPEnumerations.TOGGLE)) {
            this.allowSTOU = allowSTOU;
        }
    }

    @XMLInfo(elementType="element", elementName="UniqueFilenamePrefix", elementOrder=29, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="unique-filename-prefix", refType="", isEnumeration=false, javaName="uniqueFilenamePrefix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^/]*$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Unique file name prefix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUniqueFilenamePrefix() {
        return this.uniqueFilenamePrefix;
    }

    @XMLInfo(elementType="element", elementName="UniqueFilenamePrefix", elementOrder=29, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="unique-filename-prefix", refType="", isEnumeration=false, javaName="uniqueFilenamePrefix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^/]*$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Unique file name prefix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUniqueFilenamePrefix(String uniqueFilenamePrefix) {
        if (uniqueFilenamePrefix != null && uniqueFilenamePrefix.matches("^[^/]*$")) {
            this.uniqueFilenamePrefix = uniqueFilenamePrefix;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowREST", elementOrder=30, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-restart", refType="", isEnumeration=true, javaName="allowREST", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Allow restart (REST)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowREST() {
        return this.allowREST;
    }

    @XMLInfo(elementType="element", elementName="AllowREST", elementOrder=30, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="allow-restart", refType="", isEnumeration=true, javaName="allowREST", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Allow restart (REST)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowREST(String allowREST) {
        if (allowREST == null || Comparison.isIn(allowREST, DPEnumerations.TOGGLE)) {
            this.allowREST = allowREST;
        }
    }

    @XMLInfo(elementType="element", elementName="RestartTimeout", elementOrder=31, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="restart-timeout", refType="", isEnumeration=false, javaName="restartTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="240", displayOrder=0, displayValue="Restart timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getRestartTimeout() {
        return this.restartTimeout;
    }

    @XMLInfo(elementType="element", elementName="RestartTimeout", elementOrder=31, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="restart-timeout", refType="", isEnumeration=false, javaName="restartTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="240", displayValue="Restart timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRestartTimeout(long restartTimeout) {
        this.restartTimeout = restartTimeout;
    }

    @XMLInfo(elementType="element", elementName="IdleTimeout", elementOrder=32, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="idle-timeout", refType="", isEnumeration=false, javaName="idleTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Idle timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @XMLInfo(elementType="element", elementName="IdleTimeout", elementOrder=32, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="idle-timeout", refType="", isEnumeration=false, javaName="idleTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Idle timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @XMLInfo(elementType="element", elementName="ResponseType", elementOrder=33, dataPowerType="dmFTPResponseType", subType="", benign=false, isPassword=false, cliAlias="response-type", refType="", isEnumeration=true, javaName="responseType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="none", displayOrder=0, displayValue="Response type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getResponseType() {
        return this.responseType;
    }

    @XMLInfo(elementType="element", elementName="ResponseType", elementOrder=33, dataPowerType="dmFTPResponseType", subType="", benign=false, isPassword=false, cliAlias="response-type", refType="", isEnumeration=true, javaName="responseType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="none", displayValue="Response type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setResponseType(String responseType) {
        if (responseType == null || Comparison.isIn(responseType, DPEnumerations.FTPRESPONSE_TYPE)) {
            this.responseType = responseType;
        }
    }

    @XMLInfo(elementType="element", elementName="ResponseStorage", elementOrder=34, dataPowerType="dmFTPResponseStorage", subType="", benign=false, isPassword=false, cliAlias="response-storage", refType="", isEnumeration=true, javaName="responseStorage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="temporary", displayOrder=0, displayValue="Response storage", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getResponseStorage() {
        return this.responseStorage;
    }

    @XMLInfo(elementType="element", elementName="ResponseStorage", elementOrder=34, dataPowerType="dmFTPResponseStorage", subType="", benign=false, isPassword=false, cliAlias="response-storage", refType="", isEnumeration=true, javaName="responseStorage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="temporary", displayValue="Response storage", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setResponseStorage(String responseStorage) {
        if (responseStorage == null || Comparison.isIn(responseStorage, DPEnumerations.FTPRESPONSE_STORAGE)) {
            this.responseStorage = responseStorage;
        }
    }

    @XMLInfo(elementType="element", elementName="TemporaryStorageSize", elementOrder=35, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="filesystem-size", refType="", isEnumeration=false, javaName="temporaryStorageSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=2048L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="32", displayOrder=0, displayValue="Temporary storage size", units="MB", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getTemporaryStorageSize() {
        return this.temporaryStorageSize;
    }

    @XMLInfo(elementType="element", elementName="TemporaryStorageSize", elementOrder=35, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="filesystem-size", refType="", isEnumeration=false, javaName="temporaryStorageSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=2048L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="32", displayValue="Temporary storage size", units="MB", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTemporaryStorageSize(long temporaryStorageSize) {
        this.temporaryStorageSize = temporaryStorageSize;
    }

    @XMLInfo(elementType="element", elementName="ResponseNFSMount", elementOrder=36, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="response-nfs-mount", refType="NFSStaticMount", isEnumeration=false, javaName="responseNFSMount", javaType="ObjectReference<ConfigNFSStaticMount>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Response NFS mount", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigNFSStaticMount> getResponseNFSMount() {
        return this.responseNFSMount;
    }

    @XMLInfo(elementType="element", elementName="ResponseNFSMount", elementOrder=36, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="response-nfs-mount", refType="NFSStaticMount", isEnumeration=false, javaName="responseNFSMount", javaType="ObjectReference<ConfigNFSStaticMount>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Response NFS mount", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setResponseNFSMount(ObjectReference<ConfigNFSStaticMount> responseNFSMount) {
        this.responseNFSMount = responseNFSMount;
    }

    @XMLInfo(elementType="element", elementName="ResponseSuffix", elementOrder=37, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="response-suffix", refType="", isEnumeration=false, javaName="responseSuffix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^/]*$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Response suffix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getResponseSuffix() {
        return this.responseSuffix;
    }

    @XMLInfo(elementType="element", elementName="ResponseSuffix", elementOrder=37, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="response-suffix", refType="", isEnumeration=false, javaName="responseSuffix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^/]*$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Response suffix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setResponseSuffix(String responseSuffix) {
        if (responseSuffix != null && responseSuffix.matches("^[^/]*$")) {
            this.responseSuffix = responseSuffix;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLServerConfigType", elementOrder=38, dataPowerType="dmSSLConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-config-type", refType="", isEnumeration=true, javaName="sSLServerConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="proxy", displayOrder=0, displayValue="TLS server type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLServerConfigType() {
        return this.sSLServerConfigType;
    }

    @XMLInfo(elementType="element", elementName="SSLServerConfigType", elementOrder=38, dataPowerType="dmSSLConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-config-type", refType="", isEnumeration=true, javaName="sSLServerConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="proxy", displayValue="TLS server type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLServerConfigType(String sSLServerConfigType) {
        if (sSLServerConfigType == null || Comparison.isIn(sSLServerConfigType, DPEnumerations.SSLCONFIG_TYPE)) {
            this.sSLServerConfigType = sSLServerConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=39, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-server", refType="SSLServerProfile", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference<ConfigSSLServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLServerProfile> getSSLServer() {
        return this.sSLServer;
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=39, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-server", refType="SSLServerProfile", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference<ConfigSSLServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLServer(ObjectReference<ConfigSSLServerProfile> sSLServer) {
        this.sSLServer = sSLServer;
    }

    @XMLInfo(elementType="element", elementName="SSLSNIServer", elementOrder=40, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-sni-server", refType="SSLSNIServerProfile", isEnumeration=false, javaName="sSLSNIServer", javaType="ObjectReference<ConfigSSLSNIServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS SNI server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLSNIServerProfile> getSSLSNIServer() {
        return this.sSLSNIServer;
    }

    @XMLInfo(elementType="element", elementName="SSLSNIServer", elementOrder=40, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-sni-server", refType="SSLSNIServerProfile", isEnumeration=false, javaName="sSLSNIServer", javaType="ObjectReference<ConfigSSLSNIServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS SNI server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLSNIServer(ObjectReference<ConfigSSLSNIServerProfile> sSLSNIServer) {
        this.sSLSNIServer = sSLSNIServer;
    }

    @Override
    public int compareTo(ConfigFTPDemonSourceProtocolHandler that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "localAddress", "localPort", "filesystemType", "persistentFilesystemTimeout", "virtualDirectories", "defaultDirectory", "maxFilenameLength", "aCL", "requireTLS", "sSLProxy", "passwordAAAPolicy", "certificateAAAPolicy", "allowCCC", "passive", "usePasvPortRange", "pasvMinPort", "pasvMaxPort", "pasvIdleTimeOut", "disablePASVIPCheck", "disablePORTIPCheck", "useAlternatePASVAddr", "alternatePASVAddr", "allowLISTCmd", "allowDELECmd", "dataEncryption", "allowCompression", "allowSTOU", "uniqueFilenamePrefix", "allowREST", "restartTimeout", "idleTimeout", "responseType", "responseStorage", "temporaryStorageSize", "responseNFSMount", "responseSuffix", "sSLServerConfigType", "sSLServer", "sSLSNIServer");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.localAddress, this.localPort, this.filesystemType, this.persistentFilesystemTimeout, this.virtualDirectories, this.defaultDirectory, this.maxFilenameLength, this.aCL, this.requireTLS, this.sSLProxy, this.passwordAAAPolicy, this.certificateAAAPolicy, this.allowCCC, this.passive, this.usePasvPortRange, this.pasvMinPort, this.pasvMaxPort, this.pasvIdleTimeOut, this.disablePASVIPCheck, this.disablePORTIPCheck, this.useAlternatePASVAddr, this.alternatePASVAddr, this.allowLISTCmd, this.allowDELECmd, this.dataEncryption, this.allowCompression, this.allowSTOU, this.uniqueFilenamePrefix, this.allowREST, this.restartTimeout, this.idleTimeout, this.responseType, this.responseStorage, this.temporaryStorageSize, this.responseNFSMount, this.responseSuffix, this.sSLServerConfigType, this.sSLServer, this.sSLSNIServer);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "localAddress", "localPort", "filesystemType", "persistentFilesystemTimeout", "virtualDirectories", "defaultDirectory", "maxFilenameLength", "aCL", "requireTLS", "sSLProxy", "passwordAAAPolicy", "certificateAAAPolicy", "allowCCC", "passive", "usePasvPortRange", "pasvMinPort", "pasvMaxPort", "pasvIdleTimeOut", "disablePASVIPCheck", "disablePORTIPCheck", "useAlternatePASVAddr", "alternatePASVAddr", "allowLISTCmd", "allowDELECmd", "dataEncryption", "allowCompression", "allowSTOU", "uniqueFilenamePrefix", "allowREST", "restartTimeout", "idleTimeout", "responseType", "responseStorage", "temporaryStorageSize", "responseNFSMount", "responseSuffix", "sSLServerConfigType", "sSLServer", "sSLSNIServer");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "localAddress", "localPort", "filesystemType", "persistentFilesystemTimeout", "virtualDirectories", "defaultDirectory", "maxFilenameLength", "aCL", "requireTLS", "sSLProxy", "passwordAAAPolicy", "certificateAAAPolicy", "allowCCC", "passive", "usePasvPortRange", "pasvMinPort", "pasvMaxPort", "pasvIdleTimeOut", "disablePASVIPCheck", "disablePORTIPCheck", "useAlternatePASVAddr", "alternatePASVAddr", "allowLISTCmd", "allowDELECmd", "dataEncryption", "allowCompression", "allowSTOU", "uniqueFilenamePrefix", "allowREST", "restartTimeout", "idleTimeout", "responseType", "responseStorage", "temporaryStorageSize", "responseNFSMount", "responseSuffix", "sSLServerConfigType", "sSLServer", "sSLSNIServer"));
    }
}

