/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAccessControlList;
import com.kumbasoft.core.beans.config.ConfigDeviceManagementService;
import com.kumbasoft.core.beans.config.ConfigHTTPUserAgent;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.config.ConfigSSLSNIServerProfile;
import com.kumbasoft.core.beans.config.ConfigSSLServerProfile;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.XMLMgmtModes;
import java.util.Objects;

public class ConfigMgmtInterface
extends ConfigDeviceManagementService {
    private String userSummary;
    private int localPort;
    private ObjectReference<ConfigSSLProxyProfile> sSLProxy;
    private ObjectReference<ConfigHTTPUserAgent> userAgent;
    private ObjectReference<ConfigAccessControlList> aCL;
    private String wSManagement;
    private int sLMPeering;
    private XMLMgmtModes mode;
    private String sSLConfigType;
    private ObjectReference<ConfigSSLServerProfile> sSLServer;
    private ObjectReference<ConfigSSLSNIServerProfile> sSLSNIServer;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="5550", displayOrder=0, displayValue="Port number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLocalPort() {
        return this.localPort;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="5550", displayValue="Port number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Custom TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getSSLProxy() {
        return this.sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Custom TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLProxy(ObjectReference<ConfigSSLProxyProfile> sSLProxy) {
        this.sSLProxy = sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="UserAgent", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="user-agent", refType="HTTPUserAgent", isEnumeration=false, javaName="userAgent", javaType="ObjectReference<ConfigHTTPUserAgent>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Custom user agent", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigHTTPUserAgent> getUserAgent() {
        return this.userAgent;
    }

    @XMLInfo(elementType="element", elementName="UserAgent", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="user-agent", refType="HTTPUserAgent", isEnumeration=false, javaName="userAgent", javaType="ObjectReference<ConfigHTTPUserAgent>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Custom user agent", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserAgent(ObjectReference<ConfigHTTPUserAgent> userAgent) {
        this.userAgent = userAgent;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="xml-mgmt", displayOrder=0, displayValue="Access control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAccessControlList> getACL() {
        return this.aCL;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="xml-mgmt", displayValue="Access control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setACL(ObjectReference<ConfigAccessControlList> aCL) {
        this.aCL = aCL;
    }

    @XMLInfo(elementType="element", elementName="WSManagement", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ws-management", refType="", isEnumeration=true, javaName="wSManagement", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="NONTRANSLATABLE", units="", label="", multiplicity=1, status="obsolete", isDeprecated=true, deprecatedIn="3.5.1.0", isObsolete=true, obsoletedIn="3.5.1.0")
    public String getWSManagement() {
        return this.wSManagement;
    }

    @XMLInfo(elementType="element", elementName="WSManagement", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ws-management", refType="", isEnumeration=true, javaName="wSManagement", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="NONTRANSLATABLE", units="", label="", multiplicity=1, status="obsolete", isDeprecated=true, deprecatedIn="3.5.1.0", isObsolete=true, obsoletedIn="3.5.1.0")
    public void setWSManagement(String wSManagement) {
        if (wSManagement == null || Comparison.isIn(wSManagement, DPEnumerations.TOGGLE)) {
            this.wSManagement = wSManagement;
        }
    }

    @XMLInfo(elementType="element", elementName="SLMPeering", elementOrder=8, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="slm-peering", refType="", isEnumeration=false, javaName="sLMPeering", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="10", displayOrder=0, displayValue="SLM update interval", units="Seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getSLMPeering() {
        return this.sLMPeering;
    }

    @XMLInfo(elementType="element", elementName="SLMPeering", elementOrder=8, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="slm-peering", refType="", isEnumeration=false, javaName="sLMPeering", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="10", displayValue="SLM update interval", units="Seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSLMPeering(int sLMPeering) {
        this.sLMPeering = sLMPeering;
    }

    @XMLInfo(elementType="element", elementName="Mode", elementOrder=9, dataPowerType="dmXMLMgmtModes", subType="", benign=false, isPassword=false, cliAlias="mode", refType="", isEnumeration=false, javaName="mode", javaType="XMLMgmtModes", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Enabled services", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public XMLMgmtModes getMode() {
        return this.mode;
    }

    @XMLInfo(elementType="element", elementName="Mode", elementOrder=9, dataPowerType="dmXMLMgmtModes", subType="", benign=false, isPassword=false, cliAlias="mode", refType="", isEnumeration=false, javaName="mode", javaType="XMLMgmtModes", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Enabled services", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMode(XMLMgmtModes mode) {
        this.mode = mode;
    }

    @XMLInfo(elementType="element", elementName="SSLConfigType", elementOrder=10, dataPowerType="dmSSLConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-config-type", refType="", isEnumeration=true, javaName="sSLConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="server", displayOrder=0, displayValue="Custom TLS server type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLConfigType() {
        return this.sSLConfigType;
    }

    @XMLInfo(elementType="element", elementName="SSLConfigType", elementOrder=10, dataPowerType="dmSSLConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-config-type", refType="", isEnumeration=true, javaName="sSLConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="server", displayValue="Custom TLS server type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLConfigType(String sSLConfigType) {
        if (sSLConfigType == null || Comparison.isIn(sSLConfigType, DPEnumerations.SSLCONFIG_TYPE)) {
            this.sSLConfigType = sSLConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=11, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-server", refType="SSLServerProfile", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference<ConfigSSLServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Custom TLS server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLServerProfile> getSSLServer() {
        return this.sSLServer;
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=11, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-server", refType="SSLServerProfile", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference<ConfigSSLServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Custom TLS server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLServer(ObjectReference<ConfigSSLServerProfile> sSLServer) {
        this.sSLServer = sSLServer;
    }

    @XMLInfo(elementType="element", elementName="SSLSNIServer", elementOrder=12, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-sni-server", refType="SSLSNIServerProfile", isEnumeration=false, javaName="sSLSNIServer", javaType="ObjectReference<ConfigSSLSNIServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Custom TLS SNI server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLSNIServerProfile> getSSLSNIServer() {
        return this.sSLSNIServer;
    }

    @XMLInfo(elementType="element", elementName="SSLSNIServer", elementOrder=12, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-sni-server", refType="SSLSNIServerProfile", isEnumeration=false, javaName="sSLSNIServer", javaType="ObjectReference<ConfigSSLSNIServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Custom TLS SNI server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLSNIServer(ObjectReference<ConfigSSLSNIServerProfile> sSLSNIServer) {
        this.sSLSNIServer = sSLSNIServer;
    }

    @Override
    public int compareTo(ConfigMgmtInterface that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "localPort", "sSLProxy", "userAgent", "aCL", "wSManagement", "sLMPeering", "mode", "sSLConfigType", "sSLServer", "sSLSNIServer");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.localPort, this.sSLProxy, this.userAgent, this.aCL, this.wSManagement, this.sLMPeering, this.mode, this.sSLConfigType, this.sSLServer, this.sSLSNIServer);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "localPort", "sSLProxy", "userAgent", "aCL", "wSManagement", "sLMPeering", "mode", "sSLConfigType", "sSLServer", "sSLSNIServer");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "localPort", "sSLProxy", "userAgent", "aCL", "wSManagement", "sLMPeering", "mode", "sSLConfigType", "sSLServer", "sSLSNIServer"));
    }
}

