/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.config.ConfigNetworkConfiguration;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigNetworkSettings
extends ConfigNetworkConfiguration {
    private String userSummary;
    private String blockNonmanagementTraffic;
    private ArrayList<String> iCMPDisable;
    private String eCNDisable;
    private String destinationRouting;
    private String allowCrosstalkOnSubnet;
    private String allowAllCrosstalk;
    private int tCPSYNRetries;
    private int arpRetries;
    private int arpInterval;
    private String reversePathFiltering;
    private String tCPWindowScaling;
    private int ephemeralPortRange;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="BlockNonmanagementTraffic", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="block-traffic", refType="", isEnumeration=true, javaName="blockNonmanagementTraffic", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Block nonmanagement traffic for invalid interface configuration", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getBlockNonmanagementTraffic() {
        return this.blockNonmanagementTraffic;
    }

    @XMLInfo(elementType="element", elementName="BlockNonmanagementTraffic", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="block-traffic", refType="", isEnumeration=true, javaName="blockNonmanagementTraffic", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Block nonmanagement traffic for invalid interface configuration", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBlockNonmanagementTraffic(String blockNonmanagementTraffic) {
        if (blockNonmanagementTraffic == null || Comparison.isIn(blockNonmanagementTraffic, DPEnumerations.TOGGLE)) {
            this.blockNonmanagementTraffic = blockNonmanagementTraffic;
        }
    }

    public void addICMPDisable(String element) {
        if (element == null) {
            return;
        }
        if (this.iCMPDisable == null) {
            this.iCMPDisable = new ArrayList();
        }
        this.iCMPDisable.add(element);
    }

    public boolean removeICMPDisable(String element) {
        if (element == null || this.iCMPDisable == null) {
            return false;
        }
        return this.iCMPDisable.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ICMPDisable", elementOrder=3, dataPowerType="dmICMPReplyType", subType="", benign=false, isPassword=false, cliAlias="icmp-disable", refType="", isEnumeration=true, javaName="iCMPDisable", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Disable ICMP", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getICMPDisable() {
        return this.iCMPDisable;
    }

    @XMLInfo(elementType="element", elementName="ICMPDisable", elementOrder=3, dataPowerType="dmICMPReplyType", subType="", benign=false, isPassword=false, cliAlias="icmp-disable", refType="", isEnumeration=true, javaName="iCMPDisable", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Disable ICMP", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setICMPDisable(ArrayList<String> iCMPDisable) {
        if (CollectionUtility.isEmpty(iCMPDisable)) {
            this.iCMPDisable = null;
            return;
        }
        this.iCMPDisable = iCMPDisable;
    }

    @XMLInfo(elementType="element", elementName="ECNDisable", elementOrder=4, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ecn-disable", refType="", isEnumeration=true, javaName="eCNDisable", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Disable ECN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getECNDisable() {
        return this.eCNDisable;
    }

    @XMLInfo(elementType="element", elementName="ECNDisable", elementOrder=4, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="ecn-disable", refType="", isEnumeration=true, javaName="eCNDisable", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Disable ECN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setECNDisable(String eCNDisable) {
        if (eCNDisable == null || Comparison.isIn(eCNDisable, DPEnumerations.TOGGLE)) {
            this.eCNDisable = eCNDisable;
        }
    }

    @XMLInfo(elementType="element", elementName="DestinationRouting", elementOrder=5, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="destination-routing", refType="", isEnumeration=true, javaName="destinationRouting", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable destination-based routing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDestinationRouting() {
        return this.destinationRouting;
    }

    @XMLInfo(elementType="element", elementName="DestinationRouting", elementOrder=5, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="destination-routing", refType="", isEnumeration=true, javaName="destinationRouting", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable destination-based routing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDestinationRouting(String destinationRouting) {
        if (destinationRouting == null || Comparison.isIn(destinationRouting, DPEnumerations.TOGGLE)) {
            this.destinationRouting = destinationRouting;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowCrosstalkOnSubnet", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="relax-interface-isolation", refType="", isEnumeration=true, javaName="allowCrosstalkOnSubnet", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Relax interface isolation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowCrosstalkOnSubnet() {
        return this.allowCrosstalkOnSubnet;
    }

    @XMLInfo(elementType="element", elementName="AllowCrosstalkOnSubnet", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="relax-interface-isolation", refType="", isEnumeration=true, javaName="allowCrosstalkOnSubnet", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Relax interface isolation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowCrosstalkOnSubnet(String allowCrosstalkOnSubnet) {
        if (allowCrosstalkOnSubnet == null || Comparison.isIn(allowCrosstalkOnSubnet, DPEnumerations.TOGGLE)) {
            this.allowCrosstalkOnSubnet = allowCrosstalkOnSubnet;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowAllCrosstalk", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="disable-interface-isolation", refType="", isEnumeration=true, javaName="allowAllCrosstalk", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Disable interface isolation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowAllCrosstalk() {
        return this.allowAllCrosstalk;
    }

    @XMLInfo(elementType="element", elementName="AllowAllCrosstalk", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="disable-interface-isolation", refType="", isEnumeration=true, javaName="allowAllCrosstalk", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Disable interface isolation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowAllCrosstalk(String allowAllCrosstalk) {
        if (allowAllCrosstalk == null || Comparison.isIn(allowAllCrosstalk, DPEnumerations.TOGGLE)) {
            this.allowAllCrosstalk = allowAllCrosstalk;
        }
    }

    @XMLInfo(elementType="element", elementName="TCPSYNRetries", elementOrder=8, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="tcp-retries", refType="", isEnumeration=false, javaName="tCPSYNRetries", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=32L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="5", displayOrder=0, displayValue="TCP attempts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getTCPSYNRetries() {
        return this.tCPSYNRetries;
    }

    @XMLInfo(elementType="element", elementName="TCPSYNRetries", elementOrder=8, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="tcp-retries", refType="", isEnumeration=false, javaName="tCPSYNRetries", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=32L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="5", displayValue="TCP attempts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTCPSYNRetries(int tCPSYNRetries) {
        this.tCPSYNRetries = tCPSYNRetries;
    }

    @XMLInfo(elementType="element", elementName="ArpRetries", elementOrder=9, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="arp-retries", refType="", isEnumeration=false, javaName="arpRetries", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=64L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="8", displayOrder=0, displayValue="ARP attempts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getArpRetries() {
        return this.arpRetries;
    }

    @XMLInfo(elementType="element", elementName="ArpRetries", elementOrder=9, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="arp-retries", refType="", isEnumeration=false, javaName="arpRetries", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=64L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="8", displayValue="ARP attempts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setArpRetries(int arpRetries) {
        this.arpRetries = arpRetries;
    }

    @XMLInfo(elementType="element", elementName="ArpInterval", elementOrder=10, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="arp-interval", refType="", isEnumeration=false, javaName="arpInterval", javaType="int", isRequired=false, squelchNull=false, minimum=500, maximum=5000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="500", displayOrder=0, displayValue="ARP attempt interval", units="ms", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getArpInterval() {
        return this.arpInterval;
    }

    @XMLInfo(elementType="element", elementName="ArpInterval", elementOrder=10, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="arp-interval", refType="", isEnumeration=false, javaName="arpInterval", javaType="int", isRequired=false, squelchNull=false, minimum=500, maximum=5000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="500", displayValue="ARP attempt interval", units="ms", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setArpInterval(int arpInterval) {
        this.arpInterval = arpInterval;
    }

    @XMLInfo(elementType="element", elementName="ReversePathFiltering", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="reverse-path-filtering", refType="", isEnumeration=true, javaName="reversePathFiltering", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable reverse path filtering", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getReversePathFiltering() {
        return this.reversePathFiltering;
    }

    @XMLInfo(elementType="element", elementName="ReversePathFiltering", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="reverse-path-filtering", refType="", isEnumeration=true, javaName="reversePathFiltering", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable reverse path filtering", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setReversePathFiltering(String reversePathFiltering) {
        if (reversePathFiltering == null || Comparison.isIn(reversePathFiltering, DPEnumerations.TOGGLE)) {
            this.reversePathFiltering = reversePathFiltering;
        }
    }

    @XMLInfo(elementType="element", elementName="TCPWindowScaling", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="tcp-window-scale", refType="", isEnumeration=true, javaName="tCPWindowScaling", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Enable TCP window scaling", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTCPWindowScaling() {
        return this.tCPWindowScaling;
    }

    @XMLInfo(elementType="element", elementName="TCPWindowScaling", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="tcp-window-scale", refType="", isEnumeration=true, javaName="tCPWindowScaling", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Enable TCP window scaling", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTCPWindowScaling(String tCPWindowScaling) {
        if (tCPWindowScaling == null || Comparison.isIn(tCPWindowScaling, DPEnumerations.TOGGLE)) {
            this.tCPWindowScaling = tCPWindowScaling;
        }
    }

    @XMLInfo(elementType="element", elementName="EphemeralPortRange", elementOrder=13, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="ephemeral-port-range", refType="", isEnumeration=false, javaName="ephemeralPortRange", javaType="int", isRequired=false, squelchNull=false, minimum=10000, maximum=32768L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="10000", displayOrder=0, displayValue="Starting ephemeral port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getEphemeralPortRange() {
        return this.ephemeralPortRange;
    }

    @XMLInfo(elementType="element", elementName="EphemeralPortRange", elementOrder=13, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="ephemeral-port-range", refType="", isEnumeration=false, javaName="ephemeralPortRange", javaType="int", isRequired=false, squelchNull=false, minimum=10000, maximum=32768L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="10000", displayValue="Starting ephemeral port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEphemeralPortRange(int ephemeralPortRange) {
        this.ephemeralPortRange = ephemeralPortRange;
    }

    @Override
    public int compareTo(ConfigNetworkSettings that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "blockNonmanagementTraffic", "iCMPDisable", "eCNDisable", "destinationRouting", "allowCrosstalkOnSubnet", "allowAllCrosstalk", "tCPSYNRetries", "arpRetries", "arpInterval", "reversePathFiltering", "tCPWindowScaling", "ephemeralPortRange");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.blockNonmanagementTraffic, this.iCMPDisable, this.eCNDisable, this.destinationRouting, this.allowCrosstalkOnSubnet, this.allowAllCrosstalk, this.tCPSYNRetries, this.arpRetries, this.arpInterval, this.reversePathFiltering, this.tCPWindowScaling, this.ephemeralPortRange);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "blockNonmanagementTraffic", "iCMPDisable", "eCNDisable", "destinationRouting", "allowCrosstalkOnSubnet", "allowAllCrosstalk", "tCPSYNRetries", "arpRetries", "arpInterval", "reversePathFiltering", "tCPWindowScaling", "ephemeralPortRange");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "blockNonmanagementTraffic", "iCMPDisable", "eCNDisable", "destinationRouting", "allowCrosstalkOnSubnet", "allowAllCrosstalk", "tCPSYNRetries", "arpRetries", "arpInterval", "reversePathFiltering", "tCPWindowScaling", "ephemeralPortRange"));
    }
}

