/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigJMSSourceProtocolHandler;
import com.kumbasoft.core.beans.config.ConfigTibcoEMSServer;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigTibcoEMSSourceProtocolHandler
extends ConfigJMSSourceProtocolHandler {
    private ObjectReference<ConfigTibcoEMSServer> server;
    private int batchSize;
    private String connectionClientID;
    private String subscriptionName;
    private String unsubscribe;

    @XMLInfo(elementType="element", elementName="Server", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="server", refType="TibcoEMSServer", isEnumeration=false, javaName="server", javaType="ObjectReference<ConfigTibcoEMSServer>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TIBCO EMS server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigTibcoEMSServer> getServer() {
        return this.server;
    }

    @XMLInfo(elementType="element", elementName="Server", elementOrder=6, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="server", refType="TibcoEMSServer", isEnumeration=false, javaName="server", javaType="ObjectReference<ConfigTibcoEMSServer>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TIBCO EMS server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setServer(ObjectReference<ConfigTibcoEMSServer> server) {
        this.server = server;
    }

    @XMLInfo(elementType="element", elementName="BatchSize", elementOrder=7, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="batch-size", refType="", isEnumeration=false, javaName="batchSize", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Batch size", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getBatchSize() {
        return this.batchSize;
    }

    @XMLInfo(elementType="element", elementName="BatchSize", elementOrder=7, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="batch-size", refType="", isEnumeration=false, javaName="batchSize", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Batch size", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @XMLInfo(elementType="element", elementName="ConnectionClientID", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="connection-client-id", refType="", isEnumeration=false, javaName="connectionClientID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TIBCO EMS connection client ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getConnectionClientID() {
        return this.connectionClientID;
    }

    @XMLInfo(elementType="element", elementName="ConnectionClientID", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="connection-client-id", refType="", isEnumeration=false, javaName="connectionClientID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TIBCO EMS connection client ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConnectionClientID(String connectionClientID) {
        this.connectionClientID = connectionClientID;
    }

    @XMLInfo(elementType="element", elementName="SubscriptionName", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="sub-name", refType="", isEnumeration=false, javaName="subscriptionName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Subscription name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    @XMLInfo(elementType="element", elementName="SubscriptionName", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="sub-name", refType="", isEnumeration=false, javaName="subscriptionName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Subscription name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    @XMLInfo(elementType="element", elementName="Unsubscribe", elementOrder=10, dataPowerType="dmJMSUnsubscribe", subType="", benign=false, isPassword=false, cliAlias="unsubscribe", refType="", isEnumeration=true, javaName="unsubscribe", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="never", displayOrder=0, displayValue="Unsubscribe", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUnsubscribe() {
        return this.unsubscribe;
    }

    @XMLInfo(elementType="element", elementName="Unsubscribe", elementOrder=10, dataPowerType="dmJMSUnsubscribe", subType="", benign=false, isPassword=false, cliAlias="unsubscribe", refType="", isEnumeration=true, javaName="unsubscribe", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="never", displayValue="Unsubscribe", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUnsubscribe(String unsubscribe) {
        if (unsubscribe == null || Comparison.isIn(unsubscribe, DPEnumerations.JMSUNSUBSCRIBE)) {
            this.unsubscribe = unsubscribe;
        }
    }

    @Override
    public int compareTo(ConfigTibcoEMSSourceProtocolHandler that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "server", "batchSize", "connectionClientID", "subscriptionName", "unsubscribe");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.server, this.batchSize, this.connectionClientID, this.subscriptionName, this.unsubscribe);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "server", "batchSize", "connectionClientID", "subscriptionName", "unsubscribe");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("server", "batchSize", "connectionClientID", "subscriptionName", "unsubscribe"));
    }
}

