/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigWSRRServer;
import com.kumbasoft.core.beans.config.ConfigWebServiceSubscription;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigWSRRSavedSearchSubscription
extends ConfigWebServiceSubscription {
    private ObjectReference<ConfigWSRRServer> server;
    private String savedSearchName;
    private ArrayList<String> savedSearchParameters;
    private String method;
    private long refreshInterval;
    private String fetchPolicyAttachments;

    @XMLInfo(elementType="element", elementName="Server", elementOrder=2, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="server", refType="WSRRServer", isEnumeration=false, javaName="server", javaType="ObjectReference<ConfigWSRRServer>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="WSRR server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigWSRRServer> getServer() {
        return this.server;
    }

    @XMLInfo(elementType="element", elementName="Server", elementOrder=2, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="server", refType="WSRRServer", isEnumeration=false, javaName="server", javaType="ObjectReference<ConfigWSRRServer>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="WSRR server", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setServer(ObjectReference<ConfigWSRRServer> server) {
        this.server = server;
    }

    @XMLInfo(elementType="element", elementName="SavedSearchName", elementOrder=3, dataPowerType="dmString", subType="WSRRSavedSearchName", benign=false, isPassword=false, cliAlias="saved-search-name", refType="", isEnumeration=false, javaName="savedSearchName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Saved search or named query", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSavedSearchName() {
        return this.savedSearchName;
    }

    @XMLInfo(elementType="element", elementName="SavedSearchName", elementOrder=3, dataPowerType="dmString", subType="WSRRSavedSearchName", benign=false, isPassword=false, cliAlias="saved-search-name", refType="", isEnumeration=false, javaName="savedSearchName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Saved search or named query", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSavedSearchName(String savedSearchName) {
        this.savedSearchName = savedSearchName;
    }

    public void addSavedSearchParameters(String element) {
        if (element == null) {
            return;
        }
        if (this.savedSearchParameters == null) {
            this.savedSearchParameters = new ArrayList();
        }
        this.savedSearchParameters.add(element);
    }

    public boolean removeSavedSearchParameters(String element) {
        if (element == null || this.savedSearchParameters == null) {
            return false;
        }
        return this.savedSearchParameters.remove(element);
    }

    @XMLInfo(elementType="element", elementName="SavedSearchParameters", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="params", refType="", isEnumeration=false, javaName="savedSearchParameters", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=1, maximumLength=255, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Query parameters", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getSavedSearchParameters() {
        return this.savedSearchParameters;
    }

    @XMLInfo(elementType="element", elementName="SavedSearchParameters", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="params", refType="", isEnumeration=false, javaName="savedSearchParameters", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=1, maximumLength=255, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Query parameters", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSavedSearchParameters(ArrayList<String> savedSearchParameters) {
        this.savedSearchParameters = savedSearchParameters;
    }

    @XMLInfo(elementType="element", elementName="Method", elementOrder=5, dataPowerType="dmWsrrSynchronization", subType="", benign=false, isPassword=false, cliAlias="method", refType="", isEnumeration=true, javaName="method", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="poll", displayOrder=0, displayValue="Synchronization method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMethod() {
        return this.method;
    }

    @XMLInfo(elementType="element", elementName="Method", elementOrder=5, dataPowerType="dmWsrrSynchronization", subType="", benign=false, isPassword=false, cliAlias="method", refType="", isEnumeration=true, javaName="method", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="poll", displayValue="Synchronization method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMethod(String method) {
        if (method == null || Comparison.isIn(method, DPEnumerations.WSRR_SYNCHRONIZATION)) {
            this.method = method;
        }
    }

    @XMLInfo(elementType="element", elementName="RefreshInterval", elementOrder=6, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="refresh-interval", refType="", isEnumeration=false, javaName="refreshInterval", javaType="long", isRequired=false, squelchNull=false, minimum=60, maximum=4294967L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="86400", displayOrder=0, displayValue="Refresh interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    @XMLInfo(elementType="element", elementName="RefreshInterval", elementOrder=6, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="refresh-interval", refType="", isEnumeration=false, javaName="refreshInterval", javaType="long", isRequired=false, squelchNull=false, minimum=60, maximum=4294967L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="86400", displayValue="Refresh interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    @XMLInfo(elementType="element", elementName="FetchPolicyAttachments", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="fetch-policy-attachments", refType="", isEnumeration=true, javaName="fetchPolicyAttachments", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Fetch policy attachments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFetchPolicyAttachments() {
        return this.fetchPolicyAttachments;
    }

    @XMLInfo(elementType="element", elementName="FetchPolicyAttachments", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="fetch-policy-attachments", refType="", isEnumeration=true, javaName="fetchPolicyAttachments", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Fetch policy attachments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFetchPolicyAttachments(String fetchPolicyAttachments) {
        if (fetchPolicyAttachments == null || Comparison.isIn(fetchPolicyAttachments, DPEnumerations.TOGGLE)) {
            this.fetchPolicyAttachments = fetchPolicyAttachments;
        }
    }

    @Override
    public int compareTo(ConfigWSRRSavedSearchSubscription that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "server", "savedSearchName", "savedSearchParameters", "method", "refreshInterval", "fetchPolicyAttachments");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.server, this.savedSearchName, this.savedSearchParameters, this.method, this.refreshInterval, this.fetchPolicyAttachments);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "server", "savedSearchName", "savedSearchParameters", "method", "refreshInterval", "fetchPolicyAttachments");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("server", "savedSearchName", "savedSearchParameters", "method", "refreshInterval", "fetchPolicyAttachments"));
    }
}

