/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.lang.Application;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandResult;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;

public abstract class AbstractTool {
    protected static KumbaCoreApplicationProperties applicationProperties;
    protected static Logger logger;
    protected boolean syncrhonizeApplianceChanges;
    public HashSet<ManagementCommandSubscriber> managementCommandSubscribers;

    static {
        AbstractTool.getLogger();
    }

    private static void getLogger() {
        Application application = Application.getApplication();
        if (application != null) {
            applicationProperties = (KumbaCoreApplicationProperties)application.getApplicationProperties();
            logger = Application.getApplication().getApplicationLogger();
        } else {
            applicationProperties = null;
            logger = null;
        }
    }

    public AbstractTool() {
        if (logger == null) {
            AbstractTool.getLogger();
        }
    }

    public boolean isSyncrhonizeApplianceChanges() {
        return this.syncrhonizeApplianceChanges;
    }

    public void setSyncrhonizeApplianceChanges(boolean syncrhonizeApplianceChanges) {
        this.syncrhonizeApplianceChanges = syncrhonizeApplianceChanges;
    }

    public void addManagementCommandSubscriber(Collection<ManagementCommandSubscriber> subscribers) {
        if (CollectionUtility.isEmpty(subscribers)) {
            return;
        }
        if (this.managementCommandSubscribers == null) {
            this.managementCommandSubscribers = new HashSet();
        }
        this.managementCommandSubscribers.addAll(subscribers);
    }

    public void addManagementCommandSubscriber(ManagementCommandSubscriber managementCommandSubscriber) {
        if (managementCommandSubscriber == null) {
            return;
        }
        if (this.managementCommandSubscribers == null) {
            this.managementCommandSubscribers = new HashSet();
        }
        this.managementCommandSubscribers.add(managementCommandSubscriber);
    }

    public void removeManagementCommandSubscriber(ManagementCommandSubscriber commandSubscriber) {
        if (this.managementCommandSubscribers == null || commandSubscriber == null) {
            return;
        }
        this.managementCommandSubscribers.remove(commandSubscriber);
    }

    public HashSet<ManagementCommandSubscriber> getManagementCommandSubscribers() {
        return this.managementCommandSubscribers;
    }

    public void notifyManagementCommandSubscribers(ManagementCommandResult commandResult) {
        if (this.managementCommandSubscribers == null) {
            return;
        }
        for (ManagementCommandSubscriber subscriber : this.managementCommandSubscribers) {
            if (commandResult instanceof ManagementCommandStatus) {
                ManagementCommandStatus status = (ManagementCommandStatus)commandResult;
                subscriber.commandSucceeded(status);
                continue;
            }
            if (!(commandResult instanceof ManagementCommandError)) continue;
            ManagementCommandError error = (ManagementCommandError)commandResult;
            subscriber.commandFailed(error);
        }
    }
}

