/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.InvocationListener;
import com.jmorgan.lang.Types;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerXMLClassInfo;
import com.kumbasoft.core.beans.DataPowerXMLPropertyInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerXMLManagement;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.logging.AuditLogRecord;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

abstract class AbstractXMLManagementTool<XMLManagementType>
extends DataPowerXMLManagement {
    protected static String somaTemplatesDirectory;
    protected static String firmwareMetaDataDirectory;
    protected ArrayList<XMLManagementType> xmlManagementObjects;
    protected String xmlManagementObjectType;
    protected String commandDescription;
    protected DynamicBean additionalCommandInfo;
    protected AsynchMethodInvoker<Void> processThread;
    protected String requestXML;
    protected ArrayList<String> ignoreProperties;

    static {
        if (somaTemplatesDirectory == null) {
            somaTemplatesDirectory = AbstractTool.applicationProperties.getSomaTemplatesDirectory();
            logger.fine(() -> LMG.log("SOMA Templates Directory: %s", () -> somaTemplatesDirectory));
            firmwareMetaDataDirectory = AbstractTool.applicationProperties.getFirmwareMetaDataDirectory();
            logger.fine(() -> LMG.log("FirmwareMetaData Directory: %s", () -> firmwareMetaDataDirectory));
        }
    }

    public AbstractXMLManagementTool(Appliance appliance, XMLManagementType xmlManagementObject) {
        this(appliance, xmlManagementObject, false);
    }

    public AbstractXMLManagementTool(Appliance appliance, XMLManagementType xmlManagementObject, boolean runSynchronously) {
        this(appliance, appliance.getDomain("default"), xmlManagementObject, runSynchronously);
    }

    public AbstractXMLManagementTool(Appliance appliance, Domain domain, XMLManagementType xmlManagementObject) {
        this(appliance, domain, xmlManagementObject, false);
    }

    public AbstractXMLManagementTool(Appliance appliance, Domain domain, XMLManagementType xmlManagementObject, boolean runSynchronously) {
        this(appliance, domain, CollectionUtility.createListFrom(xmlManagementObject), runSynchronously);
    }

    public AbstractXMLManagementTool(Appliance appliance, Domain domain, Collection<XMLManagementType> xmlManagementObjects, boolean runSynchronously) {
        super(appliance, domain);
        for (XMLManagementType xmlManagementObject : xmlManagementObjects) {
            String xmlManagementObjectType = xmlManagementObject.getClass().getSimpleName();
            AuditLogRecord auditLogRecord = new AuditLogRecord(appliance, domain, String.format("Applying %s for appliance %s in domain %s.", xmlManagementObjectType, appliance.getName(), domain.getName()));
            logger.log(auditLogRecord);
            this.addXmlManagementObject(xmlManagementObject);
        }
        this.setCommandDescription(this.getCommandDescription(this.xmlManagementObjects.get(0)));
        if (runSynchronously) {
            this.processCommand();
        } else {
            this.processThread = new AsynchMethodInvoker((Object)this, "processCommand", KumbaCoreConstants.STARTUP_DELAY);
        }
    }

    public void addInvocationListener(InvocationListener listener) {
        if (listener == null || this.processThread == null) {
            return;
        }
        this.processThread.addInvocationListener(listener);
    }

    public AsynchMethodInvoker<Void> getProcessThread() {
        return this.processThread;
    }

    public void addXmlManagementObject(XMLManagementType xmlManagementObject) {
        if (this.xmlManagementObjects == null) {
            this.xmlManagementObjects = new ArrayList();
        }
        this.xmlManagementObjects.add(xmlManagementObject);
    }

    protected String prepareXMLTemplate(String templateFileName) {
        String requestXML = null;
        try {
            String fullFileName = String.format("%s/%s", somaTemplatesDirectory, templateFileName);
            requestXML = FileUtility.readFile(fullFileName);
            requestXML = requestXML.replace("${domain}", this.getDomain().getName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return requestXML;
    }

    protected String buildXMLRequestFromProperties(String requestXML, String xmlBodyMarker, XMLManagementType configObject) {
        logger.finer("(requestXML, xmlBodyMarker, XMLManagementType configObject):  Starting");
        XMLElement rootElement = new XMLElement("RootNode");
        this.getXMLElements(configObject, rootElement);
        StringBuilder xmlBody = new StringBuilder();
        for (XMLElement element : rootElement.getNodes()) {
            xmlBody.append(element.toString());
        }
        requestXML = requestXML.replace(xmlBodyMarker, xmlBody);
        logger.finer("(requestXML, xmlBodyMarker, XMLManagementType configObject):  Done");
        return requestXML;
    }

    protected String cleanupRequestXML(String requestXML) {
        requestXML = this.finalizeRequestMessage(requestXML);
        this.requestXML = requestXML = requestXML.replace(">null<", "><");
        return requestXML;
    }

    private void getXMLElements(Object dataPowerObject, XMLElement parentElement) {
        DataPowerXMLClassInfo classInfo;
        String objectClassName = dataPowerObject.getClass().getSimpleName();
        String thisClassName = this.getClass().getSimpleName();
        String methodSignature = String.format("(dataPowerObject=%s, parentElement): ", objectClassName);
        AbstractTool.logger.finer(() -> LMG.log("%sStarting", () -> methodSignature));
        String applianceFirmwareVersion = this.getAppliance().getFirmwareVersion();
        ArrayList<DataPowerXMLPropertyInfo> classProperties = new ArrayList<DataPowerXMLPropertyInfo>();
        do {
            String metaDataFileName;
            File metaDataFile;
            if (!(metaDataFile = new File(metaDataFileName = String.format("%s%s%s%s%s.xgn", firmwareMetaDataDirectory, File.separator, applianceFirmwareVersion, File.separator, objectClassName))).exists()) {
                AbstractTool.logger.severe(() -> LMG.log("%sMeta-data file (%s) does not exist!", () -> methodSignature, () -> metaDataFile.getAbsolutePath()));
                return;
            }
            AbstractTool.logger.fine(() -> LMG.log("%sProcessing meta data from: %s", () -> methodSignature, () -> metaDataFile.getAbsolutePath()));
            classInfo = (DataPowerXMLClassInfo)FileUtility.readObject(metaDataFile, true);
            ArrayList<DataPowerXMLPropertyInfo> properties = classInfo.getProperties();
            classProperties.addAll(properties);
        } while (!(objectClassName = classInfo.getSuperType()).equals("DataPowerConfig") && !objectClassName.equals("DataPowerAction") && !objectClassName.equals("JMBean"));
        BeanComparator sorter = new BeanComparator();
        sorter.addCompareProperty("elementOrder");
        Collections.sort(classProperties, sorter);
        for (DataPowerXMLPropertyInfo propertyInfo : classProperties) {
            String propertyName = propertyInfo.getPropertyName();
            if (propertyInfo.getElementType().equals("attribute")) {
                String finalObjectClassName = objectClassName;
                AbstractTool.logger.fine(() -> LMG.log("%sSkipping element creation for attribute %s for %s\n", () -> methodSignature, () -> propertyName, () -> finalObjectClassName));
                continue;
            }
            String javaPropertyName = propertyInfo.getJavaPropertyName();
            Method propertyAccessor = BeanService.getPropertyAccessor(dataPowerObject, javaPropertyName);
            if (propertyAccessor == null) continue;
            Object value = BeanService.getPropertyValue(dataPowerObject, javaPropertyName);
            if (value == null) {
                if (propertyInfo.isRequired()) {
                    AbstractTool.logger.fine(() -> LMG.log("%snull property %s for %s but is required.  Creating as empty.\n", () -> methodSignature, () -> propertyName, () -> dataPowerObject.getClass().getName()));
                    value = "";
                } else {
                    AbstractTool.logger.fine(() -> LMG.log("%sSkipping element creation for null property %s for %s\n", () -> methodSignature, () -> propertyName, () -> dataPowerObject.getClass().getName()));
                    continue;
                }
            }
            AbstractTool.logger.finer(() -> LMG.log("%s%s property %s", () -> methodSignature, () -> thisClassName, () -> propertyName));
            int elementCount = 1;
            ArrayList valueList = null;
            if (value instanceof ArrayList && (elementCount = (valueList = (ArrayList)value).size()) == 0) {
                XMLElement childElement = new XMLElement(propertyName);
                parentElement.addNode(childElement);
            }
            int i = 0;
            while (i < elementCount) {
                if (valueList != null) {
                    value = valueList.get(i);
                }
                String objectReferenceType = null;
                if (value instanceof ObjectReference) {
                    ObjectReference objectReference = (ObjectReference)value;
                    value = objectReference.getName();
                    objectReferenceType = objectReference.getClassName();
                }
                XMLElement childElement = new XMLElement(propertyName);
                parentElement.addNode(childElement);
                if (value != null && (Types.isPrimitive(value) || Types.isString(value) || Types.isBigNumberType(value.getClass()) || objectReferenceType != null)) {
                    String strValue = value.toString();
                    if (objectReferenceType == null) {
                        childElement.setValue(strValue);
                    } else {
                        childElement.setValue(strValue);
                        childElement.addAttribute("class", objectReferenceType);
                    }
                } else if (value != null) {
                    this.getXMLElements(value, childElement);
                }
                ++i;
            }
        }
        AbstractTool.logger.finer(() -> LMG.log("%sFinished", () -> methodSignature));
    }

    protected String finalizeRequestMessage(String requestXML) {
        return requestXML;
    }

    protected void processCommand() {
        XMLElement rootElement;
        String thisClassName;
        block5: {
            thisClassName = this.getClass().getSimpleName();
            AbstractTool.logger.finer(() -> LMG.log("():  Start Processing %s", () -> thisClassName));
            rootElement = this.runRequest();
            if (rootElement != null) break block5;
            AbstractTool.logger.severe(() -> LMG.log("(): Response element for %s is null", () -> thisClassName));
            ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), this.commandDescription, this, this.getErrorDescription());
            this.notifyManagementCommandSubscribers(commandError);
            AbstractTool.logger.finer(() -> LMG.log("():  Finished Processing %s", () -> thisClassName));
            return;
        }
        try {
            try {
                this.processResultDocument(rootElement);
            }
            catch (IOException e) {
                AbstractTool.logger.severe(() -> LMG.log("(): Error processing %s", () -> thisClassName));
                ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), this.commandDescription, this, "Communication Error.  Is the appliance up?");
                this.notifyManagementCommandSubscribers(commandError);
                e.printStackTrace();
                AbstractTool.logger.finer(() -> LMG.log("():  Finished Processing %s", () -> thisClassName));
            }
        }
        catch (Throwable throwable) {
            AbstractTool.logger.finer(() -> LMG.log("():  Finished Processing %s", () -> thisClassName));
            throw throwable;
        }
        AbstractTool.logger.finer(() -> LMG.log("():  Finished Processing %s", () -> thisClassName));
    }

    protected void processResultDocument(XMLElement rootElement) {
        String thisClassName = this.getClass().getSimpleName();
        String user = new String(this.getAppliance().getXmlManagementUserName());
        AbstractTool.logger.finer(() -> LMG.log("(XMLElement rootElement):  Start Processing the result document from %s", () -> thisClassName));
        if (rootElement == null) {
            AbstractTool.logger.severe(() -> LMG.log("(XMLElement rootElement):  Result document from %s is null", () -> thisClassName));
            ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), this.getCommandDescription(), this, "Result document is null.");
            commandError.setAdditionalCommandInfo(this.additionalCommandInfo);
            this.notifyManagementCommandSubscribers(commandError);
            AuditLogRecord auditLogRecord = new AuditLogRecord(this.appliance, this.domain, String.format("Error applying %s for appliance %s in domain %s.", thisClassName, this.appliance.getName(), this.domain.getName()));
            auditLogRecord.setApplicationUser(user);
            logger.log(auditLogRecord);
            return;
        }
        Collection<XMLElement> resultNodes = rootElement.getNodes("//dp:result");
        for (XMLElement resultNode : resultNodes) {
            XMLElement errorLogNode = resultNode.getNode("error-log");
            if (errorLogNode == null) {
                AbstractTool.logger.fine(() -> LMG.log("(XMLElement rootElement):  %s completed successfully", () -> thisClassName));
                ManagementCommandStatus commandStatus = new ManagementCommandStatus(this.getAppliance(), this.getDomain(), this.getCommandDescription(), this, resultNode.getValue().trim());
                commandStatus.setAdditionalCommandInfo(this.additionalCommandInfo);
                this.notifyManagementCommandSubscribers(commandStatus);
                AuditLogRecord auditLogRecord = new AuditLogRecord(this.appliance, this.domain, String.format("Successfully completed %s for appliance %s in domain %s", thisClassName, this.appliance.getName(), this.domain.getName()));
                auditLogRecord.setApplicationUser(user);
                logger.log(auditLogRecord);
                continue;
            }
            Collection<XMLElement> logEventNodes = errorLogNode.getNodes("dp:log-event");
            StringBuilder errorMessage = new StringBuilder();
            for (XMLElement logEventNode : logEventNodes) {
                if (errorMessage.length() > 0) {
                    errorMessage.append(" - ");
                }
                errorMessage.append(logEventNode.getValue());
            }
            if (errorMessage.length() == 0) {
                errorMessage.append("*** Unknown Error.  DataPower is indicating an error but not providing information about it. ***");
            }
            AbstractTool.logger.severe(() -> LMG.log("(XMLElement rootElement):  %s resulted in an error:\n\t%s", () -> thisClassName, () -> errorMessage.toString()));
            ManagementCommandError commandError = new ManagementCommandError(this.getAppliance(), this.getDomain(), this.getCommandDescription(), this, errorMessage.toString());
            commandError.setAdditionalCommandInfo(this.additionalCommandInfo);
            this.notifyManagementCommandSubscribers(commandError);
            AuditLogRecord auditLogRecord = new AuditLogRecord(this.appliance, this.domain, String.format("Error %s applying %s for appliance %s in domain %s.", errorMessage.toString(), thisClassName, this.appliance.getName(), this.domain.getName()));
            auditLogRecord.setApplicationUser(user);
            logger.log(auditLogRecord);
        }
    }

    protected String getCommandDescription(XMLManagementType xmlManagementObject) {
        String xmlManagementObjectClassName = xmlManagementObject.getClass().getSimpleName();
        this.xmlManagementObjectType = xmlManagementObjectClassName.substring(6);
        String objectName = null;
        if (BeanService.hasProperty(xmlManagementObject, "name")) {
            objectName = (String)BeanService.getPropertyValue(xmlManagementObject, "name");
        }
        String actionDescription = StringUtility.getDisplayableTitle(this.xmlManagementObjectType + (String)(objectName != null ? " - " + objectName : ""));
        this.setCommandDescription(actionDescription);
        return actionDescription;
    }

    public String getCommandDescription() {
        return this.commandDescription;
    }

    public void setCommandDescription(String commandDescription) {
        this.commandDescription = commandDescription;
    }

    public DynamicBean getAdditionalCommandInfo() {
        return this.additionalCommandInfo;
    }

    public void addIgnoreProperties(String ... ignoreProperties) {
        if (this.ignoreProperties == null) {
            this.ignoreProperties = new ArrayList();
        }
        String[] stringArray = ignoreProperties;
        int n = ignoreProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String ignoreProperty = stringArray[n2];
            this.ignoreProperties.add(ignoreProperty);
            ++n2;
        }
    }

    public void addAdditionalCommandInfo(String propertyName, Object propertyValue) {
        if (StringUtility.isEmpty(this.commandDescription)) {
            return;
        }
        if (this.additionalCommandInfo == null) {
            this.additionalCommandInfo = new DynamicBean();
        }
        this.additionalCommandInfo.setProperty(propertyName, propertyValue);
    }
}

