/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.config.ConfigIPInterface;
import com.kumbasoft.core.tools.AbstractIPManager;
import java.util.ArrayList;

public class AddIP
extends AbstractIPManager {
    private boolean isPrimary;
    private boolean isSecondary;
    private boolean isStandby;

    public AddIP(Appliance appliance, ConfigIPInterface ipInterface, ArrayList<String> ipsToManage, boolean isPrimary, boolean isSecondary, boolean isStandby) {
        super(appliance, ipInterface, ipsToManage);
        this.setPrimary(isPrimary);
        this.setSecondary(isSecondary);
        this.setStandby(isStandby);
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public boolean isSecondary() {
        return this.isSecondary;
    }

    public void setSecondary(boolean isSecondary) {
        this.isSecondary = isSecondary;
    }

    public boolean isStandby() {
        return this.isStandby;
    }

    public void setStandby(boolean isStandby) {
        this.isStandby = isStandby;
    }

    @Override
    protected String getCommandDescription() {
        return String.format("Add new IPs to %s of %s", this.getIpInterface().getName(), this.appliance.getName());
    }

    @Override
    @Reflected
    protected void configureInterface() {
        if (this.isPrimary) {
            String ipAddress = (String)this.ipsToManage.get(0);
            if (this.isStandby) {
                this.ipInterface.setVirtualIP(ipAddress);
            } else {
                this.ipInterface.setIPAddress(ipAddress);
            }
        } else {
            assert (this.isSecondary);
            if (this.isStandby) {
                ArrayList<String> secondaryVirtuals = this.ipInterface.getSecondaryVirtualIP();
                if (secondaryVirtuals == null) {
                    secondaryVirtuals = new ArrayList();
                }
                secondaryVirtuals.addAll(this.ipsToManage);
                this.ipInterface.setSecondaryVirtualIP(secondaryVirtuals);
            } else {
                ArrayList<String> secondaryIPs = this.ipInterface.getSecondaryAddress();
                if (secondaryIPs == null) {
                    secondaryIPs = new ArrayList();
                }
                secondaryIPs.addAll(this.ipsToManage);
                this.ipInterface.setSecondaryAddress(secondaryIPs);
            }
        }
        this.modifyInterface();
    }
}

