/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CreateCertificateFromFileBean;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.tools.AbstractCommandProcessTool;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ConfigTool;
import com.kumbasoft.core.tools.CreatePasswordAlias;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.ThreadManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class CreateCertificatesFromExternalFiles
extends AbstractCommandProcessTool {
    private Index<Appliance, Domain> domains;
    private ArrayList<CreateCertificateFromFileBean> certificateInfo;

    public CreateCertificatesFromExternalFiles(Index<Appliance, Domain> domains, ArrayList<CreateCertificateFromFileBean> certificateInfo) {
        this(domains, certificateInfo, false);
    }

    public CreateCertificatesFromExternalFiles(Index<Appliance, Domain> domains, ArrayList<CreateCertificateFromFileBean> certificateInfo, boolean synchronizeApplianceChanges) {
        this.syncrhonizeApplianceChanges = synchronizeApplianceChanges;
        this.domains = domains;
        this.certificateInfo = certificateInfo;
    }

    @Override
    public void performProcess() {
        this.uploadFiles();
        this.createPasswordMaps();
        this.createCertificates();
    }

    private boolean uploadFiles() {
        AbstractTool.logger.finer("(): Starting");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Appliance appliance : this.domains.getKeys()) {
            AbstractTool.logger.finer(() -> LMG.log("(): for %s", () -> appliance.getName()));
            Domain defaultDomain = appliance.getDomain("default");
            for (Domain domain : this.domains.get(appliance)) {
                AbstractTool.logger.finer(() -> LMG.log("(): for the %s domain of %s", () -> domain.getName(), () -> appliance.getName()));
                ArrayList<DataPowerFileInfo> filesToUpload = new ArrayList<DataPowerFileInfo>();
                Domain targetDomain = domain;
                for (CreateCertificateFromFileBean createCertificateInfo : this.certificateInfo) {
                    File localFile = createCertificateInfo.getLocalFile();
                    String fileStore = createCertificateInfo.getFileStore();
                    String fileName = createCertificateInfo.getDpFileName();
                    targetDomain = domain;
                    if (fileStore.equals("sharedcert:") || fileStore.equals("pubcert:")) {
                        targetDomain = defaultDomain;
                    }
                    AbstractTool.logger.finer(() -> LMG.log("(): Uploading %s to %s in the %s domain of %s", () -> localFile, () -> createCertificateInfo.getDataPowerFQFN(), () -> domain.getName(), () -> appliance.getName()));
                    DataPowerFileInfo dpFileInfo = new DataPowerFileInfo(appliance, targetDomain, null, localFile.length(), fileStore, fileName);
                    dpFileInfo.setLocalFile(localFile);
                    filesToUpload.add(dpFileInfo);
                }
                FileUploader.upload(filesToUpload, mtil);
                for (ManagementCommandSubscriber subscriber : this.managementCommandSubscribers) {
                    FileUploader.addCommandSubscriber(subscriber);
                }
                if (!this.syncrhonizeApplianceChanges) continue;
                ThreadManager.monitorAsynchThreadLifeCycle("CreateCertificatesFromExternalFiles.uploadFiles()", mtil, filesToUpload.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
            }
        }
        boolean completedOnTime = mtil.getRunningThreadCount() > 0 ? ThreadManager.monitorAsynchThreadLifeCycle("CreateCertificatesFromExternalFiles.uploadFiles()", mtil, 0, 0) : true;
        AbstractTool.logger.finer(() -> LMG.log("(): Done - returning %s.", () -> completedOnTime));
        return completedOnTime;
    }

    private boolean createPasswordMaps() {
        AbstractTool.logger.finer("(): Starting");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (CreateCertificateFromFileBean createCertificateInfo : this.certificateInfo) {
            String password;
            String passwordMapName = createCertificateInfo.getPasswordAliasName();
            if (StringUtility.isEmpty(passwordMapName) || StringUtility.isEmpty(password = createCertificateInfo.getPassword())) continue;
            for (Appliance appliance : this.domains.getKeys()) {
                AbstractTool.logger.finer(() -> LMG.log("(): for %s", () -> appliance.getName()));
                for (Domain domain : this.domains.get(appliance)) {
                    AbstractTool.logger.finer(() -> LMG.log("(): Creating/Updating password map %s int the %s domain of %s", () -> passwordMapName, () -> domain.getName(), () -> appliance.getName()));
                    SingleThreadInvocationListener syncWait = this.syncrhonizeApplianceChanges ? new SingleThreadInvocationListener() : null;
                    CreatePasswordAlias createPasswordAlias = new CreatePasswordAlias(appliance, domain, passwordMapName, password);
                    createPasswordAlias.addManagementCommandSubscriber(this.managementCommandSubscribers);
                    mtil.addThread(createPasswordAlias.getProcessThread());
                    if (!this.syncrhonizeApplianceChanges) continue;
                    createPasswordAlias.getProcessThread().addInvocationListener(syncWait);
                    boolean completedOnTime = syncWait.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                    if (completedOnTime) continue;
                    AbstractTool.logger.warning(() -> LMG.log("(): Timeout creating/updating password map %s int the %s domain of %s", () -> passwordMapName, () -> domain.getName(), () -> appliance.getName()));
                }
            }
        }
        boolean completedOnTime = mtil.getRunningThreadCount() > 0 ? ThreadManager.monitorAsynchThreadLifeCycle("CreateCertificatesFromExternalFiles.createPasswordMaps()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0) : true;
        AbstractTool.logger.finer(() -> LMG.log("(): Done - returning %s.", () -> completedOnTime));
        return completedOnTime;
    }

    private boolean createCertificates() {
        AbstractTool.logger.finer("(): Starting");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Appliance appliance : this.domains.getKeys()) {
            AbstractTool.logger.finer(() -> LMG.log("(): for %s", () -> appliance.getName()));
            SingleThreadInvocationListener syncWait = this.syncrhonizeApplianceChanges ? new SingleThreadInvocationListener() : null;
            ArrayList<DataPowerConfig> newCertificateObjects = new ArrayList<DataPowerConfig>();
            for (Domain domain : this.domains.get(appliance)) {
                AbstractTool.logger.finer(() -> LMG.log("(): for the %s domain of %s", () -> domain.getName(), () -> appliance.getName()));
                for (CreateCertificateFromFileBean createCertificateInfo : this.certificateInfo) {
                    String dataPowerFQFN = createCertificateInfo.getDataPowerFQFN();
                    String passwordMapName = createCertificateInfo.getPasswordAliasName();
                    String certificateObjectName = createCertificateInfo.getCertificateObjectName();
                    ConfigCryptoCertificate cryptoCert = new ConfigCryptoCertificate();
                    cryptoCert.setAppliance(appliance);
                    cryptoCert.setSourceDomain(domain);
                    cryptoCert.setName(certificateObjectName);
                    cryptoCert.setAdminState("on");
                    cryptoCert.setConfigObjectType("CryptoCertificate");
                    cryptoCert.setFilename(dataPowerFQFN);
                    if (StringUtility.isNotEmpty(passwordMapName)) {
                        ObjectReference<ConfigPasswordAlias> passMapRef = new ObjectReference<ConfigPasswordAlias>();
                        passMapRef.setClassName("PasswordAlias");
                        passMapRef.setName(passwordMapName);
                        cryptoCert.setAlias(passMapRef);
                    }
                    newCertificateObjects.add(cryptoCert);
                }
                AbstractTool.logger.finer(() -> LMG.log("(): Creating %d certificates in the %s domain of %s", () -> newCertificateObjects.size(), () -> domain.getName(), () -> appliance.getName()));
                ConfigTool configTool = new ConfigTool(appliance, domain, (Collection<DataPowerConfig>)newCertificateObjects);
                configTool.addManagementCommandSubscriber(this.managementCommandSubscribers);
                mtil.addThread(configTool.getProcessThread());
                if (!this.syncrhonizeApplianceChanges) continue;
                configTool.getProcessThread().addInvocationListener(syncWait);
                boolean completedOnTime = syncWait.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                if (completedOnTime) continue;
                AbstractTool.logger.warning(() -> LMG.log("(): Timeout creating certificates in the %s domain of %s", () -> domain.getName(), () -> appliance.getName()));
            }
        }
        boolean completedOnTime = mtil.getRunningThreadCount() > 0 ? ThreadManager.monitorAsynchThreadLifeCycle("CreateCertificatesFromExternalFiles.createCertificates()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0) : true;
        AbstractTool.logger.finer(() -> LMG.log("(): Done - returning %s.", () -> completedOnTime));
        return completedOnTime;
    }
}

