/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.j2ee.xml.XMLFormatter;
import com.jmorgan.lang.Application;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.ConfigTool;
import com.kumbasoft.core.tools.DataPowerFileReader;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.tools.ExportConfiguration;
import com.kumbasoft.core.tools.ModifyProperty;
import com.kumbasoft.core.tools.ModifyTool;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.logging.FinestLogRecord;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.xml.sax.SAXException;

public abstract class DataPowerXMLManagement
extends AbstractTool {
    protected static int READ_BUFFER_SIZE = 163840;
    public static final int NO_ERROR = 0;
    public static final int AUTHENTICATION_ERROR = 10;
    public static final int EMPTY_RESPONSE_ERROR = 11;
    public static final int XML_PARSE_ERROR = 26;
    public static final int XML_PARSE_CONFIG_ERROR = 27;
    public static final int PROCESSING_EXCEPTION_ERROR = 28;
    public static final int CONNECTION_FAILURE = 29;
    public static final int OUT_OF_MEMORY_ERROR = 30;
    public static final int UNKOWN_ERROR = 50;
    public static final int SEVERE_SERVER_ERROR = 500;
    public static final int COMMAND_TIMEOUT = 200;
    protected static final long MINIMUM_MONITOR_INTERVAL = 500L;
    protected Appliance appliance;
    protected String applianceName;
    private String authorizationHeader;
    protected Domain domain;
    protected String domainName;
    private URL soapMgmtURL;
    private URL apiMgmtURL;
    private HashMap<Class<? extends DataPowerConfig>, ConfigObjectSubscriber> subscriberMap;
    protected int connectionTimeout = KumbaCoreConstants.SOMA_CONNECTION_TIMEOUT;
    protected int readTimeout = KumbaCoreConstants.SOMA_READ_TIMEOUT;
    protected boolean retryOnOutputException = true;
    protected boolean retryOnSocketTimeout = true;
    protected boolean retryOnNon200ReturnCode = false;
    protected boolean returnNon200Response = false;
    protected boolean retryOnEmptyResponse = true;
    protected boolean retryOnResponseParseFailure = true;
    protected boolean retryOnOutOfMemoryError = false;
    private int retryCount = KumbaCoreConstants.SOMA_RETRY_COUNT;
    private int sleepInterval = KumbaCoreConstants.RETRY_INTERVAL;
    protected int retries = -1;
    protected String responseXML;
    protected int errorCode;

    protected DataPowerXMLManagement() {
    }

    public DataPowerXMLManagement(Appliance appliance, Domain domain) {
        if (domain == null) {
            domain = new Domain("default");
            appliance.addDomain(domain);
        }
        this.setDomain(domain);
        this.setAppliance(appliance);
    }

    public String getResponseXML() {
        return this.responseXML;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public boolean isRetryOnOutputException() {
        return this.retryOnOutputException;
    }

    public void setRetryOnOutputException(boolean retryOnOutputException) {
        this.retryOnOutputException = retryOnOutputException;
    }

    public boolean isRetryOnSocketTimeout() {
        return this.retryOnSocketTimeout;
    }

    public void setRetryOnSocketTimeout(boolean retryOnSocketTimeout) {
        this.retryOnSocketTimeout = retryOnSocketTimeout;
    }

    public boolean isRetryOnNon200ReturnCode() {
        return this.retryOnNon200ReturnCode;
    }

    public void setRetryOnNon200ReturnCode(boolean retryOnNon200ReturnCode) {
        this.retryOnNon200ReturnCode = retryOnNon200ReturnCode;
    }

    public boolean isRetryOnEmptyResponse() {
        return this.retryOnEmptyResponse;
    }

    public void setRetryOnEmptyResponse(boolean retryOnEmptyResponse) {
        this.retryOnEmptyResponse = retryOnEmptyResponse;
    }

    public boolean isRetryOnResponseParseFailure() {
        return this.retryOnResponseParseFailure;
    }

    public void setRetryOnResponseParseFailure(boolean retryOnResponseParseFailure) {
        this.retryOnResponseParseFailure = retryOnResponseParseFailure;
    }

    public boolean isRetryOnOutOfMemoryError() {
        return this.retryOnOutOfMemoryError;
    }

    public void setRetryOnOutOfMemoryError(boolean retryOnOutOfMemoryError) {
        this.retryOnOutOfMemoryError = retryOnOutOfMemoryError;
    }

    public int getSleepInterval() {
        return this.sleepInterval;
    }

    public void setSleepInterval(int sleepInterval) {
        this.sleepInterval = sleepInterval;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        return switch (this.errorCode) {
            case 0 -> "No Error";
            case 10 -> "Authentication Error";
            case 200 -> "Command Timeout";
            case 29 -> "Connection Failure";
            case 11 -> "Empty Response";
            case 30 -> "Out of Memory";
            case 28 -> "Error while processing";
            case 50 -> "Unknown Error";
            case 27 -> "XML Parsing Configuration Error";
            case 26 -> "XML Parsing Error";
            case 500 -> "DataPower Returned a 500 error.  Please contact KumbaSoft LLC Technical Support.";
            default -> {
                logger.severe(() -> LMG.log("(): Error code %d had no description.  Look it up and provide it.", () -> this.errorCode));
                yield "Description Not Available - Should Not Happen - FIX IT";
            }
        };
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    protected final XMLElement runRequest() throws IOException {
        StringBuilder response;
        int returnCode;
        Level loggerLevel;
        String requestMessage;
        block53: {
            this.errorCode = 0;
            if (this.retries++ == this.retryCount) {
                String requestTypes = "Unknown";
                if (this instanceof ExportConfiguration) {
                    requestTypes = "export configuration";
                } else if (this instanceof DataPowerStatusMonitor) {
                    requestTypes = "status";
                }
                String finalReqeustTypes = requestTypes;
                logger.severe(() -> LMG.log("():  ********* Fatal error processing %s requests on %s.  Number of retries exceeded", () -> finalReqeustTypes, () -> this.applianceName));
                return null;
            }
            logger.finer("():  Getting request message.");
            requestMessage = this.getRequestMessage();
            if (requestMessage == null) {
                return null;
            }
            int requestMessageLength = requestMessage.length();
            int outputBufferSize = requestMessageLength > KumbaCoreConstants.FILE_READ_BUFFER_SIZE ? KumbaCoreConstants.FILE_READ_BUFFER_SIZE : requestMessageLength;
            logger.finer(() -> LMG.log("():  Request Message Size: %d.", () -> requestMessageLength));
            loggerLevel = logger.getLevel();
            if (loggerLevel != null && loggerLevel.equals(Level.FINEST)) {
                FinestLogRecord logRecord = new FinestLogRecord(Level.FINEST, this.appliance, this.domain, requestMessage);
                logger.log(logRecord);
            }
            HttpsURLConnection connection = null;
            if (requestMessage.contains("http://www.datapower.com/schemas/appliance/management/")) {
                connection = (HttpsURLConnection)this.getApiMgmtURL().openConnection();
            } else if (requestMessage.contains("http://www.datapower.com/schemas/management")) {
                connection = (HttpsURLConnection)this.getSoapMgmtURL().openConnection();
            }
            if (connection == null) {
                logger.severe(() -> LMG.log("(): Connection is null to '%s' after call to open the connection.", () -> this.applianceName));
                this.sleep();
                return this.runRequest();
            }
            int keepAliveTimeout = this.connectionTimeout / 1000 * 2;
            connection.setRequestProperty("Authorization", this.getAuthorizationHeader());
            connection.setConnectTimeout(this.connectionTimeout);
            connection.setReadTimeout(this.readTimeout);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "text/xml; charset=\"utf8\"");
            connection.setRequestProperty("Content-Length", "" + requestMessageLength);
            connection.setRequestProperty("Connection", "keep-alive");
            connection.setRequestProperty("Keep-Alive", "timeout=" + keepAliveTimeout);
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            logger.finer(() -> LMG.log("():  Done setting up the connection to %s.   Initiating message push.", () -> this.applianceName));
            try {
                OutputStream out = connection.getOutputStream();
                BufferedOutputStream bout = new BufferedOutputStream(out, outputBufferSize);
                PrintStream pout = new PrintStream(bout);
                pout.print(requestMessage);
                pout.flush();
                bout.flush();
                out.flush();
                pout.close();
                bout.close();
                logger.finer(() -> LMG.log("():  Done pushing message t0 %s", () -> this.applianceName));
            }
            catch (IOException e) {
                String exceptionMessage;
                switch (exceptionMessage = e.getMessage()) {
                    case "No route to host (Host unreachable)": {
                        this.errorCode = 29;
                        break;
                    }
                    default: {
                        this.errorCode = 50;
                    }
                }
                if (this.retryOnOutputException) {
                    this.sleep();
                    logger.info(() -> LMG.log("():  ******* Output Exception \"%s\" on %s.  Retrying %s", () -> exceptionMessage, () -> this.applianceName, () -> this.retries + 1));
                    return this.runRequest();
                }
                return null;
            }
            catch (Exception e) {
                logger.severe(() -> LMG.log("():  ******* Output Exception \"%s\" on %s.  Fatal.  Not retrying", () -> e.getMessage(), () -> this.applianceName));
                this.errorCode = 50;
                return null;
            }
            returnCode = -1;
            try {
                returnCode = connection.getResponseCode();
            }
            catch (SocketTimeoutException e) {
                this.errorCode = 29;
                if (this.retryOnSocketTimeout) {
                    this.sleep();
                    logger.info(() -> LMG.log("():  ******* SocketTimeoutException \"%s\" on %s.  Retrying %s", () -> e.getMessage(), () -> this.applianceName, () -> this.retries + 1));
                    return this.runRequest();
                }
                return null;
            }
            catch (Exception e) {
                this.errorCode = 50;
                logger.severe(() -> LMG.log("():  ******* Unhandled Exception \"%s\" on %s. *** Not Retrying ***", () -> e.getMessage(), () -> this.applianceName));
                return null;
            }
            int finalReturnCode = returnCode;
            logger.finer(() -> LMG.log("():  Return code for command on %s -> %s is %d", () -> this.applianceName, () -> this.domainName, () -> finalReturnCode));
            InputStream in = null;
            if (returnCode == 200) {
                in = connection.getInputStream();
                logger.finer(() -> LMG.log("():  Processing input Stream of %s -> %s.....", () -> this.applianceName, () -> this.domainName));
            } else {
                in = connection.getErrorStream();
                logger.warning(() -> LMG.log("():  Processing error Stream of %s -> %s.....", () -> this.applianceName, () -> this.domainName));
            }
            if (loggerLevel != null && loggerLevel.equals(Level.FINEST)) {
                for (Map.Entry<String, List<String>> entries : connection.getHeaderFields().entrySet()) {
                    StringBuilder values = new StringBuilder();
                    for (String value : entries.getValue()) {
                        if (values.length() > 0) {
                            values.append(", ");
                        }
                        values.append(value);
                    }
                    logger.finest(() -> LMG.log("(): Header '%s' -> '%s'", () -> entries.getKey(), () -> values.toString()));
                }
            }
            response = new StringBuilder();
            try {
                int bufferLength;
                byte[] buffer = new byte[READ_BUFFER_SIZE];
                while ((bufferLength = in.read(buffer)) >= 0) {
                    response.append(new String(buffer, 0, bufferLength));
                }
            }
            catch (OutOfMemoryError ooe) {
                this.errorCode = 30;
                response = DataPowerXMLManagement.clearResponse(requestMessage, response);
                if (this.retryOnOutOfMemoryError) {
                    this.sleep();
                    logger.severe(() -> LMG.log("():  ********* Out of memory error... Retrying %d", () -> this.retries + 1));
                    return this.runRequest();
                }
                return null;
            }
            catch (SocketTimeoutException ste) {
                this.errorCode = 29;
                response = DataPowerXMLManagement.clearResponse(requestMessage, response);
                if (this.retryOnSocketTimeout) {
                    this.sleep();
                    logger.info(() -> LMG.log("():  ********* Socket timeout on %s... Retrying %d", () -> this.applianceName, () -> this.retries + 1));
                    return this.runRequest();
                }
                return null;
            }
            catch (IOException ioe) {
                response = DataPowerXMLManagement.clearResponse(requestMessage, response);
                if (!this.retryOnEmptyResponse) break block53;
                this.sleep();
                logger.info(() -> LMG.log("():  ********* IO Exception on %s... Retrying %d", () -> this.applianceName, () -> this.retries + 1));
                return this.runRequest();
            }
        }
        this.responseXML = response.toString().trim();
        logger.finer(() -> LMG.log("Read %d bytes total.", () -> this.responseXML.length()));
        if (loggerLevel != null && loggerLevel.equals(Level.FINEST)) {
            FinestLogRecord logRecord = new FinestLogRecord(Level.FINEST, this.appliance, this.domain, this.responseXML);
            logger.log(logRecord);
        }
        if (this.responseXML.charAt(this.responseXML.length() - 1) != '>') {
            logger.severe(() -> LMG.log("():  ***** ERROR:  Last character not '>' in response XML of the %s domain of %s.", () -> this.domainName, () -> this.applianceName));
            logger.severe(() -> XMLFormatter.format(this.responseXML));
        } else if (this.responseXML.contains("Invalid SOAP envelope")) {
            logger.severe(() -> LMG.log("():  ***** ERROR:  Invalid SOAP Envelope.\n%s", () -> requestMessage));
            logger.severe(() -> XMLFormatter.format(this.responseXML));
        }
        if (returnCode != 200) {
            this.errorCode = returnCode;
            if (this.returnNon200Response) {
                logger.info(() -> LMG.log("():  ********* Return Code = %d. Returning response", () -> this.errorCode));
                return XMLElement.parseXMLString(response);
            }
            response = DataPowerXMLManagement.clearResponse(requestMessage, response);
            if (this.retryOnNon200ReturnCode) {
                this.sleep();
                logger.info(() -> LMG.log("():  ********* Return Code = %d... Retrying %d", () -> this.errorCode, () -> this.retries + 1));
                return this.runRequest();
            }
            return null;
        }
        this.errorCode = 0;
        if (this.responseXML.length() == 0) {
            this.errorCode = 11;
            response = DataPowerXMLManagement.clearResponse(requestMessage, response);
            if (this.retryOnEmptyResponse) {
                this.sleep();
                logger.info(() -> LMG.log("():  ********* Response XML is Empty... Retrying %d", () -> this.retries + 1));
                return this.runRequest();
            }
            return null;
        }
        int countOfEnvelopes = StringUtility.getCountOf(this.responseXML, "Envelope xmlns");
        if (countOfEnvelopes > 1) {
            logger.finer(() -> LMG.log("():  Number of envelopes in the response: %d", () -> countOfEnvelopes));
            int repsponseXMLSize = this.responseXML.length();
            logger.finer(() -> LMG.log("():  Size of response XML: %d", () -> repsponseXMLSize));
            int closingInstruction = this.responseXML.indexOf("?>") + 2;
            this.responseXML = StringUtility.insertInto("<MultiEnvelopeResponse xmlns=\"http://www.kumbasoft.com/schemas/datapower/response/\">", this.responseXML, closingInstruction);
            this.responseXML = String.valueOf(this.responseXML) + "</MultiEnvelopeResponse>";
        }
        XMLElement xmlElement = XMLElement.parseXMLString(this.responseXML);
        response = DataPowerXMLManagement.clearResponse(requestMessage, response);
        if (xmlElement == null) {
            Exception parseException = XMLElement.getParseException();
            if (parseException instanceof ParserConfigurationException) {
                this.errorCode = 27;
            } else if (parseException instanceof SAXException) {
                this.errorCode = 26;
            }
            parseException.printStackTrace();
            if (this.retryOnResponseParseFailure) {
                this.sleep();
                logger.info(() -> LMG.log("():  ***** %s ... Retrying %d", () -> parseException.getClass().getSimpleName(), () -> this.retries + 1));
                return this.runRequest();
            }
            return null;
        }
        this.retries = -1;
        logger.finer("(): Done");
        return xmlElement;
    }

    private static StringBuilder clearResponse(String request, StringBuilder response) {
        if (response == null) {
            logger.warning("():  Response is null when not expected to be null for request:" + request);
        } else {
            response.delete(0, response.length());
            response.setLength(0);
            response = null;
        }
        return response;
    }

    private String getAuditLogMessage() {
        String className = this.getClass().getSimpleName();
        Object responseMessage = null;
        switch (className) {
            case "ActionTool": {
                ActionTool actionTool = (ActionTool)this;
                responseMessage = actionTool.getCommandDescription();
                break;
            }
            case "ConfigTool": {
                ConfigTool configTool = (ConfigTool)this;
                responseMessage = configTool.getCommandDescription();
                break;
            }
            case "DataPowerFileReader": {
                DataPowerFileReader fileReader = (DataPowerFileReader)this;
                responseMessage = fileReader.getCommandDescription();
                break;
            }
            case "DataPowerStatusMonitor": {
                DataPowerStatusMonitor statusMonitor = (DataPowerStatusMonitor)this;
                String statusClass = statusMonitor.getStatusClass();
                responseMessage = String.format("Reading status from %s", statusClass);
                break;
            }
            case "ModifyTool": {
                ModifyTool modifyTool = (ModifyTool)this;
                responseMessage = modifyTool.getCommandDescription();
                break;
            }
            case "ModifyProperty": {
                ModifyProperty modifyProperty = (ModifyProperty)this;
                responseMessage = modifyProperty.getCommandDescription();
                break;
            }
            default: {
                responseMessage = "Invoking " + this.getClass().getName();
            }
        }
        return "(): " + (String)responseMessage;
    }

    protected final String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    private final void createAuthorizationHeader(char[] userName, char[] password) {
        this.authorizationHeader = "Basic " + DataPowerXMLManagement.getBasicAuthHeader(userName, password);
    }

    protected static final String getBasicAuthHeader(char[] userName, char[] password) {
        if (userName == null || password == null) {
            throw new IllegalArgumentException("(char[] userName, char[] password):  User Name nor Password can be null");
        }
        byte[] authentication = new byte[userName.length + password.length + 1];
        int i = 0;
        while (i < userName.length) {
            authentication[i] = (byte)userName[i];
            ++i;
        }
        authentication[userName.length] = 58;
        i = 0;
        int j = userName.length + 1;
        while (i < password.length) {
            authentication[j] = (byte)password[i];
            ++i;
            ++j;
        }
        String b64UserInfo = Base64.encodeBase64String(authentication);
        return b64UserInfo;
    }

    protected static String getRequestStanza(String somaTemplate) {
        int startingRequest = somaTemplate.indexOf("<dp:request");
        int endingRequest = somaTemplate.indexOf("</dp:request>") + "</dp:request>".length();
        String requestStanza = somaTemplate.substring(startingRequest, endingRequest);
        return requestStanza;
    }

    protected abstract String getRequestMessage();

    public Appliance getAppliance() {
        return this.appliance;
    }

    public void setAppliance(Appliance appliance) {
        if (appliance == null) {
            this.apiMgmtURL = null;
            this.soapMgmtURL = null;
            this.appliance = null;
            this.applianceName = null;
            return;
        }
        this.appliance = appliance;
        this.applianceName = this.appliance.getName();
        char[] userName = this.appliance.getXmlManagementUserName();
        char[] password = this.appliance.getXmlManagementPassword();
        this.createAuthorizationHeader(userName, password);
        Object host = appliance.getXmlManagementHost();
        if (!((String)host).contains(":")) {
            host = (String)host + ":" + appliance.getXmlPort();
        }
        String apimURL = String.format("https://%s/service/mgmt/amp/3.0", host);
        String soapURL = String.format("https://%s/service/mgmt/3.0", host);
        try {
            this.apiMgmtURL = new URL(apimURL);
            this.soapMgmtURL = new URL(soapURL);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
        this.domainName = this.domain != null ? this.domain.getName() : "";
    }

    public URL getSoapMgmtURL() {
        return this.soapMgmtURL;
    }

    public URL getApiMgmtURL() {
        return this.apiMgmtURL;
    }

    protected void sleep() {
        this.sleep(this.sleepInterval);
    }

    protected void sleep(long monitorInterval) {
        long monitorIntervalF = monitorInterval;
        logger.fine(() -> LMG.log("(monitorInterval=[%d]): retries=%d", () -> monitorIntervalF, () -> this.retries));
        if (this.retries < 0) {
            return;
        }
        if (monitorInterval < 500L) {
            monitorInterval = 500L;
            logger.fine(() -> LMG.log("(monitorInterval=[%d]):  Set to minimum.", () -> 500L));
        }
        ThreadUtility.sleep(monitorInterval * (long)this.retries);
    }

    protected static String getDomainAMPRequestXML() throws IOException {
        String somaFileName = FileUtility.getSOMATemplateFileName("AMPRequest.xml");
        String xmlRequest = FileUtility.readFile(somaFileName);
        String domainRequest = xmlRequest.replace("${Request}", "GetDomainListRequest");
        return domainRequest;
    }

    public void addConfigObjectSubscriber(Class<? extends DataPowerConfig> key, ConfigObjectSubscriber subscriber) {
        if (this.subscriberMap == null) {
            this.subscriberMap = new HashMap();
        }
        this.subscriberMap.put(key, subscriber);
    }

    protected void notifyConfigObjectSubscribers() {
        if (CollectionUtility.isEmpty(this.subscriberMap)) {
            return;
        }
        for (ConfigObjectSubscriber subscriber : this.subscriberMap.values()) {
            subscriber.configProcessingComplete();
        }
    }

    protected void notifyConfigObjectSubscribers(DataPowerConfig dataPowerConfig) {
        logger.finer(() -> LMG.log("(dataPowerConfig=%s): Starting", () -> dataPowerConfig.getFQON()));
        if (CollectionUtility.isEmpty(this.subscriberMap)) {
            logger.finer(() -> LMG.log("(dataPowerConfig=%s): No subscribers.  Returning.", () -> dataPowerConfig.getFQON()));
            return;
        }
        Class<?> configType = dataPowerConfig.getClass();
        ConfigObjectSubscriber subscriber = null;
        subscriber = this.subscriberMap.get(configType);
        while (subscriber == null && configType != null) {
            Class<?> beforeConfigType = configType;
            logger.finer(() -> LMG.log("(dataPowerConfig=%s): No subscriber for %s.", () -> dataPowerConfig.getFQON(), () -> beforeConfigType.getClass().getSimpleName()));
            Class<?> superConfigType = configType = configType.getSuperclass();
            logger.finer(() -> LMG.log("(dataPowerConfig=%s): Trying %s.", () -> dataPowerConfig.getFQON(), () -> superConfigType.getClass().getSimpleName()));
            subscriber = this.subscriberMap.get(configType);
        }
        if (subscriber != null) {
            ConfigObjectSubscriber subscriberF = subscriber;
            logger.finer(() -> LMG.log("(dataPowerConfig=%s): Notifying Subscriber: %s", () -> dataPowerConfig.getFQON(), () -> subscriberF.getClass().getSimpleName()));
            subscriber.processDataPowerConfig(dataPowerConfig);
        }
        logger.finer(() -> LMG.log("(dataPowerConfig=%s): Done", () -> dataPowerConfig.getFQON()));
    }

    public static void clearLocalCache() {
        Application application = Application.getApplication();
        KumbaCoreApplicationProperties appProps = (KumbaCoreApplicationProperties)application.getApplicationProperties();
        String configExportsDirectory = appProps.getConfigExportsDirectory();
        File configExportsDir = new File(configExportsDirectory);
        FileUtility.deleteFiles(configExportsDir, ".xml");
    }
}

