/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.actions.ActionRemoveDir;
import com.kumbasoft.core.tools.AbstractCommandProcessTool;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ActionTool;
import java.util.ArrayList;

public class DirectoryDeleter
extends AbstractCommandProcessTool {
    private ArrayList<DataPowerFileInfo> selectedDirectories;

    public DirectoryDeleter(ArrayList<DataPowerFileInfo> selectedDirectories) {
        this.selectedDirectories = selectedDirectories;
    }

    @Override
    public void performProcess() {
        for (DataPowerFileInfo selectedDirectory : this.selectedDirectories) {
            AbstractTool.logger.finer(() -> LMG.log("Removing '%s' from the %s domain of %s", () -> selectedDirectory.getName(), () -> selectedDirectory.getSourceDomain().getName(), () -> selectedDirectory.getAppliance().getName()));
            ActionRemoveDir deleteDirectoryAction = new ActionRemoveDir();
            deleteDirectoryAction.setDir(selectedDirectory.getName());
            ActionTool actionTool = new ActionTool(selectedDirectory.getAppliance(), selectedDirectory.getSourceDomain(), deleteDirectoryAction);
            actionTool.setCommandDescription(String.format("Delete Directory %s", selectedDirectory.getName()));
            actionTool.addManagementCommandSubscriber(this.managementCommandSubscribers);
            AbstractTool.logger.config(() -> LMG.log("Removed '%s' from the %s domain of %s", () -> selectedDirectory.getName(), () -> selectedDirectory.getSourceDomain().getName(), () -> selectedDirectory.getAppliance().getName()));
        }
    }
}

