/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusDomainStatus;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import java.util.ArrayList;
import java.util.HashMap;

public class ListDomains
extends AbstractTool {
    private Appliance appliance;

    public ListDomains(Appliance appliance) {
        this.appliance = appliance;
        this.listDomains();
    }

    public void listDomains() {
        ArrayList domainInfo;
        String logSuffix = String.format("for appliance %s(%d)", this.appliance.getName(), this.appliance.hashCode());
        AbstractTool.logger.finer(() -> LMG.log("(): Starting %s", () -> logSuffix));
        Boolean healthChecks = (Boolean)Application.getApplication().getAttribute("healthChecksAllowed");
        if (healthChecks == null) {
            AbstractTool.logger.fine(() -> LMG.log("(): Health checks global attribute setting is missing %s. Setting to true.", () -> logSuffix));
            healthChecks = Boolean.TRUE;
        }
        if (!healthChecks.booleanValue()) {
            AbstractTool.logger.fine(() -> LMG.log("(): Health checks are off %s.  Rescheduling.", () -> logSuffix));
            new AsynchMethodInvoker((Object)this, "listDomains", KumbaCoreConstants.DOMAIN_HEALTH_CHECK_INTERVAL);
            return;
        }
        if (!this.appliance.isActive()) {
            AbstractTool.logger.fine(() -> LMG.log("(): Appliance is not active.  Skipping checks %s.", () -> logSuffix));
            new AsynchMethodInvoker((Object)this, "listDomains", KumbaCoreConstants.DOMAIN_HEALTH_CHECK_INTERVAL);
            return;
        }
        DataPowerStatusCache statusCache = new DataPowerStatusCache();
        Domain defaultDomain = new Domain("default");
        AbstractTool.logger.finer(() -> LMG.log("(): Getting domain status %s", () -> logSuffix));
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        DataPowerStatusMonitor domainStatusMonitor = new DataPowerStatusMonitor(this.appliance, defaultDomain, "DomainStatus", 0L);
        domainStatusMonitor.getProcessThread().addInvocationListener(stil);
        domainStatusMonitor.addStatusListener(statusCache);
        AbstractTool.logger.finer(() -> LMG.log("(): Waiting for domain status %s", () -> logSuffix));
        boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        if (!completedOnTime) {
            AbstractTool.logger.warning(() -> LMG.log("(): Domain status %s did not complete on time. Will attempt to continue.", () -> logSuffix));
        }
        if (CollectionUtility.isEmpty(domainInfo = statusCache.getStatusCache())) {
            this.appliance.setConnected(false);
            AbstractTool.logger.warning(() -> LMG.log("(): Domain status %s is empty.  Will retry.", () -> logSuffix));
        } else {
            AbstractTool.logger.finer(() -> LMG.log("(): Got domain %s.  Setting connected=true %s.", () -> domainInfo.size(), () -> logSuffix));
            this.appliance.setConnected(true);
            HashMap<String, StatusObjectStatus> domainStatusIndex = null;
            if (CollectionUtility.isNotEmpty(this.appliance.getDomains())) {
                ArrayList<Appliance> appliances = new ArrayList<Appliance>();
                appliances.add(this.appliance);
                ConfigurationManager configurationManager = new ConfigurationManager();
                ArrayList<StatusObjectStatus> domains = configurationManager.listObjects(appliances, "Domain", null);
                BeanIndexer<StatusObjectStatus> indexer = new BeanIndexer<StatusObjectStatus>(domains);
                domainStatusIndex = indexer.getMapOf("name", "--null--");
            }
            AbstractTool.logger.finer(() -> LMG.log("(): Processing %d domain status records %s", () -> domainInfo.size(), () -> logSuffix));
            for (StatusDomainStatus domainStatus : domainInfo) {
                AbstractTool.logger.finer(() -> LMG.log("(): Domain status for %s - %s", () -> logSuffix, () -> domainStatus.getFQON()));
                String domainName = domainStatus.getDomain();
                Domain domain = null;
                try {
                    domain = this.appliance.getDomain(domainName);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (domain == null) {
                    AbstractTool.logger.fine(() -> LMG.log("(): Adding domain %s %s", () -> domainName, () -> logSuffix));
                    domain = new Domain(domainName);
                    this.appliance.addDomain(domain);
                }
                int domainHashCode = domain.hashCode();
                AbstractTool.logger.finer(() -> LMG.log("(): Setting domain status to the %s[%d] domain %s - %s", () -> domainName, () -> domainHashCode, () -> logSuffix, () -> domainStatus.getFQON()));
                domain.setStatusDomainStatus(domainStatus);
                if (domainStatusIndex == null) continue;
                StatusObjectStatus domainObjectStatus = domainStatusIndex.get(domainName);
                domain.setObjectStatus(domainObjectStatus);
            }
            BeanIndexer statusIndexer = new BeanIndexer(domainInfo);
            HashMap domainMap = statusIndexer.getMapOf("domain", null);
            ArrayList<Domain> applianceDomains = this.appliance.getDomains();
            ArrayList<Domain> applianceDomainLooper = new ArrayList<Domain>(applianceDomains);
            for (Domain domain : applianceDomainLooper) {
                StatusDomainStatus statusDomain = (StatusDomainStatus)domainMap.get(domain.getName());
                if (statusDomain != null) continue;
                this.appliance.removeDomain(domain);
                AbstractTool.logger.fine(() -> LMG.log("(): Removing domain %s %s", () -> domain.getName(), () -> logSuffix));
            }
            AbstractTool.logger.finer(() -> LMG.log("(): Complete.  Rescheduling domain status check %s", () -> logSuffix));
        }
        new AsynchMethodInvoker((Object)this, "listDomains", KumbaCoreConstants.DOMAIN_HEALTH_CHECK_INTERVAL);
        AbstractTool.logger.finer(() -> LMG.log("(): Finished %s", () -> logSuffix));
    }
}

