/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.DynamicClassLoader;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.beans.config.ConfigCryptoProfile;
import com.kumbasoft.core.beans.config.ConfigCryptoValCred;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.config.ConfigSSLServerProfile;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.SSLClientFeatures;
import com.kumbasoft.core.beans.types.SSLHostnameValidationFlags;
import com.kumbasoft.core.beans.types.SSLOptionType;
import com.kumbasoft.core.beans.types.SSLOptions;
import com.kumbasoft.core.beans.types.SSLProtoVersionsBitmap;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ConfigTool;
import com.kumbasoft.core.tools.DeleteObjectConfiguration;
import com.kumbasoft.core.tools.ModifyTool;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class MigrateSSLProxyProfile
extends AbstractTool {
    private static ArrayList<String> defaultCiphers;
    private static ArrayList<String> defaultEllipticCurves;
    private static ArrayList<String> defaultSignatureAlgorithms;
    private static SSLHostnameValidationFlags hostNameValidationFlags;
    private static ObjectReference<ConfigSSLProxyProfile> nullObjectReference;
    private DateTime migrationTime = new DateTime();
    private DynamicBean model;
    private ArrayList<DynamicBean> refactorModel;
    private ManagementCommandSubscriber commandSubscriber;
    private ConfigurationManager configurationManager;

    static {
        nullObjectReference = new ObjectReference();
        nullObjectReference.setClassName("SSLProxyProfile");
        defaultCiphers = new ArrayList();
        defaultCiphers.add("AES_256_GCM_SHA384");
        defaultCiphers.add("CHACHA20_POLY1305_SHA256");
        defaultCiphers.add("AES_128_GCM_SHA256");
        defaultCiphers.add("ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        defaultCiphers.add("ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        defaultCiphers.add("ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        defaultCiphers.add("ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        defaultCiphers.add("ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        defaultCiphers.add("ECDHE_RSA_WITH_AES_256_CBC_SHA");
        defaultCiphers.add("DHE_DSS_WITH_AES_256_GCM_SHA384");
        defaultCiphers.add("DHE_RSA_WITH_AES_256_GCM_SHA384");
        defaultCiphers.add("DHE_RSA_WITH_AES_256_CBC_SHA256");
        defaultCiphers.add("DHE_DSS_WITH_AES_256_CBC_SHA256");
        defaultCiphers.add("DHE_RSA_WITH_AES_256_CBC_SHA");
        defaultCiphers.add("DHE_DSS_WITH_AES_256_CBC_SHA");
        defaultCiphers.add("RSA_WITH_AES_256_GCM_SHA384");
        defaultCiphers.add("RSA_WITH_AES_256_CBC_SHA256");
        defaultCiphers.add("RSA_WITH_AES_256_CBC_SHA");
        defaultCiphers.add("ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        defaultCiphers.add("ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        defaultCiphers.add("ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        defaultCiphers.add("ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        defaultCiphers.add("ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        defaultCiphers.add("ECDHE_RSA_WITH_AES_128_CBC_SHA");
        defaultCiphers.add("DHE_DSS_WITH_AES_128_GCM_SHA256");
        defaultCiphers.add("DHE_RSA_WITH_AES_128_GCM_SHA256");
        defaultCiphers.add("DHE_RSA_WITH_AES_128_CBC_SHA256");
        defaultCiphers.add("DHE_DSS_WITH_AES_128_CBC_SHA256");
        defaultCiphers.add("DHE_RSA_WITH_AES_128_CBC_SHA");
        defaultCiphers.add("DHE_DSS_WITH_AES_128_CBC_SHA");
        defaultCiphers.add("RSA_WITH_AES_128_GCM_SHA256");
        defaultCiphers.add("RSA_WITH_AES_128_CBC_SHA256");
        defaultCiphers.add("RSA_WITH_AES_128_CBC_SHA");
        defaultEllipticCurves = new ArrayList();
        defaultEllipticCurves.add("secp521r1");
        defaultEllipticCurves.add("secp384r1");
        defaultEllipticCurves.add("secp256k1");
        defaultEllipticCurves.add("secp256r1");
        defaultSignatureAlgorithms = new ArrayList();
        defaultSignatureAlgorithms.add("ecdsa_secp256r1_sha256");
        defaultSignatureAlgorithms.add("ecdsa_secp384r1_sha384");
        defaultSignatureAlgorithms.add("ecdsa_secp521r1_sha512");
        defaultSignatureAlgorithms.add("ed25519");
        defaultSignatureAlgorithms.add("ed448");
        defaultSignatureAlgorithms.add("rsa_pss_pss_sha256");
        defaultSignatureAlgorithms.add("rsa_pss_pss_sha384");
        defaultSignatureAlgorithms.add("rsa_pss_pss_sha512");
        defaultSignatureAlgorithms.add("rsa_pss_rsae_sha256");
        defaultSignatureAlgorithms.add("rsa_pss_rsae_sha384");
        defaultSignatureAlgorithms.add("rsa_pss_rsae_sha512");
        defaultSignatureAlgorithms.add("rsa_pkcs1_sha256");
        defaultSignatureAlgorithms.add("rsa_pkcs1_sha384");
        defaultSignatureAlgorithms.add("rsa_pkcs1_sha512");
        defaultSignatureAlgorithms.add("ecdsa_sha224");
        defaultSignatureAlgorithms.add("ecdsa_sha1");
        defaultSignatureAlgorithms.add("rsa_pkcs1_sha224");
        defaultSignatureAlgorithms.add("rsa_pkcs1_sha1");
        defaultSignatureAlgorithms.add("dsa_sha224");
        defaultSignatureAlgorithms.add("dsa_sha1");
        defaultSignatureAlgorithms.add("dsa_sha256");
        defaultSignatureAlgorithms.add("dsa_sha384");
        defaultSignatureAlgorithms.add("dsa_sha512");
        hostNameValidationFlags = new SSLHostnameValidationFlags();
        hostNameValidationFlags.setX509_CHECK_FLAG_ALWAYS_CHECK_SUBJECT("off");
        hostNameValidationFlags.setX509_CHECK_FLAG_MULTI_LABEL_WILDCARDS("off");
        hostNameValidationFlags.setX509_CHECK_FLAG_NO_PARTIAL_WILDCARDS("off");
        hostNameValidationFlags.setX509_CHECK_FLAG_NO_WILDCARDS("off");
        hostNameValidationFlags.setX509_CHECK_FLAG_SINGLE_LABEL_SUBDOMAINS("off");
    }

    public MigrateSSLProxyProfile(DynamicBean model, ManagementCommandSubscriber commandSubscriber) {
        this.model = model;
        this.refactorModel = (ArrayList)model.getProperty("newData");
        this.commandSubscriber = commandSubscriber;
        this.configurationManager = new ConfigurationManager();
        Index<Appliance, DynamicBean> actionsByAppliance = new Index<Appliance, DynamicBean>();
        AbstractTool.logger.finer("(DynamicBean model, commandSubscriber):  Assembling actions by appliance");
        for (DynamicBean refactorAction : this.refactorModel) {
            Appliance appliance = (Appliance)refactorAction.getProperty("appliance");
            actionsByAppliance.put(appliance, refactorAction);
        }
        Collection appliances = actionsByAppliance.getKeys();
        for (Appliance appliance : appliances) {
            AbstractTool.logger.finer(() -> LMG.log("(DynamicBean model, commandSubscriber):  Applying actions for appliance '%s'", () -> appliance.getName()));
            Collection<DynamicBean> applianceActions = actionsByAppliance.get(appliance);
            this.migrateApplianceActions(applianceActions);
        }
        AbstractTool.logger.finer("(DynamicBean model, commandSubscriber):  Done");
    }

    private void migrateApplianceActions(Collection<DynamicBean> applianceActions) {
        AbstractTool.logger.finer("(Collection<DynamicBean> applianceActions): Starting.");
        for (DynamicBean action : applianceActions) {
            Appliance appliance = (Appliance)action.getProperty("appliance");
            int actionType = (Integer)action.getProperty("action");
            switch (actionType) {
                case 0: {
                    this.createProfile(appliance, action);
                    break;
                }
                case 1: {
                    this.updateReference(appliance, action);
                    break;
                }
                case 2: {
                    this.deleteObject(appliance, action);
                }
            }
        }
        AbstractTool.logger.finer("(Collection<DynamicBean> applianceActions): Done.");
    }

    private void createProfile(Appliance appliance, DynamicBean action) {
        String newObjectType = (String)action.getProperty("objectType");
        String newObjectName = (String)action.getProperty("objectName");
        Domain domain = (Domain)action.getProperty("domain");
        logger.finer(() -> LMG.log("(appliance=%s, action):  Creating new %s named %s within the %s domain", () -> appliance.getName(), () -> newObjectType, () -> newObjectName, () -> domain.getName()));
        ConfigSSLProxyProfile sslProxyProfile = (ConfigSSLProxyProfile)action.getProperty("proxyProfile");
        ConfigCrypto newObject = null;
        String cryptoProfileName = switch (newObjectType) {
            case "SSLClientProfile" -> {
                newObject = new ConfigSSLClientProfile();
                ObjectReference<ConfigCryptoProfile> cryptoProfileReference = sslProxyProfile.getForwardCryptoProfile();
                yield cryptoProfileReference.getName();
            }
            case "SSLServerProfile" -> {
                newObject = new ConfigSSLServerProfile();
                ObjectReference<ConfigCryptoProfile> cryptoProfileReference = sslProxyProfile.getReverseCryptoProfile();
                yield cryptoProfileReference.getName();
            }
            default -> {
                logger.severe(() -> LMG.log("(appliance=%s, action):  Did not receive correct profile type.  Got '%s'.  This will fail.", () -> appliance.getName(), () -> newObjectType));
                yield "";
            }
        };
        HashMap cryptoProfileMap = (HashMap)this.model.getProperty("cryptoProfileConfigs");
        Index cryptoProfilesByAppliance = (Index)cryptoProfileMap.get(appliance);
        Collection cryptoProfilesByDomain = cryptoProfilesByAppliance.get(domain);
        PropertyValueSelector nameSelector = new PropertyValueSelector(cryptoProfilesByDomain);
        nameSelector.addPropertyValueMap("name", cryptoProfileName);
        ArrayList matchingCryptoProfiles = (ArrayList)nameSelector.getSelectedElements();
        if (matchingCryptoProfiles.size() == 0) {
            logger.severe(() -> LMG.log("(appliance=%s, action):  No crypto profiles named '%s' in domain '%s'.  This will fail.", () -> appliance.getName(), () -> cryptoProfileName, () -> domain.getName()));
        }
        ConfigCryptoProfile cryptoProfile = (ConfigCryptoProfile)matchingCryptoProfiles.get(0);
        logger.finer(() -> LMG.log("(appliance=%s, action):  Building new object instance.", () -> appliance.getName()));
        newObject.setAppliance(appliance);
        newObject.setSourceDomain(domain);
        newObject.setConfigObjectType(newObjectType);
        newObject.setName(newObjectName);
        newObject.setAdminState("enabled");
        SSLOptionType sslOptionsType = cryptoProfile.getSSLOptions();
        SSLProtoVersionsBitmap sslProtoVersionsBitmap = new SSLProtoVersionsBitmap();
        sslProtoVersionsBitmap.setSSLv3(sslOptionsType.getDisableSSLv3().equals("on") ? "off" : "on");
        sslProtoVersionsBitmap.setTLSv1d0(sslOptionsType.getDisableTLSv1().equals("on") ? "off" : "on");
        sslProtoVersionsBitmap.setTLSv1d1(sslOptionsType.getDisableTLSv1d1().equals("on") ? "off" : "on");
        sslProtoVersionsBitmap.setTLSv1d2(sslOptionsType.getDisableTLSv1d2().equals("on") ? "off" : "on");
        if (newObject instanceof ConfigSSLClientProfile) {
            ConfigSSLClientProfile clientProfile = (ConfigSSLClientProfile)newObject;
            SSLClientFeatures sslClientFeatures = new SSLClientFeatures();
            sslClientFeatures.setCompression(sslOptionsType.getEnableCompression());
            sslClientFeatures.setPermitInsecureServers(sslOptionsType.getEnableLegacyRenegotiation());
            sslClientFeatures.setUseSni("on");
            clientProfile.setCiphers(defaultCiphers);
            clientProfile.setEllipticCurves(defaultEllipticCurves);
            clientProfile.setSigAlgs(defaultSignatureAlgorithms);
            clientProfile.setCacheSize(sslProxyProfile.getClientCacheSize());
            clientProfile.setCacheTimeout(sslProxyProfile.getClientSessionTimeout());
            clientProfile.setCaching(sslProxyProfile.getClientCache());
            clientProfile.setCustomSNIHostname("");
            clientProfile.setEnableTLS13Compat("on");
            clientProfile.setHostnameValidationFailOnError("off");
            clientProfile.setHostnameValidationFlags(hostNameValidationFlags);
            clientProfile.setIdcred(cryptoProfile.getIdentCredential());
            clientProfile.setProtocols(sslProtoVersionsBitmap);
            clientProfile.setSSLClientFeatures(sslClientFeatures);
            clientProfile.setUserSummary(String.format("Migrated from TLS Proxy Profile '%s' on '%s'", sslProxyProfile.getName(), this.migrationTime));
            clientProfile.setUseCustomSNIHostname(DPEnumerations.USE_CUSTOM_SNIHOSTNAME[0]);
            ObjectReference<ConfigCryptoValCred> valCred = cryptoProfile.getValCredential();
            if (valCred != null) {
                clientProfile.setValcred(cryptoProfile.getValCredential());
                clientProfile.setValidateServerCert("on");
            } else {
                clientProfile.setValidateServerCert("off");
            }
            clientProfile.setValidateHostname("off");
        } else {
            SSLOptions sslOptions = new SSLOptions();
            sslOptions.setMaxDuration("off");
            sslOptions.setMaxRenegotiation("off");
            ConfigSSLServerProfile serverProfile = (ConfigSSLServerProfile)newObject;
            serverProfile.setCiphers(defaultCiphers);
            serverProfile.setEllipticCurves(defaultEllipticCurves);
            serverProfile.setSigAlgs(defaultSignatureAlgorithms);
            serverProfile.setAllowLegacyRenegotiation(sslOptionsType.getEnableLegacyRenegotiation());
            serverProfile.setCacheSize(sslProxyProfile.getCacheSize());
            serverProfile.setCacheTimeout(sslProxyProfile.getSessionTimeout());
            serverProfile.setCaching(sslProxyProfile.getServerCaching());
            serverProfile.setCompression(sslOptionsType.getEnableCompression());
            serverProfile.setIdcred(cryptoProfile.getIdentCredential());
            serverProfile.setMaxSSLDuration(60L);
            serverProfile.setNumberOfRenegotiationAllowed(0L);
            serverProfile.setPreferServerCiphers("on");
            serverProfile.setPrioritizeChaCha("off");
            serverProfile.setProhibitResumeOnReneg("off");
            serverProfile.setProtocols(sslProtoVersionsBitmap);
            serverProfile.setRequestClientAuth(sslProxyProfile.getClientAuthAlwaysRequest());
            serverProfile.setRequireClientAuth(sslProxyProfile.getClientAuthOptional().equals("on") ? "off" : "on");
            serverProfile.setSendClientAuthCAList(cryptoProfile.getClientCAList());
            serverProfile.setSSLOptions(sslOptions);
            serverProfile.setUserSummary(String.format("Migrated from TLS Proxy Profile '%s' on '%s'", sslProxyProfile.getName(), this.migrationTime));
        }
        logger.finer(() -> LMG.log("(appliance=%s, action):  Creating new DataPower object.", () -> appliance.getName()));
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        ConfigTool configTool = new ConfigTool(appliance, domain, newObject);
        configTool.addManagementCommandSubscriber(this.commandSubscriber);
        configTool.getProcessThread().addInvocationListener(stil);
        boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        if (!completedOnTime) {
            logger.info(() -> LMG.log("(appliance=%s, action):  Timed out creating new %s named %s within the %s domain.  Continuing, but unexpected results may occur.", () -> appliance.getName(), () -> newObjectType, () -> newObjectName, () -> domain.getName()));
        } else {
            logger.finer(() -> LMG.log("(appliance=%s, action):  Done Creating new %s named %s within the %s domain", () -> appliance.getName(), () -> newObjectType, () -> newObjectName, () -> domain.getName()));
        }
    }

    private void updateReference(Appliance appliance, DynamicBean action) {
        Domain domain = (Domain)action.getProperty("domain");
        String objectToBeRefactoredType = (String)action.getProperty("objectType");
        String objectToBeRefactoredClassName = String.format("com.kumbasoft.core.beans.config.Config%s", objectToBeRefactoredType);
        String objectToBeRefactoredModifyClassName = String.format("com.kumbasoft.core.beans.modify.Modify%s", objectToBeRefactoredType);
        String objectToBeRefactoredName = (String)action.getProperty("objectName");
        ConfigSSLProxyProfile sslProxyProfile = (ConfigSSLProxyProfile)action.getProperty("proxyProfile");
        String sslProxyProfileName = sslProxyProfile.getName();
        logger.finer(() -> LMG.log("(appliance=%s, action) Refactoring Proxy Profile '%s' within '%s' '%s'.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
        ArrayList objectReplaceList = (ArrayList)this.model.getProperty("refactorData");
        DynamicBean objectReplaceData = null;
        for (DynamicBean objectReplaceInfo : objectReplaceList) {
            Appliance objectReplaceAppliance = (Appliance)objectReplaceInfo.getProperty("appliance");
            Domain objectReplaceDomain = (Domain)objectReplaceInfo.getProperty("domain");
            String objectReplaceName = (String)objectReplaceInfo.getProperty("objectName");
            if (!objectReplaceAppliance.equals(appliance) || !objectReplaceDomain.equals(domain) || !sslProxyProfileName.equals(objectReplaceName)) continue;
            objectReplaceData = objectReplaceInfo;
            break;
        }
        if (objectReplaceData == null) {
            logger.severe(() -> LMG.log("(appliance=%s, action) Could not locate refactoring info while refactoring Proxy Profile '%s' within '%s' '%s'.  Cannot Continue.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
            return;
        }
        logger.finer(() -> LMG.log("(appliance=%s, action) Building modify info for refactoring Proxy Profile '%s' within '%s' '%s'.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
        try {
            Class<?> objectClass = DynamicClassLoader.loadClass(objectToBeRefactoredClassName);
            DataPowerConfig modifyObject = (DataPowerConfig)BeanService.getBean(objectToBeRefactoredModifyClassName);
            modifyObject.setAppliance(appliance);
            modifyObject.setSourceDomain(domain);
            modifyObject.setConfigObjectType(objectToBeRefactoredType);
            modifyObject.setName(objectToBeRefactoredName);
            String sslProxyProfilePropertyName = null;
            String newConfigReferencePropertyName = null;
            String proxyTypePropertyName = null;
            String newConfigType = null;
            ObjectReference newObjectReference = new ObjectReference();
            boolean nestedPropertyChanged = false;
            ArrayList<String> propertyNames = BeanService.getPropertyNames(objectClass);
            for (String propertyName : propertyNames) {
                boolean completedOnTime;
                Object modifyTool;
                SingleThreadInvocationListener stil;
                int i;
                String[] undefinedProperties;
                ArrayList<String> modifyObjectPropertyNames;
                DataPowerConfig objectToBeRefactored;
                Class<ArrayList> propertyType = BeanService.getPropertyType(objectClass, propertyName);
                String propertyTypeClassName = propertyType.getName();
                if (propertyTypeClassName.startsWith("com.kumbasoft.core.beans.types.")) {
                    boolean changed;
                    objectToBeRefactored = this.configurationManager.getObject(appliance, domain, objectToBeRefactoredType, objectToBeRefactoredName);
                    Object value = BeanService.getPropertyValue(objectToBeRefactored, propertyName);
                    if (value == null || !(changed = this.updateNestedTypeReference(propertyType, value, sslProxyProfileName, (String)objectReplaceData.getProperty("clientProfile"), (String)objectReplaceData.getProperty("serverProfile")))) continue;
                    nestedPropertyChanged = true;
                    BeanService.setPropertyValue(modifyObject, propertyName, value);
                    modifyObjectPropertyNames = BeanService.getPropertyNames(modifyObject);
                    undefinedProperties = new String[propertyNames.size() - 1];
                    i = 0;
                    for (String modifyObjectPropertyName : modifyObjectPropertyNames) {
                        if (modifyObjectPropertyName.equals(propertyName)) continue;
                        undefinedProperties[i++] = modifyObjectPropertyName;
                    }
                    stil = new SingleThreadInvocationListener();
                    modifyTool = new ModifyTool(appliance, domain, modifyObject);
                    ((ModifyTool)modifyTool).addIgnoreProperties(undefinedProperties);
                    ((AbstractTool)modifyTool).addManagementCommandSubscriber(this.commandSubscriber);
                    ((ModifyTool)modifyTool).getProcessThread().addInvocationListener(stil);
                    completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                    if (!completedOnTime) {
                        logger.info(() -> LMG.log("(appliance=%s, action) Timeout waiting for modify tool while refactoring nested property '%s' referencing Proxy Profile '%s' within '%s' '%s'.  Continuing, but refactoring may not be complete.", () -> appliance.getName(), () -> propertyName, () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
                        continue;
                    }
                    logger.info(() -> LMG.log("(appliance=%s, action) Refactoring nested property referencing Proxy Profile '%s' within '%s' '%s'.  Continuing, but refactoring may not be complete.", () -> appliance.getName(), () -> propertyName, () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
                    continue;
                }
                if (propertyType.isAssignableFrom(ArrayList.class)) {
                    objectToBeRefactored = this.configurationManager.getObject(appliance, domain, objectToBeRefactoredType, objectToBeRefactoredName);
                    ArrayList valueList = (ArrayList)BeanService.getPropertyValue(objectToBeRefactored, propertyName);
                    if (valueList == null) continue;
                    boolean changed = false;
                    for (Object value : valueList) {
                        boolean valueChanged = this.updateNestedTypeReference(value.getClass(), value, sslProxyProfileName, (String)objectReplaceData.getProperty("clientProfile"), (String)objectReplaceData.getProperty("serverProfile"));
                        if (!valueChanged) continue;
                        changed = true;
                    }
                    if (!changed) continue;
                    nestedPropertyChanged = true;
                    BeanService.setPropertyValue(modifyObject, propertyName, valueList);
                    modifyObjectPropertyNames = BeanService.getPropertyNames(modifyObject);
                    undefinedProperties = new String[propertyNames.size() - 1];
                    i = 0;
                    for (String modifyObjectPropertyName : modifyObjectPropertyNames) {
                        if (modifyObjectPropertyName.equals(propertyName)) continue;
                        undefinedProperties[i++] = modifyObjectPropertyName;
                    }
                    stil = new SingleThreadInvocationListener();
                    modifyTool = new ModifyTool(appliance, domain, modifyObject);
                    ((ModifyTool)modifyTool).addIgnoreProperties(undefinedProperties);
                    ((AbstractTool)modifyTool).addManagementCommandSubscriber(this.commandSubscriber);
                    ((ModifyTool)modifyTool).getProcessThread().addInvocationListener(stil);
                    completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                    if (!completedOnTime) {
                        logger.info(() -> LMG.log("(appliance=%s, action) Timeout waiting for modify tool while refactoring nested property '%s' referencing Proxy Profile '%s' within '%s' '%s'.  Continuing, but refactoring may not be complete.", () -> appliance.getName(), () -> propertyName, () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
                        continue;
                    }
                    logger.info(() -> LMG.log("(appliance=%s, action) Refactoring nested property referencing Proxy Profile '%s' within '%s' '%s'.  Continuing, but refactoring may not be complete.", () -> appliance.getName(), () -> propertyName, () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
                    continue;
                }
                Method accessor = BeanService.getPropertyAccessor(objectClass, propertyName);
                XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(accessor, XMLInfo.class);
                if (xmlInfo == null) continue;
                String cliAlias = xmlInfo.cliAlias();
                switch (cliAlias) {
                    case "ssl-client-type": {
                        newConfigType = "client";
                        break;
                    }
                    case "ssl-config-type": {
                        newConfigType = "server";
                    }
                }
                String refType = xmlInfo.refType();
                if (cliAlias.equals("ssl-client-type") || cliAlias.equals("ssl-config-type")) {
                    proxyTypePropertyName = propertyName;
                }
                switch (refType) {
                    case "SSLClientProfile": {
                        newConfigReferencePropertyName = propertyName;
                        newObjectReference.setClassName(refType);
                        newObjectReference.setName((String)objectReplaceData.getProperty("clientProfile"));
                        break;
                    }
                    case "SSLServerProfile": {
                        newConfigReferencePropertyName = propertyName;
                        newObjectReference.setClassName(refType);
                        newObjectReference.setName((String)objectReplaceData.getProperty("serverProfile"));
                        break;
                    }
                    case "SSLProxyProfile": {
                        sslProxyProfilePropertyName = propertyName;
                    }
                }
            }
            if (sslProxyProfilePropertyName == null) {
                if (nestedPropertyChanged) {
                    logger.info(() -> LMG.log("(appliance=%s, action) Unable to resolve property name referencing ssl proxy profile while refactoring Proxy Profile '%s' within '%s' '%s'.  This is probably OK since it was changed within a nested value.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
                } else {
                    logger.severe(() -> LMG.log("(appliance=%s, action) Unable to resolve property name referencing ssl proxy profile while refactoring Proxy Profile '%s' within '%s' '%s'.  Cannot Continue.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
                }
                return;
            }
            if (proxyTypePropertyName == null) {
                if (nestedPropertyChanged) {
                    logger.info(() -> LMG.log("(appliance=%s, action) Unable to resolve property name indicating new proxy type while refactoring Proxy Profile '%s' within '%s' '%s'.  This is probably OK since it was changed within a nested value.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
                } else {
                    logger.severe(() -> LMG.log("(appliance=%s, action) Unable to resolve property name indicating new proxy type while refactoring Proxy Profile '%s' within '%s' '%s'.  Cannot Continue.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
                }
                return;
            }
            if (newConfigReferencePropertyName == null) {
                if (nestedPropertyChanged) {
                    logger.info(() -> LMG.log("(appliance=%s, action) Unable to resolve property name referencing new config object while refactoring Proxy Profile '%s' within '%s' '%s'.  This is probably OK since it was changed within a nested value.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
                } else {
                    logger.severe(() -> LMG.log("(appliance=%s, action) Unable to resolve property name referencing new config object while refactoring Proxy Profile '%s' within '%s' '%s'.  Cannot Continue.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
                }
                return;
            }
            logger.finer(() -> LMG.log("(appliance=%s, action) Invoking modify tool for refactoring Proxy Profile '%s' within '%s' '%s'.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
            String[] undefinedProperties = new String[propertyNames.size() - 3];
            int i = 0;
            for (String propertyName : propertyNames) {
                if (propertyName.equals(sslProxyProfilePropertyName) || propertyName.equals(newConfigReferencePropertyName) || propertyName.equals(proxyTypePropertyName)) continue;
                undefinedProperties[i++] = propertyName;
            }
            BeanService.setPropertyValue(modifyObject, sslProxyProfilePropertyName, nullObjectReference);
            BeanService.setPropertyValue(modifyObject, newConfigReferencePropertyName, newObjectReference);
            BeanService.setPropertyValue(modifyObject, proxyTypePropertyName, newConfigType);
            SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
            ModifyTool modifyTool = new ModifyTool(appliance, domain, modifyObject);
            modifyTool.addIgnoreProperties(undefinedProperties);
            modifyTool.addManagementCommandSubscriber(this.commandSubscriber);
            modifyTool.getProcessThread().addInvocationListener(stil);
            boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
            if (!completedOnTime) {
                logger.info(() -> LMG.log("(appliance=%s, action) Timeout waiting for modify tool while refactoring Proxy Profile '%s' within '%s' '%s'.  Continuing, but refactoring may not be complete.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            logger.severe(() -> LMG.log("(appliance=%s, action) Unable to load config object class or build modify object while refactoring Proxy Profile '%s' within '%s' '%s'.  Cannot Continue.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
            e.printStackTrace();
            return;
        }
        logger.finer(() -> LMG.log("(appliance=%s, action) Done Refactoring Proxy Profile '%s' within '%s' '%s'.", () -> appliance.getName(), () -> sslProxyProfileName, () -> objectToBeRefactoredType, () -> objectToBeRefactoredName));
    }

    private boolean updateNestedTypeReference(Class<?> nestedPropertyType, Object nestedPropertyValue, String proxyProfileToReplace, String clientProfileObjectName, String serverProfileObjectName) {
        logger.finer(() -> LMG.log("(nestedPropertyType=%s, nestedPropertyValue, proxyProfileToReplace=%s, clientProfileObjectName=%s, serverProfileObjectName=%s): Starting", () -> nestedPropertyType.getName(), () -> proxyProfileToReplace, () -> clientProfileObjectName == null ? "" : clientProfileObjectName, () -> serverProfileObjectName == null ? "" : serverProfileObjectName));
        ArrayList<String> propertyNames = BeanService.getPropertyNames(nestedPropertyValue);
        String sslProxyProfilePropertyName = null;
        String newConfigReferencePropertyName = null;
        String proxyTypePropertyName = null;
        String newConfigType = null;
        ObjectReference newObjectReference = new ObjectReference();
        for (String propertyName : propertyNames) {
            String refType;
            XMLInfo xmlInfo;
            block40: {
                String dataPowerType;
                block38: {
                    Method accessor = BeanService.getPropertyAccessor(nestedPropertyType, propertyName);
                    xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(accessor, XMLInfo.class);
                    if (xmlInfo == null) continue;
                    String cliAlias = xmlInfo.cliAlias();
                    dataPowerType = xmlInfo.dataPowerType();
                    if (!StringUtility.isNotEmpty(cliAlias)) break block38;
                    switch (cliAlias) {
                        case "ssl-client-type": {
                            newConfigType = "client";
                            proxyTypePropertyName = propertyName;
                            break;
                        }
                        case "ssl-config-type": {
                            newConfigType = "server";
                            proxyTypePropertyName = propertyName;
                        }
                    }
                    break block40;
                }
                if (!StringUtility.isNotEmpty(dataPowerType)) break block40;
                switch (dataPowerType) {
                    case "dmSSLClientConfigType": {
                        newConfigType = "client";
                        proxyTypePropertyName = propertyName;
                        break;
                    }
                    case "dmSSLConfigType": {
                        newConfigType = "server";
                        proxyTypePropertyName = propertyName;
                    }
                }
            }
            switch (refType = xmlInfo.refType()) {
                case "SSLClientProfile": {
                    newConfigReferencePropertyName = propertyName;
                    newObjectReference.setClassName(refType);
                    newObjectReference.setName(clientProfileObjectName);
                    newConfigType = "client";
                    break;
                }
                case "SSLServerProfile": {
                    newConfigReferencePropertyName = propertyName;
                    newObjectReference.setClassName(refType);
                    newObjectReference.setName(serverProfileObjectName);
                    newConfigType = "server";
                    break;
                }
                case "SSLProxyProfile": {
                    sslProxyProfilePropertyName = propertyName;
                }
            }
        }
        if (sslProxyProfilePropertyName == null || proxyTypePropertyName == null || newConfigReferencePropertyName == null) {
            logger.info(() -> LMG.log("(nestedPropertyType=%s, nestedPropertyValue, proxyProfileToReplace=%s, clientProfileObjectName=%s, serverProfileObjectName=%s): Doesn't contain a reference.  Done.", () -> nestedPropertyType.getName(), () -> proxyProfileToReplace, () -> clientProfileObjectName == null ? "" : clientProfileObjectName, () -> serverProfileObjectName == null ? "" : serverProfileObjectName));
            return false;
        }
        ObjectReference proxyProfileReference = (ObjectReference)BeanService.getPropertyValue(nestedPropertyValue, sslProxyProfilePropertyName);
        if (proxyProfileReference == null) {
            logger.info(() -> LMG.log("(nestedPropertyType=%s, nestedPropertyValue, proxyProfileToReplace=%s, clientProfileObjectName=%s, serverProfileObjectName=%s): Proxy profile reference is null.  Stale config?", () -> nestedPropertyType.getName(), () -> proxyProfileToReplace, () -> clientProfileObjectName == null ? "" : clientProfileObjectName, () -> serverProfileObjectName == null ? "" : serverProfileObjectName));
            return false;
        }
        String referencedProxyProfileName = proxyProfileReference.getName();
        if (referencedProxyProfileName == null) {
            logger.info(() -> LMG.log("(nestedPropertyType=%s, nestedPropertyValue, proxyProfileToReplace=%s, clientProfileObjectName=%s, serverProfileObjectName=%s): Proxy profile reference doesn't have an object name.  Stale config?", () -> nestedPropertyType.getName(), () -> proxyProfileToReplace, () -> clientProfileObjectName == null ? "" : clientProfileObjectName, () -> serverProfileObjectName == null ? "" : serverProfileObjectName));
            return false;
        }
        if (referencedProxyProfileName.equals(proxyProfileToReplace)) {
            logger.finer(() -> LMG.log("(nestedPropertyType=%s, nestedPropertyValue, proxyProfileToReplace=%s, clientProfileObjectName=%s, serverProfileObjectName=%s):  References proxy profile.  Updating nested values.  Done.", () -> nestedPropertyType.getName(), () -> proxyProfileToReplace, () -> clientProfileObjectName == null ? "" : clientProfileObjectName, () -> serverProfileObjectName == null ? "" : serverProfileObjectName));
            BeanService.setPropertyValue(nestedPropertyValue, proxyTypePropertyName, newConfigType);
            BeanService.setPropertyValue(nestedPropertyValue, sslProxyProfilePropertyName, nullObjectReference);
            BeanService.setPropertyValue(nestedPropertyValue, newConfigReferencePropertyName, newObjectReference);
            return true;
        }
        logger.info(() -> LMG.log("(nestedPropertyType=%s, nestedPropertyValue, proxyProfileToReplace=%s, clientProfileObjectName=%s, serverProfileObjectName=%s): Doesn't not reference Proxy Profile.  Done.", () -> nestedPropertyType.getName(), () -> proxyProfileToReplace, () -> clientProfileObjectName == null ? "" : clientProfileObjectName, () -> serverProfileObjectName == null ? "" : serverProfileObjectName));
        return false;
    }

    private void deleteObject(Appliance appliance, DynamicBean action) {
        Domain domain = (Domain)action.getProperty("domain");
        String deleteObjectType = (String)action.getProperty("objectType");
        String deleteObjectName = (String)action.getProperty("objectName");
        logger.finer(() -> LMG.log("(appliance=%s, action): Deleting %s %s within the %s domain.", () -> appliance.getName(), () -> deleteObjectType, () -> deleteObjectName, () -> domain.getName()));
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        DeleteObjectConfiguration deleteTool = new DeleteObjectConfiguration(appliance, domain, deleteObjectType, deleteObjectName);
        deleteTool.addManagementCommandSubscriber(this.commandSubscriber);
        deleteTool.getProcessThread().addInvocationListener(stil);
        boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_WAIT);
        if (!completedOnTime) {
            logger.info(() -> LMG.log("(appliance=%s, action): Timed out while deleting %s %s within the %s domain.  Continuing, but no guarantee object is deleted.", () -> appliance.getName(), () -> deleteObjectType, () -> deleteObjectName, () -> domain.getName()));
        } else {
            logger.finer(() -> LMG.log("(appliance=%s, action): Deleted %s %s within the %s domain.", () -> appliance.getName(), () -> deleteObjectType, () -> deleteObjectName, () -> domain.getName()));
        }
    }
}

