/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionSetLogLevel;
import com.kumbasoft.core.beans.config.ConfigLogLabel;
import com.kumbasoft.core.beans.config.ConfigLogTarget;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.LogEvent;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.ModifyTool;
import java.util.ArrayList;

public class SetLogTargetLogLevel {
    private ArrayList<ManagementCommandSubscriber> subscribers;
    private Appliance appliance;
    private Domain domain;
    private ConfigLogTarget logTarget;
    private String logLevel;
    private boolean rbmLogging;
    private boolean internalLogging;

    public SetLogTargetLogLevel(Appliance appliance, Domain domain, ConfigLogTarget logTarget, String logLevel) {
        this.setAppliance(appliance);
        this.setDomain(domain);
        this.setLogTarget(logTarget);
        this.logLevel = logLevel;
        new AsynchMethodInvoker((Object)this, "setLogLevel", KumbaCoreConstants.THREAD_WAIT);
    }

    public SetLogTargetLogLevel(StatusObjectStatus logTargetInfo, String logLevel) {
        this(logTargetInfo.getAppliance(), logTargetInfo.getSourceDomain(), logTargetInfo.getName(), logLevel);
    }

    public SetLogTargetLogLevel(Appliance appliance, Domain domain, String logTargetName, String logLevel) {
        this.setAppliance(appliance);
        this.setDomain(domain);
        Index<Appliance, Domain> domains = new Index<Appliance, Domain>();
        domains.put(appliance, domain);
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<ConfigLogTarget> logTargets = configurationManager.getObjects(domains, ConfigLogTarget.class, logTargetName);
        if (CollectionUtility.isEmpty(logTargets)) {
            return;
        }
        this.setLogTarget(logTargets.get(0));
        this.logLevel = logLevel;
        new AsynchMethodInvoker((Object)this, "setLogLevel", KumbaCoreConstants.THREAD_WAIT);
    }

    public Appliance getAppliance() {
        return this.appliance;
    }

    public void setAppliance(Appliance appliance) {
        this.appliance = appliance;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public boolean isRbmLogging() {
        return this.rbmLogging;
    }

    public void setRbmLogging(boolean rbmLogging) {
        this.rbmLogging = rbmLogging;
    }

    public boolean isInternalLogging() {
        return this.internalLogging;
    }

    public void setInternalLogging(boolean internalLogging) {
        this.internalLogging = internalLogging;
    }

    public void addCommandSubscriber(ManagementCommandSubscriber subscriber) {
        if (subscriber == null) {
            return;
        }
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        this.subscribers.add(subscriber);
    }

    public void removeCommandSubscriber(ManagementCommandSubscriber subscriber) {
        if (subscriber == null || CollectionUtility.isEmpty(this.subscribers)) {
            return;
        }
        this.subscribers.remove(subscriber);
    }

    public ConfigLogTarget getLogTarget() {
        return this.logTarget;
    }

    public void setLogTarget(ConfigLogTarget logTarget) {
        this.logTarget = logTarget;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    @Reflected
    private void setLogLevel() {
        String commandDescription = String.format("Set logging level of %s to %s", this.logTarget.getName(), this.logLevel);
        if (this.logTarget.getName().equals("default-log")) {
            ActionSetLogLevel actionSetLogLevel = new ActionSetLogLevel();
            actionSetLogLevel.setLogLevel(this.logLevel);
            String rbmLog = this.rbmLogging ? "on" : "off";
            String internalLog = this.internalLogging ? "on" : "off";
            actionSetLogLevel.setRBMLog(rbmLog);
            actionSetLogLevel.setInternalLog(internalLog);
            ActionTool actionTool = new ActionTool(this.appliance, this.domain, actionSetLogLevel);
            actionTool.setCommandDescription(commandDescription);
            if (CollectionUtility.isNotEmpty(this.subscribers)) {
                for (ManagementCommandSubscriber subscriber : this.subscribers) {
                    actionTool.addManagementCommandSubscriber(subscriber);
                }
            }
            return;
        }
        boolean allExists = false;
        ArrayList<LogEvent> logEvents = this.logTarget.getLogEvents();
        for (LogEvent logEvent : logEvents) {
            if (!logEvent.getDataPowerClass().getName().equals("all")) continue;
            allExists = true;
            logEvent.setPriority(this.logLevel);
            break;
        }
        if (!allExists) {
            LogEvent allEvent = new LogEvent();
            ObjectReference<ConfigLogLabel> allLabel = new ObjectReference<ConfigLogLabel>();
            allLabel.setClassName("LogLabel");
            allLabel.setName("all");
            allEvent.setDataPowerClass(allLabel);
            allEvent.setPriority(this.logLevel);
            this.logTarget.addLogEvents(allEvent);
        }
        ModifyTool modifyTool = new ModifyTool(this.appliance, this.domain, this.logTarget);
        modifyTool.setCommandDescription(commandDescription);
        if (CollectionUtility.isNotEmpty(this.subscribers)) {
            for (ManagementCommandSubscriber subscriber : this.subscribers) {
                modifyTool.addManagementCommandSubscriber(subscriber);
            }
        }
    }
}

