/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.tools;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.io.ASCFileReader;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ExportOptions;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.SnapShotListener;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.CertificateExportSubscriber;
import com.kumbasoft.core.tools.DataPowerFileReader;
import com.kumbasoft.core.tools.ExportConfiguration;
import com.kumbasoft.core.tools.ListFiles;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.tools.ViewCertificateDetails;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class SnapShot
extends AbstractTool
implements ManagementCommandSubscriber,
CertificateExportSubscriber,
ConfigObjectSubscriber<DataPowerFileInfo> {
    public static final String FILE_SYSTEM_DIRECTORY_NAME = "datapower-file-system";
    private static final String CERT_DIRECTORY;
    private File outputDirectory;
    private Index<Appliance, Domain> selectedDomains;
    private boolean includeLogs;
    private boolean includeCertificates;
    private AsynchMethodInvoker<Void> processThread;
    private ArrayList<SnapShotListener> listeners;

    static {
        Application application = Application.getApplication();
        KumbaCoreApplicationProperties appProps = (KumbaCoreApplicationProperties)application.getApplicationProperties();
        CERT_DIRECTORY = appProps.getCertificateFileDirectory();
    }

    public SnapShot(Index<Appliance, Domain> selectedDomains, File outputDirectory) {
        this.setSelectedDomains(selectedDomains);
        this.setOutputDirectory(outputDirectory);
        this.processThread = new AsynchMethodInvoker((Object)this, "snapShot", KumbaCoreConstants.STARTUP_DELAY);
    }

    public AsynchMethodInvoker<Void> getProcessThread() {
        return this.processThread;
    }

    public boolean includeLogs() {
        return this.includeLogs;
    }

    public void setIncludeLogs(boolean includeLogs) {
        this.includeLogs = includeLogs;
    }

    public boolean isIncludeCertificates() {
        return this.includeCertificates;
    }

    public void setIncludeCertificates(boolean includeCertificates) {
        this.includeCertificates = includeCertificates;
    }

    @Reflected
    private void snapShot() {
        logger.finer("(): Starting");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        if (this.includeLogs) {
            AsynchMethodInvoker logsThread = new AsynchMethodInvoker((Object)this, "getLogs");
            mtil.addThread(logsThread);
        }
        ExportOptions exportOptions = new ExportOptions();
        exportOptions.setAllFiles(true);
        exportOptions.setPersisted(false);
        exportOptions.setExportDebug(false);
        exportOptions.setExportFiles(true);
        exportOptions.setExportFormat(DPEnumerations.EXPORT_FORMAT[0]);
        exportOptions.setOutputDirectory(this.outputDirectory);
        Collection<Appliance> appliances = this.selectedDomains.getKeys();
        for (Appliance appliance : appliances) {
            AsynchMethodInvoker ami = new AsynchMethodInvoker((Object)this, "snapShotAppliance", new Object[]{appliance, exportOptions});
            mtil.addThread(ami);
        }
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("SnapShot.snapShot()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        if (completedOnTime) {
            logger.info("():  Snapshot is complete.  Notifying listeners.");
        } else {
            logger.warning("():  Snapshot did not complete on time!  Notifying listeners anyway.");
        }
        for (SnapShotListener snapShotListener : this.listeners) {
            snapShotListener.snapshotComplete();
        }
        logger.finer("(): Done");
    }

    @Reflected
    private void snapShotAppliance(Appliance appliance, ExportOptions exportOptions) {
        logger.finer(() -> LMG.log("(appliance=%s, ExportOptions):  Starting", () -> appliance.getName()));
        SingleThreadInvocationListener domainExportThreadListener = new SingleThreadInvocationListener();
        Collection<Domain> domains = this.selectedDomains.get(appliance);
        for (Domain domain : domains) {
            logger.finer(() -> LMG.log("():  Starting Snapshot of %s -> %s", () -> appliance.getName(), () -> domain.getName()));
            SingleThreadInvocationListener certThreadListener = null;
            if (this.includeCertificates) {
                certThreadListener = new SingleThreadInvocationListener();
                AsynchMethodInvoker ami = new AsynchMethodInvoker((Object)this, "getCertificatesFor", new Object[]{appliance, domain});
                ami.addInvocationListener(certThreadListener);
            }
            StatusObjectStatus object = new StatusObjectStatus();
            object.setAppliance(appliance);
            object.setSourceDomain(domain);
            object.setDataPowerClass("all-classes");
            object.setName("all-objects");
            logger.finer(() -> LMG.log("(appliance=%s, ExportOptions):  Exporting configurations of all objects for domain '%s'", () -> appliance.getName(), () -> domain.getName()));
            domainExportThreadListener.clearCompletionStatus();
            ExportConfiguration exportConfiguration = new ExportConfiguration(object, exportOptions);
            exportConfiguration.getProcessThread().addInvocationListener(domainExportThreadListener);
            exportConfiguration.addManagementCommandSubscriber(this);
            boolean completedOnTime = domainExportThreadListener.waitForCompletion(KumbaCoreConstants.EXPORT_CACHE_TIMEOUT);
            if (completedOnTime) {
                logger.fine(() -> LMG.log("(appliance=%s, ExportOptions):  Exporting configurations of all objects for domain '%s' is complete.", () -> appliance.getName(), () -> domain.getName()));
            } else {
                logger.warning(() -> LMG.log("(appliance=%s, ExportOptions):  Timeout waiting for export for domain '%s'.", () -> appliance.getName(), () -> domain.getName()));
            }
            if (certThreadListener == null) continue;
            certThreadListener.waitForCompletion(KumbaCoreConstants.EXPORT_CACHE_TIMEOUT + KumbaCoreConstants.THREAD_TIMEOUT);
        }
        logger.finer(() -> LMG.log("(appliance=%s, ExportOptions):  Done", () -> appliance.getName()));
    }

    private void processExportXML(Appliance appliance, Domain domain, String exportFileName) {
        try {
            logger.finer(() -> LMG.log("(appliance=%s, domain=%s, exportFileName=%s) Processing Export.", () -> appliance.getName(), () -> domain.getName(), () -> exportFileName));
            File exportFile = new File(exportFileName);
            File domainDir = exportFile.getParentFile().getParentFile();
            this.unzipExportFile(appliance, domain, exportFile);
            File exportXML = new File(domainDir, "export.xml");
            ASCFileReader fileReader = new ASCFileReader(exportXML);
            String xmlString = fileReader.readAll();
            XMLElement rootElement = XMLElement.parseXMLString(xmlString);
            if (rootElement == null) {
                logger.warning(() -> LMG.log("Error Processing XML %s for SnapShot from %s %s", () -> exportFileName, () -> appliance.getName(), () -> domain.getName()));
                return;
            }
            XMLElement dataPowerConfiguration = rootElement.getNode("datapower-configuration");
            String configVersion = dataPowerConfiguration.getAttributeValue("version");
            XMLElement configurationElement = dataPowerConfiguration.getNode("configuration");
            String domainName = configurationElement.getAttributeValue("domain");
            ArrayList objectElements = (ArrayList)configurationElement.getNodes();
            for (XMLElement objectElement : objectElements) {
                XMLElement outputDPConfigElement = new XMLElement("datapower-configuration");
                outputDPConfigElement.addAttribute("version", configVersion);
                XMLElement outputConfigElement = new XMLElement("configuration");
                outputConfigElement.addAttribute("domain", domainName);
                outputDPConfigElement.addNode(outputConfigElement);
                outputConfigElement.addNode(objectElement);
                String objectType = objectElement.getName();
                String objectName = objectElement.getAttributeValue("name");
                logger.finer(() -> LMG.log("(appliance=%s, domain=%s, exportFileName=%s) Writing Export of %s %s.", () -> appliance.getName(), () -> domain.getName(), () -> exportFileName, () -> objectType, () -> objectName));
                File typeDir = new File(domainDir, objectType);
                typeDir.mkdirs();
                File objectSnapShot = new File(typeDir, String.format("%s.xml", objectName));
                new ASCFileWriter(objectSnapShot, outputDPConfigElement.toString());
                this.notifySnapshotListeners(appliance, domain, objectType, objectName);
            }
            logger.finer(() -> LMG.log("(appliance=%s, domain=%s, exportFileName=%s) Cleaning up.", () -> appliance.getName(), () -> domain.getName(), () -> exportFileName));
            File exportParent = exportFile.getParentFile();
            exportFile.delete();
            exportParent.delete();
            exportXML.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Reflected
    private void getCertificatesFor(Appliance appliance, Domain domain) {
        String loggerPrefix = String.format("(Appliance appliance=%s, Domain domain=%s):", appliance.getName(), domain.getName());
        logger.finer(() -> LMG.log("%s Starting", () -> loggerPrefix));
        try {
            MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
            ConfigurationManager configurationManager = new ConfigurationManager();
            ArrayList<DataPowerConfig> certificateConfigs = configurationManager.getObjects(appliance, domain, "CryptoCertificate", ".*");
            logger.fine(() -> LMG.log("%s  Received %d Certificates from selected appliance(s) and domain(s)", () -> loggerPrefix, () -> certificateConfigs.size()));
            ArrayList<ConfigCryptoCertificate> matchingCerts = new ArrayList<ConfigCryptoCertificate>();
            for (DataPowerConfig configObject : certificateConfigs) {
                ConfigCryptoCertificate cryptoCertificate = (ConfigCryptoCertificate)configObject;
                String certificateObjectName = cryptoCertificate.getName();
                if (certificateObjectName.isEmpty()) {
                    logger.warning(() -> LMG.log("%s  The certificate object name is null for %s", () -> loggerPrefix, () -> cryptoCertificate.getFQON()));
                    continue;
                }
                String fileName = cryptoCertificate.getFilename();
                if (StringUtility.isEmpty(fileName)) {
                    logger.warning(() -> LMG.log("%s  The certificate file name is null for %s", () -> loggerPrefix, () -> cryptoCertificate.getFQON()));
                    continue;
                }
                logger.fine(() -> LMG.log("%s  Processing cert: %s -> %s", () -> loggerPrefix, () -> cryptoCertificate.getName(), () -> cryptoCertificate.getFilename()));
                StatusObjectStatus certificateStatus = cryptoCertificate.getStatus();
                String eventCode = certificateStatus.getEventCode();
                if (StringUtility.isNotEmpty(eventCode) && (eventCode.equals("0x00f30002") || eventCode.equals("0x00f30003"))) continue;
                matchingCerts.add(cryptoCertificate);
            }
            logger.finer(() -> LMG.log("%s  Getting certificate details for %d certs", () -> loggerPrefix, () -> matchingCerts.size()));
            ViewCertificateDetails viewCertificateDetails = new ViewCertificateDetails(matchingCerts, mtil);
            viewCertificateDetails.addCertificateExportSubscriber(this);
            ThreadManager.monitorAsynchThreadLifeCycle("SnapShot.getCertificatesFor" + loggerPrefix, mtil, matchingCerts.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.severe(e.getMessage());
        }
        logger.finer(() -> LMG.log("%s Done", () -> loggerPrefix));
    }

    @Reflected
    private void getLogs() {
        logger.finer("(): Starting");
        ConfigObjectCache<DataPowerFileInfo> logFileCache = new ConfigObjectCache<DataPowerFileInfo>();
        ArrayList<String> logDirectories = new ArrayList<String>();
        logDirectories.add("logstore:");
        logDirectories.add("logtemp:");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        logger.finer("(): Listing all log files.");
        ListFiles.list(this.selectedDomains, logDirectories, ".*", mtil);
        ListFiles.addConfigObjectSubscriber(logFileCache);
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("SnapShot.getLogs()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        mtil.clearCompleted();
        Vector<DataPowerFileInfo> logFileNames = logFileCache.getObjectCache();
        int logFileCount = logFileNames.size();
        if (completedOnTime) {
            logger.finer(() -> LMG.log("(): Log files listing complete.  Reading %d files.", () -> logFileCount));
        } else {
            logger.finer(() -> LMG.log("(): Failed to list all log files in time.  Continuing to read with the %d files we have.", () -> logFileCount));
        }
        DataPowerFileReader.readFiles(new ArrayList<DataPowerFileInfo>(logFileNames), mtil, this);
        logFileNames.clear();
        logFileNames = null;
        completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("SnapShot.getLogs()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        logger.finer("(): Done");
    }

    @Override
    public void processDataPowerConfig(DataPowerFileInfo dataPowerFileInfo) {
        Appliance appliance = dataPowerFileInfo.getAppliance();
        Domain domain = dataPowerFileInfo.getSourceDomain();
        String directory = dataPowerFileInfo.getBaseDirectory();
        String fileStore = StringUtility.substringBefore(directory, ":");
        directory = StringUtility.substringAfter(directory, "/");
        String fileName = dataPowerFileInfo.getFileName();
        String logOutputDirectoryName = String.format("%s%s%s%sdatapower-file-system%s%s%s%s%s%s", appliance.getName(), File.separator, domain.getName(), File.separator, File.separator, fileStore, File.separator, directory, File.separator, fileName);
        logger.finer(() -> LMG.log("(): Writing '%s'", () -> logOutputDirectoryName));
        File logOutputFile = new File(this.outputDirectory, logOutputDirectoryName);
        File logOutputFileParent = logOutputFile.getParentFile();
        logOutputFileParent.mkdirs();
        try {
            new ASCFileWriter(logOutputFile, dataPowerFileInfo.getFileContent());
        }
        catch (IOException e) {
            logger.finer(() -> LMG.log("(): Error Writing '%s'", () -> logOutputDirectoryName));
            e.printStackTrace();
        }
        this.notifySnapshotListeners(appliance, domain, fileStore + ":", directory, fileName);
    }

    @Override
    public void configProcessingComplete() {
    }

    /*
     * Exception decompiling
     */
    private void unzipExportFile(Appliance appliance, Domain domain, File exportFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void processCertificate(Appliance appliance, Domain domain, ConfigCryptoCertificate certificateObject, Certificate certificate) {
        String snapShotFileDir;
        File fileOutputDir;
        String loggerPrefix = String.format("(appliance=%s, domain=%s, certificateObject=%s, certificate)", appliance.getName(), domain.getName(), certificateObject.getName());
        logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        String outputDirectory = String.format("%s%s%s%s%s%s", CERT_DIRECTORY, File.separator, appliance.getName(), File.separator, domain.getName(), File.separator);
        File certDirectory = new File(outputDirectory);
        File localCertificateFile = new File(certDirectory, String.format("%s.cer", certificateObject.getName()));
        String certFileName = certificateObject.getFilename();
        int colon = certFileName.indexOf(58);
        String fileStore = certFileName.substring(0, colon);
        int slash = certFileName.indexOf(47);
        if (slash >= 0) {
            while (slash < certFileName.length() && certFileName.charAt(slash) == '/') {
                ++slash;
            }
        } else {
            slash = 0;
        }
        String dataPowerFileName = certFileName.substring(slash);
        String domainName = domain.getName();
        if (fileStore.equals("pubcert:") || fileStore.equals("sharedcert:")) {
            domainName = "default";
        }
        if (!(fileOutputDir = new File(this.outputDirectory, snapShotFileDir = String.format("%s%s%s%s%s%s%s%s", appliance.getName(), File.separator, domainName, File.separator, FILE_SYSTEM_DIRECTORY_NAME, File.separator, fileStore, File.separator))).exists()) {
            fileOutputDir.mkdirs();
        }
        File snapShotFile = new File(fileOutputDir, dataPowerFileName);
        this.notifySnapshotListeners(appliance, domain, "CryptoCertificate", certificateObject.getName());
        logger.finer(() -> LMG.log("%s: Moving file from %s to %s.", () -> loggerPrefix, () -> localCertificateFile.getAbsolutePath(), () -> snapShotFile.getAbsolutePath()));
        try {
            com.jmorgan.io.File fileMover = new com.jmorgan.io.File(localCertificateFile);
            fileMover.moveTo(snapShotFile);
        }
        catch (IOException e) {
            logger.severe(() -> LMG.log("%s: Unable to move file from %s to %s.", () -> loggerPrefix, () -> localCertificateFile.getAbsolutePath(), () -> snapShotFile.getAbsolutePath()));
        }
        logger.finer(() -> LMG.log("%s: done", () -> loggerPrefix));
    }

    public void addSnapShotListener(SnapShotListener snapShotListener) {
        if (snapShotListener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(snapShotListener);
    }

    private void notifySnapshotListeners(Appliance appliance, Domain domain, String objectType, String objectName) {
        if (this.listeners == null) {
            return;
        }
        for (SnapShotListener listener : this.listeners) {
            listener.objectProcessed(appliance, domain, objectType, objectName);
        }
    }

    private void notifySnapshotListeners(Appliance appliance, Domain domain, String fileStore, String directory, String fileName) {
        if (this.listeners == null) {
            return;
        }
        for (SnapShotListener listener : this.listeners) {
            listener.fileProcessed(appliance, domain, fileStore, directory, fileName);
        }
    }

    public Index<Appliance, Domain> getSelectedDomains() {
        return this.selectedDomains;
    }

    public void setSelectedDomains(Index<Appliance, Domain> selectedDomains) {
        this.selectedDomains = selectedDomains;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
        DynamicBean additionalInfo = commandStatus.getAdditionalCommandInfo();
        Appliance appliance = commandStatus.getAppliance();
        Domain domain = commandStatus.getDomain();
        String outputFileName = (String)additionalInfo.getProperty("outputFileName");
        this.processExportXML(appliance, domain, outputFileName);
    }

    @Override
    public void commandFailed(ManagementCommandError commandError) {
        Appliance appliance = commandError.getAppliance();
        Domain domain = commandError.getDomain();
        String error = commandError.getErrorMessage();
        System.err.printf("(ManagementCommandError): %s %s, %s", appliance.getName(), domain.getName(), error);
        logger.config(() -> LMG.log("(ManagementCommandError): %s %s, %s", () -> appliance.getName(), () -> domain.getName(), () -> error));
    }

    private static /* synthetic */ String lambda$66(File file) {
        return LMG.log("(File exportFile='%s'): Zip File Opened Successfully.", () -> file.getName());
    }

    private static /* synthetic */ String lambda$68(File file, String string) {
        return LMG.log("(File exportFile='%s'): Skipping '%s'.", () -> file.getName(), () -> string);
    }

    private static /* synthetic */ String lambda$71(File file, long l, String string, long l2) {
        return LMG.log("(File exportFile='%s'): Found %d byte entry named '%s'.  Compressed size is %d", () -> file.getName(), () -> l, () -> string, () -> l2);
    }

    private static /* synthetic */ String lambda$76(File file, String string) {
        return LMG.log("(File exportFile='%s'):  Creating directory '%s'", () -> file.getName(), () -> string);
    }

    private static /* synthetic */ String lambda$79(File file, String string) {
        return LMG.log("(File exportFile='%s'):  Uncompressing to '%s'", () -> file.getName(), () -> string);
    }

    private static /* synthetic */ String lambda$82(File file, String string, String string2) {
        return LMG.log("(File exportFile='%s'):  '%s' Exception attempting to open '%s' for output.", () -> file.getName(), () -> string, () -> string2);
    }

    private static /* synthetic */ String lambda$62(File file) {
        return LMG.log("(File exportFile='%s'):  Zip file reference is null.  Cannot close.", () -> file.getName());
    }

    private static /* synthetic */ String lambda$64(File file) {
        return LMG.log("(File exportFile='%s'):  Error closing zip file", () -> file.getName());
    }

    private static /* synthetic */ String lambda$86(File file, String string) {
        return LMG.log("%s:  '%s' created successfully.", () -> file.getName(), () -> string);
    }

    private static /* synthetic */ String lambda$89(File file) {
        return LMG.log("(File exportFile='%s'):  Failed to successfully process zip file.", () -> file.getName());
    }
}

