/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.applianceManagement;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMPasswordField;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.layout.XYLayout;
import com.jmorgan.swing.layout.XYLayoutConstraints;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.CharArrayTableCellEditor;
import com.jmorgan.swing.table.CharArrayTableCellRenderer;
import com.jmorgan.swing.table.PasswordTableCellEditorRenderer;
import com.jmorgan.swing.table.RowFocusEventInvoker;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.swing.util.WindowCloser;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.AbstractTablePanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.applianceManagement.CategoriesTableCellEditor;
import com.kumbasoft.core.ui.dialog.applianceManagement.CategoriesTableCellRenderer;
import com.kumbasoft.core.util.FileUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.table.JTableHeader;

public class ApplianceManagementPanel
extends AbstractTablePanel<Appliance> {
    private JMButton btnAddAppliance;
    private JMButton btnCopyAppliance;
    private JMButton btnDeleteAppliance;
    private JMButton btnImport;
    private JMButton btnExport;
    private JMPasswordField tfExportPassword;
    private JMCheckBox cbxExportWithCredentials;
    private JMCheckBox cbxImportReplace;
    private JMButton btnTestConnection;
    private JMButton btnSave;
    private JMButton btnCancel;
    private JMTextField tfCategories;
    private JMButton btnAddCategories;
    private JMButton btnSetCategories;
    private JMTextField tfUserName;
    private JMPasswordField tfPassword;
    private JMRadioButton rbXML;
    private JMRadioButton rbSSH;
    private JMRadioButton rbBoth;
    private JMButton btnSetCredentials;
    private JMCheckBox cbxShowPasswords;

    public ApplianceManagementPanel() {
        super(Appliance.class);
        this.centerPanel.add((Component)this.createControlsPanel(), "North");
        this.centerPanel.add((Component)this.createExportPanel(), "South");
        this.tableModel.addAll(this.getModelAppliances());
        JTableHeader tableHeader = this.displayTable.getTableHeader();
        tableHeader.setPreferredSize(new Dimension(100, 33));
        this.setPreferredSize(1200, 600);
        new RowFocusEventInvoker(this.displayTable, this, "appliancesRowFocusChanged");
    }

    private ArrayList<Appliance> getModelAppliances() {
        ArrayList appliances = (ArrayList)Application.getApplication().getAttribute("Appliances");
        if (appliances == null) {
            return new ArrayList<Appliance>();
        }
        ArrayList<Appliance> modelAppliances = new ArrayList<Appliance>(appliances.size());
        for (Appliance appliance : appliances) {
            Appliance modelAppliance = appliance.clone();
            modelAppliances.add(modelAppliance);
        }
        return modelAppliances;
    }

    private JMPanel createControlsPanel() {
        this.btnAddAppliance = ComponentFactory.createButton(KumbaCoreUIConstants.ADD_ICON, null, "Add a new appliance configuration", true, this, "fileNew", new Object[0]);
        this.btnCopyAppliance = ComponentFactory.createButton(KumbaCoreUIConstants.COPY_ICON, null, "Duplicate the selected appliances", true, this, "fileCopy", new Object[0]);
        this.btnDeleteAppliance = ComponentFactory.createButton(KumbaCoreUIConstants.DELETE_ICON, null, "Delete the selected appliances from the list", false, this, "editDelete", new Object[0]);
        this.btnTestConnection = ComponentFactory.createButton(KumbaCoreUIConstants.CONNECT_ICON, null, "Test the connection for all or the selected appliances.", true, this, "testConnection", new Object[0]);
        this.tfCategories = new JMTextField(30);
        LabeledComponent lblCategories = new LabeledComponent("Categories:", (Component)this.tfCategories);
        lblCategories.setPreferredSize(489, 29);
        this.btnSetCategories = ComponentFactory.createButton(KumbaCoreUIConstants.CATEGORIES_ICON, null, "Set the categories for all selected appliances.", false, this, "editSetCategories", new Object[0]);
        this.btnAddCategories = ComponentFactory.createButton(KumbaCoreUIConstants.ADD_CATEGORIES_ICON, null, "Add the categories to all selected appliances.", true, this, "editAddCategories", new Object[0]);
        JMPanel leftControls = new JMPanel(new FlowLayout(0));
        leftControls.addAll(this.btnAddAppliance, this.btnCopyAppliance, this.btnDeleteAppliance, ComponentFactory.createSpacer(20, 20), this.btnTestConnection, ComponentFactory.createSpacer(20, 20), lblCategories, this.btnSetCategories, this.btnAddCategories);
        this.btnSave = ComponentFactory.createButton(KumbaCoreUIConstants.SAVE_ICON, null, "Save the appliance information for DPAA\u00ae use.", true, this, "fileSave", new Object[0]);
        this.btnCancel = ComponentFactory.createButton(KumbaCoreUIConstants.CANCEL_ICON, null, "Cancel all changes and close the window.", true, this, "fileCancel", new Object[0]);
        JMPanel rightControls = new JMPanel(new FlowLayout(2));
        rightControls.addAll(this.btnSave, this.btnCancel);
        JMPanel credentialsControls = this.createSetCredentialsPanel();
        JMPanel allControls = KumbaCoreUIConstants.createBorderLayoutPanel();
        allControls.add((Component)leftControls, "West");
        allControls.add((Component)rightControls, "East");
        allControls.add((Component)credentialsControls, "South");
        return allControls;
    }

    private JMPanel createSetCredentialsPanel() {
        this.tfUserName = new JMTextField(15);
        LabeledComponent lblUserName = new LabeledComponent("User Name:", (Component)this.tfUserName, 1, 75, 75);
        this.tfPassword = new JMPasswordField(15);
        this.tfPassword.setName("ApplianceManagementPanel.credentialsPassword");
        LabeledComponent lblPassword = new LabeledComponent("Password:", (Component)this.tfPassword, 1, 75, 75);
        this.rbXML = new JMRadioButton("XML");
        this.rbXML.setToolTipText(LabelUtility.wrapInHTML("Select this to set the credentials\nfor the XML Management Interface"));
        this.rbSSH = new JMRadioButton("SSH");
        this.rbSSH.setToolTipText(LabelUtility.wrapInHTML("Select this to set the credentials\nfor the SSH (CLI) Interface"));
        this.rbBoth = new JMRadioButton("Both", true);
        this.rbBoth.setToolTipText(LabelUtility.wrapInHTML("Select this to set both the XML and SSH Interface credentials"));
        new JMButtonGroup(this.rbXML, this.rbSSH, this.rbBoth);
        this.btnSetCredentials = ComponentFactory.createButton(KumbaCoreUIConstants.CHANGECREDS_ICON, "Set", LabelUtility.wrapInHTML("Set all selected appliances to have\nthe given user name and password\nfor the indicated type(s)."), true, this, "editSetCredentials", new Object[0]);
        this.cbxShowPasswords = ComponentFactory.createCheckbox(null, "Show Passwords", "Toggle Password Display", false, true, this, "showPasswords", new Object[0]);
        JMPanel credentialsPanel = new JMPanel(new XYLayout());
        int leftOffset = 273;
        int fieldWidth = 150;
        int passwordOffset = 433;
        int labeledFieldHeight = 55;
        int rbY = 30;
        int rbWidth = 60;
        int bHeight = 20;
        credentialsPanel.add((Component)lblUserName, new XYLayoutConstraints(273, 0, 150, 55));
        credentialsPanel.add((Component)lblPassword, new XYLayoutConstraints(433, 0, 150, 55));
        credentialsPanel.add((Component)this.rbXML, new XYLayoutConstraints(593, 30, 60, 20));
        credentialsPanel.add((Component)this.rbSSH, new XYLayoutConstraints(653, 30, 60, 20));
        credentialsPanel.add((Component)this.rbBoth, new XYLayoutConstraints(723, 30, 60, 20));
        credentialsPanel.add((Component)this.btnSetCredentials, new XYLayoutConstraints(793, 30, 70, 20));
        credentialsPanel.add((Component)this.cbxShowPasswords, new XYLayoutConstraints(883, 30, 130, 20));
        return credentialsPanel;
    }

    private JMPanel createExportPanel() {
        this.btnImport = ComponentFactory.createButton(KumbaCoreUIConstants.IMPORT_ICON, null, "Import appliance data from a protected export", true, this, "fileImport", new Object[0]);
        this.btnExport = ComponentFactory.createButton(KumbaCoreUIConstants.EXPORT_ICON, null, "Export the selected appliances to a protected export", true, this, "fileExport", new Object[0]);
        this.tfExportPassword = new JMPasswordField(15);
        this.tfExportPassword.setName("ApplianceManagementPanel.exportPassword");
        LabeledComponent lblExportPassword = new LabeledComponent("Import/Export Password:", (Component)this.tfExportPassword);
        lblExportPassword.setPreferredSize(350, 29);
        this.cbxExportWithCredentials = new JMCheckBox("Export with Credentials", false);
        this.cbxExportWithCredentials.setToolTipText(LabelUtility.wrapInHTML("Export the selected appliances\nincluding the credentials associated with them."));
        this.cbxImportReplace = new JMCheckBox("Replace from imported", false);
        this.cbxImportReplace.setToolTipText(LabelUtility.wrapInHTML("If on, importing will replace the appliances\nin the table.\n\nIf off, importing will add the appliances\nwithin the import file to the table."));
        JMPanel panel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        panel.addAll(lblExportPassword, this.cbxExportWithCredentials, this.btnExport, ComponentFactory.createSpacer(20, 20), this.cbxImportReplace, this.btnImport);
        return panel;
    }

    @Override
    protected JMPanel createLeftPanel() {
        return null;
    }

    @Reflected
    private void appliancesRowFocusChanged() {
        ThreadUtility.sleep(75L);
        ArrayList selectedAppliances = this.getSelectedValues();
        boolean selected = CollectionUtility.isNotEmpty(selectedAppliances);
        this.btnDeleteAppliance.setEnabled(selected);
        this.btnExport.setEnabled(selected);
        this.btnSetCategories.setEnabled(selected);
        this.btnAddCategories.setEnabled(selected);
        this.btnSetCredentials.setEnabled(selected);
    }

    @Reflected
    private void fileNew() {
        Appliance appliance = new Appliance();
        this.tableModel.addRow(appliance);
    }

    @Reflected
    private void fileCopy() {
        this.displayTable.commitEdits();
        this.displayTable.removeEditor();
        ArrayList appliances = this.getSelectedValues();
        if (CollectionUtility.isEmpty(appliances)) {
            return;
        }
        for (Appliance appliance : appliances) {
            Appliance dupe = appliance.clone();
            dupe.setConnected(false);
            this.tableModel.addRow(dupe);
        }
    }

    @Reflected
    private void editDelete() {
        ArrayList removedAppliances = this.removeSelectedValues("Delete Appliances", "Are you sure you want to remove all selected appliances?");
        if (removedAppliances == null) {
            return;
        }
        this.displayTable.removeEditor();
        this.btnSetCredentials.setEnabled(false);
        new AsynchMethodInvoker((Object)this, "appliancesRowFocusChanged");
    }

    @Reflected
    private void showPasswords() {
        boolean showPasswords = this.cbxShowPasswords.isSelected();
        PasswordTableCellEditorRenderer passwordRenderer = (PasswordTableCellEditorRenderer)this.displayTable.getColumn("xmlManagementPassword").getCellRenderer();
        passwordRenderer.setShowPassword(showPasswords);
        passwordRenderer = (PasswordTableCellEditorRenderer)this.displayTable.getColumn("sshManagementPassword").getCellRenderer();
        passwordRenderer.setShowPassword(showPasswords);
        this.displayTable.repaint();
    }

    @Reflected
    private void testConnection() {
        if (this.displayTable.getRowCount() == 0) {
            return;
        }
        ArrayList selectedAppliances = this.getSelectedValues(true);
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        HashMap<Appliance, AsynchMethodInvoker<Void>> threads = new HashMap<Appliance, AsynchMethodInvoker<Void>>();
        HashMap cachesByAppliance = new HashMap();
        for (Appliance appliance : selectedAppliances) {
            appliance.setConnected(false);
            DataPowerStatusCache statusCache = new DataPowerStatusCache();
            DataPowerStatusMonitor dts = new DataPowerStatusMonitor(appliance, new Domain("default"), "DateTimeStatus", 0L);
            dts.setRetryCount(1);
            dts.addStatusListener(statusCache);
            threads.put(appliance, dts.getProcessThread());
            cachesByAppliance.put(appliance, statusCache);
        }
        this.tableModel.fireTableDataChanged();
        ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        AbstractPanel.logger.finer("():  Waiting for status threads to complete.");
        long startTime = System.currentTimeMillis();
        long elapsed = 0L;
        boolean allComplete = false;
        while (!allComplete && elapsed < (long)(KumbaCoreConstants.THREAD_TIMEOUT * threads.size())) {
            allComplete = true;
            for (Appliance appliance : threads.keySet()) {
                ArrayList dateTimeStatus;
                AsynchMethodInvoker thread = (AsynchMethodInvoker)threads.get(appliance);
                if (thread == null) {
                    AbstractPanel.logger.severe(() -> LMG.log("():  No threads registered for appliance %s", () -> appliance.getName()));
                    continue;
                }
                if (!thread.hasCompleted()) {
                    AbstractPanel.logger.fine(() -> LMG.log("():  Thread has not completed for appliance %s", () -> appliance.getName()));
                    allComplete = false;
                    continue;
                }
                DataPowerStatusCache statusCache = (DataPowerStatusCache)cachesByAppliance.get(appliance);
                if (statusCache == null || !CollectionUtility.isNotEmpty(dateTimeStatus = statusCache.getStatusCache())) continue;
                appliance.setConnected(true);
                this.tableModel.fireTableDataChanged();
            }
            ThreadUtility.sleep(KumbaCoreConstants.APPLIANCE_NOT_CONNECTED_HEALTH_CHECK_INTERVAL);
            long endTime = System.currentTimeMillis();
            elapsed = endTime - startTime;
        }
        if (elapsed >= (long)(KumbaCoreConstants.THREAD_TIMEOUT * threads.size())) {
            AbstractPanel.logger.severe("():  Connection test failed - timed out for the following appliances");
            for (Appliance appliance : threads.keySet()) {
                AbstractPanel.logger.severe(() -> LMG.log("(): %s", () -> appliance.getName()));
            }
        } else {
            AbstractPanel.logger.finer("():  All threads are complete.");
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    @Reflected
    private void fileImport() {
        if (!this.validateImportExportPassword("Import Appliances", "import")) {
            return;
        }
        boolean replace = this.cbxImportReplace.isSelected();
        Object verifyMessage = "Are you sure you want to import the saved appliances\n";
        verifyMessage = replace ? (String)verifyMessage + "replacing" : (String)verifyMessage + "adding to";
        verifyMessage = (String)verifyMessage + " the current list of appliances?";
        if (!this.continueAction("Import Appliances", (String)(verifyMessage = LabelUtility.wrapInHTML((String)verifyMessage)))) {
            return;
        }
        File inputFile = GUIServices.fileOpenDialog(null);
        if (inputFile == null) {
            return;
        }
        String importPassword = this.tfExportPassword.getText();
        ArrayList appliances = (ArrayList)FileUtility.readSecureData(inputFile.getAbsolutePath(), importPassword);
        if (appliances == null) {
            this.showMessage("Appliance Import", "Failed to import appliances. Check the password or input file and try again.");
            return;
        }
        if (replace) {
            this.displayTable.removeEditor();
            this.displayTable.clearSelection();
            this.tableModel.reset();
        }
        this.tableModel.addAll(appliances);
    }

    @Override
    @Reflected
    public void fileExport() {
        AbstractPanel.logger.finer("():  Starting.");
        this.displayTable.commitEdits();
        if (this.displayTable.getRowCount() == 0) {
            new JMMessageBox((JFrame)AbstractPanel.frame, "Export Appliances", "Please create appliances first.");
            AbstractPanel.logger.info("():  No appliances present.");
            return;
        }
        if (!this.validateImportExportPassword("Export Selected Appliances", "export")) {
            AbstractPanel.logger.info("():  Export password not valid.");
            return;
        }
        AbstractPanel.logger.finer("():  Collecting appliance information.");
        ArrayList selectedAppliances = this.getSelectedValues(true);
        if (CollectionUtility.isEmpty(selectedAppliances)) {
            AbstractPanel.logger.warning("():  Neither appliances created nor selected.  Something is unexpectedly wrong.");
            new JMMessageBox((JFrame)AbstractPanel.frame, "Export Appliances", LabelUtility.wrapInHTML("An unexpected error occurred.\n\nPlease contact Kumbasoft Tecnical Support.\n"));
            return;
        }
        boolean exportWithCreds = this.cbxExportWithCredentials.isSelected();
        String credsMessage = exportWithCreds ? "with" : "without";
        String verifyMessage = String.format(LabelUtility.wrapInHTML("Are you sure you want to export all or the selected appliances\n%s the assigned credentials?"), credsMessage);
        if (!this.continueAction("Export Selected Appliances", verifyMessage)) {
            return;
        }
        AbstractPanel.logger.finer("():  Opening file save dialog.");
        File outputFile = GUIServices.fileSaveDialog(null);
        if (outputFile == null) {
            AbstractPanel.logger.info("():  File save dialog cancelled.");
            return;
        }
        boolean exportCredentials = this.cbxExportWithCredentials.isSelected();
        if (exportCredentials) {
            AbstractPanel.logger.fine("(): Exporting with credentials.");
        } else {
            AbstractPanel.logger.fine("(): Exporting without credentials.");
        }
        ArrayList<Appliance> newValues = new ArrayList<Appliance>(selectedAppliances.size());
        AbstractPanel.logger.finer("():  Removing domains" + (!exportCredentials ? " and credentials." : "."));
        for (Appliance appliance : selectedAppliances) {
            Appliance clonedAppliance = appliance.clone();
            clonedAppliance.setDomains(null);
            if (!exportCredentials) {
                clonedAppliance.setXmlManagementPassword(null);
                clonedAppliance.setXmlManagementUserName(null);
                clonedAppliance.setSshManagementPassword(null);
                clonedAppliance.setSshManagementUserName(null);
            }
            newValues.add(clonedAppliance);
        }
        AbstractPanel.logger.fine(() -> LMG.log("(): Exporting to '%s'.", () -> outputFile.getAbsolutePath()));
        String exportPassword = this.tfExportPassword.getText();
        FileUtility.writeSecureData(outputFile.getAbsolutePath(), newValues, exportPassword);
        AbstractPanel.logger.finer("():  Done.");
    }

    private boolean validateImportExportPassword(String errorTitle, String mode) {
        String importExportPassword = this.tfExportPassword.getText();
        if (StringUtility.isEmpty(importExportPassword)) {
            String message = String.format(LabelUtility.wrapInHTML("No %s password set.\n\nPlease provide the password needed for %s."), mode, mode);
            this.showMessage(errorTitle, message);
            return false;
        }
        return true;
    }

    @Reflected
    private void editSetCategories() {
        this.changeCategories(true, "Set Categories", "Are you sure you want to set all\nselected appliances to have the same categories?", "No categories are defined to set.\n\nPlease define at least one category\nor many using commas a delimiters.");
    }

    @Reflected
    private void editAddCategories() {
        this.changeCategories(false, "Add Categories", "Are you sure you want to add the\ncategories to all or selected appliances?", "No categories are defined to add.\n\nPlease define at least one category\nor many using commas a delimiters.");
    }

    private void changeCategories(boolean set, String confirmTitle, String confirmMessage, String errorMessage) {
        if (this.displayTable.getRowCount() == 0) {
            return;
        }
        this.displayTable.removeEditor();
        ArrayList selectedAppliances = this.getSelectedValues(true);
        String categories = this.tfCategories.getText();
        if (StringUtility.isEmpty(categories)) {
            this.showMessage(confirmTitle, LabelUtility.wrapInHTML(errorMessage));
            return;
        }
        if (!this.continueAction(confirmTitle, LabelUtility.wrapInHTML(confirmMessage))) {
            return;
        }
        for (Appliance appliance : selectedAppliances) {
            if (set) {
                appliance.setCategories(categories);
                continue;
            }
            appliance.addCategories(categories);
        }
        this.displayTable.repaint();
    }

    @Reflected
    private void editSetCredentials() {
        this.displayTable.removeEditor();
        String userName = this.tfUserName.getText().trim();
        String password = this.tfPassword.getText().trim();
        if (StringUtility.isEmpty(userName) || StringUtility.isEmpty(password)) {
            new JMMessageBox((JFrame)frame, "Credentials Required", "Please provide both user name and password.");
            return;
        }
        ArrayList selectedAppliances = this.getSelectedValues(true);
        boolean allAppliances = selectedAppliances.size() == this.displayTable.getRowCount();
        String messageFragment = "";
        messageFragment = this.rbXML.isSelected() ? "the XML management interface" : (this.rbSSH.isSelected() ? "the SSH (CLI) management interface" : "both the XML and SSH (CLI) management interfaces");
        String confirmMessage = String.format("Do you want to change credentials\nfor %s\n%s?", messageFragment, allAppliances ? "for all appliances" : "for all of the selected appliances");
        if (!this.continueAction("Change Credentials", LabelUtility.wrapInHTML(confirmMessage))) {
            return;
        }
        for (Appliance appliance : selectedAppliances) {
            if (this.rbBoth.isSelected() || this.rbXML.isSelected()) {
                appliance.setXmlManagementUserName(userName.toCharArray());
                appliance.setXmlManagementPassword(password.toCharArray());
            }
            if (!this.rbBoth.isSelected() && !this.rbSSH.isSelected()) continue;
            appliance.setSshManagementUserName(userName.toCharArray());
            appliance.setSshManagementPassword(password.toCharArray());
        }
        this.displayTable.repaint();
    }

    @Reflected
    private void fileSave() {
        this.displayTable.commitEdits();
        ArrayList<Appliance> applianceSet = this.tableModel.getModelData(false);
        String initConfigFile = applicationProperties.getInitConfigFile();
        FileUtility.saveInitConfig(initConfigFile, applianceSet);
        ThreadManager.startThreadManager(applianceSet.size());
        Application.getApplication().setAttribute("Appliances", applianceSet);
    }

    @Reflected
    private void fileCancel() {
        JMDialog parent = (JMDialog)ComponentService.getParentWindow(this);
        WindowCloser.closeWindow(parent, 0, true);
    }

    @Override
    public BeanTableModel<Appliance> getTableModel() {
        BeanTableModel<Appliance> tableModel = super.getTableModel();
        tableModel.setEditableColumns("active", "name", "categories", "xmlManagementHost", "xmlManagementUserName", "xmlManagementPassword", "xmlPort", "sshManagementHost", "sshManagementUserName", "sshManagementPassword", "sshPort");
        return tableModel;
    }

    @Override
    protected BeanColumnModel<Appliance> getColumnModel() {
        BeanColumnModel<Appliance> model = super.getColumnModel();
        model.hideColumns("appliances", "appliancesConnected", "createdFromCategory", "domains", "firmwareVersion", "host", "groupName", "percentOfAppliancesConnected", "restPort", "useApplicationCredentialsForLogin", "webMgmtPort", "quiesced", "inDiagnosticMode", "inFailsafeMode", "hasInterfaceLinkError", "quarantined");
        model.setColumnOrder("active", "name", "categories", "xmlManagementHost", "xmlPort", "xmlManagementUserName", "xmlManagementPassword", "sshManagementHost", "sshPort", "sshManagementUserName", "sshManagementPassword", "connected");
        model.setEditor("categories", new CategoriesTableCellEditor());
        model.setRenderer("categories", new CategoriesTableCellRenderer());
        model.setColumnTitle("xmlManagementHost", LabelUtility.wrapInHTML("XML Mgmt\nHost"));
        model.setColumnWidth("xmlManagementHost", 200);
        model.setColumnTitle("xmlPort", "XML Port");
        model.setEditor("xmlManagementUserName", new CharArrayTableCellEditor());
        model.setRenderer("xmlManagementUserName", new CharArrayTableCellRenderer());
        model.setEditor("xmlManagementPassword", new PasswordTableCellEditorRenderer(char[].class));
        model.setRenderer("xmlManagementPassword", new PasswordTableCellEditorRenderer(char[].class));
        model.setColumnWidth("xmlManagementUserName", 150);
        model.setColumnWidth("xmlManagementPassword", 150);
        model.setColumnTitle("xmlManagementUserName", LabelUtility.wrapInHTML("XML Mgmt\nUser Name"));
        model.setColumnTitle("xmlManagementPassword", LabelUtility.wrapInHTML("XML Mgmt\nPassword"));
        model.setColumnTitle("sshManagementHost", LabelUtility.wrapInHTML("SSH Mgmt\nHost"));
        model.setColumnWidth("sshManagementHost", 200);
        model.setColumnTitle("sshPort", "SSH Port");
        model.setEditor("sshManagementUserName", new CharArrayTableCellEditor());
        model.setRenderer("sshManagementUserName", new CharArrayTableCellRenderer());
        model.setEditor("sshManagementPassword", new PasswordTableCellEditorRenderer(char[].class));
        model.setRenderer("sshManagementPassword", new PasswordTableCellEditorRenderer(char[].class));
        model.setColumnWidth("sshManagementUserName", 150);
        model.setColumnWidth("sshManagementPassword", 150);
        model.setColumnTitle("sshManagementUserName", LabelUtility.wrapInHTML("SSH Mgmt\nUser Name"));
        model.setColumnTitle("sshManagementPassword", LabelUtility.wrapInHTML("SSH Mgmt\nPassword"));
        model.setColumnTitle("connected", "Is Connected");
        return model;
    }
}

