/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.logSearchOptions;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.combobox.JMComboBoxModel;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.ComboBoxModel;

public abstract class AbstractLogSettingsPanel
extends AbstractPanel
implements DialogPanel {
    protected static final int LABEL_WIDTH = 100;
    protected static final int FIELD_WIDTH = 200;
    protected GenericDialog parentDialog;
    protected DynamicBean logSettings;
    protected JMComboBoxModel<String> cbxModel;
    protected JMComboBox<String> cbxLevel;
    protected NumberField nfFileSize;
    protected NumberSpinner nsFileSize;
    protected NumberField nfRotations;
    protected NumberSpinner nsRotations;
    private JMButton btnOK;
    private JMButton btnCancel;

    public AbstractLogSettingsPanel(DynamicBean logSettings) {
        super(KumbaCoreUIConstants.createVerticalFlowLayout(3));
        this.setLogSettings(logSettings);
        this.createControls();
        this.btnOK = new JMButton("OK");
        new ActionEventInvoker(this.btnOK, this, "okClicked");
        this.btnCancel = new JMButton("Cancel");
        new ActionEventInvoker(this.btnCancel, this, "cancelClicked");
        JMPanel buttonPanel = new JMPanel(new FlowLayout());
        buttonPanel.addAll(this.btnOK, this.btnCancel);
        this.add(buttonPanel);
    }

    protected void createControls() {
        this.cbxModel = new JMComboBoxModel<String>((ElementType[])this.getComboBoxElements());
        this.cbxLevel = new JMComboBox<String>((ComboBoxModel<String>)this.cbxModel);
        this.cbxLevel.setSelectedItem(this.getDefaultSelectedItem());
        LabeledComponent lblComboBox = new LabeledComponent(this.getComboBoxLabel(), this.cbxLevel, 100, 200);
        this.nfFileSize = new NumberField((double)this.getDefaultFileSize());
        this.nfFileSize.setFormatString("###0;-###0");
        this.nsFileSize = new NumberSpinner(this.nfFileSize, 1.0, this.getMinimumFileSize(), this.getMaximumFileSize());
        LabeledComponent lblFileSize = new LabeledComponent("File Size:", (Component)this.nsFileSize, 100, 200);
        this.nfRotations = new NumberField((double)this.getDefaultRotations());
        this.nfRotations.setFormatString("###0;-###0");
        this.nsRotations = new NumberSpinner(this.nfRotations, 1.0, this.getMinimumRotations(), this.getMaximumRotations());
        LabeledComponent lblNumRotations = new LabeledComponent("Rotations:", (Component)this.nsRotations, 100, 200);
        this.addAll(lblComboBox, lblFileSize, lblNumRotations);
    }

    @Override
    public void setParentDialog(GenericDialog dialog) {
        this.parentDialog = dialog;
    }

    protected DynamicBean getLogSettings() {
        return this.logSettings;
    }

    protected void setLogSettings(DynamicBean logSettings) {
        this.logSettings = logSettings;
    }

    protected abstract String getComboBoxLabel();

    protected abstract String[] getComboBoxElements();

    protected abstract String getDefaultSelectedItem();

    protected abstract int getDefaultFileSize();

    protected abstract int getMinimumFileSize();

    protected abstract int getMaximumFileSize();

    protected int getDefaultRotations() {
        return 3;
    }

    protected int getMinimumRotations() {
        return 1;
    }

    protected int getMaximumRotations() {
        return 100;
    }

    protected abstract String getSelectedLogLevel();

    @Reflected
    private void okClicked() {
        this.parentDialog.closeDialog();
    }

    @Reflected
    private void cancelClicked() {
        this.parentDialog.setCancelled(true);
        this.okClicked();
    }

    @Override
    public boolean parentDialogClosing() {
        String logLevel = this.getSelectedLogLevel();
        long fileSize = (long)this.nfFileSize.getNumber();
        long rotations = (long)this.nfRotations.getNumber();
        this.logSettings.setProperty("fileSize", fileSize);
        this.logSettings.setProperty("rotations", rotations);
        this.logSettings.setProperty("logLevel", logLevel);
        return true;
    }
}

