/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.dialog.logSearchOptions;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.TimeField;
import com.jmorgan.swing.combobox.DateComboBox;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.spinner.TimeSpinner;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Time;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.AbstractLogSearchOptions;
import com.kumbasoft.core.ui.beans.RelativeAnchor;
import com.kumbasoft.core.ui.beans.RelativeTimeMeasure;
import com.kumbasoft.core.ui.dialog.logSearchOptions.AbstractDateOptionsPanel;

public class TimeRangeOptionsPanel
extends AbstractDateOptionsPanel {
    private static final int LABEL_WIDTH = 60;
    private static final int COMPONENT_WIDTH = 100;
    private JMComboBox<String> rangeType;
    private DateComboBox dfBeginDate;
    private TimeField tfBeginTime;
    private DateComboBox dfEndDate;
    private TimeField tfEndTime;
    private JMPanel beginTimePanel;
    private JMPanel endTimePanel;

    public TimeRangeOptionsPanel(AbstractLogSearchOptions searchOptions) {
        super(searchOptions, KumbaCoreUIConstants.createVerticalFlowLayout(0));
    }

    @Override
    protected void createControls() {
        this.rangeType = new JMComboBox<String>((ItemType[])new String[]{"Between", "Since", "Before"});
        DateTime beginTime = this.searchOptions.getBeginTime();
        if (beginTime == null) {
            beginTime = new DateTime();
            beginTime.getTime().setTime(0, 0, 0);
            beginTime.addDays(-10);
            this.searchOptions.setBeginTime(beginTime);
        }
        this.dfBeginDate = new DateComboBox(this.searchOptions.getBeginTime().getCalendar());
        this.dfBeginDate.setWidth(100);
        this.tfBeginTime = new TimeField(this.searchOptions.getBeginTime().getCalendar());
        this.tfBeginTime.setWidth(100);
        TimeSpinner tsBeginTime = new TimeSpinner(this.tfBeginTime);
        DateTime endTime = this.searchOptions.getEndTime();
        if (endTime == null) {
            endTime = new DateTime();
            endTime.getTime().setTime(0, 0, 0);
            endTime.addDays(1);
            this.searchOptions.setEndTime(endTime);
        }
        this.dfEndDate = new DateComboBox(this.searchOptions.getEndTime().getCalendar());
        this.dfEndDate.setWidth(100);
        this.tfEndTime = new TimeField(this.searchOptions.getEndTime().getCalendar());
        this.tfEndTime.setWidth(100);
        TimeSpinner tsEndTime = new TimeSpinner(this.tfEndTime);
        LabeledComponent lblRangeType = new LabeledComponent("Anchor:", this.rangeType, 60, 100);
        this.beginTimePanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        JMLabel lblBeginTime = new JMLabel("From:");
        lblBeginTime.setPreferredSize(60, 23);
        this.beginTimePanel.addAll(lblBeginTime, this.dfBeginDate, tsBeginTime);
        this.endTimePanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        JMLabel lblEndTime = new JMLabel("To:");
        lblEndTime.setPreferredSize(60, 23);
        this.endTimePanel.addAll(lblEndTime, this.dfEndDate, tsEndTime);
        RelativeAnchor anchor = this.searchOptions.getRelativeAnchor();
        if (anchor == null) {
            anchor = RelativeAnchor.BETWEEN;
        }
        int typeIndex = 0;
        switch (anchor) {
            case BETWEEN: {
                typeIndex = 0;
                break;
            }
            case BEGIN_TIME: {
                typeIndex = 1;
                break;
            }
            case END_TIME: {
                typeIndex = 2;
                break;
            }
            case NOW: {
                typeIndex = 0;
            }
        }
        this.rangeType.setSelectedIndex(typeIndex);
        this.showAnchorControls();
        this.addAll(lblRangeType, this.beginTimePanel, this.endTimePanel);
        new ItemEventInvoker(this.rangeType, this, "showAnchorControls");
    }

    @Override
    protected void setSearchOptions(AbstractLogSearchOptions searchOptions) {
        String timeRange;
        super.setSearchOptions(searchOptions);
        if (this.rangeType != null && (timeRange = (String)this.searchOptions.getUserSelectedOption("timeRangeType")) != null) {
            this.rangeType.setSelectedItem(timeRange);
        }
        if (this.dfBeginDate != null) {
            DateTime beginTime = this.searchOptions.getBeginTime();
            this.dfBeginDate.setDate(beginTime.getDate());
            this.tfBeginTime.setTime(beginTime.getTime().getCalendar());
        }
        if (this.dfEndDate != null) {
            DateTime endTime = this.searchOptions.getEndTime();
            this.dfEndDate.setDate(endTime.getDate());
            this.tfEndTime.setTime(endTime.getTime().getCalendar());
        }
    }

    @Reflected
    private void showAnchorControls() {
        int typeIndex = this.rangeType.getSelectedIndex();
        switch (typeIndex) {
            case 0: {
                this.endTimePanel.setVisible(true);
                this.beginTimePanel.setVisible(true);
                break;
            }
            case 1: {
                this.beginTimePanel.setVisible(true);
                this.endTimePanel.setVisible(false);
                break;
            }
            case 2: {
                this.beginTimePanel.setVisible(false);
                this.endTimePanel.setVisible(true);
            }
        }
    }

    @Override
    protected void saveOptions() {
        AbstractPanel.logger.finer("(): Starting");
        this.searchOptions.setUserSelectedOption("selectedDateTab", "timeRange");
        RelativeAnchor anchor = RelativeAnchor.BETWEEN;
        String rangeType = (String)this.rangeType.getSelectedItem();
        this.searchOptions.setUserSelectedOption("timeRangeType", rangeType);
        switch (rangeType) {
            case "Between": {
                anchor = RelativeAnchor.BETWEEN;
                break;
            }
            case "Since": {
                anchor = RelativeAnchor.BEGIN_TIME;
                break;
            }
            case "Before": {
                anchor = RelativeAnchor.END_TIME;
            }
        }
        this.searchOptions.setRelativeAnchor(anchor);
        this.searchOptions.setRelativeTimeMeasure(RelativeTimeMeasure.SECONDS);
        this.searchOptions.setTimeAmount(1);
        Date beginDate = this.dfBeginDate.getDate();
        Time beginTime = new Time(this.tfBeginTime.getTime());
        DateTime begin = new DateTime(beginDate, beginTime);
        Date endDate = this.dfEndDate.getDate();
        Time endTime = new Time(this.tfEndTime.getTime());
        DateTime end = new DateTime(endDate, endTime);
        this.searchOptions.setBeginTime(begin);
        this.searchOptions.setEndTime(end);
        AbstractPanel.logger.finer("(): Done");
    }
}

