/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.editors;

import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.table.TableCellRenderingHelper;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AdminStateTableCellEditorRenderer
extends JMPanel
implements TableCellRenderer,
TableCellEditor {
    private JMCheckBox cbxAdminState;
    private ArrayList<CellEditorListener> listeners;
    private ChangeEvent changeEvent = new ChangeEvent(this);

    public AdminStateTableCellEditorRenderer() {
        super(new FlowLayout(1, 0, 0));
        this.cbxAdminState = new JMCheckBox();
        this.add(this.cbxAdminState);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.cbxAdminState.isSelected()) {
            return DPEnumerations.ADMIN_STATE[0];
        }
        return DPEnumerations.ADMIN_STATE[1];
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        if (CollectionUtility.isNotEmpty(this.listeners)) {
            ArrayList<CellEditorListener> listenerCopy = new ArrayList<CellEditorListener>(this.listeners);
            for (CellEditorListener listener : listenerCopy) {
                listener.editingStopped(this.changeEvent);
            }
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        if (CollectionUtility.isNotEmpty(this.listeners)) {
            ArrayList<CellEditorListener> listenerCopy = new ArrayList<CellEditorListener>(this.listeners);
            for (CellEditorListener listener : listenerCopy) {
                listener.editingCanceled(this.changeEvent);
            }
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        if (l == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        if (l == null || this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setCBXValue(value);
        TableCellRenderingHelper.renderComponent(this, isSelected, row);
        TableCellRenderingHelper.renderComponentColors(this.cbxAdminState, isSelected, row);
        this.cbxAdminState.setBorder(this.getBorder());
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setCBXValue(value);
        TableCellRenderingHelper.renderComponent(this, isSelected, row);
        TableCellRenderingHelper.renderComponentColors(this.cbxAdminState, isSelected, row);
        this.cbxAdminState.setBorder(this.getBorder());
        return this;
    }

    private void setCBXValue(Object value) {
        block10: {
            String sValue;
            if (value == null || !(value instanceof String)) break block10;
            switch (sValue = (String)value) {
                case "enabled": {
                    this.cbxAdminState.setSelected(true);
                    break;
                }
                case "disabled": {
                    this.cbxAdminState.setSelected(false);
                }
            }
        }
    }
}

