/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.panels.users;

import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.kumbasoft.core.beans.config.ConfigUser;
import com.kumbasoft.core.ui.AbstractCRUDPanel;
import com.kumbasoft.core.ui.panels.users.AbstractCRUDPopupMenu;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JSeparator;

public class ManageUsersPopupMenu
extends AbstractCRUDPopupMenu<ConfigUser> {
    public ManageUsersPopupMenu(AbstractCRUDPanel<ConfigUser> eventTarget, JMTable displayTable, JMScrollPane emptyTableClient) {
        super(eventTarget, displayTable, emptyTableClient);
        this.addMenuItem("Add User", eventTarget, "fileNew");
        this.addMenuItem("Save Changes", eventTarget, "fileSave");
        this.add(new JSeparator());
        this.addMenuItem("Force Password Change...", eventTarget, "forcePasswordChange");
        this.addMenuItem("Reset Failed Login...", eventTarget, "resetFailedLogin");
        this.addMenuItem("Change Password...", eventTarget, "changePassword");
        this.add(new JSeparator());
        this.addMenuItem("Disconnect User Sessions...", eventTarget, "disconnectUser");
        this.add(new JSeparator());
        this.addMenuItem("Delete...", eventTarget, "editDelete");
        this.setEnabled(true);
    }

    @Override
    public boolean isPopupReady() {
        ArrayList selectedUsers = this.objectManagementPanel.getSelectedValues();
        boolean isEmpty = CollectionUtility.isEmpty(selectedUsers);
        PropertyValueSelector adminSelector = new PropertyValueSelector(selectedUsers);
        adminSelector.addPropertyValueMap("name", "admin");
        Collection adminUsers = adminSelector.getSelectedElements();
        boolean allAdminUsers = adminUsers.size() == selectedUsers.size();
        this.setMenuItemEnabled("(force|change|disconnect|delete).*", !allAdminUsers && !isEmpty);
        this.setMenuItemEnabled("reset.*", !isEmpty);
        this.setMenuItemEnabled("save.*", !isEmpty && !allAdminUsers && this.objectManagementPanel.isDirty());
        return true;
    }
}

