/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.ui.renderers;

import com.jmorgan.swing.JMLabel;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.renderers.AbstractListCellValueRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.UIManager;

public class LogTargetListCellValueRenderer
extends AbstractListCellValueRenderer {
    private JMLabel lblName = new JMLabel();
    private JMLabel lblEnabled = new JMLabel("0/0", 4);
    private Index<String, StatusObjectStatus> logTargetIndexByName;
    private PropertyValueSelector<StatusObjectStatus> selector;

    public LogTargetListCellValueRenderer() {
        this.add((Component)this.lblName, "Center");
        this.add((Component)this.lblEnabled, "East");
        this.selector = new PropertyValueSelector(new ArrayList());
        this.selector.addPropertyValueMap("adminState", "enabled");
    }

    public void setLogTargetIndexByName(Index<String, StatusObjectStatus> logTargetIndexByName) {
        this.logTargetIndexByName = logTargetIndexByName;
    }

    @Override
    public void renderValueToComponent(Object value, boolean isSelected) {
        Collection<StatusObjectStatus> logTargets = null;
        String logTargetName = null;
        this.lblName.setFont(UIManager.getFont("Label.font"));
        this.lblEnabled.setFont(UIManager.getFont("Label.font"));
        try {
            if (value == null) {
                return;
            }
            logger.finest(() -> LMG.log("(value=%s, isSelected=%b): Starting", () -> value.toString(), () -> isSelected));
            logTargetName = value.toString();
            String logTargetsToFind = logTargetName.equals("audit-log") ? "AuditLog-Settings" : logTargetName;
            logTargets = this.logTargetIndexByName.get(logTargetsToFind);
            if (logTargets == null) {
                return;
            }
        }
        finally {
            this.lblName.setText("");
            this.lblEnabled.setText("");
        }
        this.selector.setCollection(logTargets);
        Collection enabledTargets = this.selector.getSelectedElements();
        int logTargetCount = logTargets.size();
        int enabledCount = enabledTargets.size();
        String countLabel = String.format("%d/%d", enabledCount, logTargetCount);
        this.lblName.setText(logTargetName);
        this.lblEnabled.setText(countLabel);
        double enabledPct = (double)enabledCount / (double)logTargetCount;
        Color foreground = KumbaCoreUIConstants.LIST_UNSELECTED_FOREGROUND;
        Color background = KumbaCoreUIConstants.LIST_UNSELECTED_BACKGROUND;
        if (enabledPct == 0.0) {
            foreground = KumbaCoreUIConstants.APPLIANCE_UNCONNECTED_FOREGROUND;
            background = KumbaCoreUIConstants.APPLIANCE_UNCONNECTED_BACKGROUND;
        } else if (enabledPct < 1.0) {
            foreground = KumbaCoreUIConstants.APPLIANCE_GROUP_PARTIALLY_CONNECTED_FOREGROUND;
            background = KumbaCoreUIConstants.APPLIANCE_GROUP_PARTIALLY_CONNECTED_BACKGROUND;
        }
        if (isSelected) {
            foreground = KumbaCoreUIConstants.LIST_SELECTED_FOREGROUND;
            background = KumbaCoreUIConstants.LIST_SELECTED_BACKGROUND;
        }
        this.lblName.setForeground(foreground);
        this.lblEnabled.setForeground(foreground);
        this.setBackground(background);
        logger.finest(() -> LMG.log("(value=%s, isSelected=%b): Done", () -> value.toString(), () -> isSelected));
    }
}

