/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util;

import com.jmorgan.beans.persistence.DateTimePersistenceDelegate;
import com.jmorgan.io.ASCFileReader;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.io.FileInputStreamHelper;
import com.jmorgan.io.FileOutputStreamHelper;
import com.jmorgan.lang.Application;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.util.security.SecurityManager;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.io.IOUtils;

public final class FileUtility
extends AbstractTool {
    private static boolean initConfigFileExists;
    private static String somaTemplatesDirectory;

    private FileUtility() {
    }

    public static boolean initConfigFileExists() {
        return initConfigFileExists;
    }

    public static ArrayList<Appliance> getInitConfig(String initConfigFileName) {
        File file = new File(initConfigFileName);
        initConfigFileExists = file.exists();
        Cipher cipher = SecurityManager.getCipher(2);
        ArrayList applianceGroups = (ArrayList)FileUtility.readSecureDataFromFile(initConfigFileName, cipher);
        return applianceGroups;
    }

    public static void saveInitConfig(String initConfigFileName, ArrayList<Appliance> appliances) {
        if (CollectionUtility.isEmpty(appliances)) {
            return;
        }
        ArrayList<Appliance> applianceClones = new ArrayList<Appliance>(appliances.size());
        for (Appliance appliance : appliances) {
            Appliance applianceClone = appliance.clone();
            applianceClone.setDomains(null);
            applianceClones.add(applianceClone);
        }
        FileUtility.backupInitConfigFile(initConfigFileName);
        Cipher cipher = SecurityManager.getCipher(1);
        FileUtility.writeSecureDataToFile(initConfigFileName, cipher, applianceClones);
    }

    private static void backupInitConfigFile(String initConfigFileName) {
        com.jmorgan.io.File initConfigFile = new com.jmorgan.io.File(initConfigFileName);
        if (!initConfigFile.exists()) {
            return;
        }
        Date today = new Date();
        today.setFormat(Date.SQL_FORMAT);
        String backupFileName = String.format("%s_%s", today.toString(), initConfigFile.getName());
        File parent = initConfigFile.getParentFile();
        File backupFile = new File(parent, backupFileName);
        try {
            initConfigFile.copyTo(backupFile);
        }
        catch (IOException e) {
            Application.getApplication().getApplicationLogger().config("Unable to make backup of init config file.");
            e.printStackTrace();
        }
    }

    public static String getMimeType(String fileName) {
        String extension;
        String mimeType = "text/plain";
        switch (extension = StringUtility.getNthOfDelimited(fileName, ".")) {
            case "xml": 
            case "xsd": 
            case "xsl": 
            case "wsdl": 
            case "xcfg": 
            case "xslt": {
                mimeType = "text/xml";
                break;
            }
            case "js": 
            case "jsv": {
                mimeType = "text/js";
                break;
            }
            case "swagger": 
            case "properties": 
            case "cfg": 
            case "yaml": {
                mimeType = "text/properties";
                break;
            }
            case "htm": 
            case "html": 
            case "xhtml": {
                mimeType = "text/html";
                break;
            }
            case "binary": {
                mimeType = "application/octet-stream";
                break;
            }
            default: {
                mimeType = "text/plain";
            }
        }
        return mimeType;
    }

    public static void writeSecureData(String fileName, Object data, String password) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', data, password): Starting", () -> fileName));
        }
        char[] exportPassChars = SecurityManager.ensurePasswordLength(password, 32);
        byte[] bytes = SecurityManager.getKeyBytes(SecurityManager.charsToBytes(exportPassChars));
        SecretKeySpec secretKey = new SecretKeySpec(bytes, "AES");
        Cipher cipher = SecurityManager.getCipher(1, secretKey);
        FileUtility.writeSecureDataToFile(fileName, cipher, data);
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', data, password): Done", () -> fileName));
        }
    }

    private static void writeSecureDataToFile(String fileName, Cipher cipher, Object data) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', cipher, data): Starting", () -> fileName));
        }
        FileOutputStreamHelper fout = new FileOutputStreamHelper(fileName);
        fout.open();
        fout.stackStream(new CipherOutputStream((OutputStream)fout.getStream(), cipher));
        XMLEncoder xmlEncoder = new XMLEncoder((OutputStream)fout.getStream());
        xmlEncoder.writeObject(data);
        xmlEncoder.flush();
        xmlEncoder.close();
        if (!fout.close()) {
            String errorMessage = String.format("(fileName=%s, data, password):  Error writing secure data.\n%s\n", fileName, fout.getException().getMessage());
            Application.getApplication().getApplicationLogger().severe(errorMessage);
            fout.getException().printStackTrace();
        }
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', cipher, data): Done", () -> fileName));
        }
    }

    public static <T> T readSecureData(String fileName, String password) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', password): Starting", () -> fileName));
        }
        char[] importPassChars = SecurityManager.ensurePasswordLength(password, 32);
        byte[] bytes = SecurityManager.getKeyBytes(SecurityManager.charsToBytes(importPassChars));
        SecretKeySpec secretKey = new SecretKeySpec(bytes, "AES");
        Cipher cipher = SecurityManager.getCipher(2, secretKey);
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', password): Done", () -> fileName));
        }
        return FileUtility.readSecureDataFromFile(fileName, cipher);
    }

    public static <T> T readSecureDataFromFile(String fileName, Cipher cipher) {
        FileInputStreamHelper fin;
        InputStream inputStream;
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', cipher): Starting", () -> fileName));
        }
        if ((inputStream = (fin = new FileInputStreamHelper(fileName)).open()) == null) {
            if (logger != null) {
                logger.warning(() -> LMG.log("(fileName='%s', cipher): File invalid or does not exist.", () -> fileName));
            }
            return null;
        }
        fin.stackStream(new CipherInputStream(inputStream, cipher));
        try {
            byte[] data = ((InputStream)fin.getStream()).readAllBytes();
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            XMLDecoder xmlDecoder = new XMLDecoder(bin);
            ArrayList applianceGroups = (ArrayList)xmlDecoder.readObject();
            xmlDecoder.close();
            if (logger != null) {
                logger.finer(() -> LMG.log("(fileName='%s', cipher): Done", () -> fileName));
            }
            ArrayList arrayList = applianceGroups;
            return (T)arrayList;
        }
        catch (IOException ioe) {
            if (logger != null) {
                logger.severe(() -> LMG.log("(fileName='%s', cipher): Incorrect credentials provided.", () -> fileName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            fin.close();
        }
        if (logger != null) {
            logger.info(() -> LMG.log("(fileName='%s', cipher): Failed.  Returrning null.", () -> fileName));
        }
        return null;
    }

    public static String getSOMATemplateFileName(String fileName) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s'): Starting", () -> fileName));
        }
        if (somaTemplatesDirectory == null) {
            Application application = Application.getApplication();
            KumbaCoreApplicationProperties dpaaApplicationProperties = (KumbaCoreApplicationProperties)application.getApplicationProperties();
            somaTemplatesDirectory = dpaaApplicationProperties.getSomaTemplatesDirectory();
        }
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s'): Done", () -> fileName));
        }
        return String.format("%s/%s", somaTemplatesDirectory, fileName);
    }

    public static boolean writeFile(File file, String fileContents) throws IOException {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', fileContents): Starting", () -> file.getAbsolutePath()));
        }
        try {
            new ASCFileWriter(file, fileContents);
        }
        catch (IOException ioe) {
            if (logger != null) {
                logger.severe(() -> LMG.log("(fileName='%s', fileContents): Failed:\n%s", () -> file.getAbsolutePath(), () -> ioe.getMessage()));
            }
            return false;
        }
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', fileContents): Done", () -> file.getAbsolutePath()));
        }
        return true;
    }

    public static boolean writeFile(String fileName, String fileContents) throws IOException {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', fileContents): Starting", () -> fileName));
        }
        File file = new File(fileName);
        boolean result = FileUtility.writeFile(file, fileContents);
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', fileContents): Done.  Result = %b", () -> fileName, () -> result));
        }
        return result;
    }

    public static boolean writeFile(File file, byte[] fileData) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s', fileData): Starting", () -> file.getAbsolutePath()));
        }
        boolean successful = true;
        try {
            FileOutputStreamHelper fout = new FileOutputStreamHelper(file);
            fout.open();
            BufferedOutputStream bout = (BufferedOutputStream)fout.getStream();
            bout.write(fileData);
            fout.close();
        }
        catch (IOException e) {
            if (logger != null) {
                logger.severe(() -> LMG.log("(file='%s', fileData): Failed with\n%s", () -> file.getAbsolutePath(), () -> e.getMessage()));
            }
            successful = false;
            e.printStackTrace();
        }
        boolean s = successful;
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s', fileData): Done:  Returning %b", () -> file.getAbsolutePath(), () -> s));
        }
        return successful;
    }

    public static String readFile(File file) throws IOException {
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s'): Starting", () -> file.getAbsolutePath()));
        }
        ASCFileReader reader = new ASCFileReader(file);
        String fileContents = reader.readAll();
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s'): Done.  Read %d bytes.", () -> file.getAbsolutePath(), () -> fileContents.length()));
        }
        return fileContents;
    }

    public static String readFile(String fileName) throws IOException {
        String fixedFileName;
        String resourceFileName;
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s'): Starting", () -> fileName));
        }
        if ((resourceFileName = (fixedFileName = StringUtility.coalesce(fileName, "/"))).startsWith("./")) {
            resourceFileName = resourceFileName.substring(1);
        } else if (!resourceFileName.startsWith("/")) {
            resourceFileName = String.format("/%s", resourceFileName);
        }
        InputStream in = FileUtility.class.getResourceAsStream(resourceFileName);
        if (in != null) {
            StringBuilder sb = new StringBuilder();
            int ch = in.read();
            while (ch != -1) {
                sb.append((char)ch);
                ch = in.read();
            }
            if (logger != null) {
                logger.finer(() -> LMG.log("(fileName='%s'): Successfully read file as resource.", () -> fileName));
            }
            return sb.toString();
        }
        if (logger != null) {
            String rfn = resourceFileName;
            logger.severe(() -> LMG.log("(fileName=%s):  Cannot read file as a resource.\n", () -> rfn));
        }
        File file = new File(fixedFileName);
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s'): Done", () -> fixedFileName));
        }
        return FileUtility.readFile(file);
    }

    public static String readAsBase64(String fileName) throws IOException {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s'): Starting", () -> fileName));
        }
        File file = new File(fileName);
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s'): Done", () -> fileName));
        }
        return FileUtility.readAsBase64(file);
    }

    public static String readAsBase64(File file) throws IOException {
        long fileLength;
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s'): Starting", () -> file.getAbsolutePath()));
        }
        if ((fileLength = file.length()) < 0x100000L) {
            if (logger != null) {
                logger.finer(() -> LMG.log("(file='%s'): Reading as a small file with length %d", () -> file.getAbsolutePath(), () -> fileLength));
            }
            return FileUtility.readAsBase64Small(file);
        }
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s'): Reading as a large file with length %d", () -> file.getAbsolutePath(), () -> fileLength));
        }
        return FileUtility.readAsBase64Large(file);
    }

    private static String readAsBase64Small(File file) throws IOException {
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s'): Starting", () -> file.getAbsolutePath()));
        }
        FileInputStream fin = new FileInputStream(file);
        byte[] binaryContent = new byte[(int)file.length()];
        fin.read(binaryContent);
        fin.close();
        byte[] base64Content = Base64.encodeBase64(binaryContent);
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s'): Done", () -> file.getAbsolutePath()));
        }
        return new String(base64Content);
    }

    private static String readAsBase64Large(File file) throws IOException {
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s'): Starting", () -> file.getAbsolutePath()));
        }
        FileInputStream fin = new FileInputStream(file);
        BufferedInputStream bin = new BufferedInputStream(fin, KumbaCoreConstants.FILE_READ_BUFFER_SIZE);
        File tempFile = File.createTempFile("FileUtility", file.getName());
        FileOutputStreamHelper fout = new FileOutputStreamHelper(tempFile);
        fout.open();
        fout.stackStream(new Base64OutputStream((OutputStream)fout.getStream()));
        IOUtils.copy((InputStream)bin, (OutputStream)fout.getStream());
        fin.close();
        bin.close();
        fout.close();
        fin = null;
        bin = null;
        fout = null;
        StringBuilder sb = new StringBuilder();
        FileReader fr = new FileReader(tempFile);
        BufferedReader br = new BufferedReader(fr, KumbaCoreConstants.FILE_READ_BUFFER_SIZE);
        char[] buffer = new char[KumbaCoreConstants.FILE_READ_BUFFER_SIZE];
        int numRead = br.read(buffer);
        while (numRead > 0) {
            sb.append(buffer);
            numRead = br.read(buffer);
        }
        br.close();
        fr.close();
        buffer = null;
        tempFile.delete();
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s'): Done", () -> file.getAbsolutePath()));
        }
        return sb.toString();
    }

    public static void deleteFiles(File directory, String extension) {
        File[] files;
        if (logger != null) {
            logger.finer(() -> LMG.log("(directory='%s', extension='%s'): Starting", () -> directory.getAbsolutePath(), () -> extension));
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (fileName.endsWith(extension)) {
                if (logger != null) {
                    logger.info(() -> LMG.log("(directory='%s', extension='%s'): Deleting file '%s'", () -> directory.getAbsolutePath(), () -> extension, () -> fileName));
                }
                file.delete();
            }
            ++n2;
        }
        if (logger != null) {
            logger.finer(() -> LMG.log("(directory='%s', extension='%s'): Done", () -> directory.getAbsolutePath(), () -> extension));
        }
    }

    public static final <T> T readObject(File file, ExceptionListener exceptionListener) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s', exceptionListener):  Reached.", () -> file.getAbsolutePath()));
        }
        return FileUtility.readObject(file.getAbsolutePath(), exceptionListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final <T> T readObject(String fileName, ExceptionListener exceptionListener) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', exceptionListener):  Starting.", () -> fileName));
        }
        InputStream in = null;
        FileInputStreamHelper fin = null;
        Logger logger = Application.getApplication().getApplicationLogger();
        try {
            in = FileUtility.class.getResourceAsStream(fileName);
            if (in == null) {
                InputStream inputStream;
                if (logger != null) {
                    logger.info(() -> LMG.log("(fileName='%s', exceptionListener):  Failed, cannot read as a resource.", () -> fileName));
                }
                if ((inputStream = (fin = new FileInputStreamHelper(fileName, KumbaCoreConstants.FILE_READ_BUFFER_SIZE)).open()) == null) {
                    if (logger != null) {
                        logger.severe(() -> LMG.log("(fileName='%s', exceptionListener):  Failed, cannot read as a file.", () -> fileName));
                    }
                    return null;
                }
                in = (InputStream)fin.getStream();
            }
            XMLDecoder decoder = new XMLDecoder(in);
            Object o = decoder.readObject();
            decoder.close();
            if (fin != null) {
                fin.close();
            }
            if (logger != null) {
                logger.finer(() -> LMG.log("(fileName='%s', errorMessageTitle):  Done.", () -> fileName));
            }
            return (T)o;
        }
        catch (Exception e) {
            if (exceptionListener != null) {
                exceptionListener.exceptionThrown(e);
            }
            if (logger != null) {
                logger.info(() -> LMG.log("(fileName='%s', errorMessageTitle):  Done.  Failed.", () -> fileName));
            }
            return null;
        }
    }

    public static final <T> T readObject(String fileName, boolean isCompressed) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', isCompressed=%b):  Reached.", () -> fileName, () -> isCompressed));
        }
        return FileUtility.readObject(new File(fileName), isCompressed);
    }

    public static final <T> T readObject(File file, boolean isCompressed) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s', isCompressed=%b):  Starting.", () -> file.getAbsolutePath(), () -> isCompressed));
        }
        if (!file.exists()) {
            if (logger == null) {
                System.out.printf("FileUtility.readObject(file=%s, isCompressed=%b):  File does not exist.\n", file.getAbsolutePath(), isCompressed);
            } else {
                logger.info(() -> LMG.log("(file='%s', isCompressed=%b):  File does not exist.  Returning null.", () -> file.getAbsolutePath(), () -> isCompressed));
            }
            return null;
        }
        InputStream in = null;
        FileInputStreamHelper fin = null;
        try {
            fin = new FileInputStreamHelper(file, KumbaCoreConstants.FILE_READ_BUFFER_SIZE);
            fin.open();
            if (isCompressed) {
                fin.stackStream(new GZIPInputStream((InputStream)fin.getStream()));
            }
            in = (InputStream)fin.getStream();
            XMLDecoder decoder = new XMLDecoder(in);
            Object o = decoder.readObject();
            decoder.close();
            if (fin != null) {
                fin.close();
            }
            if (logger != null) {
                logger.finer(() -> LMG.log("(file='%s', isCompressed=%b):  Done.", () -> file.getAbsolutePath(), () -> isCompressed));
            }
            return (T)o;
        }
        catch (Exception e) {
            if (logger != null) {
                logger.severe(() -> LMG.log("(file='%s', isCompressed=%b):  Unable to read file.\n%s", () -> file.getAbsolutePath(), () -> isCompressed, () -> e.getMessage()));
            } else {
                System.out.printf("FileUtility.readObject(file=%s, isCompressed=%b):  Unable to read file.\n%s\n", file.getAbsolutePath(), isCompressed, e.getMessage());
            }
            e.printStackTrace();
            if (logger != null) {
                logger.severe(() -> LMG.log("(file='%s', isCompressed=%b):  Failed reading object.  Returning NULL.", () -> file.getAbsolutePath(), () -> isCompressed));
            } else {
                System.out.printf("FileUtility.readObject(file=%s, isCompressed=%b):  Failed reading object.  Returning NULL.\n", file.getAbsolutePath(), isCompressed);
            }
            return null;
        }
    }

    public static final void writeObject(String fileName, Object object) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', object):  Reached.", () -> fileName));
        }
        FileUtility.writeObject(fileName, object, false);
    }

    public static final void writeObject(String fileName, Object object, boolean compress) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s', object, compress=%b):  Reached.", () -> fileName, () -> compress));
        }
        FileUtility.writeObject(new File(fileName), object, compress);
    }

    public static void writeObject(File file, Object object) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s', object):  Reached.", () -> file.getAbsolutePath()));
        }
        FileUtility.writeObject(file, object, false);
    }

    public static final void writeObject(File file, Object object, boolean compress) {
        FileOutputStreamHelper fout;
        OutputStream out;
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s', object, compress=%b):  Starting.", () -> file.getAbsolutePath(), () -> compress));
        }
        if ((out = (fout = new FileOutputStreamHelper(file, 32768)).open()) == null) {
            IOException ioe = fout.getException();
            if (logger != null) {
                logger.severe(() -> LMG.log("(file='%s', object, compress=%b):  Exception opening file\n%s.", () -> file.getAbsolutePath(), () -> compress, () -> ioe.getMessage()));
            }
            return;
        }
        if (compress) {
            if (logger != null) {
                logger.finer(() -> LMG.log("(file='%s', object, compress=%b):  Compressing output.", () -> file.getAbsolutePath(), () -> compress));
            }
            try {
                fout.stackStream(new GZIPOutputStream((OutputStream)fout.getStream()));
            }
            catch (IOException e) {
                if (logger != null) {
                    logger.severe(() -> LMG.log("(file='%s', object, compress=%b):  IOException building compressed output stream\n%s.", () -> file.getAbsolutePath(), () -> compress, () -> e.getMessage()));
                }
                e.printStackTrace();
            }
        }
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s', object, compress=%b):  Building output encoder.", () -> file.getAbsolutePath(), () -> compress));
        }
        XMLEncoder xmlEncoder = new XMLEncoder((OutputStream)fout.getStream());
        xmlEncoder.setPersistenceDelegate(DateTime.class, new DateTimePersistenceDelegate());
        xmlEncoder.writeObject(object);
        xmlEncoder.flush();
        xmlEncoder.close();
        if (!fout.close() && logger != null) {
            logger.severe(() -> LMG.log("(file='%s', object, compress=%b):  Error writing file.", () -> file.getAbsolutePath(), () -> compress));
        }
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s', object, compress=%b):  Done.", () -> file.getAbsolutePath(), () -> compress));
        }
    }

    public static void ensureDirectoriesExist(String fileName) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(fileName='%s'):  Reached.", () -> fileName));
        }
        FileUtility.ensureDirectoriesExist(new File(fileName));
    }

    public static void ensureDirectoriesExist(File file) {
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s'):  Starting.", () -> file.getAbsolutePath()));
        }
        File absoluteFile = file.getAbsoluteFile();
        String fileName = file.getName();
        int dotPos = fileName.indexOf(46);
        if (absoluteFile.isDirectory() || dotPos == -1) {
            if (!absoluteFile.exists()) {
                absoluteFile.mkdirs();
            }
        } else {
            File parent = absoluteFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
        }
        if (logger != null) {
            logger.finer(() -> LMG.log("(file='%s'):  Done.", () -> file.getAbsolutePath()));
        }
    }

    public static boolean isText(byte[] fileBytes) {
        if (logger != null) {
            logger.finer("(fileBytes): Starting");
        }
        if (ArrayUtility.isEmpty(fileBytes)) {
            if (logger != null) {
                logger.finer("(fileBytes): fileBytes is empty.  Thinking no.");
            }
            return false;
        }
        double nonAsc = 0.0;
        byte[] byArray = fileBytes;
        int n = fileBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b < 9 || b > 13 && b < 32) {
                nonAsc += 1.0;
            }
            ++n2;
        }
        double pct = nonAsc / (double)fileBytes.length * 100.0;
        if (pct > 10.0) {
            if (logger != null) {
                logger.finer("(fileBytes): Percentage of non-ASC characters is greater than 10%.  Thinking not.");
            }
            return false;
        }
        if (logger != null) {
            logger.finer("(fileBytes): Yes, this is most likely a text file.  Done");
        }
        return true;
    }
}

