/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.logging;

import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.util.logging.AbstractLogRecord;
import java.util.function.Supplier;
import java.util.logging.Level;

public class AuditLogRecord
extends AbstractLogRecord {
    private String licensedUser;
    private String applicationUser;
    private String applianceXMLManagementUser;
    private String applianceSSHManagementUser;

    public AuditLogRecord(Appliance appliance, Domain domain, String message) {
        super(Level.CONFIG, appliance, domain, message);
        this.applianceXMLManagementUser = new String(appliance.getXmlManagementUserName());
        this.applianceSSHManagementUser = new String(appliance.getSshManagementUserName());
    }

    public AuditLogRecord(Appliance appliance, Domain domain, Supplier<String> messageSupplier) {
        super(Level.CONFIG, appliance, domain, messageSupplier);
    }

    public String getApplianceXMLManagementUser() {
        return this.applianceXMLManagementUser;
    }

    public String getApplianceSSHManagementUser() {
        return this.applianceSSHManagementUser;
    }

    public String getLicensedUser() {
        return this.licensedUser;
    }

    public void setLicensedUser(String licensedUser) {
        this.licensedUser = licensedUser;
    }

    public String getApplicationUser() {
        return this.applicationUser;
    }

    public void setApplicationUser(String applicationUser) {
        this.applicationUser = applicationUser;
    }
}

