/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.logging;

import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.Application;
import com.jmorgan.util.logging.StandardLogFormatter;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.util.logging.FinestLogRecord;
import java.io.File;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class FinestLogHandler
extends Handler {
    private static File debugDirectory;

    static {
        KumbaCoreApplicationProperties appProperties = (KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties();
        String debuggingDirectoryName = appProperties.getDebuggingDirectory();
        debugDirectory = new File(debuggingDirectoryName);
    }

    public FinestLogHandler() {
        this.setLevel(Level.FINEST);
        this.setFormatter(new StandardLogFormatter());
        Application.getApplication().getApplicationLogger().addHandler(this);
    }

    @Override
    public void publish(LogRecord record) {
        if (record == null) {
            return;
        }
        if (record instanceof FinestLogRecord) {
            FinestLogRecord finestLogRecord = (FinestLogRecord)record;
            Appliance appliance = finestLogRecord.getAppliance();
            Domain domain = finestLogRecord.getDomain();
            String sourceClassName = finestLogRecord.getSourceClassName();
            String sourceMethodName = finestLogRecord.getSourceMethodName();
            String outputDirectoryName = String.format("%s%s%s%s%s%s%s", appliance.getName(), File.separator, domain.getName(), File.separator, sourceClassName, File.separator, sourceMethodName);
            File outputDirectory = new File(debugDirectory, outputDirectoryName);
            outputDirectory.mkdirs();
            long threadID = finestLogRecord.getLongThreadID();
            long sequenceNumber = finestLogRecord.getSequenceNumber();
            long time = finestLogRecord.getMillis();
            String outputFileName = String.format("Thread(%d)-Sequence(%d)-Time(%d).log", threadID, sequenceNumber, time);
            File outputFile = new File(outputDirectory, outputFileName);
            try {
                new ASCFileWriter(outputFile, record.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.getFormatter().format(record);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

