/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.logging;

import com.kumbasoft.core.util.logging.AbstractSocketSender;
import com.kumbasoft.core.util.logging.SyslogRecord;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.BlockingQueue;

class UdpSender
extends AbstractSocketSender {
    private DatagramSocket socket = null;
    private InetAddress address = null;

    public UdpSender(String hostName, int port, BlockingQueue<SyslogRecord> blockingQueue) {
        super(hostName, port, blockingQueue);
    }

    @Override
    protected boolean initialize() {
        try {
            if (this.socket == null) {
                this.address = InetAddress.getByName(this.hostName);
                this.socket = new DatagramSocket();
            }
        }
        catch (SocketException | UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected void sendMessage(SyslogRecord record) throws IOException, Throwable {
        String syslogMessage = record.getSyslogMessage();
        DatagramPacket packet = new DatagramPacket(syslogMessage.getBytes(), syslogMessage.length(), this.address, this.port);
        this.socket.send(packet);
    }

    @Override
    protected void cleanup() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Throwable t) {
            this.socket = null;
        }
    }
}

