/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.copymoveWizard;

import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CopyMoveActionBean;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.CopyMoveObjectBean;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListModel;

public class CopyMoveDomainsPage
extends KumbaCoreWizardPage<CopyMoveActionBean> {
    private JMListModel<String> domainListModel;
    private JMList<String> domainList;

    public CopyMoveDomainsPage(CopyMoveActionBean model) {
        super(model);
    }

    public CopyMoveDomainsPage(CopyMoveActionBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean doesPageApply() {
        CopyMoveObjectBean model;
        CopyMoveActionBean copyMoveActionBean = (CopyMoveActionBean)this.model;
        return !(copyMoveActionBean instanceof CopyMoveObjectBean) || !(model = (CopyMoveObjectBean)copyMoveActionBean).duplicateDestinationDomains();
    }

    @Override
    protected void saveDataToModel() {
        ((CopyMoveActionBean)this.model).clearDestinationDomains();
        List selectedDomains = this.domainList.getSelectedValuesList();
        for (String domain : selectedDomains) {
            ((CopyMoveActionBean)this.model).addDestinationDomain(domain);
        }
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        JMLabel label = new JMLabel("Destination Domains");
        panel.add((Component)label, "North");
        this.domainListModel = new JMListModel();
        this.domainList = new JMList<String>((ListModel<String>)this.domainListModel);
        this.domainList.setSelectionMode(2);
        panel.add((Component)new JMScrollPane(this.domainList), "Center");
        ArrayList<String> selectedDomains = ((CopyMoveActionBean)this.model).getDestinationDomains();
        if (!CollectionUtility.isEmpty(selectedDomains)) {
            for (Domain domain : selectedDomains) {
                String domainName = domain.getName();
                this.domainList.setSelectedValue(domainName, false);
            }
        }
        return panel;
    }

    @Override
    protected void updateControls() {
        ArrayList<Appliance> selectedAppliances = ((CopyMoveActionBean)this.model).getDestinationAppliances();
        UniqueArrayList<String> domainNames = new UniqueArrayList<String>();
        for (Appliance appliance : selectedAppliances) {
            ArrayList<Domain> domains = appliance.getDomains();
            for (Domain domain : domains) {
                domainNames.add(domain.getName());
            }
        }
        Collections.sort(domainNames);
        this.domainListModel.clear();
        this.domainListModel.addAll(domainNames);
    }
}

