/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.copymoveWizard;

import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.CopyMoveObjectBean;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.CopyMoveObjectsS2DBean;
import java.awt.Component;
import java.util.ArrayList;

public class CopyMoveObjectsFinalPage
extends KumbaCoreWizardPage<CopyMoveObjectBean> {
    private BeanTableModel<CopyMoveObjectsS2DBean> tableModel;
    private BeanColumnModel<CopyMoveObjectsS2DBean> columnModel;
    private JMTable table;

    public CopyMoveObjectsFinalPage(CopyMoveObjectBean model) {
        super(model);
    }

    public CopyMoveObjectsFinalPage(CopyMoveObjectBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    protected void saveDataToModel() {
        ((CopyMoveObjectBean)this.model).clearDestinationObjects();
        ArrayList sourceObjects = ((CopyMoveObjectBean)this.model).getObjects();
        ArrayList<CopyMoveObjectsS2DBean> finalObjects = this.tableModel.getModelData();
        for (CopyMoveObjectsS2DBean s2dBean : finalObjects) {
            for (StatusObjectStatus sourceObject : sourceObjects) {
                if (!sourceObject.getAppliance().equals(s2dBean.getSourceAppliance()) || !sourceObject.getSourceDomain().equals(s2dBean.getSourceDomain()) || !sourceObject.getDataPowerClass().equals(s2dBean.getDataPowerClass()) || !sourceObject.getName().equals(s2dBean.getObjectName())) continue;
                StatusObjectStatus destObject = new StatusObjectStatus();
                destObject.setAppliance(s2dBean.getDestinationAppliance());
                destObject.setSourceDomain(s2dBean.getDestinationDomain());
                destObject.setDataPowerClass(s2dBean.getDataPowerClass());
                destObject.setName(s2dBean.getObjectName());
                ((CopyMoveObjectBean)this.model).addSourceToDestination(sourceObject, destObject);
            }
        }
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        int mode = ((CopyMoveObjectBean)this.model).getMode();
        String labelText = (mode == 0 ? "Copy" : "Move") + " Objects";
        this.tableModel = new BeanTableModel<CopyMoveObjectsS2DBean>(CopyMoveObjectsS2DBean.class);
        this.columnModel = new BeanColumnModel<CopyMoveObjectsS2DBean>(this.tableModel);
        this.columnModel.setColumnOrder("sourceAppliance", "sourceDomain", "dataPowerClass", "objectName", "destinationAppliance", "destinationDomain");
        this.columnModel.setColumnTitle("dataPowerClass", "Type");
        this.columnModel.setColumnTitle("objectName", "Name");
        this.tableModel.setValueExpression("sourceAppliance", "name");
        this.tableModel.setValueExpression("sourceDomain", "name");
        this.tableModel.setValueExpression("destinationAppliance", "name");
        this.tableModel.setValueExpression("destinationDomain", "name");
        this.table = new JMTable(this.tableModel, this.columnModel);
        JMScrollPane scrollPane = new JMScrollPane(this.table);
        LabeledComponent cpLabel = new LabeledComponent(labelText, (Component)scrollPane, 1);
        panel.add((Component)cpLabel, "Center");
        return panel;
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void updateControls() {
        this.tableModel.reset();
        ArrayList sourceObjects = ((CopyMoveObjectBean)this.model).getObjects();
        ArrayList<Appliance> destAppliances = ((CopyMoveObjectBean)this.model).getDestinationAppliances();
        boolean duplicateSourceDomains = ((CopyMoveObjectBean)this.model).duplicateDestinationDomains();
        if (duplicateSourceDomains) {
            for (StatusObjectStatus sourceObject : sourceObjects) {
                Domain destDomain = sourceObject.getSourceDomain();
                for (Appliance appliance : destAppliances) {
                    ArrayList<Domain> domains = appliance.getDomains();
                    if (!domains.contains(destDomain)) continue;
                    CopyMoveObjectsS2DBean destObject = new CopyMoveObjectsS2DBean();
                    destObject.setSourceAppliance(sourceObject.getAppliance());
                    destObject.setSourceDomain(sourceObject.getSourceDomain());
                    destObject.setDestinationAppliance(appliance);
                    destObject.setDestinationDomain(sourceObject.getSourceDomain());
                    destObject.setDataPowerClass(sourceObject.getDataPowerClass());
                    destObject.setObjectName(sourceObject.getName());
                    this.tableModel.addRow(destObject);
                }
            }
        } else {
            ArrayList<String> destDomains = ((CopyMoveObjectBean)this.model).getDestinationDomains();
            for (StatusObjectStatus sourceObject : sourceObjects) {
                for (Appliance appliance : destAppliances) {
                    for (String destDomain : destDomains) {
                        Domain domain = appliance.getDomain(destDomain, true);
                        if (domain == null) continue;
                        CopyMoveObjectsS2DBean destObject = new CopyMoveObjectsS2DBean();
                        destObject.setSourceAppliance(sourceObject.getAppliance());
                        destObject.setSourceDomain(sourceObject.getSourceDomain());
                        destObject.setDestinationAppliance(appliance);
                        destObject.setDestinationDomain(domain);
                        destObject.setDataPowerClass(sourceObject.getDataPowerClass());
                        destObject.setObjectName(sourceObject.getName());
                        this.tableModel.addRow(destObject);
                    }
                }
            }
        }
        this.table.optimizeColumnWidths();
    }
}

