/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.createLogTargetWizard;

import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.config.ConfigLogTarget;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.LogEvent;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.ListModel;

public class LogTargetBasicsPage
extends KumbaCoreWizardPage<ConfigLogTarget> {
    private JMTextField tfName;
    private JMRadioButton rbText;
    private JMRadioButton rbXML;
    private JMListModel<String> logLevelListModel;
    private JMList<String> logLevelList;

    public LogTargetBasicsPage(ConfigLogTarget model) {
        super(model);
    }

    public LogTargetBasicsPage(ConfigLogTarget model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isDataValid() {
        if (StringUtility.isEmpty(this.tfName.getText())) {
            new JMMessageBox((JDialog)this.parentDialog, "Name is empty", "Please enter a valid name for the logging target.");
            return false;
        }
        if (!ConfigurationManager.isObjectNameValid(this.tfName.getText())) {
            new JMMessageBox((JDialog)this.parentDialog, "Invalid Log Target Name", ConfigurationManager.getStandardInvalidObjectNameMessage("logging target"));
            return false;
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        ((ConfigLogTarget)this.model).setName(this.tfName.getText());
        if (this.rbText.isSelected()) {
            ((ConfigLogTarget)this.model).setFormat("text");
        } else {
            ((ConfigLogTarget)this.model).setFormat("xml");
        }
        String logLevel = this.logLevelList.getSelectedItem();
        ArrayList<LogEvent> logEvents = ((ConfigLogTarget)this.model).getLogEvents();
        Iterator<LogEvent> iterator = logEvents.iterator();
        if (iterator.hasNext()) {
            LogEvent logEvent = iterator.next();
            logEvent.setPriority(logLevel);
        }
    }

    @Override
    protected void updateControls() {
        this.tfName.setText(((ConfigLogTarget)this.model).getName());
        switch (((ConfigLogTarget)this.model).getFormat()) {
            case "text": {
                this.rbText.setSelected(true);
                this.rbXML.setSelected(false);
                break;
            }
            case "xml": {
                this.rbText.setSelected(false);
                this.rbXML.setSelected(true);
            }
        }
        ArrayList<LogEvent> logEvents = ((ConfigLogTarget)this.model).getLogEvents();
        Iterator<LogEvent> iterator = logEvents.iterator();
        if (iterator.hasNext()) {
            LogEvent logEvent = iterator.next();
            this.logLevelList.setSelectedValue(logEvent.getPriority(), true);
        }
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createVerticalFlowLayout(0));
        this.tfName = new JMTextField();
        LabeledComponent lblName = new LabeledComponent("Log Target Name:", (Component)this.tfName, 125, 300);
        this.rbText = new JMRadioButton("Text", true);
        this.rbXML = new JMRadioButton("XML");
        new JMButtonGroup(this.rbText, this.rbXML);
        JMPanel rbPanel = new JMPanel(new VerticalFlowLayout(0, 5));
        rbPanel.addAll(this.rbText, this.rbXML);
        this.logLevelListModel = new JMListModel((Comparable[])DPEnumerations.LOG_LEVEL);
        this.logLevelList = new JMList<String>((ListModel<String>)this.logLevelListModel);
        this.logLevelList.setBorder(KumbaCoreUIConstants.BUTTON_BORDER);
        this.logLevelList.setSelectedValue("error", false);
        LabeledComponent lblLogLevel = new LabeledComponent("Logging Levels:", this.logLevelList, 1);
        panel.addAll(lblName, rbPanel, lblLogLevel);
        return panel;
    }
}

