/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.createValCredWizard;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.table.PasswordTableCellEditorRenderer;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.AbstractCreateCertificateFromExternalSourceBean;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.ui.editors.DPObjectListTableCellEditor;
import com.kumbasoft.core.ui.editors.DataPowerFileStoreTableCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JDialog;

abstract class AbstractNewCertificateFromExternalSourcesPage<TableModelElementType extends AbstractCreateCertificateFromExternalSourceBean>
extends KumbaCoreWizardPage<DynamicBean> {
    protected Index<Appliance, Domain> selectedDomains;
    protected BeanTableModel<TableModelElementType> tableModel;
    protected BeanColumnModel<TableModelElementType> columnModel;
    private DPObjectListTableCellEditor pmaEditor;
    protected Index<String, StatusObjectStatus> passMapAliases;
    protected JMTable table;
    protected String tableLabel;
    protected JMLabel lblTable;
    protected JMButton btnAddRow;
    protected JMButton btnRemoveRow;

    public AbstractNewCertificateFromExternalSourcesPage(String tableLabel, DynamicBean model) {
        super(model);
        this.tableLabel = tableLabel;
    }

    public AbstractNewCertificateFromExternalSourcesPage(String tableLabel, DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
        this.tableLabel = tableLabel;
        this.lblTable.setText(tableLabel);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        this.selectedDomains = (Index)((DynamicBean)this.model).getProperty("selectedDomains");
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        panel.add((Component)this.createTableHeaderPanel(), "North");
        this.tableModel = this.createTableModel();
        this.columnModel = this.createColumnModel();
        this.table = new JMTable(this.tableModel, this.columnModel);
        panel.add((Component)new JMScrollPane(this.table), "Center");
        return panel;
    }

    private JMPanel createTableHeaderPanel() {
        this.lblTable = new JMLabel(this.tableLabel);
        this.btnAddRow = ComponentFactory.createButton(KumbaCoreUIConstants.ADD_ICON, "", "Add", true, this, "addRow", new Object[0]);
        this.btnRemoveRow = ComponentFactory.createButton(KumbaCoreUIConstants.DELETE_ICON, "", "Delete", true, this, "deleteRow", new Object[0]);
        JMPanel buttons = new JMPanel(new FlowLayout(2));
        buttons.addAll(this.btnAddRow, this.btnRemoveRow);
        KumbaCoreWizardPanel header = new KumbaCoreWizardPanel(new BorderLayout());
        header.add((Component)this.lblTable, "West");
        header.add((Component)buttons, "Center");
        return header;
    }

    protected BeanTableModel<TableModelElementType> createTableModel() {
        TableModelElementType t = this.createNewRowInstance();
        BeanTableModel tableModel = new BeanTableModel(t.getClass());
        tableModel.setEditableColumns(this.getEditableColumns());
        return tableModel;
    }

    protected abstract String[] getEditableColumns();

    protected BeanColumnModel<TableModelElementType> createColumnModel() {
        BeanColumnModel<TableModelElementType> columnModel = new BeanColumnModel<TableModelElementType>(this.tableModel);
        columnModel.setColumnOrder(this.getColumnOrder());
        columnModel.setEditor("fileStore", new DataPowerFileStoreTableCellEditor());
        columnModel.setColumnTitle("dpFileName", "DP File Name");
        columnModel.hideColumns(this.getHiddenColumns());
        columnModel.hideColumn("dataPowerFQFN");
        this.pmaEditor = new DPObjectListTableCellEditor(this.selectedDomains, "PasswordAlias", "name", true);
        this.pmaEditor.makeComboBoxEditable();
        columnModel.setEditor("password", new PasswordTableCellEditorRenderer(String.class));
        columnModel.setRenderer("password", new PasswordTableCellEditorRenderer(String.class));
        columnModel.setEditor("passwordAliasName", this.pmaEditor);
        return columnModel;
    }

    protected abstract String[] getColumnOrder();

    protected abstract String[] getHiddenColumns();

    protected abstract TableModelElementType createNewRowInstance();

    @Reflected
    protected abstract void addRow();

    @Reflected
    private void deleteRow() {
        int[] selectedRows = this.table.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            return;
        }
        this.table.commitEdits();
        new JMMessageBox((JDialog)this.parentDialog, "Remove Rows", "Do you want to remove all selected rows?", 12);
        if (JMMessageBox.getSelection() == 8) {
            return;
        }
        this.table.clearSelection();
        this.tableModel.deleteAll(selectedRows);
    }

    @Override
    public boolean isDataValid() {
        this.table.commitEdits();
        boolean isValid = true;
        ArrayList<TableModelElementType> rowData = this.tableModel.getModelData();
        for (AbstractCreateCertificateFromExternalSourceBean element : rowData) {
            if (this.isDataValid(element)) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    protected boolean isDataValid(TableModelElementType element) {
        String certificateObjectName = ((AbstractCreateCertificateFromExternalSourceBean)element).getCertificateObjectName();
        if (!ConfigurationManager.isObjectNameValid(certificateObjectName)) {
            new JMMessageBox((JDialog)this.parentDialog, "Certificate Object Name Invalid", ConfigurationManager.getStandardInvalidObjectNameMessage("Certificate " + certificateObjectName));
            return false;
        }
        String passwordAlias = ((AbstractCreateCertificateFromExternalSourceBean)element).getPasswordAliasName();
        if (StringUtility.isNotEmpty(passwordAlias) && !ConfigurationManager.isObjectNameValid(passwordAlias)) {
            new JMMessageBox((JDialog)this.parentDialog, "Password Alias Name Invalid", ConfigurationManager.getStandardInvalidObjectNameMessage("Password Alias " + passwordAlias));
            return false;
        }
        if (StringUtility.isNotEmpty(passwordAlias)) {
            String password;
            Collection<StatusObjectStatus> passMapByName;
            if (this.passMapAliases == null) {
                ArrayList<StatusObjectStatus> passMapAliasList = this.pmaEditor.getObjects();
                BeanIndexer<StatusObjectStatus> nameIndexer = new BeanIndexer<StatusObjectStatus>(passMapAliasList);
                this.passMapAliases = nameIndexer.getIndexOf("name", "");
                ((DynamicBean)this.model).setProperty("passMapAliases", this.passMapAliases);
            }
            if (CollectionUtility.isEmpty(passMapByName = this.passMapAliases.get(passwordAlias)) && StringUtility.isEmpty(password = ((AbstractCreateCertificateFromExternalSourceBean)element).getPassword())) {
                new JMMessageBox((JDialog)this.parentDialog, "Missing Password for Password Alias", String.format("The new password alias %s must have a password.", passwordAlias));
                return false;
            }
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        ((DynamicBean)this.model).setProperty("certificateData", this.tableModel.getModelData());
    }
}

