/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.createValCredWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.layout.OutlineLayout;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.AbstractCreateCertificateFromExternalSourceBean;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JSeparator;

public abstract class AbstractNewCertificateFromExternalSourcesReviewPage<TableModelType extends AbstractCreateCertificateFromExternalSourceBean>
extends KumbaCoreWizardPage<DynamicBean> {
    public AbstractNewCertificateFromExternalSourcesReviewPage(DynamicBean model) {
        super(model);
    }

    public AbstractNewCertificateFromExternalSourcesReviewPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void saveDataToModel() {
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(new OutlineLayout(50, 10));
        ((DynamicBean)this.model).setProperty("passMapAliases", null);
        return panel;
    }

    @Override
    protected void updateControls() {
        ((KumbaCoreWizardPanel)this.controlsPanel).removeAll();
        ArrayList certificateInfo = (ArrayList)((DynamicBean)this.model).getProperty("certificateData");
        Index passMapAliases = (Index)((DynamicBean)this.model).getProperty("passMapAliases");
        JMLabel headerLabel = new JMLabel("The following actions will be taken when you select 'Finish'");
        ((KumbaCoreWizardPanel)this.controlsPanel).add(headerLabel);
        JMLabel filesHeader = new JMLabel(this.getFilesHeaderLabel());
        ((KumbaCoreWizardPanel)this.controlsPanel).add((Component)filesHeader, (Object)headerLabel);
        JSeparator filesSeparator = new JSeparator();
        filesSeparator.setPreferredSize(new Dimension(600, 2));
        ((KumbaCoreWizardPanel)this.controlsPanel).add((Component)filesSeparator, (Object)filesHeader);
        boolean createPasswordMaps = this.createExternalSourceSection(certificateInfo, filesHeader);
        if (createPasswordMaps) {
            JMLabel pmaHeader = new JMLabel("Password Maps to be created or updated:");
            ((KumbaCoreWizardPanel)this.controlsPanel).add((Component)pmaHeader, (Object)headerLabel);
            JSeparator pmaSeparator = new JSeparator();
            pmaSeparator.setPreferredSize(new Dimension(600, 2));
            ((KumbaCoreWizardPanel)this.controlsPanel).add((Component)pmaSeparator, (Object)pmaHeader);
            for (AbstractCreateCertificateFromExternalSourceBean bean : certificateInfo) {
                String password;
                String passwordMapName = bean.getPasswordAliasName();
                if (!StringUtility.isNotEmpty(passwordMapName) || !StringUtility.isNotEmpty(password = bean.getPassword())) continue;
                ((KumbaCoreWizardPanel)this.controlsPanel).add((Component)AbstractNewCertificateFromExternalSourcesReviewPage.createPassMapAliasLabel(passwordMapName, password, passMapAliases), (Object)pmaHeader);
            }
        }
        JMLabel certsHeader = new JMLabel("Certificate Objects to be created:");
        ((KumbaCoreWizardPanel)this.controlsPanel).add((Component)certsHeader, (Object)headerLabel);
        JSeparator certsSeparator = new JSeparator();
        certsSeparator.setPreferredSize(new Dimension(600, 2));
        ((KumbaCoreWizardPanel)this.controlsPanel).add((Component)certsSeparator, (Object)certsHeader);
        for (AbstractCreateCertificateFromExternalSourceBean bean : certificateInfo) {
            String dpFQFN = bean.getDataPowerFQFN();
            String certificateObjectName = bean.getCertificateObjectName();
            String passwordMapName = bean.getPasswordAliasName();
            ((KumbaCoreWizardPanel)this.controlsPanel).add((Component)AbstractNewCertificateFromExternalSourcesReviewPage.createCertificateLabel(dpFQFN, certificateObjectName, passwordMapName), (Object)certsHeader);
        }
        ((KumbaCoreWizardPanel)this.controlsPanel).repaint();
    }

    protected boolean needsToCreatePasswordMap(TableModelType bean) {
        String password;
        boolean createPasswordMap = false;
        String passwordMapName = ((AbstractCreateCertificateFromExternalSourceBean)bean).getPasswordAliasName();
        if (StringUtility.isNotEmpty(passwordMapName) && StringUtility.isNotEmpty(password = ((AbstractCreateCertificateFromExternalSourceBean)bean).getPassword())) {
            createPasswordMap = true;
        }
        return createPasswordMap;
    }

    protected abstract boolean createExternalSourceSection(ArrayList<TableModelType> var1, JMLabel var2);

    protected abstract String getFilesHeaderLabel();

    private static JMLabel createPassMapAliasLabel(String passwordMapName, String password, Index<String, StatusObjectStatus> passMapAliases) {
        String createOrUpdate = "Create";
        if (CollectionUtility.isNotEmpty(passMapAliases.get(passwordMapName))) {
            createOrUpdate = "Update";
        }
        String label = String.format("%s Password Map %s using password %s", createOrUpdate, passwordMapName, password.replaceAll(password, "*".repeat(password.length())));
        JMLabel displayLabel = new JMLabel(label);
        return displayLabel;
    }

    private static JMLabel createCertificateLabel(String dpFQFN, String certificateObjectName, String passwordMapName) {
        String label = "";
        label = StringUtility.isNotEmpty(passwordMapName) ? String.format("Create Certificate %s using Password Alias %s referencing file %s", certificateObjectName, passwordMapName, dpFQFN) : String.format("Create Certificate %s referencing file %s", certificateObjectName, dpFQFN);
        JMLabel displayLabel = new JMLabel(label);
        return displayLabel;
    }
}

