/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.encryption.SecretKeyGenerator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.config.ConfigCryptoSSKey;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.ModifyTool;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.AbstractUpdateCryptoConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.HexFormat;

public class UpdateCryptoSSKey
extends AbstractUpdateCryptoConfig {
    public UpdateCryptoSSKey(DynamicBean model) {
        super(model);
    }

    @Override
    protected void updateConfigurations() {
        AbstractTool.logger.finer("(): Starting");
        ArrayList selectedKeys = (ArrayList)this.model.getProperty("selectedObjects");
        int keyLength = (Integer)this.model.getProperty("keyLength");
        boolean createNewFile = (Boolean)this.model.getProperty("createNewFile");
        boolean replaceExistingFile = (Boolean)this.model.getProperty("replaceExistingFile");
        String uploadDirectory = this.model.hasProperty("selectedDirectory") ? (String)this.model.getProperty("selectedDirectory") : "";
        String newDirectory = this.model.hasProperty("newDirectory") ? (String)this.model.getProperty("newDirectory") : "";
        String newFileName = this.model.hasProperty("newFileName") ? (String)this.model.getProperty("newFileName") : "";
        String newBaseDirectory = String.format("%s/%s/", uploadDirectory, newDirectory);
        String uploadDir = newBaseDirectory = StringUtility.coalesce(newBaseDirectory, "/");
        AbstractTool.logger.finer(() -> LMG.log("(): Base directory for upload: '%s'.", () -> uploadDir));
        AbstractTool.logger.finer(() -> LMG.log("(): Building new secret key of %d key length.", () -> keyLength));
        SecretKeyGenerator secretKeyGenerator = new SecretKeyGenerator(keyLength);
        byte[] keyBytes = secretKeyGenerator.generateKey();
        String formattedKey = String.format("0x%s", HexFormat.of().formatHex(keyBytes));
        AbstractTool.logger.finer(() -> LMG.log("(): Generated Key: %s", () -> formattedKey));
        File outputFile = null;
        try {
            outputFile = File.createTempFile("UpdateCryptoSSKey", ".sskey");
            new ASCFileWriter(outputFile, formattedKey);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AbstractTool.logger.finer(() -> LMG.log("(): Getting configurations for %d selected keys.", () -> selectedKeys.size()));
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<DataPowerConfig> allSSKeyConfigs = configurationManager.getObjects(selectedKeys);
        HashSet<DataPowerFileInfo> filesToUpload = new HashSet<DataPowerFileInfo>();
        AbstractTool.logger.finer("(): Building upload file list.");
        DateTime now = new DateTime();
        String commonFileDate = now.toString();
        for (DataPowerConfig ssKeyConfig : allSSKeyConfigs) {
            Appliance appliance = ssKeyConfig.getAppliance();
            Domain domain = ssKeyConfig.getSourceDomain();
            ConfigCryptoSSKey ssKey = (ConfigCryptoSSKey)ssKeyConfig;
            String fileName = ssKey.getFilename();
            DataPowerFileInfo dpFileInfo = null;
            if (createNewFile) {
                dpFileInfo = new DataPowerFileInfo(appliance, domain, commonFileDate, 0L, newBaseDirectory, newFileName);
                String newFileFQFN = String.format("%s%s", newBaseDirectory, newFileName);
                ssKey.setFilename(newFileFQFN);
            } else {
                dpFileInfo = new DataPowerFileInfo(appliance, domain, commonFileDate, 0L, fileName);
            }
            dpFileInfo.setFileContent(formattedKey);
            filesToUpload.add(dpFileInfo);
        }
        AbstractTool.logger.finer(() -> LMG.log("(): Preparing to upload %d created file(s).", () -> filesToUpload.size()));
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        FileUploader.upload(new ArrayList<DataPowerFileInfo>(filesToUpload), mtil);
        FileUploader.addCommandSubscribers(this.managementCommandSubscribers);
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("UpdateCryptoSSKey.updateConfigurations()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        if (!completedOnTime) {
            AbstractTool.logger.warning("():  Not all files uploaded in time.  Moving on, but some configurations may not be stable.");
        }
        AbstractTool.logger.finer(() -> LMG.log("(): Preparing to update %d Crypto SS Keys", () -> allSSKeyConfigs.size()));
        HashMap<Appliance, Index<Domain, DataPowerConfig>> ssKeysByApplianceDomain = DataStructureUtility.mapByApplianceDomain(allSSKeyConfigs);
        for (Appliance appliance : ssKeysByApplianceDomain.keySet()) {
            Index<Domain, DataPowerConfig> ssKeysByDomain = ssKeysByApplianceDomain.get(appliance);
            for (Domain domain : ssKeysByDomain.getKeys()) {
                Collection<DataPowerConfig> ssKeyConfigs = ssKeysByDomain.get(domain);
                ModifyTool modifyTool = new ModifyTool(appliance, domain, ssKeyConfigs);
                modifyTool.addManagementCommandSubscriber(this.managementCommandSubscribers);
                mtil.addThread(modifyTool.getProcessThread());
            }
        }
        completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("UpdateCryptoSSKey.updateConfigurations()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        if (!completedOnTime) {
            AbstractTool.logger.warning("():  Timed out waiting for all modifications to complete.  Releasing control, but some configurations may not be stable.");
        }
        AbstractTool.logger.finer("(): Done");
    }
}

