/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.ipWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.ListModel;

abstract class AbstractIPInterfaceListPanel
extends KumbaCoreWizardPage<DynamicBean> {
    protected static final String ETH_PANEL = "eth";
    protected static final String LINKAGG_PANEL = "linkAgg";
    protected static final String VLAN_PANEL = "vlan";
    protected JMListModel<String> ethernetModel;
    protected JMList<String> ethernetList;
    protected JMListModel<String> linkAggModel;
    protected JMList<String> linkAggList;
    protected JMListModel<String> vlanModel;
    protected JMList<String> vlanList;
    protected CardLayout listCards;
    protected boolean isEthernet;
    protected boolean isLinkAgg;

    public AbstractIPInterfaceListPanel(DynamicBean model) {
        super(model);
    }

    public AbstractIPInterfaceListPanel(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    protected void updateControls() {
        this.getSelectedInterfaceType();
        if (this.isEthernet) {
            if (this.ethernetModel.getSize() == 0) {
                this.loadListModel(this.getListModelEthernetInterfacesPropertyName(), this.ethernetModel);
            }
            this.listCards.show(this.controlsPanel, ETH_PANEL);
        } else if (this.isLinkAgg) {
            if (this.linkAggModel.getSize() == 0) {
                this.loadListModel(this.getListModelLinkAggInterfacesPropertyName(), this.linkAggModel);
            }
            this.listCards.show(this.controlsPanel, LINKAGG_PANEL);
        } else {
            if (this.vlanModel.getSize() == 0) {
                this.loadListModel(this.getListModelVLANInterfacePropertyName(), this.vlanModel);
            }
            this.listCards.show(this.controlsPanel, VLAN_PANEL);
        }
    }

    protected abstract String getListModelEthernetInterfacesPropertyName();

    protected abstract String getListModelLinkAggInterfacesPropertyName();

    protected abstract String getListModelVLANInterfacePropertyName();

    protected void getSelectedInterfaceType() {
        this.isEthernet = (Boolean)((DynamicBean)this.model).getProperty("isEthernet");
        this.isLinkAgg = (Boolean)((DynamicBean)this.model).getProperty("isLinkAggregation");
    }

    protected void loadListModel(String propertyName, JMListModel<String> listModel) {
        while (!((DynamicBean)this.model).hasProperty(propertyName)) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        ArrayList interfaces = (ArrayList)((DynamicBean)this.model).getProperty(propertyName);
        while (interfaces == null) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            interfaces = (ArrayList)((DynamicBean)this.model).getProperty(propertyName);
        }
        UniqueArrayList<String> interfaceNames = new UniqueArrayList<String>();
        for (DataPowerConfig interfaceConfig : interfaces) {
            String name = interfaceConfig.getName();
            interfaceNames.add(name);
        }
        listModel.addAll(interfaceNames);
    }

    @Override
    public boolean isDataValid() {
        int[] selectedRows = null;
        selectedRows = this.isEthernet ? this.ethernetList.getSelectedIndices() : (this.isLinkAgg ? this.linkAggList.getSelectedIndices() : this.vlanList.getSelectedIndices());
        if (ArrayUtility.isEmpty(selectedRows)) {
            new JMMessageBox((JDialog)this.parentDialog, "Missing Interface Selection", "You must select a destination interface.");
            return false;
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        String ethernetInterfaceModelPropertyName = this.getSavedEthernetInterfaceModelPropertyName();
        String linkAggInterfaceModelPropertyName = this.getSavedLinkAggInterfaceModelPropertyName();
        String getVLANInterfaceModelPropertyName = this.getSavedVLANInterfaceModelPropertyName();
        ((DynamicBean)this.model).setProperty(ethernetInterfaceModelPropertyName, null);
        ((DynamicBean)this.model).setProperty(linkAggInterfaceModelPropertyName, null);
        ((DynamicBean)this.model).setProperty(getVLANInterfaceModelPropertyName, null);
        if (this.isEthernet) {
            String ethernetInterface = this.ethernetList.getSelectedItem();
            ((DynamicBean)this.model).setProperty(ethernetInterfaceModelPropertyName, ethernetInterface);
        } else if (this.isLinkAgg) {
            String linkAggInterface = this.linkAggList.getSelectedItem();
            ((DynamicBean)this.model).setProperty(linkAggInterfaceModelPropertyName, linkAggInterface);
        } else {
            String vlanInterface = this.vlanList.getSelectedItem();
            ((DynamicBean)this.model).setProperty(getVLANInterfaceModelPropertyName, vlanInterface);
        }
    }

    protected abstract String getSavedEthernetInterfaceModelPropertyName();

    protected abstract String getSavedLinkAggInterfaceModelPropertyName();

    protected abstract String getSavedVLANInterfaceModelPropertyName();

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        this.listCards = new CardLayout(10, 10);
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(this.listCards);
        this.ethernetModel = new JMListModel();
        this.ethernetList = new JMList<String>((ListModel<String>)this.ethernetModel);
        JMPanel ethPanel = AbstractIPInterfaceListPanel.createListPanel(this.ethernetList, "Ethernet Interfaces:");
        this.linkAggModel = new JMListModel();
        this.linkAggList = new JMList<String>((ListModel<String>)this.linkAggModel);
        JMPanel linkAggPanel = AbstractIPInterfaceListPanel.createListPanel(this.linkAggList, "Link Aggregation Interfaces:");
        this.vlanModel = new JMListModel();
        this.vlanList = new JMList<String>((ListModel<String>)this.vlanModel);
        JMPanel vlanPanel = AbstractIPInterfaceListPanel.createListPanel(this.vlanList, "VLAN Interfaces:");
        panel.add((Component)ethPanel, ETH_PANEL);
        panel.add((Component)linkAggPanel, LINKAGG_PANEL);
        panel.add((Component)vlanPanel, VLAN_PANEL);
        return panel;
    }

    private static JMPanel createListPanel(JMList<?> list, String label) {
        list.setSelectionMode(0);
        JMPanel panel = new JMPanel(new BorderLayout());
        JMScrollPane scrollPane = new JMScrollPane(list);
        LabeledComponent lc = new LabeledComponent(label, (Component)scrollPane, 1);
        panel.add(lc);
        return panel;
    }
}

