/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.migrateWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.event.ExtendedTableModelEvent;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.table.StringOptionsTableCellEditor;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCryptoProfile;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.config.ConfigSSLServerProfile;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractTableWizardPage;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class MigrateProxyProfileWizardPage
extends AbstractTableWizardPage
implements TableModelListener {
    private ConfigurationManager configurationManager;
    private HashMap<Appliance, Index<Domain, ConfigSSLClientProfile>> clientProfileMap;
    private HashMap<Appliance, Index<Domain, ConfigSSLServerProfile>> serverProfileMap;
    private JMCheckBox cbxSynchronizeChanges;
    private JMCheckBox cbxDeleteProxyProfile;
    private boolean suppressChangeEvents;

    public MigrateProxyProfileWizardPage(DynamicBean model) {
        super(model);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        this.configurationManager = new ConfigurationManager();
        new AsynchMethodInvoker((Object)this, "loadServerAndClientProfiles");
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.cbxSynchronizeChanges = new JMCheckBox("Synchronize Changes", true);
        this.cbxDeleteProxyProfile = new JMCheckBox("Delete Proxy Profiles After Refactoring", true);
        JMPanel cbxPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        cbxPanel.addAll(this.cbxSynchronizeChanges, this.cbxDeleteProxyProfile);
        panel.add((Component)cbxPanel, "North");
        this.tableModel.addTableModelListener(this);
        return panel;
    }

    @Reflected
    private void loadServerAndClientProfiles() {
        logger.finer("(): Starting.  Getting client and server profiles from selected domains...");
        Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        ArrayList<DataPowerConfig> profiles = this.configurationManager.getObjects(selectedDomains, "SSL(Client|Server)Profile", ".*");
        ArrayList<ConfigSSLClientProfile> clientProfiles = new ArrayList<ConfigSSLClientProfile>();
        ArrayList<ConfigSSLServerProfile> serverProfiles = new ArrayList<ConfigSSLServerProfile>();
        for (DataPowerConfig config : profiles) {
            if (config instanceof ConfigSSLClientProfile) {
                ConfigSSLClientProfile sslClientProfile = (ConfigSSLClientProfile)config;
                clientProfiles.add(sslClientProfile);
                continue;
            }
            serverProfiles.add((ConfigSSLServerProfile)config);
        }
        logger.finer(() -> LMG.log("(): Got %d client and %d server profiles.", () -> clientProfiles.size(), () -> serverProfiles.size()));
        this.clientProfileMap = DataStructureUtility.mapByApplianceDomain(clientProfiles);
        this.serverProfileMap = DataStructureUtility.mapByApplianceDomain(serverProfiles);
        ((DynamicBean)this.model).setProperty("clientProfiles", this.clientProfileMap);
        ((DynamicBean)this.model).setProperty("serverProfiles", this.serverProfileMap);
        while (this.table == null) {
            logger.finer("(): Waiting to table to be created.");
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        logger.finer("(): Defining cell editors");
        int rowCount = this.table.getRowCount();
        int row = 0;
        while (row < rowCount) {
            this.createRowEditor(row, 5, this.clientProfileMap);
            this.createRowEditor(row, 4, this.serverProfileMap);
            ++row;
        }
        logger.finer("(): Done");
    }

    private void createRowEditor(int row, int column, HashMap<Appliance, ? extends Index<Domain, ? extends DataPowerConfig>> objectMap) {
        if (objectMap == null || objectMap.isEmpty()) {
            return;
        }
        int modelRow = this.table.convertRowIndexToModel(row);
        int modelColumn = this.table.convertColumnIndexToModel(column);
        DynamicBean rowData = this.tableModel.getValue(modelRow);
        String profileName = (String)this.tableModel.getValueAt(modelRow, modelColumn);
        if (StringUtility.isEmpty(profileName)) {
            this.tableModel.setCellEditable(modelRow, modelColumn, false);
            return;
        }
        this.tableModel.setCellEditable(modelRow, modelColumn);
        Appliance appliance = (Appliance)rowData.getProperty("appliance");
        Domain domain = (Domain)rowData.getProperty("domain");
        Index<Domain, ? extends DataPowerConfig> objectsByAppliance = objectMap.get(appliance);
        Collection<? extends DataPowerConfig> objectsByDomain = objectsByAppliance.get(domain);
        Collection objectNames = CollectionUtility.getPropertyValues(objectsByDomain, "name");
        ArrayList<String> objectNameList = objectNames == null ? new ArrayList<String>() : new ArrayList(objectNames);
        objectNameList.add("");
        Collections.sort(objectNameList);
        StringOptionsTableCellEditor editor = new StringOptionsTableCellEditor(objectNameList);
        editor.makeComboBoxEditable();
        this.columnModel.setEditor(row, column, editor);
    }

    @Override
    protected DynamicBeanTableModel createTableModel() {
        DynamicBeanTableModel tableModel = super.createTableModel();
        ArrayList proxyProfiles = (ArrayList)((DynamicBean)this.model).getProperty("proxyProfiles");
        ArrayList<DataPowerConfig> proxyProfileConfigurations = this.configurationManager.getObjects(proxyProfiles);
        new AsynchMethodInvoker((Object)this, "loadReferencedCryptoProfileConfigurations", new ArrayList<DataPowerConfig>(proxyProfileConfigurations));
        ((DynamicBean)this.model).setProperty("proxyProfileConfigs", proxyProfileConfigurations);
        BeanComparator sorter = new BeanComparator("name", "appliance.name", "sourceDomain.name");
        Collections.sort(proxyProfileConfigurations, sorter);
        for (DataPowerConfig object : proxyProfileConfigurations) {
            ConfigSSLProxyProfile proxyProfile = (ConfigSSLProxyProfile)object;
            Appliance appliance = object.getAppliance();
            Domain domain = object.getSourceDomain();
            String objectName = object.getName();
            String direction = proxyProfile.getDirection();
            DynamicBean row = new DynamicBean();
            row.setProperty("appliance", appliance);
            row.setProperty("domain", domain);
            row.setProperty("objectName", objectName);
            row.setProperty("direction", direction);
            row.setProperty("serverProfile", !direction.equals("forward") ? objectName : "");
            row.setProperty("clientProfile", !direction.equals("reverse") ? objectName : "");
            tableModel.addRow(row);
        }
        tableModel.addComputedExpression("appliance", "name");
        tableModel.addComputedExpression("domain", "name");
        return tableModel;
    }

    @Reflected
    private void loadReferencedCryptoProfileConfigurations(ArrayList<DataPowerConfig> proxyProfileConfigurations) {
        KumbaCoreWizardPage.logger.finer("(proxyProfileConfigurations): Starting.  Assembling configuration collections.");
        Index<Appliance, Domain> applianceDomainIndex = new Index<Appliance, Domain>();
        HashSet<String> cryptoProfileNames = new HashSet<String>();
        for (DataPowerConfig object : proxyProfileConfigurations) {
            ObjectReference<ConfigCryptoProfile> reverseObjectReference;
            ConfigSSLProxyProfile proxyProfile = (ConfigSSLProxyProfile)object;
            Appliance appliance = object.getAppliance();
            Domain domain = object.getSourceDomain();
            applianceDomainIndex.put(appliance, domain);
            String direction = proxyProfile.getDirection();
            ObjectReference<ConfigCryptoProfile> forwardObjectReference = direction.equals("forward") || direction.equals("two-way") ? proxyProfile.getForwardCryptoProfile() : null;
            ObjectReference<ConfigCryptoProfile> objectReference = reverseObjectReference = direction.equals("reverse") || direction.equals("two-way") ? proxyProfile.getReverseCryptoProfile() : null;
            if (forwardObjectReference != null) {
                cryptoProfileNames.add(forwardObjectReference.getName());
            }
            if (reverseObjectReference == null) continue;
            cryptoProfileNames.add(reverseObjectReference.getName());
        }
        KumbaCoreWizardPage.logger.finer("(proxyProfileConfigurations): Getting Crypto Profile Configurations.");
        String searchPattern = String.format("(%s)", StringUtility.getDelimitedString(cryptoProfileNames, "|"));
        ArrayList<ConfigCryptoProfile> cryptoProfiles = this.configurationManager.getObjects(applianceDomainIndex, ConfigCryptoProfile.class, searchPattern);
        KumbaCoreWizardPage.logger.finer("(proxyProfileConfigurations): Done Getting Crypto Profile Configurations.");
        HashMap<Appliance, Index<Domain, ConfigCryptoProfile>> cryptoProfileMap = DataStructureUtility.mapByApplianceDomain(cryptoProfiles);
        ((DynamicBean)this.model).setProperty("cryptoProfileConfigs", cryptoProfileMap);
        KumbaCoreWizardPage.logger.finer("(proxyProfileConfigurations): Done");
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        DynamicBeanColumnModel columnModel = super.createColumnModel();
        columnModel.setColumnOrder("appliance", "domain", "objectName", "direction", "serverProfile", "clientProfile");
        return columnModel;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        ExtendedTableModelEvent ee = (ExtendedTableModelEvent)e;
        if (!this.cbxSynchronizeChanges.isSelected() || this.suppressChangeEvents || ee.getNewValue().equals(ee.getOldValue())) {
            return;
        }
        this.suppressChangeEvents = true;
        int changedRow = e.getFirstRow();
        DynamicBean changedValue = this.tableModel.getValue(changedRow);
        Domain domain = (Domain)changedValue.getProperty("domain");
        String objectName = (String)changedValue.getProperty("objectName");
        String serverProfile = (String)changedValue.getProperty("serverProfile");
        String clientProfile = (String)changedValue.getProperty("clientProfile");
        int rowCount = this.tableModel.getRowCount();
        int row = 0;
        while (row < rowCount) {
            if (row != changedRow) {
                DynamicBean value = this.tableModel.getValue(row);
                Domain vDomain = (Domain)value.getProperty("domain");
                String vObjectName = (String)value.getProperty("objectName");
                if (domain.equals(vDomain) && objectName.equals(vObjectName)) {
                    value.setProperty("serverProfile", serverProfile);
                    value.setProperty("clientProfile", clientProfile);
                }
            }
            ++row;
        }
        this.suppressChangeEvents = false;
        this.table.repaint();
    }

    @Override
    protected void saveDataToModel() {
        this.table.commitEdits();
        boolean deleteProxyProfile = this.cbxDeleteProxyProfile.isSelected();
        ((DynamicBean)this.model).setProperty("removeProxyProfiles", deleteProxyProfile);
        ArrayList<DynamicBean> modelData = this.tableModel.getModelData();
        ((DynamicBean)this.model).setProperty("refactorData", modelData);
    }
}

