/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.passwordWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ConfigTool;
import com.kumbasoft.core.tools.ModifyTool;
import com.kumbasoft.core.util.DataStructureUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class MigratePlaintextPasswords
extends AbstractTool {
    private Collection<DataPowerConfig> migrationTargets;
    private DynamicBean model;
    private HashMap<Appliance, Index<Domain, StatusObjectStatus>> passMapAliases;
    private ManagementCommandSubscriber subscriber;

    public MigratePlaintextPasswords(Collection<DataPowerConfig> migrationTargets, DynamicBean model, HashMap<Appliance, Index<Domain, StatusObjectStatus>> passMapAliases, ManagementCommandSubscriber subscriber) {
        this.migrationTargets = migrationTargets;
        this.model = model;
        this.passMapAliases = passMapAliases;
        this.subscriber = subscriber;
        this.migratePasswords();
    }

    private void migratePasswords() {
        AbstractTool.logger.finer("():  Starting.");
        ArrayList finalData = (ArrayList)this.model.getProperty("migrationFinalData");
        if (CollectionUtility.isEmpty(finalData)) {
            AbstractTool.logger.info("(): No migration targets have any changes.  Nothing to do.  Returning.");
            return;
        }
        boolean removePlaintextPassword = (Boolean)this.model.getProperty("removePlaintextPassword");
        AbstractTool.logger.finer(() -> LMG.log("():  Migrating %d objects. ", () -> finalData.size()));
        HashMap<Appliance, Index<Domain, DataPowerConfig>> migrationTargetIndex = DataStructureUtility.mapByApplianceDomain(this.migrationTargets);
        for (DynamicBean migrationTarget : finalData) {
            Appliance appliance = (Appliance)migrationTarget.getProperty("appliance");
            Index<Domain, DataPowerConfig> migrationConfigsByAppliance = migrationTargetIndex.get(appliance);
            Index<Domain, StatusObjectStatus> passMapAliasesByAppliance = this.passMapAliases.get(appliance);
            if (passMapAliasesByAppliance == null) {
                AbstractTool.logger.info(() -> LMG.log("(): There are no pass map aliases for appliance '%s' for this migration target.", () -> appliance.getName()));
                passMapAliasesByAppliance = new Index();
            }
            Domain domain = (Domain)migrationTarget.getProperty("domain");
            AbstractTool.logger.finer(() -> LMG.log("(): Migrating for the '%s' domain for appliance '%s'.", () -> domain.getName(), () -> appliance.getName()));
            Collection<DataPowerConfig> migrationConfigs = migrationConfigsByAppliance.get(domain);
            Collection<StatusObjectStatus> passMapAliasList = passMapAliasesByAppliance.get(domain);
            if (passMapAliasList == null) {
                AbstractTool.logger.info(() -> LMG.log("(): No existing pass map aliases in the '%s' domain for appliance '%s'.", () -> domain.getName(), () -> appliance.getName()));
                passMapAliasList = new ArrayList<StatusObjectStatus>();
            }
            int passMapAliasListSize = passMapAliasList.size();
            AbstractTool.logger.finer(() -> LMG.log("(): Found %d configs and %d pass map aliases in the '%s' domain for appliance '%s'.", () -> migrationConfigs.size(), () -> passMapAliasListSize, () -> domain.getName(), () -> appliance.getName()));
            PropertyValueSelector<DataPowerConfig> configSelector = new PropertyValueSelector<DataPowerConfig>(migrationConfigs);
            PropertyValueSelector<StatusObjectStatus> statusSelector = new PropertyValueSelector<StatusObjectStatus>(passMapAliasList);
            String objectType = (String)migrationTarget.getProperty("dataPowerType");
            configSelector.addPropertyValueMap("configObjectType", objectType);
            Collection configsByType = configSelector.getSelectedElements();
            String objectName = (String)migrationTarget.getProperty("objectName");
            configSelector.setCollection(configsByType);
            configSelector.clearMap();
            configSelector.addPropertyValueMap("name", objectName);
            ArrayList migrationTargetConfigs = (ArrayList)configSelector.getSelectedElements();
            DataPowerConfig migrationTargetConfig = (DataPowerConfig)migrationTargetConfigs.get(0);
            AbstractTool.logger.finer(() -> LMG.log("():  Migrating %s. ", () -> migrationTargetConfig.getFQON()));
            String passMapAliasName = (String)migrationTarget.getProperty("alias");
            String password = (String)migrationTarget.getProperty("password");
            statusSelector.addPropertyValueMap("name", passMapAliasName);
            ArrayList chosenAliases = (ArrayList)statusSelector.getSelectedElements();
            StatusObjectStatus alias = null;
            if (CollectionUtility.isEmpty(chosenAliases)) {
                AbstractTool.logger.finer(() -> LMG.log("():  Creating new alias: %s->%s->%s. ", () -> appliance.getName(), () -> domain.getName(), () -> passMapAliasName));
                alias = new StatusObjectStatus();
                alias.setAppliance(appliance);
                alias.setSourceDomain(domain);
                alias.setAdminState("enabled");
                alias.setConfigState("new");
                alias.setDataPowerClass("PasswordAlias");
                alias.setOpState("up");
                alias.setName(passMapAliasName);
                ConfigPasswordAlias newConfig = new ConfigPasswordAlias();
                newConfig.setStatus(alias);
                newConfig.setAppliance(appliance);
                newConfig.setSourceDomain(domain);
                newConfig.setAdminState("enabled");
                newConfig.setConfigObjectType("PasswordAlias");
                newConfig.setName(passMapAliasName);
                newConfig.setPassword(password);
                SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
                ConfigTool configTool = new ConfigTool(appliance, domain, newConfig);
                configTool.getProcessThread().addInvocationListener(stil);
                configTool.addManagementCommandSubscriber(this.subscriber);
                passMapAliasesByAppliance.put(domain, alias);
                boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                if (!completedOnTime) {
                    AbstractTool.logger.warning(() -> LMG.log("():  Timeout creating alias: %s. ", () -> newConfig.getFQON()));
                }
            } else {
                alias = (StatusObjectStatus)chosenAliases.get(0);
                String aliasName = alias.getName();
                AbstractTool.logger.finer(() -> LMG.log("():  Associating existing alias: %s->%s. ", () -> ((StatusObjectStatus)chosenAliases.get(0)).getFQON(), () -> aliasName));
            }
            ObjectReference passMapReference = new ObjectReference();
            passMapReference.setClassName("PasswordAlias");
            passMapReference.setName(passMapAliasName);
            BeanService.setPropertyValue(migrationTargetConfig, "alias", passMapReference);
            if (removePlaintextPassword) {
                BeanService.setPropertyValue(migrationTargetConfig, "password", "");
            }
            AbstractTool.logger.config(() -> LMG.log("():  Modifying: %s. ", () -> migrationTargetConfig.getFQON()));
            ModifyTool modifyTool = new ModifyTool(appliance, domain, migrationTargetConfig);
            modifyTool.addManagementCommandSubscriber(this.subscriber);
        }
        AbstractTool.logger.finer("():  Done.");
    }
}

