/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.probe;

import com.jmorgan.j2ee.xml.XMLFormatter;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.JMTextArea;
import com.jmorgan.swing.splitpane.SplitPane;
import com.jmorgan.swing.splitpane.SplitPaneLayout;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanRowSorter;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.config.ConfigStylePolicyAction;
import com.kumbasoft.core.beans.probe.AttachmentTrace;
import com.kumbasoft.core.beans.probe.ProtocolHeader;
import com.kumbasoft.core.beans.probe.TransactionContext;
import com.kumbasoft.core.beans.probe.Variable;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.probe.ProbeContextInfo;
import com.kumbasoft.dpaa.ui.dialogs.probe.ProbeAttachmentContentTableCellRenderer;
import com.kumbasoft.dpaa.ui.dialogs.probe.ProbeVariableValueTableCellRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;

public class ContextViewDialog
extends JMDialog {
    private TransactionContext context;
    private JMTable attachmentsTable;
    private BeanTableModel<AttachmentTrace> attachmentsTableModel;
    private JEditorPane attachmentContentView;
    private JMTable variablesTable;
    private BeanTableModel<Variable> variablesTableModel;
    private JEditorPane nodeSetView;

    public ContextViewDialog(JDialog owner, TransactionContext context) {
        super(owner, "", context);
        this.setSize(1000, 600);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        this.context = (TransactionContext)arguments[0];
        ConfigStylePolicyAction action = this.context.getActionConfig();
        String actionName = action == null ? "OUTPUT" : action.getName();
        String dialogTitle = String.format("Context %s for: %s", this.context.getTransactionIdentity().getInputContext(), actionName);
        this.setTitle(dialogTitle);
        JMTabbedPane tabbedPane = new JMTabbedPane();
        tabbedPane.addTab("Content", ContextViewDialog.createContentTab(this.context));
        ArrayList<ProtocolHeader> headers = this.context.getProtocolHeaders();
        tabbedPane.addTab("Headers", ContextViewDialog.createHeadersTab(headers));
        ArrayList<AttachmentTrace> attachments = this.context.getAttachmentTraces();
        tabbedPane.addTab("Attachments", this.createAttachmentsTab(attachments));
        ArrayList<Variable> variables = this.context.getVariables();
        tabbedPane.addTab("Variables", this.createVariablesTab(variables));
        this.contentPane.add(tabbedPane);
    }

    private static JComponent createContentTab(TransactionContext context) {
        String displayableContent = ProbeContextInfo.getDisplayableContent(context);
        JTextComponent component = null;
        switch (ProbeContextInfo.getInputContextType(context.getTransactionInput())) {
            case 1: {
                JEditorPane xmlPane = new JEditorPane("text/xml", displayableContent);
                component = xmlPane;
                break;
            }
            case 2: {
                JEditorPane jsonPane = new JEditorPane("text/js", displayableContent);
                component = jsonPane;
                break;
            }
            case 3: {
                JMTextArea ta = new JMTextArea(displayableContent);
                ta.setFont(new Font("Courier", 0, 12));
                ta.setLineWrap(false);
                component = ta;
                break;
            }
            default: {
                JMTextArea plainText;
                component = plainText = new JMTextArea(displayableContent);
            }
        }
        return new JMScrollPane(component);
    }

    private static JMPanel createHeadersTab(ArrayList<ProtocolHeader> headers) {
        JMPanel panel = new JMPanel(KumbaCoreUIConstants.createBorderLayout());
        BeanTableModel<ProtocolHeader> tableModel = ContextViewDialog.createHeadersTableModel(headers);
        BeanColumnModel<ProtocolHeader> columnModel = ContextViewDialog.createHeadersColumnModel(tableModel);
        JMTable table = new JMTable(tableModel, columnModel);
        table.optimizeColumnWidths();
        BeanRowSorter<ProtocolHeader> rowSorter = new BeanRowSorter<ProtocolHeader>(tableModel);
        table.setRowSorter(rowSorter);
        panel.add(new JMScrollPane(table));
        return panel;
    }

    private static BeanTableModel<ProtocolHeader> createHeadersTableModel(ArrayList<ProtocolHeader> headers) {
        BeanTableModel<ProtocolHeader> tableModel = new BeanTableModel<ProtocolHeader>(ProtocolHeader.class);
        tableModel.addAll(headers);
        return tableModel;
    }

    private static BeanColumnModel<ProtocolHeader> createHeadersColumnModel(BeanTableModel<ProtocolHeader> tableModel) {
        BeanColumnModel<ProtocolHeader> columnModel = new BeanColumnModel<ProtocolHeader>(tableModel);
        return columnModel;
    }

    private JMPanel createAttachmentsTab(ArrayList<AttachmentTrace> attachments) {
        JMPanel panel = new JMPanel(KumbaCoreUIConstants.createBorderLayout());
        this.attachmentsTableModel = ContextViewDialog.createAttachmentsTableModel(attachments);
        BeanColumnModel<AttachmentTrace> columnModel = ContextViewDialog.createAttachmentsColumnModel(this.attachmentsTableModel);
        this.attachmentsTable = new JMTable(this.attachmentsTableModel, columnModel);
        this.attachmentsTable.optimizeColumnWidths();
        this.attachmentsTable.addRowFocusListener(e -> this.showAttachmentTraceContent());
        BeanRowSorter<AttachmentTrace> rowSorter = new BeanRowSorter<AttachmentTrace>(this.attachmentsTableModel);
        this.attachmentsTable.setRowSorter(rowSorter);
        panel.add(new JMScrollPane(this.attachmentsTable));
        this.attachmentContentView = new JEditorPane("text/plain", "");
        this.attachmentContentView.setPreferredSize(new Dimension(300, 400));
        this.attachmentContentView.setMaximumSize(new Dimension(300, 400));
        this.attachmentContentView.setEditable(false);
        Object d = null;
        panel.add((Component)new JMScrollPane(this.nodeSetView), "East");
        return panel;
    }

    private void showAttachmentTraceContent() {
        int selectedRow = this.attachmentsTable.getSelectedRow();
        AttachmentTrace selectedVariable = this.attachmentsTableModel.getValue(selectedRow);
        String contentType = selectedVariable.getContentType();
        String content = selectedVariable.getContent();
        this.attachmentContentView.setContentType(contentType);
        this.attachmentContentView.setText(content);
    }

    private static BeanTableModel<AttachmentTrace> createAttachmentsTableModel(ArrayList<AttachmentTrace> attachments) {
        BeanTableModel<AttachmentTrace> tableModel = new BeanTableModel<AttachmentTrace>(AttachmentTrace.class);
        tableModel.addAll(attachments);
        return tableModel;
    }

    private static BeanColumnModel<AttachmentTrace> createAttachmentsColumnModel(BeanTableModel<AttachmentTrace> tableModel) {
        BeanColumnModel<AttachmentTrace> columnModel = new BeanColumnModel<AttachmentTrace>(tableModel);
        columnModel.setColumnOrder("url", "contentType", "content");
        ProbeAttachmentContentTableCellRenderer valueRenderer = new ProbeAttachmentContentTableCellRenderer();
        columnModel.setRenderer("content", valueRenderer);
        return columnModel;
    }

    private JMPanel createVariablesTab(ArrayList<Variable> variables) {
        SplitPane panel = new SplitPane(1, 2);
        SplitPaneLayout layout = (SplitPaneLayout)panel.getLayout();
        layout.setColumnWidth(0, 0.75);
        this.variablesTableModel = ContextViewDialog.createVariablesTableModel(variables);
        BeanColumnModel<Variable> columnModel = ContextViewDialog.createVariablesColumnModel(this.variablesTableModel);
        this.variablesTable = new JMTable(this.variablesTableModel, columnModel);
        this.variablesTable.optimizeColumnWidths();
        this.variablesTable.addRowFocusListener(e -> this.showVariableValue());
        BeanRowSorter<Variable> rowSorter = new BeanRowSorter<Variable>(this.variablesTableModel);
        this.variablesTable.setRowSorter(rowSorter);
        panel.add(new JMScrollPane(this.variablesTable));
        this.nodeSetView = new JEditorPane("text/xml", "");
        this.nodeSetView.setPreferredSize(new Dimension(300, 400));
        this.nodeSetView.setMaximumSize(new Dimension(300, 400));
        this.nodeSetView.setEditable(false);
        panel.add(new JMScrollPane(this.nodeSetView));
        return panel;
    }

    private void showVariableValue() {
        applicationLogger.finer("(): Starting.");
        int selectedRow = this.variablesTable.getSelectedRow();
        Variable selectedVariable = this.variablesTableModel.getValue(selectedRow);
        String variableType = selectedVariable.getType();
        applicationLogger.finer(() -> LMG.log("(): Showing variable '%s' of type '%s' from row %d", () -> selectedVariable.getLocalURL(), () -> variableType, () -> selectedRow));
        if (variableType.equals("node-set")) {
            String variableValue = selectedVariable.getValue();
            if (variableValue == null) {
                applicationLogger.finer(() -> LMG.log("(): The value of variable '%s' is null.  Forcing blank.", () -> selectedVariable.getLocalURL()));
                variableValue = "";
            } else {
                String vv = variableValue;
                applicationLogger.finer(() -> LMG.log("(): The value of variable '%s' is '%s'.  Cleaning it up.", () -> selectedVariable.getLocalURL(), () -> vv));
                variableValue = variableValue.substring(1, variableValue.length() - 1);
                variableValue = StringUtility.removeAll(variableValue, "\t");
                variableValue = variableValue.replace(">\n, <", ">\n<");
                try {
                    variableValue = XMLFormatter.format(variableValue);
                }
                catch (Exception e) {
                    applicationLogger.finer(() -> LMG.log("(): Error processing variable '%s' for display.\n%s", () -> selectedVariable.getLocalURL(), () -> e.getMessage()));
                }
            }
            applicationLogger.finer(() -> LMG.log("(): Showing the value of variable '%s' in node set view.", () -> selectedVariable.getLocalURL()));
            this.nodeSetView.setText(variableValue);
        } else {
            applicationLogger.finer(() -> LMG.log("(): Variable '%s' isn't a nodet-set.  Clearing the view.", () -> selectedVariable.getLocalURL()));
            this.nodeSetView.setText("");
        }
        applicationLogger.finer("(): Done.");
    }

    private static BeanTableModel<Variable> createVariablesTableModel(ArrayList<Variable> variables) {
        BeanTableModel<Variable> tableModel = new BeanTableModel<Variable>(Variable.class);
        tableModel.addAll(variables);
        return tableModel;
    }

    private static BeanColumnModel<Variable> createVariablesColumnModel(BeanTableModel<Variable> tableModel) {
        BeanColumnModel<Variable> columnModel = new BeanColumnModel<Variable>(tableModel);
        ProbeVariableValueTableCellRenderer valueRenderer = new ProbeVariableValueTableCellRenderer();
        columnModel.setRenderer("value", valueRenderer);
        columnModel.hideColumns("name", "localURL");
        columnModel.setColumnTitle("globalURL", "Variable");
        return columnModel;
    }
}

