/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.probe;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMPanel;
import com.kumbasoft.core.beans.probe.TransactionManifest;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.dpaa.ui.dialogs.probe.ProbeViewPanel;
import com.kumbasoft.dpaa.ui.dialogs.probe.TransactionListPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JFrame;

public class ProbeViewDialog
extends JMDialog {
    private static final String LIST_PANEL = "ListPanel";
    private static final String PROBE_PANEL = "ProbePanel";
    private ArrayList<StatusObjectStatus> selectedObjects;
    private JMPanel cardPanel;
    private CardLayout cardLayout;
    private TransactionListPanel transactionListPanel;
    private ProbeViewPanel probeViewPanel;

    public ProbeViewDialog(JFrame owner, Object ... arguments) {
        super(owner, "Aggregated Probe View", arguments);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        this.selectedObjects = (ArrayList)arguments[0];
        this.cardLayout = new CardLayout();
        this.cardPanel = new JMPanel(this.cardLayout);
        this.transactionListPanel = new TransactionListPanel(this, this.selectedObjects);
        this.probeViewPanel = new ProbeViewPanel(this);
        this.cardPanel.add((Component)this.transactionListPanel, LIST_PANEL);
        this.cardPanel.add((Component)this.probeViewPanel, PROBE_PANEL);
        this.contentPane.add((Component)this.cardPanel, "Center");
    }

    @Override
    public boolean getQueryOnClose() {
        return true;
    }

    @Override
    public void setupEventHandling() {
        super.setupEventHandling();
        this.setDefaultCloseOperation(0);
    }

    @Reflected
    private void openTransactions(ArrayList<TransactionManifest> selectedTransactions) {
        this.probeViewPanel.setTransactions(selectedTransactions);
        this.cardLayout.show(this.cardPanel, PROBE_PANEL);
    }

    @Reflected
    private void swapPanels() {
        this.probeViewPanel.close();
        this.cardLayout.show(this.cardPanel, LIST_PANEL);
    }
}

