/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.cacheManagement;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionFlushDocumentCache;
import com.kumbasoft.core.beans.actions.ActionFlushExpiredDocuments;
import com.kumbasoft.core.beans.actions.ActionFlushLDAPPoolCache;
import com.kumbasoft.core.beans.actions.ActionFlushStylesheetCache;
import com.kumbasoft.core.beans.actions.ActionInvalidateDocumentCache;
import com.kumbasoft.core.beans.config.ConfigXMLManager;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.dpaa.ui.panels.cacheManagement.AbstractObjectCacheManagementPanel;
import java.util.ArrayList;

public class XMLManagerCacheManagementPanel
extends AbstractObjectCacheManagementPanel<ConfigXMLManager> {
    private JMCheckBox cbxStyleSheetCache;
    private JMCheckBox cbxFlushDocumentCache;
    private JMTextField tfDocumentMatchPattern;
    private JMCheckBox cbxFlushExpiredDocuments;
    private JMTextField tfExpiredDocumentMatchPattern;
    private JMCheckBox cbxInvalidateDocument;
    private JMTextField tfInvalidateDocumentMatchPattern;
    private JMCheckBox cbxLDAPPoolCache;

    public XMLManagerCacheManagementPanel() {
        JMPanel cbxPanel = new JMPanel(new VerticalFlowLayout(3, 10));
        this.cbxStyleSheetCache = ComponentFactory.createCheckbox(null, "Stylesheet Cache", "Clear the stylesheet cache for all selected XML Managers", false, true, null, null, new Object[0]);
        this.cbxFlushDocumentCache = ComponentFactory.createCheckbox(null, "Document Cache", "Clear the document cache for all selected XML Managers", false, true, null, null, new Object[0]);
        this.tfDocumentMatchPattern = ComponentFactory.createTextField("*", 150, 25, null, null, new Object[0]);
        JMPanel documentCachePanel = AbstractObjectCacheManagementPanel.getCheckboxFieldPanel(this.cbxFlushDocumentCache, this.tfDocumentMatchPattern);
        this.cbxFlushExpiredDocuments = ComponentFactory.createCheckbox(null, "Expired Documents", "Clear the expried documents within the cache for all selected XML Managers", false, true, null, null, new Object[0]);
        this.tfExpiredDocumentMatchPattern = ComponentFactory.createTextField("*", 150, 25, null, null, new Object[0]);
        JMPanel expiredDocumentsPanel = AbstractObjectCacheManagementPanel.getCheckboxFieldPanel(this.cbxFlushExpiredDocuments, this.tfExpiredDocumentMatchPattern);
        this.cbxInvalidateDocument = ComponentFactory.createCheckbox(null, "Invalidate Documents", "Invalidate document in the cache for all selected XML Managers", false, true, null, null, new Object[0]);
        this.tfInvalidateDocumentMatchPattern = ComponentFactory.createTextField("*", 150, 25, null, null, new Object[0]);
        JMPanel invalidateDocumentPanel = AbstractObjectCacheManagementPanel.getCheckboxFieldPanel(this.cbxInvalidateDocument, this.tfInvalidateDocumentMatchPattern);
        this.cbxLDAPPoolCache = ComponentFactory.createCheckbox(null, "LDAP Pool", "Clear the LDAP pool for all selected XML Managers", false, true, null, null, new Object[0]);
        cbxPanel.addAll(this.cbxStyleSheetCache, documentCachePanel, expiredDocumentsPanel, invalidateDocumentPanel, this.cbxLDAPPoolCache);
        this.rightPanel.add(cbxPanel);
    }

    @Override
    protected String getListNameLabel() {
        return "XML Managers";
    }

    @Override
    protected int getButtonLeftMargin() {
        return 240;
    }

    @Override
    protected String getButtonText() {
        return "Clear Cache";
    }

    @Override
    protected String getButtonToolTip() {
        return "Clears all selected caches for all selected XML managers";
    }

    @Override
    protected String getActionEventMethod() {
        return "clearXMLManagerCache";
    }

    @Override
    protected String getObjectType() {
        return "XMLManager";
    }

    @Reflected
    private void clearXMLManagerCache() {
        this.openResultsDialogAndSetWaitCursor("Clear XML Manager Caches");
        this.clearCache("clearXMLManagerCache");
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void clearXMLManagerCache(Appliance appliance, Domain domain, String xmlManager) {
        String cacheNameList;
        int lastComma;
        ArrayList<DataPowerAction> actions = new ArrayList<DataPowerAction>();
        ObjectReference<ConfigXMLManager> or = new ObjectReference<ConfigXMLManager>();
        or.setClassName("XMLManager");
        or.setName(xmlManager);
        ArrayList<String> cacheNames = new ArrayList<String>();
        if (this.cbxStyleSheetCache.isSelected()) {
            ActionFlushStylesheetCache fssc = new ActionFlushStylesheetCache();
            fssc.setXMLManager(or);
            actions.add(fssc);
            cacheNames.add("Stylesheet");
        }
        if (this.cbxFlushDocumentCache.isSelected()) {
            String documentPattern = this.tfDocumentMatchPattern.getText();
            ActionFlushDocumentCache fsc = new ActionFlushDocumentCache();
            fsc.setXMLManager(or);
            fsc.setMatchPattern(documentPattern);
            actions.add(fsc);
            cacheNames.add("Document");
        }
        if (this.cbxFlushExpiredDocuments.isSelected()) {
            String expiredDocumentsPattern = this.tfDocumentMatchPattern.getText();
            ActionFlushExpiredDocuments fed = new ActionFlushExpiredDocuments();
            fed.setXMLManager(or);
            fed.setMatchPattern(expiredDocumentsPattern);
            actions.add(fed);
            cacheNames.add("Expired Document");
        }
        if (this.cbxInvalidateDocument.isSelected()) {
            String invalidatePattern = this.tfInvalidateDocumentMatchPattern.getText();
            ActionInvalidateDocumentCache idc = new ActionInvalidateDocumentCache();
            idc.setXMLManager(or);
            idc.setMatchPattern(invalidatePattern);
            actions.add(idc);
            cacheNames.add("Invalid Document");
        }
        if (this.cbxLDAPPoolCache.isSelected()) {
            ActionFlushLDAPPoolCache fLdapC = new ActionFlushLDAPPoolCache();
            fLdapC.setXMLManager(or);
            actions.add(fLdapC);
            cacheNames.add("LDAP Pool");
        }
        if ((lastComma = (cacheNameList = StringUtility.getDelimitedString(cacheNames, ", ")).lastIndexOf(", ")) > 0) {
            cacheNameList = StringUtility.replaceAt(cacheNameList, ", ", " and ", lastComma);
        }
        String commandDescription = String.format("Flush %s %s for %s", cacheNameList, cacheNames.size() > 1 ? "Caches" : "Cache", xmlManager);
        for (JMBean jMBean : actions) {
            ActionTool actionTool = new ActionTool(appliance, domain, jMBean);
            actionTool.setCommandDescription(commandDescription);
            actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
        }
    }
}

