/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.FileSelectorComponent;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.list.ThreadSafeListModelWorker;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.Date;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.SnapShotListener;
import com.kumbasoft.core.tools.SnapShot;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.ListModel;

public class SnapShotPanel
extends AbstractPanel
implements SnapShotListener {
    private FileSelectorComponent fileSelector;
    private JMCheckBox cbxUseDatePrefix;
    private JMCheckBox cbxIncludeLogs;
    private JMCheckBox cbxIncludeCertificates;
    private JMListModel<String> statusListModel;
    private JMList<String> statusList;
    private ThreadSafeListModelWorker<String> listModelWorker;

    public SnapShotPanel() {
        super(new BorderLayout(1, 10));
        this.setInsets(InsetsFactory.createFixedInsets(5));
        JMPanel topPanel = new JMPanel(new VerticalFlowLayout(0));
        DPAAApplicationProperties appProps = (DPAAApplicationProperties)Application.getApplication().getApplicationProperties();
        this.fileSelector = new FileSelectorComponent("SnapShot Output Directory:", "Start");
        this.fileSelector.setPreferredSize(600, 25);
        this.fileSelector.setFileName(appProps.getSnapShotsDirectory());
        this.fileSelector.setFileNameFilter(KumbaCoreUIConstants.DIRECTORY_FILE_FILTER);
        this.fileSelector.setActionButtonIcon(KumbaCoreUIConstants.SNAPSHOT_ICON);
        this.fileSelector.getActionButton().setPreferredSize(75, 25);
        new ActionEventInvoker(this.fileSelector, this, "startSnapshot");
        JMPanel otherControls = new JMPanel(new FlowLayout(0));
        this.cbxUseDatePrefix = new JMCheckBox("SnapShot with Date", true);
        this.setStandardComopnentSize(this.cbxUseDatePrefix);
        this.cbxUseDatePrefix.setToolTipText("Prefix the SnapShot output directory with today's date.");
        this.cbxIncludeLogs = new JMCheckBox("Include Logs", false);
        this.setStandardComopnentSize(this.cbxIncludeLogs);
        this.cbxIncludeLogs.setToolTipText(LabelUtility.wrapInHTML("Check this to include log files in the SnapShot.\n\nThere aren't too many good reasons to do this."));
        this.cbxIncludeCertificates = new JMCheckBox("Include Certificates", true);
        this.setStandardComopnentSize(this.cbxIncludeCertificates);
        this.cbxIncludeCertificates.setToolTipText("Check this to include certificates in the export");
        otherControls.addAll(this.cbxUseDatePrefix, this.cbxIncludeCertificates, this.cbxIncludeLogs);
        topPanel.addAll(this.fileSelector, otherControls);
        this.statusListModel = new JMListModel();
        this.statusList = new JMList<String>((ListModel<String>)this.statusListModel);
        this.add((Component)topPanel, "North");
        this.add((Component)KumbaCoreUIConstants.createScrollPane(this.statusList), "Center");
    }

    private void setStandardComopnentSize(Component component) {
        component.setPreferredSize(new Dimension(160, 25));
    }

    @Reflected
    private void startSnapshot() {
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.setControlState(false);
        this.statusListModel.clear();
        this.statusList.repaint();
        this.listModelWorker = new ThreadSafeListModelWorker<String>(this.statusListModel);
        File outputDirectory = this.fileSelector.getSelectedFile();
        if (this.cbxUseDatePrefix.isSelected()) {
            Date today = new Date();
            outputDirectory = new File(outputDirectory, today.toString().replace('/', '-'));
            outputDirectory.mkdirs();
        }
        Index<Appliance, Domain> shapShotSelection = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        SnapShot snapShot = new SnapShot(shapShotSelection, outputDirectory);
        snapShot.addSnapShotListener(this);
        snapShot.setIncludeCertificates(this.cbxIncludeCertificates.isSelected());
        snapShot.setIncludeLogs(this.cbxIncludeLogs.isSelected());
    }

    @Override
    public void objectProcessed(Appliance appliance, Domain domain, String objectType, String objectName) {
        String info = String.format("Object Exported:  %s     %s     %s     %s", appliance.getName(), domain.getName(), objectType, objectName);
        this.listModelWorker.addElement(info);
    }

    @Override
    public void fileProcessed(Appliance appliance, Domain domain, String filestore, String directory, String fileName) {
        if (StringUtility.isEmpty(directory)) {
            directory = "/";
        }
        String info = String.format("Output File:  %s     %s     %s     %s     %s", appliance.getName(), domain.getName(), filestore, directory, fileName);
        this.listModelWorker.addElement(info);
    }

    @Override
    public void snapshotComplete() {
        this.listModelWorker.setComplete(true);
        this.setControlState(true);
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    private void setControlState(boolean state) {
        this.fileSelector.setEnabled(state);
        this.cbxUseDatePrefix.setEnabled(state);
        this.cbxIncludeLogs.setEnabled(state);
        this.cbxIncludeCertificates.setEnabled(state);
    }
}

