/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.configurations;

import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.SnapShotDiffListener;
import com.kumbasoft.core.tools.SnapshotDiff;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.panels.configurations.CertificateSnapshotDiffPane;
import com.kumbasoft.dpaa.ui.panels.configurations.ConfigSnapshotDiffPane;
import com.kumbasoft.dpaa.ui.panels.configurations.FileSnapshotDiffPane;
import com.kumbasoft.dpaa.ui.panels.configurations.SnapshotDiffOptionsPanel;
import java.awt.Component;

public class SnapshotDiffPanel
extends AbstractPanel
implements SnapShotDiffListener {
    private SnapshotDiffOptionsPanel optionPanel = new SnapshotDiffOptionsPanel(this);
    private JMTabbedPane tabbedPane;
    private ConfigSnapshotDiffPane objectPane;
    private FileSnapshotDiffPane filePane;
    private CertificateSnapshotDiffPane certPane;

    public SnapshotDiffPanel() {
        super(KumbaCoreUIConstants.createBorderLayout());
        this.add((Component)this.optionPanel, "North");
        this.tabbedPane = new JMTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
    }

    void setupSnapshot(boolean forObjects, boolean forFiles, boolean forCerts, String sourceDirectory, String targetDirectory) {
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        this.tabbedPane.removeAll();
        this.tabbedPane.repaint();
        this.objectPane = null;
        this.filePane = null;
        this.certPane = null;
        if (forObjects) {
            this.objectPane = new ConfigSnapshotDiffPane(sourceDirectory, targetDirectory);
            this.tabbedPane.addTab("Objects", this.objectPane);
        }
        if (forFiles) {
            this.filePane = new FileSnapshotDiffPane(sourceDirectory, targetDirectory);
            this.tabbedPane.addTab("Files", this.filePane);
        }
        if (forCerts) {
            this.certPane = new CertificateSnapshotDiffPane(sourceDirectory, targetDirectory);
            this.tabbedPane.addTab("Certificates", this.certPane);
        }
        Index<Appliance, Domain> domains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        SnapshotDiff snapShotDiff = new SnapshotDiff(domains, sourceDirectory, targetDirectory, ".*", ".*", forObjects, forFiles, forCerts);
        snapShotDiff.addSnapShotDiffListener(this);
        snapShotDiff.getProcessThread().addInvocationListener(stil);
        stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT * 6);
        if (this.objectPane != null) {
            this.objectPane.optimizeView();
        }
        if (this.filePane != null) {
            this.filePane.optimizeView();
        }
        if (this.certPane != null) {
            this.certPane.optimizeView();
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    @Override
    public void setObjectDifference(DataPowerConfig source, DataPowerConfig target) {
        this.objectPane.addDeltaPair(source, target);
    }

    @Override
    public void setFileDifference(DataPowerFileInfo source, DataPowerFileInfo target) {
        if (source != null && StringUtility.isEmpty(source.getFileStore()) && StringUtility.isEmpty(source.getBaseDirectory()) || target != null && StringUtility.isEmpty(target.getFileStore()) && StringUtility.isEmpty(target.getBaseDirectory())) {
            return;
        }
        if (source != null && source.getLocalFile().isDirectory()) {
            return;
        }
        if (target != null && target.getLocalFile().isDirectory()) {
            return;
        }
        this.filePane.addDeltaPair(source, target);
    }

    @Override
    public void setCertificateDifference(CertificateInformation source, CertificateInformation target) {
        this.certPane.addDeltaPair(source, target);
    }

    @Override
    public void snapShotComplete() {
        this.objectPane.optimizeView();
        this.filePane.optimizeView();
        this.certPane.optimizeView();
    }
}

