/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.domainactions;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.Date;
import com.jmorgan.util.Time;
import java.io.File;

public class BackupInfo
extends JMBean {
    private String appliance;
    private String domain;
    private Date backupDate;
    private Time backupTime;
    private File file;

    public BackupInfo(File backupFile) {
        this.setFile(backupFile);
    }

    public String getAppliance() {
        return this.appliance;
    }

    public void setAppliance(String appliance) {
        this.appliance = appliance;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Date getBackupDate() {
        return this.backupDate;
    }

    public void setBackupDate(Date backupDate) {
        this.backupDate = backupDate;
    }

    public Time getBackupTime() {
        return this.backupTime;
    }

    public void setBackupTime(Time backupTime) {
        this.backupTime = backupTime;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        String fileName = this.file.getName();
        fileName = fileName.replace("-Backup.zip", "");
        String[] dateTime = fileName.split(" ");
        Date date = new Date(dateTime[0]);
        Time time = new Time(dateTime[1]);
        this.setBackupDate(date);
        this.setBackupTime(time);
        File domainParent = this.file.getParentFile();
        String domainName = domainParent.getName();
        this.setDomain(domainName);
        File applianceParent = domainParent.getParentFile();
        String applianceName = applianceParent.getName();
        this.setAppliance(applianceName);
    }

    public int compareTo(BackupInfo that) {
        return this.compareTo(that, "appliance", "domain", "backupDate", "backupTime");
    }

    public boolean equals(Object that) {
        return this.equals(that, "file");
    }

    @Override
    public int hashCode() {
        return this.hashCode("file");
    }

    @Override
    public String toString() {
        return this.toString("appliance", "domain", "backupDate", "backupTime");
    }
}

