/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.domainactions;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.util.CountAggregator;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.Time;
import com.jmorgan.util.collection.CollectionAggregator;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusDomainCheckpointStatus;
import com.kumbasoft.core.tools.ActionController;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.tools.ModifyProperty;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.panels.domainactions.AbstractDomainActionTablePanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;

public class CheckPointsPanel
extends AbstractDomainActionTablePanel<StatusDomainCheckpointStatus> {
    private JMButton btnCreateCheckpoint;
    private JMButton btnRestoreCheckpoint;
    private JMButton btnDeleteCheckpoint;
    private JMTextField tfCheckpointName;
    private NumberField nfCheckpointHistory;
    private JMButton btnSetCheckpointHistory;
    private String checkpointName;

    public CheckPointsPanel() {
        super(StatusDomainCheckpointStatus.class);
        this.remove(this.leftPanel);
        this.leftPanel.add(this.createControlsPanel());
        this.add((Component)this.leftPanel, "North");
    }

    private JMPanel createControlsPanel() {
        this.btnCreateCheckpoint = ComponentFactory.createButton(KumbaCoreUIConstants.CHECKPOINT_ICON, "Create", "Create a new checkpoint for all selected appliances and domains", true, this, "createCheckpoint", new Object[0]);
        this.btnCreateCheckpoint.setPreferredSize(90, 23);
        this.btnRestoreCheckpoint = ComponentFactory.createButton(KumbaCoreUIConstants.RESTORE_CHECKPOINT_ICON, "Restore", "Restore the selected checkpoint", false, this, "restoreCheckpoints", new Object[0]);
        this.btnRestoreCheckpoint.setPreferredSize(100, 23);
        this.btnDeleteCheckpoint = ComponentFactory.createButton(KumbaCoreUIConstants.DELETE_ICON, "Delete", "Delete the selected checkpoints", false, this, "deleteCheckpoints", new Object[0]);
        this.btnDeleteCheckpoint.setPreferredSize(100, 23);
        this.btnSetCheckpointHistory = ComponentFactory.createButton(KumbaCoreUIConstants.NEXT_ICON, "Set", "Set the checkpoint history for all selected domains", true, this, "setCheckpointHistory", new Object[0]);
        this.btnSetCheckpointHistory.setPreferredSize(70, 23);
        this.tfCheckpointName = new JMTextField("");
        this.setDefaultCheckPointName();
        LabeledComponent checkpointNameLabel = new LabeledComponent("Checkpoint Name:", (Component)this.tfCheckpointName, 130, 300);
        this.nfCheckpointHistory = new NumberField(3.0);
        NumberSpinner nsCheckpointHistory = new NumberSpinner(this.nfCheckpointHistory, 1.0, 1.0, 5.0);
        LabeledComponent setCheckpointHistoryLabel = new LabeledComponent("Checkpoint History:", (Component)nsCheckpointHistory, 130, 50);
        JMPanel createPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        createPanel.add((Component)checkpointNameLabel, "Center");
        createPanel.add((Component)this.btnCreateCheckpoint, "East");
        JMPanel setHistoryPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        setHistoryPanel.add((Component)setCheckpointHistoryLabel, "Center");
        setHistoryPanel.add((Component)this.btnSetCheckpointHistory, "East");
        JMPanel restoreDeletePanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        restoreDeletePanel.addAll(this.btnRestoreCheckpoint, this.btnDeleteCheckpoint);
        JMPanel controlsPanel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(0);
        controlsPanel.addAll(createPanel, setHistoryPanel, restoreDeletePanel);
        return controlsPanel;
    }

    @Override
    protected BeanColumnModel<StatusDomainCheckpointStatus> getColumnModel() {
        BeanColumnModel<StatusDomainCheckpointStatus> columnModel = super.getColumnModel();
        columnModel.hideColumns("fQON", "statusTime");
        columnModel.setColumnOrder("appliance", "sorceDomain", "chkName", "date", "time");
        columnModel.setColumnTitle("chkName", "Checkpoint Name");
        return columnModel;
    }

    private void setDefaultCheckPointName() {
        DateTime now = new DateTime();
        now.getDate().setFormat(Date.SQL_FORMAT);
        now.getTime().setFormat(Time.LONG_FORMAT_24);
        String timeStamp = now.toString();
        timeStamp = timeStamp.replace(" ", "_");
        timeStamp = timeStamp.replace(":", "-");
        String checkPointName = String.format("%s_CheckPoint", timeStamp);
        this.tfCheckpointName.setText(checkPointName);
    }

    @Reflected
    private void rowFocusChanged() {
        ThreadUtility.sleep(100L);
        int[] selectedRows = this.displayTable.getSelectedRows();
        this.btnRestoreCheckpoint.setEnabled(selectedRows.length > 0);
        this.btnDeleteCheckpoint.setEnabled(selectedRows.length > 0);
    }

    @Override
    @Reflected
    protected void domainsChanged(Index<Appliance, Domain> selectedDomains) {
        super.domainsChanged(selectedDomains);
        DataPowerStatusCache checkPoints = new DataPowerStatusCache();
        for (Appliance appliance : selectedDomains.getKeys()) {
            for (Domain domain : selectedDomains.get(appliance)) {
                DataPowerStatusMonitor checkpointStatus = new DataPowerStatusMonitor(appliance, domain, "DomainCheckpointStatus", 0L);
                checkpointStatus.addStatusListener(checkPoints);
            }
        }
        while (!checkPoints.isComplete()) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        this.tableModel.addAll(checkPoints.getStatusCache());
        this.btnDeleteCheckpoint.setEnabled(false);
        this.btnRestoreCheckpoint.setEnabled(false);
    }

    @Reflected
    private void createCheckpoint() {
        this.checkpointName = this.tfCheckpointName.getText().trim();
        if (StringUtility.isEmpty(this.checkpointName)) {
            this.showMessage("Invalid Checkpoint Name", "The checkpoint name you provided is blank.");
            return;
        }
        if (!ConfigurationManager.isObjectNameValid(this.checkpointName)) {
            this.showMessage("Invalid Checkpoint Name Name", "The checkpointName name [" + this.checkpointName + "] you provided contains invalid characters.  Do not use spaces or any of the following:   !@#$%^&*()+=`~[]{};:'\"/\\|?,<>");
            return;
        }
        String confirmationMessage = String.format("Are you sure you want to create checkpoint \"%s\" in all selected domains?", this.checkpointName);
        if (!this.start("Create Checkpoint", confirmationMessage)) {
            return;
        }
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "saveCheckpoint", false);
        this.finish();
    }

    @Reflected
    private void saveCheckpoint(Appliance appliance, Domain domain) {
        ActionTool actionTool = ActionController.saveCheckpoint(appliance, domain, this.checkpointName, this.commandResultsDialog);
        this.mtil.addThread(actionTool.getProcessThread());
    }

    @Reflected
    private void restoreCheckpoints() {
        ArrayList selectedCheckpoints = this.tableModel.getValues(this.displayTable.getSelectedRows());
        if (CollectionUtility.isEmpty(selectedCheckpoints)) {
            this.showMessage("No Checkpoints To Restore", "Please select a one or more checkpoints from the list.");
            return;
        }
        CountAggregator applianceCounter = new CountAggregator();
        CollectionAggregator applianceAggregator = new CollectionAggregator(selectedCheckpoints);
        applianceAggregator.addAggregatorFunction("'the ' + sourceDomain.name + ' domain of ' + appliance.name", applianceCounter);
        applianceAggregator.aggregate();
        Map applianceCounts = applianceCounter.getCounts();
        for (String applianceDomain : applianceCounts.keySet()) {
            int count = applianceCounts.get(applianceDomain);
            if (count <= 1) continue;
            this.showMessage("Checkpoint Restoration Collision", String.format("<html><body>You have selected %d checkpoints to restore for %s.<br/><br/>This can cause unexpected results.<br/><br/>Please check your selection and try again.</body></html>", count, applianceDomain));
            return;
        }
        if (!this.start("Restore Checkpoints", "Are you sure you want to restore all of the selected checkpoints?")) {
            return;
        }
        for (StatusDomainCheckpointStatus selectedCheckpoint : selectedCheckpoints) {
            ActionTool actionTool = ActionController.restoreCheckpoint(selectedCheckpoint.getAppliance(), selectedCheckpoint.getSourceDomain(), selectedCheckpoint.getChkName(), this.commandResultsDialog);
            this.mtil.addThread(actionTool.getProcessThread());
        }
        this.finish();
    }

    @Reflected
    private void deleteCheckpoints() {
        ArrayList selectedCheckpoints = this.tableModel.getValues(this.displayTable.getSelectedRows());
        if (CollectionUtility.isEmpty(selectedCheckpoints)) {
            this.showMessage("No Checkpoints To Delete", "Please select a one or more checkpoints from the list.");
            return;
        }
        if (!this.start("Delete Checkpoints", "Are you sure you want to delete all of the selected checkpoints?")) {
            return;
        }
        for (StatusDomainCheckpointStatus selectedCheckpoint : selectedCheckpoints) {
            ActionTool actionTool = ActionController.deleteCheckpoint(selectedCheckpoint.getAppliance(), selectedCheckpoint.getSourceDomain(), selectedCheckpoint.getChkName(), this.commandResultsDialog);
            this.mtil.addThread(actionTool.getProcessThread());
        }
        this.finish();
    }

    @Reflected
    private void setCheckpointHistory() {
        long checkpointHistory = (long)this.nfCheckpointHistory.getNumber();
        if (checkpointHistory < 1L || checkpointHistory > 5L) {
            this.showMessage("Set Configuration Checkpoint Limit", String.format("The value %d for checkpoint history limit must be in the range 1 - 5.", checkpointHistory));
            return;
        }
        String confirmationMessage = String.format("Are you sure you want to set the configuration checkpoint limit to %d for all selected domains?", checkpointHistory);
        if (!this.start("Set Configuration Checkpoint Limit", confirmationMessage)) {
            return;
        }
        Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        for (Appliance appliance : selectedDomains.getKeys()) {
            for (Domain domain : selectedDomains.get(appliance)) {
                AbstractPanel.logger.config(() -> LMG.log("(): Setting checkpoint history to %d for %s -> %s", () -> checkpointHistory, () -> appliance.getName(), () -> domain.getName()));
                ModifyProperty<Long> domainChanger = new ModifyProperty<Long>(appliance, appliance.getDomain("default"), "Domain", domain.getName(), "MaxChkpoints", checkpointHistory);
                this.addProcessListeners(domainChanger);
            }
        }
        this.finish();
    }
}

