/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.files;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.tools.ActionController;
import com.kumbasoft.core.tools.ListFiles;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractTablePanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.models.DataPowerFileInfoColumnModel;
import com.kumbasoft.core.ui.models.DataPowerFileInfoTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JSeparator;

public class CleanupFilesPanel
extends AbstractTablePanel<DataPowerFileInfo>
implements PopupMenuController {
    private static final String[] TEMP_STORES = new String[]{"temporary:", "logtemp:", "image:", "export:"};
    private int totalFiles;
    private long totalSize;
    private NumberField lblTotalFiles;
    private NumberField lblTotalSize;
    private boolean readingFiles;
    private boolean interruptRead;
    private JMButton btnSelectAll;
    private JMButton btnUnSelectAll;
    private JMButton btnDelete;

    public CleanupFilesPanel() {
        super(DataPowerFileInfo.class);
        this.createPopupMenu();
        JMPanel buttonPanel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        this.btnSelectAll = ComponentFactory.createButton(KumbaCoreUIConstants.SELECT_ALL_ICON, null, "Select all rows", true, this, "editSelectAll", new Object[0]);
        this.btnUnSelectAll = ComponentFactory.createButton(KumbaCoreUIConstants.SELECT_NONE_ICON, null, "Clear row selection", true, this.displayTable, "clearSelection", new Object[0]);
        this.btnDelete = ComponentFactory.createButton(KumbaCoreUIConstants.DELETE_ICON, null, "Delete all or selected files", true, this, "editDelete", new Object[0]);
        buttonPanel.addAll(this.btnSelectAll, this.btnUnSelectAll, ComponentFactory.createSpacer(20, 10), this.btnDelete);
        JMPanel hamburgerMenu = new JMPanel(new FlowLayout(2));
        hamburgerMenu.add(this.getPopupMenuButton());
        JMPanel topPanel = new JMPanel(new BorderLayout());
        topPanel.add((Component)buttonPanel, "West");
        topPanel.add((Component)hamburgerMenu, "Center");
        this.add((Component)topPanel, "North");
        JMPanel statsPanel = KumbaCoreUIConstants.createFlowLayoutPanel(2);
        this.lblTotalFiles = CleanupFilesPanel.createNumberLabel();
        this.lblTotalSize = CleanupFilesPanel.createNumberLabel();
        statsPanel.addAll(new JMLabel("Total Files:"), this.lblTotalFiles, ComponentFactory.createSpacer(20, 10), new JMLabel("Total Size:"), this.lblTotalSize);
        this.add((Component)statsPanel, "South");
        new ListSelectionEventInvoker(this.displayTable.getSelectionModel(), this, "rowSelectionChanged");
        ApplianceDomainChangeMonitor.getInstance().addApplianceChangeSubscriber(this, "appliancesChanged");
    }

    private static NumberField createNumberLabel() {
        NumberField nf = new NumberField(0.0);
        nf.setFormatString("#,##0;-#,##0");
        nf.setEditable(false);
        nf.setWidth(100);
        return nf;
    }

    @Override
    protected void createPopupMenu() {
        JMPopupMenu popupMenu = this.getPopupMenu(this.displayTableScrollPane);
        popupMenu.addPopupMenuClient(this.displayTable);
        popupMenu.setPopupController(this);
        popupMenu.addMenuItem("Select All", (Object)this, "editSelectAll");
        popupMenu.addMenuItem("Select None", (Object)this.displayTable, "clearSelection");
        popupMenu.add(new JSeparator());
        popupMenu.addMenuItem("Delete...", (Object)this, "editDelete");
    }

    @Override
    public boolean isPopupReady() {
        return this.displayTable.getRowCount() > 0;
    }

    @Reflected
    private void appliancesChanged(ArrayList<Appliance> selectedAppliances) {
        if (this.readingFiles) {
            this.interruptRead = true;
            logger.fine("(ArrayList<Appliance> selectedAppliances): Waiting for last invocation to complete.");
            new AsynchMethodInvoker((Object)this, "appliancesChanged", (Object)selectedAppliances, KumbaCoreConstants.THREAD_WAIT);
            return;
        }
        this.interruptRead = false;
        this.readingFiles = true;
        logger.finer("(ArrayList<Appliance> selectedAppliances): Starting");
        this.tableModel.reset();
        this.lblTotalFiles.setText("0");
        this.lblTotalSize.setText("0");
        this.totalFiles = 0;
        this.totalSize = 0L;
        this.showProgressBar(selectedAppliances.size());
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Appliance appliance : selectedAppliances) {
            logger.finer(() -> LMG.log("(ArrayList<Appliance> selectedAppliances): Listing files for appliance %s", () -> appliance.getName()));
            mtil.addThread(new AsynchMethodInvoker((Object)this, "listFiles", new Object[]{appliance, mtil}));
            if (this.interruptRead) break;
        }
        ThreadManager.monitorAsynchThreadLifeCycle("CleanupFilesPanel.appliancesChanged(...)", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        this.displayTable.optimizeColumnWidths();
        this.hideProgressBar();
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        this.readingFiles = false;
        this.interruptRead = false;
        logger.finer("(ArrayList<Appliance> selectedAppliances): Done");
    }

    @Reflected
    private void listFiles(Appliance appliance, MultiThreadInvocationListener mtil) {
        String loggerPrefix = String.format("(Appliance appliance=%s): ", appliance.getName());
        logger.finer(() -> LMG.log("%sListing files.", () -> loggerPrefix));
        ArrayList<Domain> domains = new ArrayList<Domain>(appliance.getDomains());
        this.progressBar.setMaximum(this.progressBar.getMaximum() + domains.size() * TEMP_STORES.length);
        block0: for (Domain domain : domains) {
            if (this.interruptRead) break;
            String[] stringArray = TEMP_STORES;
            int n = TEMP_STORES.length;
            int n2 = 0;
            while (n2 < n) {
                String tempStore = stringArray[n2];
                if (this.interruptRead) continue block0;
                this.updateProgressBar(this.progressBar.getValue() + 1);
                logger.finer(() -> LMG.log("%sListing files for the %s store in %s.", () -> loggerPrefix, () -> tempStore, () -> domain.getName()));
                ConfigObjectCache fileCache = new ConfigObjectCache();
                SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
                ListFiles listFiles = new ListFiles(appliance, domain, tempStore, ".*");
                listFiles.addConfigObjectSubscriber(DataPowerFileInfo.class, fileCache);
                listFiles.getProcessThread().addInvocationListener(stil);
                mtil.addThread(listFiles.getProcessThread());
                stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
                Vector<DataPowerFileInfo> files = fileCache.getObjectCache();
                if (tempStore.equals("logtemp:")) {
                    Vector<DataPowerFileInfo> logFiles = new Vector<DataPowerFileInfo>();
                    for (DataPowerFileInfo logFile : files) {
                        if (!StringUtility.endsWidth(logFile.getName(), "\\.\\d+")) continue;
                        logFiles.add(logFile);
                    }
                    this.updateTable(logFiles);
                } else if (tempStore.equals("temporary:")) {
                    Vector<DataPowerFileInfo> tempFiles = new Vector<DataPowerFileInfo>();
                    for (DataPowerFileInfo tempFile : tempFiles) {
                        String FQFN = tempFile.getAbsolutePath();
                        if (FQFN.startsWith("temporary:/log/")) continue;
                        tempFiles.add(tempFile);
                    }
                    this.updateTable(tempFiles);
                } else {
                    this.updateTable(files);
                }
                logger.finer(() -> LMG.log("%sDone listing files for the %s store in %s.", () -> loggerPrefix, () -> tempStore, () -> domain.getName()));
                ++n2;
            }
        }
        logger.finer(() -> LMG.log("%sDone listing files.", () -> loggerPrefix));
    }

    private void updateTable(Vector<DataPowerFileInfo> files) {
        this.updateFileStatistics(files);
        this.tableModel.addAll(files);
    }

    private void updateFileStatistics(Vector<DataPowerFileInfo> files) {
        this.totalFiles += files.size();
        for (DataPowerFileInfo file : files) {
            this.totalSize += file.getFileSize();
        }
        this.lblTotalFiles.setNumber(this.totalFiles);
        this.lblTotalSize.setNumber(this.totalSize);
    }

    @Reflected
    private void rowSelectionChanged() {
        this.totalFiles = 0;
        this.totalSize = 0L;
        int[] selectedRows = this.displayTable.getSelectedRows();
        if (ArrayUtility.isEmpty(selectedRows)) {
            this.updateFileStatistics(new Vector<DataPowerFileInfo>(this.tableModel.getModelData()));
            return;
        }
        Vector<DataPowerFileInfo> selectedFiles = new Vector<DataPowerFileInfo>(this.tableModel.getValues(selectedRows));
        this.updateFileStatistics(selectedFiles);
    }

    @Reflected
    private void editDelete() {
        int[] selectedRows = this.displayTable.getSelectedRows();
        boolean rowsAreSelected = !ArrayUtility.isEmpty(selectedRows);
        ArrayList<DataPowerFileInfo> selectedFiles = rowsAreSelected ? this.tableModel.getValues(selectedRows) : this.tableModel.getModelData();
        String warningSnippet = rowsAreSelected ? "all of the selected" : "all of the displayed";
        String warningMessage = String.format("Are you sure you want to remove %s files?", warningSnippet);
        new JMMessageBox((JFrame)frame, "Delete Temporary Files", warningMessage, 12);
        if (JMMessageBox.getSelection() == 8) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Delete Temporary Files");
        ActionController.deleteFiles(selectedFiles, this.commandResultsDialog);
        if (rowsAreSelected) {
            this.displayTable.clearSelection();
            this.tableModel.deleteAll(selectedRows);
        } else {
            this.tableModel.reset();
        }
        this.displayTable.repaint();
        this.updateFileStatistics(new Vector<DataPowerFileInfo>(this.tableModel.getModelData()));
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Override
    public BeanTableModel<DataPowerFileInfo> getTableModel() {
        return new DataPowerFileInfoTableModel();
    }

    @Override
    protected BeanColumnModel<DataPowerFileInfo> getColumnModel() {
        DataPowerFileInfoColumnModel columnModel = new DataPowerFileInfoColumnModel();
        return columnModel;
    }
}

