/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.files;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.actions.ActionCreateDir;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.AbstractUpdateConfiguration;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.ThreadManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class CreateNewFIle
extends AbstractUpdateConfiguration {
    private String newBaseDirectory;

    public CreateNewFIle(DynamicBean model) {
        super(model);
    }

    public boolean createdNewDirectory() {
        return StringUtility.isNotEmpty(this.newBaseDirectory);
    }

    public String getNewBaseDirectory() {
        return this.newBaseDirectory;
    }

    @Override
    protected void updateConfigurations() {
        String newFileName = (String)this.model.getProperty("newFileName");
        String content = (String)this.model.getProperty("fileContent");
        String temporaryDirectoryName = ((KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties()).getTemporaryDirectory();
        File temporaryDirectory = new File(temporaryDirectoryName);
        temporaryDirectory.mkdirs();
        File localFile = new File(temporaryDirectory, newFileName);
        try {
            localFile.createNewFile();
            if (StringUtility.isNotEmpty(content)) {
                new ASCFileWriter(localFile, content);
            }
        }
        catch (IOException ioe) {
            return;
        }
        ArrayList newFiles = (ArrayList)this.model.getProperty("finalData");
        String newDirectory = (String)this.model.getProperty("newDirectory");
        boolean createDirectory = StringUtility.isNotEmpty(newDirectory);
        this.newBaseDirectory = "";
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        for (DataPowerFileInfo newFile : newFiles) {
            AbstractTool.logger.config(() -> LMG.log("():  Creating new file in %s domain of %s: %s", () -> newFile.getSourceDomain().getName(), () -> newFile.getAppliance().getName(), () -> newFile.getAbsolutePath()));
            stil.clearCompletionStatus();
            if (createDirectory) {
                String directory;
                String absolutePathDP = newFile.getAbsolutePath();
                int lastSlash = absolutePathDP.lastIndexOf(47);
                this.newBaseDirectory = directory = StringUtility.getLeftSubstring(absolutePathDP, lastSlash);
                AbstractTool.logger.config(() -> LMG.log("():  Creating new directory (if needed) %s in %s domain of %s", () -> newDirectory, () -> newFile.getSourceDomain().getName(), () -> newFile.getAppliance().getName()));
                ActionCreateDir createDirAction = new ActionCreateDir();
                createDirAction.setDir(directory);
                new ActionTool(newFile.getAppliance(), newFile.getSourceDomain(), createDirAction, true);
                AbstractTool.logger.config(() -> LMG.log("():  Finished creating new directory %s in %s domain of %s", () -> newDirectory, () -> newFile.getSourceDomain().getName(), () -> newFile.getAppliance().getName()));
            }
            AbstractTool.logger.config(() -> LMG.log("():  Uploading file %s into the %s domain of %s", () -> newFile.getAbsolutePath(), () -> newFile.getSourceDomain().getName(), () -> newFile.getAppliance().getName()));
            newFile.setLocalFile(localFile);
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        FileUploader.upload(newFiles, mtil);
        ThreadManager.monitorAsynchThreadLifeCycle("CreateNewFile.updateConfigurations()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        AbstractTool.logger.config("(): Finished uploading files");
        localFile.delete();
    }
}

