/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.systemControl;

import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.combobox.ListComboBox;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.actions.ActionShutdown;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.dpaa.ui.panels.systemControl.AbstractSystemActionPanel;
import java.awt.Component;
import java.awt.Dimension;

public class ApplianceShutdownPanel
extends AbstractSystemActionPanel<ActionShutdown> {
    private ListComboBox cbxShutDownMode;
    private NumberField nfDelay;

    public ApplianceShutdownPanel() {
        super("Set Shutdown ");
        int reloadIndex = 0;
        Object[] displayMode = new String[DPEnumerations.SHUTDOWN_MODE.length];
        int i = 0;
        while (i < displayMode.length) {
            String suffix = "System";
            if (DPEnumerations.SHUTDOWN_MODE[i].equals("reload")) {
                reloadIndex = i;
                suffix = "Firmware";
            }
            displayMode[i] = String.format("%s %s", StringUtility.capitalize(DPEnumerations.SHUTDOWN_MODE[i]), suffix);
            ++i;
        }
        this.cbxShutDownMode = new ListComboBox(displayMode);
        LabeledComponent lblShutDownnMode = new LabeledComponent("Shutdown Mode:", (Component)this.cbxShutDownMode, 120, 135);
        this.cbxShutDownMode.setSelectedIndex(reloadIndex);
        JMTextField tf = (JMTextField)this.cbxShutDownMode.getField();
        MethodInvoker getTextPtr = new MethodInvoker((Object)tf, "getText", new Object[0]);
        new PropertyChangeInvoker(tf, this.btnPerformSystemAction, "setText", getTextPtr);
        this.nfDelay = new NumberField(10.0);
        NumberSpinner nsDelay = new NumberSpinner(this.nfDelay, 1.0, 0.0, 2.147483647E9);
        LabeledComponent lblDelay = new LabeledComponent("Delay (seconds):", (Component)nsDelay, 120, 135);
        this.addAll(lblShutDownnMode, lblDelay);
    }

    @Override
    protected Dimension getButtonSize() {
        return new Dimension(200, 25);
    }

    @Override
    protected String getCommandResultsDialogTitle() {
        return this.cbxShutDownMode.getText();
    }

    @Override
    protected boolean isUserInputValid() {
        String mode = (String)this.cbxShutDownMode.getSelectedValue();
        String message = String.format("Are you sure you want to %s all the selected appliances?", mode);
        return this.continueAction("Confirm Shutdown Action", message);
    }

    @Override
    protected ActionShutdown setupActionObjectType() {
        int selectedMode = this.cbxShutDownMode.getSelectedIndex();
        int delay = (int)this.nfDelay.getNumber();
        ActionShutdown shutDownAction = new ActionShutdown();
        shutDownAction.setMode(DPEnumerations.SHUTDOWN_MODE[selectedMode]);
        shutDownAction.setDelay(delay);
        return shutDownAction;
    }
}

