/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.systemControl;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.filefilter.DirectoryFileFilter;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.j2ee.xml.XMLParser;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionSecureRestore;
import com.kumbasoft.core.beans.config.ConfigCryptoIdentCred;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.panels.systemControl.AbstractSecureBackupRestorePanel;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ListModel;

public class SecureRestorePanel
extends AbstractSecureBackupRestorePanel<ActionSecureRestore> {
    private static final DirectoryFileFilter directoryFileFilter = new DirectoryFileFilter();
    private JMListModel<String> idcredListModel = new JMListModel();
    private JMList<String> idcredList = new JMList<String>((ListModel<String>)this.idcredListModel);
    private ArrayList<StatusObjectStatus> idcredObjects;
    private JMListModel<String> historicalBackupsListModel;
    private JMList<String> historicalBackupsList;
    private HashMap<String, File> historicalBackupDirectories;
    private String backupMachineType;

    public SecureRestorePanel() {
        super("Secure Restore");
        this.idcredList.setPreferredSize(300, 600);
        LabeledComponent idcredListComponent = new LabeledComponent(this.labelComponent, (Component)KumbaCoreUIConstants.createScrollPane(this.idcredList), 1);
        this.controlsPanel.add((Component)idcredListComponent, "West");
        this.historicalBackupsListModel = new JMListModel();
        this.historicalBackupsList = new JMList<String>((ListModel<String>)this.historicalBackupsListModel);
        LabeledComponent historicalListComponent = new LabeledComponent("Historical Backups:", (Component)KumbaCoreUIConstants.createScrollPane(this.historicalBackupsList), 1);
        this.controlsPanel.add((Component)historicalListComponent, "South");
    }

    @Override
    protected String getListLabel() {
        return "Identification Credentials:";
    }

    @Override
    protected String getCommandResultsDialogTitle() {
        return "Secure Restore";
    }

    @Override
    protected void invokeSystemAction() {
        String selectedHistoricalBackup = (String)this.historicalBackupsList.getSelectedValue();
        if (selectedHistoricalBackup != null) {
            File[] backupFiles;
            File systemFile = this.historicalBackupDirectories.get(selectedHistoricalBackup);
            ArrayList<DataPowerFileInfo> filesToUpload = new ArrayList<DataPowerFileInfo>();
            MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
            File[] fileArray = backupFiles = systemFile.listFiles();
            int n = backupFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File backupFile = fileArray[n2];
                if (backupFile.getName().equals("backupmanifest.xml")) {
                    try {
                        XMLParser xmlParser = new XMLParser(new FileReader(backupFile));
                        XMLElement rootElement = new XMLElement(xmlParser.getRootNode());
                        XMLElement backupManifest = rootElement.getNode("backupmanifest");
                        XMLElement mtm = backupManifest.getNode("mtm");
                        this.backupMachineType = mtm.getValue();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                for (Appliance appliance : this.selectedAppliances) {
                    DataPowerFileInfo dpFileInfo = new DataPowerFileInfo(appliance, appliance.getDomain("default"), null, backupFile.length(), this.destinationLocation, backupFile.getName());
                    dpFileInfo.setLocalFile(backupFile);
                    filesToUpload.add(dpFileInfo);
                }
                ++n2;
            }
            FileUploader.upload(filesToUpload, mtil);
            ThreadManager.monitorAsynchThreadLifeCycle("TestPasswordMapPanel.domainsChanged(...)", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        }
        super.invokeSystemAction();
    }

    @Override
    @Reflected
    protected void loadArtifacts(ArrayList<Appliance> selectedAppliances) {
        this.selectedAppliances = selectedAppliances;
        if (this.idcredObjects != null) {
            this.idcredObjects.clear();
            this.idcredObjects = null;
        }
        if (this.historicalBackupDirectories == null) {
            this.historicalBackupDirectories = new HashMap();
        } else {
            this.historicalBackupDirectories.clear();
        }
        this.historicalBackupsListModel.clear();
        this.idcredListModel.clear();
        new AsynchMethodInvoker((Object)this, "loadIDCreds");
        new AsynchMethodInvoker((Object)this, "loadHistoricalBackups");
        super.loadArtifacts(selectedAppliances);
    }

    @Reflected
    private void loadIDCreds() {
        ConfigurationManager configurationManager = new ConfigurationManager();
        this.idcredObjects = configurationManager.listObjects(this.selectedAppliances, "CryptoIdentCred", ".*");
        UniqueArrayList<String> cryptoIDCredNames = new UniqueArrayList<String>();
        for (StatusObjectStatus cert : this.idcredObjects) {
            cryptoIDCredNames.add(cert.getName());
        }
        cryptoIDCredNames.sort();
        this.idcredListModel.addAll(cryptoIDCredNames);
        if (cryptoIDCredNames.size() > 0) {
            this.idcredList.setSelectedIndex(0);
        }
    }

    @Reflected
    private void loadHistoricalBackups() {
        String secureBackupsDirectory = AbstractPanel.applicationProperties.getSecureBackupsDirectory();
        ArrayList<String> backupNames = new ArrayList<String>();
        for (Appliance appliance : this.selectedAppliances) {
            String secureBackupsDirName = String.format("%s%s%s", secureBackupsDirectory, File.separator, appliance.getName());
            File applianceBackupDir = new File(secureBackupsDirName);
            Object[] files = applianceBackupDir.listFiles(directoryFileFilter);
            if (ArrayUtility.isEmpty(files)) continue;
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                String fName = ((File)file).getName();
                String backupName = String.format("%s     %s", appliance.getName(), fName);
                this.historicalBackupDirectories.put(backupName, (File)file);
                backupNames.add(backupName);
                ++n2;
            }
        }
        this.historicalBackupsListModel.addAll(backupNames);
    }

    @Override
    protected ActionSecureRestore setupActionObjectType() {
        String idCredName = this.idcredList.getSelectedItem();
        ObjectReference<ConfigCryptoIdentCred> idCredRef = new ObjectReference<ConfigCryptoIdentCred>();
        idCredRef.setClassName("CryptoCertificate");
        idCredRef.setName(idCredName);
        this.isFileDestination = false;
        String source = null;
        if (this.rbTemporaryDestination.isSelected()) {
            source = (String)this.lcbxTempDirectories.getSelectedValue();
            this.isFileDestination = true;
        } else if (this.rbLocalDestination.isSelected()) {
            source = (String)this.lcbxLocalDirectories.getSelectedValue();
            this.isFileDestination = true;
        } else {
            source = this.tfFTPDestinationURL.getText();
        }
        this.destinationLocation = source;
        ActionSecureRestore secureRestore = new ActionSecureRestore();
        secureRestore.setCred(idCredRef);
        secureRestore.setSource(source);
        secureRestore.setBackupMachineType(this.backupMachineType);
        return secureRestore;
    }
}

