/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.awt;

import com.jmorgan.awt.ShapeCreator;
import com.jmorgan.awt.ShapeFactory;
import java.awt.Rectangle;
import java.awt.Shape;

public class RoundedCornerShapeCreator
implements ShapeCreator {
    private int nwRadius;
    private int neRadius;
    private int swRadius;
    private int seRadius;

    public RoundedCornerShapeCreator() {
        this(0, 0, 0, 0);
    }

    public RoundedCornerShapeCreator(int cornerRadius) {
        this(cornerRadius, cornerRadius, cornerRadius, cornerRadius);
    }

    public RoundedCornerShapeCreator(int nwRadius, int neRadius, int swRadius, int seRadius) {
        this.setNwRadius(nwRadius);
        this.setNeRadius(neRadius);
        this.setSwRadius(swRadius);
        this.setSeRadius(seRadius);
    }

    public int getNwRadius() {
        return this.nwRadius;
    }

    public void setNwRadius(int nwRadius) {
        this.nwRadius = nwRadius;
    }

    public int getNeRadius() {
        return this.neRadius;
    }

    public void setNeRadius(int neRadius) {
        this.neRadius = neRadius;
    }

    public int getSwRadius() {
        return this.swRadius;
    }

    public void setSwRadius(int swRadius) {
        this.swRadius = swRadius;
    }

    public int getSeRadius() {
        return this.seRadius;
    }

    public void setSeRadius(int seRadius) {
        this.seRadius = seRadius;
    }

    @Override
    public Shape createShape(Rectangle bounds) {
        return ShapeFactory.createRoundedRectangle(bounds.width, bounds.height, this.nwRadius, this.neRadius, this.seRadius, this.swRadius);
    }
}

